/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.synch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AuditOpinionEnum;
import com.kingdee.eas.hr.ats.CardStateEnum;
import com.kingdee.eas.hr.ats.ComprehensiveType;
import com.kingdee.eas.hr.ats.ISignRecord;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.PunchCardStateEnum;
import com.kingdee.eas.hr.ats.SignRecordCollection;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;

public class PunchCardSynUtile {
    public static CoreBaseCollection compareSignRcdColl(ISignRecord signRecord, CoreBaseCollection signRcdColl, Timestamp beginDate, Timestamp endDate) {
        beginDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(beginDate)).getTime());
        endDate = new Timestamp(AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(endDate)).getTime() + 86400000L - 1L);
        CoreBaseCollection col = new CoreBaseCollection();
        if (signRcdColl == null || signRcdColl.isEmpty()) {
            return col;
        }
        HashSet<String> pidSet = new HashSet<String>();
        Iterator iterator = signRcdColl.iterator();
        boolean havePersonNull = false;
        while (iterator.hasNext()) {
            SignRecordInfo signRecordInfo = (SignRecordInfo)iterator.next();
            if (signRecordInfo.getPerson() != null && signRecordInfo.getPerson().getId() != null) {
                pidSet.add(signRecordInfo.getPerson().getId().toString());
                continue;
            }
            havePersonNull = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("signTime"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("auditOpinion"));
        evi.getSelector().add(new SelectorItemInfo("cardState"));
        FilterInfo fi = new FilterInfo();
        if (pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
        } else if (!pidSet.isEmpty() && !havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
        } else if (!pidSet.isEmpty() && havePersonNull) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", pidSet, CompareType.INCLUDE));
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("person.id", null, CompareType.EQUALS));
            try {
                fi.mergeFilter(fi2, "OR");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            return col;
        }
        FilterInfo fi3 = new FilterInfo();
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi3.getFilterItems().add(new FilterItemInfo("signTime", (Object)endDate, CompareType.LESS_EQUALS));
        try {
            fi.mergeFilter(fi3, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        evi.setFilter(fi);
        try {
            SignRecordCollection signRecordCollection = signRecord.getSignRecordCollection(evi);
            for (SignRecordInfo signRecordInfo : signRcdColl) {
                int index = signRecordCollection.indexOf(signRecordInfo);
                if (index == -1) {
                    col.add((CoreBaseInfo)signRecordInfo);
                    continue;
                }
                SignRecordInfo dbRecord = signRecordCollection.get(index);
                if ((!signRecordInfo.getAuditOpinion().equals((Object)AuditOpinionEnum.agree) || dbRecord.getAuditOpinion().equals((Object)AuditOpinionEnum.agree)) && (signRecordInfo.getCardState() == null || signRecordInfo.getCardState().equals((Object)dbRecord.getCardState()))) continue;
                if (signRecordInfo.getAuditOpinion().equals((Object)AuditOpinionEnum.agree)) {
                    dbRecord.setAuditOpinion(AuditOpinionEnum.agree);
                }
                if (!signRecordInfo.getCardState().equals((Object)dbRecord.getCardState())) {
                    dbRecord.setCardState(signRecordInfo.getCardState());
                }
                col.add((CoreBaseInfo)dbRecord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    public static PunchCardRecordInfo assemblePunchCardRecordInfo(JSONObject json, String openapikey, Timestamp nowTimestamp, Map<String, PersonPositionInfo> ppMap, Map<String, PersonInfo> allOpenID2PersonMap, Map<String, AttendanceFileInfo> allOpenID2AttFileMap) {
        return PunchCardSynUtile.assemblePunchCardRecordInfo(json, openapikey, nowTimestamp, ppMap, allOpenID2PersonMap, allOpenID2AttFileMap, new HashMap<String, PersonInfo>(0));
    }

    public static PunchCardRecordInfo assemblePunchCardRecordInfo(JSONObject json, String openapikey, Timestamp nowTimestamp, Map<String, PersonPositionInfo> ppMap, Map<String, PersonInfo> allOpenID2PersonMap, Map<String, AttendanceFileInfo> allOpenID2AttFileMap, Map<String, PersonInfo> pMap) {
        String workNum;
        PersonPositionInfo ppInfo;
        PunchCardRecordInfo crdInfo = new PunchCardRecordInfo();
        String openID = "";
        if (json.containsKey((Object)"openId")) {
            openID = json.getString("openId");
        } else if (json.containsKey((Object)"userId")) {
            openID = json.getString("userId");
        }
        crdInfo.setEquipmentNum(openapikey);
        if (json.getString("time").contains("time")) {
            crdInfo.setPunchCardTime(new Timestamp(json.getJSONObject("time").getLong("time")));
        } else {
            crdInfo.setPunchCardTime(Date.getTime(json.getString("time")));
        }
        if (!json.containsKey((Object)"day") || StringUtils.isEmpty((String)json.getString("day"))) {
            crdInfo.setPunchCardDate(Date.getDate(crdInfo.getPunchCardTime()));
        } else {
            crdInfo.setPunchCardDate(AtsDateUtils.stringToShortDate(json.getString("day")));
        }
        if ("nullnull".equals(json.getString("position"))) {
            crdInfo.setPunchCardPlace("");
        } else {
            crdInfo.setPunchCardPlace(json.getString("position"));
        }
        crdInfo.setPunchCardSource(PunchCardSourceEnum.openapisynch);
        if (json.containsKey((Object)"comprehensiveType") && !"".equals(json.getString("comprehensiveType").trim())) {
            crdInfo.setComprehensiveType(ComprehensiveType.getEnum(json.getInt("comprehensiveType")));
        }
        if (json.containsKey((Object)"del") && !"".equals(json.getString("del").trim())) {
            crdInfo.setPunchCardState(PunchCardStateEnum.getEnum(json.getBoolean("del") ? 1 : 0));
        }
        if (crdInfo.getProposer() != null && ppMap != null && (ppInfo = ppMap.get(crdInfo.getProposer().getId().toString())) != null) {
            crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
            crdInfo.setAdminOrgUnit(ppInfo.getPersonDep());
        }
        if (allOpenID2PersonMap != null && allOpenID2PersonMap.containsKey(openID)) {
            crdInfo.setProposer(allOpenID2PersonMap.get(openID));
            if (allOpenID2AttFileMap != null && allOpenID2AttFileMap.containsKey(openID) && allOpenID2AttFileMap.get(openID).getAttendanceNum() != null) {
                crdInfo.setAttendanceNum(allOpenID2AttFileMap.get(openID).getAttendanceNum());
                crdInfo.setHrOrgUnit(allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrgUnit(allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            } else {
                crdInfo.setAttendanceNum(crdInfo.getProposer().getNumber());
            }
        } else if (json.containsKey((Object)"workNum") && (workNum = json.getString("workNum")) != null && !"".equals(workNum) && !"null".equals(workNum)) {
            crdInfo.setAttendanceNum(workNum);
            crdInfo.setProposer(pMap.get(workNum));
        }
        crdInfo.setCreateTime(nowTimestamp);
        crdInfo.setLastUpdateTime(nowTimestamp);
        return crdInfo;
    }

    public static SignRecordInfo assembleSignRecordInfo(JSONObject json, String openapikey, Map<String, PersonPositionInfo> ppMap, Map<String, PersonInfo> allOpenID2PersonMap, Map<String, AttendanceFileInfo> allOpenID2AttFileMap) {
        return PunchCardSynUtile.assembleSignRecordInfo(json, openapikey, ppMap, allOpenID2PersonMap, new HashMap<String, PersonInfo>(0), allOpenID2AttFileMap);
    }

    public static SignRecordInfo assembleSignRecordInfo(JSONObject json, String openapikey, Map<String, PersonPositionInfo> ppMap, Map<String, PersonInfo> allOpenID2PersonMap, Map<String, PersonInfo> pMap, Map<String, AttendanceFileInfo> allOpenID2AttFileMap) {
        String workNum;
        SignRecordInfo crdInfo = new SignRecordInfo();
        String openID = "";
        if (json.containsKey((Object)"openId")) {
            openID = json.getString("openId");
        } else if (json.containsKey((Object)"userId")) {
            openID = json.getString("userId");
        }
        if (json.getString("time").contains("time")) {
            crdInfo.setSignTime(new Timestamp(json.getJSONObject("time").getLong("time")));
        } else {
            crdInfo.setSignTime(Date.getTime(json.getString("time")));
        }
        if (!json.containsKey((Object)"day") || StringUtils.isEmpty((String)json.getString("day"))) {
            crdInfo.setSignDate(Date.getDate(crdInfo.getSignTime()));
        } else {
            crdInfo.setSignDate(AtsDateUtils.stringToShortDate(json.getString("day")));
        }
        if ("nullnull".equals(json.getString("position"))) {
            crdInfo.setAddress("");
        } else {
            crdInfo.setAddress(json.getString("position"));
        }
        if (allOpenID2PersonMap != null && allOpenID2PersonMap.containsKey(openID)) {
            crdInfo.setPerson(allOpenID2PersonMap.get(openID));
        } else if (json.containsKey((Object)"workNum") && (workNum = json.getString("workNum")) != null && !"".equals(workNum) && !"null".equals(workNum)) {
            crdInfo.setPerson(pMap.get(workNum));
        }
        if (crdInfo.getPerson() != null) {
            PersonPositionInfo ppInfo;
            if (ppMap != null && (ppInfo = ppMap.get(crdInfo.getPerson().getId().toString())) != null) {
                crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
                crdInfo.setAdminOrg(ppInfo.getPersonDep());
            }
            if (allOpenID2AttFileMap != null && allOpenID2AttFileMap.containsKey(openID)) {
                crdInfo.setHrOrgUnit(allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrg(allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            }
        }
        if (json.containsKey((Object)"comprehensiveType") && !"".equals(json.getString("comprehensiveType").trim())) {
            crdInfo.setComprehensiveType(ComprehensiveType.getEnum(json.getInt("comprehensiveType")));
        }
        if (json.containsKey((Object)"del") && !"".equals(json.getString("del").trim())) {
            crdInfo.setCardState(CardStateEnum.getEnum(json.getBoolean("del") ? 1 : 0));
        }
        crdInfo.setAuditOpinion(PunchCardSynUtile.getAuditOpinionFromJson(json));
        crdInfo.setSignType(1);
        if (json.containsKey((Object)"remark")) {
            crdInfo.setNote(json.getString("remark"));
        }
        return crdInfo;
    }

    public static AuditOpinionEnum getAuditOpinionFromJson(JSONObject jsonObj) {
        JSONObject approveResult = null;
        if (jsonObj == null) {
            return AuditOpinionEnum.unaudited;
        }
        if (jsonObj.containsKey((Object)"approveResult") && !jsonObj.getString("approveResult").equals("")) {
            approveResult = jsonObj.getJSONObject("approveResult");
        }
        if (approveResult != null && approveResult.containsKey((Object)"approveStatus")) {
            if ("HANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"))) {
                return AuditOpinionEnum.agree;
            }
            if ("DISAGREE".equalsIgnoreCase(approveResult.getString("approveStatus"))) {
                return AuditOpinionEnum.disagree;
            }
            if ("UNHANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"))) {
                return AuditOpinionEnum.unaudited;
            }
        }
        return AuditOpinionEnum.unaudited;
    }
}

