/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.takeWorkLimit.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayLimitStatus;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.IOTtoTakeWorkDetail;
import com.kingdee.eas.hr.ats.OTType;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailFactory;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailInfo;
import com.kingdee.eas.hr.ats.OTtoTakeWorkDetailStatus;
import com.kingdee.eas.hr.ats.TakeWorkSourceType;
import com.kingdee.eas.hr.ats.TakeWorkUnitConvertRule;
import com.kingdee.eas.hr.ats.takeWorkLimit.impl.CoreCalTakeWorkLimit;
import com.kingdee.eas.hr.ats.takeWorkLimit.util.TakeWorkLimitUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalAttendRes2TakeWorkLimit
extends CoreCalTakeWorkLimit {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.takeWorkLimit.impl.CalAttendRes2TakeWorkLimit");
    private IOTtoTakeWorkDetail ioTtoTakeWorkDetail;

    public CalAttendRes2TakeWorkLimit(Context ctx, Map map) {
        super(ctx, map);
        try {
            this.ioTtoTakeWorkDetail = OTtoTakeWorkDetailFactory.getLocalInstance(ctx);
            this.limitInfo = (HolidayLimitInfo)map.get("existedLimit");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateTakeWorkLimit(Context ctx, Map param) {
        logger.error((Object)("AttendRes takeWorkLimit cal person id: " + (String)param.get("proposerID")));
        super.generateTakeWorkLimit(ctx, param);
    }

    @Override
    protected void beforeCal(Context ctx, Map param) {
        super.beforeCal(ctx, param);
        String proposerID = (String)param.get("proposerID");
        Set detailSet = (Set)param.get("existedDetail");
        Set resSet = (Set)param.get("res");
        HashMap<String, HashMap> resMap = new HashMap<String, HashMap>();
        if (resSet != null && resSet.size() > 0) {
            for (HashMap res : resSet) {
                resMap.put((String)res.get("resultID"), res);
            }
        }
        if (this.limitInfo != null && detailSet != null && detailSet.size() > 0) {
            ArrayList<ObjectUuidPK> detailList = new ArrayList<ObjectUuidPK>();
            for (OTtoTakeWorkDetailInfo detailInfo : detailSet) {
                HashMap res = (HashMap)resMap.get(detailInfo.getSourceBillId());
                BigDecimal formerConvOTValue = detailInfo.getLimitValue();
                if (res != null) continue;
                detailInfo.setState(OTtoTakeWorkDetailStatus.invalid);
                detailInfo.setHrOrgUnit(this.limitInfo.getHrOrgUnit());
                detailList.add(new ObjectUuidPK(detailInfo.getId()));
                this.limitInfo.setStandardLimit(this.limitInfo.getStandardLimit().subtract(formerConvOTValue));
                this.limitInfo.setRealLimit(this.limitInfo.getRealLimit().subtract(formerConvOTValue));
                this.limitInfo.setRemainLimit(this.limitInfo.getRemainLimit().subtract(formerConvOTValue));
            }
            int detailSize = detailList.size();
            if (detailSize > 0) {
                try {
                    ObjectUuidPK[] detailIds = new ObjectUuidPK[detailSize];
                    for (int i = 0; i < detailSize; ++i) {
                        detailIds[i] = (IObjectPK)detailList.get(i);
                    }
                    OTtoTakeWorkDetailFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])detailIds);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected void doCalTotalLimit(Context ctx, Map param) {
        Set existedDetail = (Set)param.get("existedDetail");
        HashMap<String, OTtoTakeWorkDetailInfo> existedDetailMap = new HashMap<String, OTtoTakeWorkDetailInfo>();
        if (existedDetail != null && existedDetail.size() > 0) {
            for (OTtoTakeWorkDetailInfo detail : existedDetail) {
                String sourceBillId = detail.getSourceBillId();
                existedDetailMap.put(sourceBillId, detail);
            }
        }
        HolidayPolicyInfo policyInfo = (HolidayPolicyInfo)param.get("policyInfo");
        PersonPositionInfo personPositionInfo = (PersonPositionInfo)param.get("personPosition");
        AtsTakeWorkingInfo twRule = (AtsTakeWorkingInfo)param.get("twRule");
        Map ruleBasedData = (Map)param.get("ruleBasedData");
        Map stdHourMap = (Map)param.get("stdHour");
        Set results = (Set)param.get("res");
        if (results != null && results.size() > 0) {
            for (HashMap result : results) {
                BigDecimal standardHour = null;
                BigDecimal afterDealStdHour = null;
                boolean isHalfDay = AtsLeaveBillUtils.isHalfDay(ctx, result.get("proposerID").toString(), (Date)result.get("atsDate"));
                HolidayTypeUnitEnum unit = policyInfo.getUnit();
                if (twRule.getUnitConvertRule().compareTo((Object)TakeWorkUnitConvertRule.fixedHour) == 0) {
                    standardHour = twRule.getFixedHour();
                } else {
                    standardHour = (BigDecimal)stdHourMap.get(result.get("proposerID") + "_" + AtsDateUtils.dateShortToString((Date)result.get("atsDate")));
                    if (unit.equals((Object)HolidayTypeUnitEnum.day) && isHalfDay) {
                        standardHour = standardHour.multiply(new BigDecimal("2"));
                    }
                }
                afterDealStdHour = standardHour;
                if (afterDealStdHour != null && afterDealStdHour.compareTo(new BigDecimal(0)) > 0) {
                    this.calLimit(ctx, result, existedDetailMap, policyInfo, twRule, afterDealStdHour, personPositionInfo, ruleBasedData, param);
                    continue;
                }
                param.put("success", 0);
                if (twRule.getUnitConvertRule().compareTo((Object)TakeWorkUnitConvertRule.fixedHour) != 0) continue;
                param.put("errorStr", MLUtile.getRes(AtsOverTimeBillResEnum.RegenLimitForIllegalTransferRule, ctx));
            }
        } else {
            AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)param.get("atsHolidayFileHis");
            if (this.limitInfo != null) {
                if (null != atsHolidayFileHisInfo) {
                    this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                    this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                }
                this.limitInfo.setStandardLimit(BigDecimal.ZERO);
                this.limitInfo.setRealLimit(this.limitInfo.getAddOrSubLimit());
                this.limitInfo.setRemainLimit(this.limitInfo.getAddOrSubLimit().subtract(this.limitInfo.getUsedLimit()).subtract(this.limitInfo.getFreezeLimit()).subtract(this.limitInfo.getPreOverdraftLimit()));
                this.limitInfo.setStatus(HolidayLimitStatus.audited);
            } else {
                HolidayLimitInfo preLimit = (HolidayLimitInfo)param.get("preLimit");
                if (policyInfo.isIsOverAutoSub() && preLimit != null && preLimit.getRemainLimit().compareTo(BigDecimal.ZERO) < 0) {
                    Date delayDate;
                    this.limitInfo = new HolidayLimitInfo();
                    this.limitInfo.setStandardLimit(BigDecimal.ZERO);
                    this.limitInfo.setRealLimit(BigDecimal.ZERO);
                    this.limitInfo.setRemainLimit(BigDecimal.ZERO);
                    this.limitInfo.setAddOrSubLimit(BigDecimal.valueOf(0.0));
                    this.limitInfo.setUsedLimit(BigDecimal.valueOf(0.0));
                    this.limitInfo.setFreezeLimit(BigDecimal.valueOf(0.0));
                    this.limitInfo.setPreOverdraftLimit(preLimit.getRemainLimit().abs());
                    this.limitInfo.setRemainLimit(this.limitInfo.getPreOverdraftLimit().multiply(new BigDecimal(-1)));
                    this.limitInfo.setStatus(HolidayLimitStatus.audited);
                    TakeWorkLimitUtils.setRuleBasedData(this.limitInfo, ruleBasedData);
                    this.limitInfo.setEnableCycle(true);
                    this.limitInfo.setHolidayUnit(policyInfo.getUnit());
                    this.limitInfo.setHolidayPolicy(policyInfo);
                    this.limitInfo.setDelayDate(TakeWorkLimitUtils.getDelayDate(twRule, this.limitInfo.getCycleEndDate()));
                    if (null != ruleBasedData && null != (delayDate = (Date)ruleBasedData.get("delayDate")) && delayDate.compareTo(this.limitInfo.getDelayDate()) < 0) {
                        this.limitInfo.setDelayDate(delayDate);
                    }
                    this.limitInfo.setProposer(personPositionInfo.getPerson());
                    this.limitInfo.setPosition(personPositionInfo.getPrimaryPosition());
                    if (null != atsHolidayFileHisInfo) {
                        this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                        this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                    }
                    this.limitInfo.setCycleType(twRule.getTaskWorkingType());
                    try {
                        ObjectUuidPK uuidPK = (ObjectUuidPK)HolidayLimitFactory.getLocalInstance(ctx).addnew(this.limitInfo);
                        this.limitInfo.setId(uuidPK.getKeyValue());
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.limitInfo != null) {
            CoreBaseCollection allLimitColl = (CoreBaseCollection)param.get("allLimitColl");
            allLimitColl.add((CoreBaseInfo)this.limitInfo);
            try {
                System.out.println("takeWork limit result save:" + this.limitInfo.getProposer().getName() + "--standard limit\uff1a" + this.limitInfo.getStandardLimit() + "--real limit\uff1a" + this.limitInfo.getRealLimit() + "--rest limit:" + this.limitInfo.getRemainLimit() + "--limit cycle start time:" + this.limitInfo.getCycleBeginDate());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        param.put("success", 1);
    }

    protected void calLimit(Context ctx, HashMap<String, Object> result, Map<String, OTtoTakeWorkDetailInfo> detailMap, HolidayPolicyInfo policyInfo, AtsTakeWorkingInfo twRule, BigDecimal standardHour, PersonPositionInfo personPositionInfo, Map<String, Object> ruleBasedData, Map param) {
        BigDecimal ot1 = (BigDecimal)result.get("ot1");
        BigDecimal ot2 = (BigDecimal)result.get("ot2");
        BigDecimal ot3 = (BigDecimal)result.get("ot3");
        if (null == ot1 && null == ot2 && null == ot3 || ot1 != null && ot1.compareTo(BigDecimal.ZERO) <= 0 && ot2 != null && ot2.compareTo(BigDecimal.ZERO) <= 0 && ot3 != null && ot3.compareTo(BigDecimal.ZERO) <= 0) {
            logger.error((Object)"genereate takework limit OT1,OT2,OT3 value is zero!");
            return;
        }
        Date otDate = (Date)result.get("atsDate");
        logger.error((Object)("calLimit resultID:" + result.get("resultID")));
        OTtoTakeWorkDetailInfo detail = detailMap.get(result.get("resultID"));
        HolidayLimitInfo preLimit = (HolidayLimitInfo)param.get("preLimit");
        if (this.limitInfo != null) {
            this.updateTakeWorkLimit(ctx, result, policyInfo, twRule, detail, personPositionInfo, standardHour, param);
        } else {
            this.insertTakeWorkLimit(ctx, result, policyInfo, personPositionInfo, ruleBasedData, twRule, standardHour, preLimit, param);
        }
    }

    protected void updateTakeWorkLimit(Context ctx, HashMap<String, Object> result, HolidayPolicyInfo policyInfo, AtsTakeWorkingInfo twRule, OTtoTakeWorkDetailInfo detail, PersonPositionInfo personPositionInfo, BigDecimal standardHour, Map param) {
        AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)param.get("atsHolidayFileHis");
        this.limitInfo.setStatus(HolidayLimitStatus.audited);
        BigDecimal ot1 = (BigDecimal)result.get("ot1");
        BigDecimal ot2 = (BigDecimal)result.get("ot2");
        BigDecimal ot3 = (BigDecimal)result.get("ot3");
        BigDecimal sourceValue = BigDecimal.ZERO;
        BigDecimal convLimit = BigDecimal.ZERO;
        OTType otType = null;
        BigDecimal convValue = BigDecimal.ZERO;
        BigDecimal convRate = BigDecimal.ZERO;
        if (ot3.compareTo(BigDecimal.ZERO) > 0) {
            otType = OTType.OT3;
            sourceValue = ot3;
            convRate = new BigDecimal(twRule.getLegalHolidayRate());
            convValue = ot3.multiply(convRate);
        }
        if (ot2.compareTo(BigDecimal.ZERO) > 0) {
            otType = OTType.OT2;
            sourceValue = sourceValue.add(ot2);
            convRate = new BigDecimal(twRule.getRestDayRate());
            convValue = convValue.add(ot2.multiply(convRate));
        }
        if (ot1.compareTo(BigDecimal.ZERO) > 0) {
            otType = OTType.OT1;
            sourceValue = sourceValue.add(ot1);
            convRate = new BigDecimal(twRule.getWorkDayRate());
            convValue = convValue.add(ot1.multiply(convRate));
        }
        convLimit = convValue;
        HolidayTypeUnitEnum unit = policyInfo.getUnit();
        if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
            if (!this.limitInfo.getHolidayUnit().equals((Object)HolidayTypeUnitEnum.day)) {
                this.limitInfo.setHolidayUnit(HolidayTypeUnitEnum.day);
            }
            convLimit = TakeWorkLimitUtils.transHourToDay(convLimit, standardHour);
        }
        convLimit = TakeWorkLimitUtils.getMinAmtRealLimit(ctx, convLimit, policyInfo);
        if (detail != null) {
            logger.error((Object)("updateTakeWorkLimit params of convLimit: " + convLimit + " LimitValue: " + detail.getLimitValue()));
            if (null != atsHolidayFileHisInfo) {
                this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                if (this.limitInfo.getHrOrgUnit() == null) {
                    this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                }
            }
            if (convLimit.compareTo(detail.getLimitValue()) == 0) {
                return;
            }
            detail.setState(OTtoTakeWorkDetailStatus.invalid);
            this.limitInfo.setStandardLimit(this.limitInfo.getStandardLimit().subtract(detail.getLimitValue()));
            this.limitInfo.setRealLimit(this.limitInfo.getRealLimit().subtract(detail.getLimitValue()));
            this.limitInfo.setRemainLimit(this.limitInfo.getRemainLimit().subtract(detail.getLimitValue()));
        }
        try {
            if (null != atsHolidayFileHisInfo) {
                this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                if (this.limitInfo.getHrOrgUnit() == null) {
                    this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
                }
            }
            this.limitInfo.setStandardLimit(this.limitInfo.getStandardLimit().add(convLimit));
            this.limitInfo.setRealLimit(this.limitInfo.getRealLimit().add(convLimit));
            this.limitInfo.setRemainLimit(this.limitInfo.getRemainLimit().add(convLimit));
            if (detail != null) {
                if (detail.getState().getValue() == OTtoTakeWorkDetailStatus.invalid.getValue()) {
                    OTtoTakeWorkDetailFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(detail.getId()));
                } else {
                    detail.setHrOrgUnit(atsHolidayFileHisInfo != null ? atsHolidayFileHisInfo.getHrOrgUnit() : null);
                    OTtoTakeWorkDetailFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(detail.getId()), detail);
                }
            }
            this.insertDetailRecord(result, twRule, otType, sourceValue, convRate, convLimit, policyInfo, personPositionInfo);
        }
        catch (Exception e) {
            logger.error((Object)"updateTakeWorkLimit failed!");
            e.printStackTrace();
        }
    }

    protected void insertTakeWorkLimit(Context ctx, HashMap<String, Object> result, HolidayPolicyInfo policyInfo, PersonPositionInfo personPositionInfo, Map ruleBasedData, AtsTakeWorkingInfo twRule, BigDecimal standardHour, HolidayLimitInfo preLimit, Map param) {
        if (this.limitInfo != null) {
            return;
        }
        this.limitInfo = new HolidayLimitInfo();
        this.limitInfo.setPreOverdraftLimit(new BigDecimal(0));
        if (policyInfo.isIsOverAutoSub() && preLimit != null && preLimit.getRemainLimit().compareTo(BigDecimal.ZERO) < 0) {
            this.limitInfo.setPreOverdraftLimit(preLimit.getRemainLimit().abs());
        }
        BigDecimal sourceValue = BigDecimal.ZERO;
        BigDecimal convRate = BigDecimal.ZERO;
        BigDecimal convLimit = BigDecimal.ZERO;
        BigDecimal ot1 = (BigDecimal)result.get("ot1");
        BigDecimal ot2 = (BigDecimal)result.get("ot2");
        BigDecimal ot3 = (BigDecimal)result.get("ot3");
        OTType otType = null;
        BigDecimal convValue = BigDecimal.ZERO;
        if (ot3.compareTo(BigDecimal.ZERO) > 0) {
            otType = OTType.OT3;
            sourceValue = ot3;
            convRate = new BigDecimal(twRule.getLegalHolidayRate());
            convValue = ot3.multiply(convRate);
        }
        if (ot2.compareTo(BigDecimal.ZERO) > 0) {
            otType = OTType.OT2;
            sourceValue = sourceValue.add(ot2);
            convRate = new BigDecimal(twRule.getRestDayRate());
            convValue = convValue.add(ot2.multiply(convRate));
        }
        if (ot1.compareTo(BigDecimal.ZERO) > 0) {
            otType = OTType.OT1;
            sourceValue = sourceValue.add(ot1);
            convRate = new BigDecimal(twRule.getWorkDayRate());
            convValue = convValue.add(ot1.multiply(convRate));
        }
        convLimit = convValue;
        HolidayTypeUnitEnum unit = policyInfo.getUnit();
        if (unit.equals((Object)HolidayTypeUnitEnum.day)) {
            convLimit = TakeWorkLimitUtils.transHourToDay(convLimit, standardHour);
        }
        if ((convLimit = TakeWorkLimitUtils.getMinAmtRealLimit(ctx, convLimit, policyInfo)).compareTo(BigDecimal.ZERO) >= 0) {
            Date delayDate;
            this.limitInfo.setStandardLimit(convLimit);
            this.limitInfo.setRealLimit(convLimit);
            this.limitInfo.setRemainLimit(convLimit.subtract(this.limitInfo.getPreOverdraftLimit()));
            this.limitInfo.setAddOrSubLimit(BigDecimal.valueOf(0.0));
            this.limitInfo.setUsedLimit(BigDecimal.valueOf(0.0));
            this.limitInfo.setFreezeLimit(BigDecimal.valueOf(0.0));
            this.limitInfo.setStatus(HolidayLimitStatus.audited);
            TakeWorkLimitUtils.setRuleBasedData(this.limitInfo, ruleBasedData);
            this.limitInfo.setEnableCycle(true);
            this.limitInfo.setHolidayUnit(policyInfo.getUnit());
            this.limitInfo.setHolidayPolicy(policyInfo);
            this.limitInfo.setDelayDate(TakeWorkLimitUtils.getDelayDate(twRule, this.limitInfo.getCycleEndDate()));
            if (null != ruleBasedData && null != (delayDate = (Date)ruleBasedData.get("delayDate")) && delayDate.compareTo(this.limitInfo.getDelayDate()) < 0) {
                this.limitInfo.setDelayDate(delayDate);
            }
            this.limitInfo.setProposer(personPositionInfo.getPerson());
            this.limitInfo.setPosition(personPositionInfo.getPrimaryPosition());
            AtsHolidayFileHisInfo atsHolidayFileHisInfo = (AtsHolidayFileHisInfo)param.get("atsHolidayFileHis");
            if (null != atsHolidayFileHisInfo) {
                this.limitInfo.setAdminOrgUnit(atsHolidayFileHisInfo.getAdminOrgUnit());
                this.limitInfo.setHrOrgUnit(atsHolidayFileHisInfo.getHrOrgUnit());
            }
            this.limitInfo.setCycleType(twRule.getTaskWorkingType());
            try {
                ObjectUuidPK uuidPK = (ObjectUuidPK)HolidayLimitFactory.getLocalInstance(ctx).addnew(this.limitInfo);
                this.limitInfo.setId(uuidPK.getKeyValue());
                logger.error((Object)"insertTakeWorkLimit detail not null");
                this.insertDetailRecord(result, twRule, otType, sourceValue, convRate, convLimit, policyInfo, personPositionInfo);
                logger.error((Object)("limitInfo standardlimit value: " + this.limitInfo.getStandardLimit()));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    protected void insertDetailRecord(HashMap<String, Object> result, AtsTakeWorkingInfo twRule, OTType otType, BigDecimal sourceValue, BigDecimal convRate, BigDecimal convLimit, HolidayPolicyInfo policyInfo, PersonPositionInfo personPositionInfo) throws EASBizException, BOSException {
        if (convLimit.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        OTtoTakeWorkDetailInfo detail = new OTtoTakeWorkDetailInfo();
        detail.setSourceBillId((String)result.get("resultID"));
        detail.setSourceNum(new SimpleDateFormat("yyyy-MM-dd").format((Date)result.get("atsDate")));
        detail.setConvertDate(new Date());
        detail.setPeriodStart(this.limitInfo.getCycleBeginDate());
        detail.setPeriodEnd(this.limitInfo.getCycleEndDate());
        detail.setPeriodDelay(this.limitInfo.getDelayDate());
        detail.setConvertRate(convRate);
        detail.setSource(TakeWorkSourceType.attendRes);
        detail.setSourceUnit(HolidayTypeUnitEnum.hour);
        detail.setSourceValue(sourceValue);
        detail.setLimit(this.limitInfo.getId().toString());
        detail.setLimitUnit(policyInfo.getUnit());
        detail.setLimitValue(convLimit);
        detail.setAdminOrgUnit(this.limitInfo.getAdminOrgUnit());
        detail.setHrOrgUnit(this.limitInfo.getHrOrgUnit());
        detail.setProposer(personPositionInfo.getPerson());
        detail.setPosition(personPositionInfo.getPrimaryPosition());
        detail.setState(OTtoTakeWorkDetailStatus.effected);
        detail.setUnitConvertRule(twRule.getUnitConvertRule());
        detail.setFixedHour(twRule.getFixedHour());
        detail.setEnableMinAmt(policyInfo.isEnableMinAmt());
        detail.setMinAmt(policyInfo.getMinAmt());
        detail.setMinAmtValueMtd(policyInfo.getMinAmtValueMtd());
        detail.setOtDate((Date)result.get("atsDate"));
        detail.setOTType(otType);
        detail.setAttAdminOrgUnit(detail.getAdminOrgUnit());
        this.ioTtoTakeWorkDetail.addnew(detail);
    }
}

