/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.result.AttDynamicItemResInfo;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsAttCalProjectDealUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCalCommonUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsAttItemResultUtils {
    private static Logger logger = Logger.getLogger(AtsAttItemResultUtils.class);
    public static final String TABLENAME = "T_HR_ATS_AttResultItem";

    public static Map<String, String> getStandardProjectMap() {
        LinkedHashMap<String, String> atsCalItemResultMap = new LinkedHashMap<String, String>();
        atsCalItemResultMap.put("FID", "String");
        atsCalItemResultMap.put("FProposerID".toUpperCase(), "String");
        atsCalItemResultMap.put("FAttenceDate".toUpperCase(), "Date");
        atsCalItemResultMap.put("FAdminOrgUnitID".toUpperCase(), "String");
        atsCalItemResultMap.put("FPositionID".toUpperCase(), "String");
        atsCalItemResultMap.put("FHrOrgUnitID".toUpperCase(), "String");
        atsCalItemResultMap.put("FAttadminOrgUnitID".toUpperCase(), "String");
        atsCalItemResultMap.put("FAttpositionID".toUpperCase(), "String");
        atsCalItemResultMap.put("FAtthrOrgUnitID".toUpperCase(), "String");
        atsCalItemResultMap.put("FCreatorID".toUpperCase(), "String");
        atsCalItemResultMap.put("FCreateTime".toUpperCase(), "Date");
        atsCalItemResultMap.put("FLastUpdateUserID".toUpperCase(), "String");
        atsCalItemResultMap.put("FLastUpdateTime".toUpperCase(), "Date");
        atsCalItemResultMap.put("FAttenceStatus".toUpperCase(), "Int");
        atsCalItemResultMap.put("FIsDefaultManage".toUpperCase(), "Boolean");
        atsCalItemResultMap.put("FItemStartDate".toUpperCase(), "Date");
        atsCalItemResultMap.put("FItemEndDate".toUpperCase(), "Date");
        atsCalItemResultMap.put("FItemSourceType".toUpperCase(), "Int");
        atsCalItemResultMap.put("FAttendResultID".toUpperCase(), "String");
        atsCalItemResultMap.put("FSegment".toUpperCase(), "String");
        atsCalItemResultMap.put("FConfirmState".toUpperCase(), "Int");
        atsCalItemResultMap.put("FattendanceType".toUpperCase(), "String");
        atsCalItemResultMap.put("S1", "Date");
        atsCalItemResultMap.put("S2", "Date");
        atsCalItemResultMap.put("S7", "Int");
        atsCalItemResultMap.put("S10", "Int");
        atsCalItemResultMap.put("S13", "Float");
        atsCalItemResultMap.put("S16", "Float");
        atsCalItemResultMap.put("S17", "Float");
        atsCalItemResultMap.put("S18", "Int");
        atsCalItemResultMap.put("S19", "Int");
        atsCalItemResultMap.put("S20", "Int");
        atsCalItemResultMap.put("S21", "Int");
        atsCalItemResultMap.put("S22", "Int");
        atsCalItemResultMap.put("S23", "Float");
        atsCalItemResultMap.put("S24", "Int");
        atsCalItemResultMap.put("S25", "Int");
        atsCalItemResultMap.put("S26", "Int");
        atsCalItemResultMap.put("S27", "Float");
        atsCalItemResultMap.put("S28", "Float");
        atsCalItemResultMap.put("S29", "Int");
        atsCalItemResultMap.put("S30", "Float");
        atsCalItemResultMap.put("S31", "Float");
        atsCalItemResultMap.put("S32", "Float");
        atsCalItemResultMap.put("S33", "Float");
        atsCalItemResultMap.put("S34", "Float");
        atsCalItemResultMap.put("S35", "Float");
        atsCalItemResultMap.put("S36", "Float");
        atsCalItemResultMap.put("S37", "Float");
        atsCalItemResultMap.put("S38", "Int");
        atsCalItemResultMap.put("S41", "Int");
        atsCalItemResultMap.put("S42", "Float");
        atsCalItemResultMap.put("S43", "Float");
        atsCalItemResultMap.put("S44", "Int");
        atsCalItemResultMap.put("S45", "Float");
        atsCalItemResultMap.put("S46", "Float");
        atsCalItemResultMap.put("S47", "Int");
        atsCalItemResultMap.put("S48", "Float");
        atsCalItemResultMap.put("S49", "Float");
        atsCalItemResultMap.put("S50", "Float");
        atsCalItemResultMap.put("S51", "Float");
        atsCalItemResultMap.put("S52", "Float");
        atsCalItemResultMap.put("S53", "Float");
        atsCalItemResultMap.put("S54", "Float");
        atsCalItemResultMap.put("S55", "Float");
        atsCalItemResultMap.put("S56", "Float");
        atsCalItemResultMap.put("S57", "Float");
        atsCalItemResultMap.put("S58", "Float");
        atsCalItemResultMap.put("S59", "Float");
        atsCalItemResultMap.put("S60", "Float");
        atsCalItemResultMap.put("S61", "Float");
        atsCalItemResultMap.put("S62", "Float");
        atsCalItemResultMap.put("S63", "Float");
        atsCalItemResultMap.put("S64", "Int");
        atsCalItemResultMap.put("S65", "Float");
        atsCalItemResultMap.put("S66", "String");
        atsCalItemResultMap.put("S67", "Float");
        atsCalItemResultMap.put("S68", "Float");
        atsCalItemResultMap.put("S69", "Float");
        atsCalItemResultMap.put("S70", "String");
        atsCalItemResultMap.put("S71", "String");
        atsCalItemResultMap.put("S76", "Float");
        atsCalItemResultMap.put("S77", "Float");
        atsCalItemResultMap.put("S78", "Int");
        return atsCalItemResultMap;
    }

    public static void saveItemResultData(Context ctx, Map<Object, Object> globalMap) {
        Map<String, String> atsCalItemResultMap = AtsAttItemResultUtils.getStandardProjectMap();
        Map calItemResultInfoMap = (Map)globalMap.get("atsItemResultInfoMap");
        if (AtsCollectionUtile.isEmpty(atsCalItemResultMap) || AtsCollectionUtile.isEmpty(calItemResultInfoMap)) {
            return;
        }
        List<String> columnNameList = AtsAttCalProjectDealUtils.getResultColumnNameList(atsCalItemResultMap);
        if (AtsCollectionUtile.isEmpty(columnNameList)) {
            return;
        }
        int columnNameSize = columnNameList.size();
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        for (Map.Entry entry : calItemResultInfoMap.entrySet()) {
            List itemResultInfoList = (List)entry.getValue();
            if (AtsCollectionUtile.isEmpty(itemResultInfoList)) continue;
            for (Map itemResultInfo : itemResultInfoList) {
                Object[] param = new Object[columnNameSize];
                for (int index = 0; index < columnNameSize; ++index) {
                    String columnName = columnNameList.get(index);
                    param[index] = AtsAttCalProjectDealUtils.convertorValByType(atsCalItemResultMap, itemResultInfo, columnName);
                }
                insertParamList.add(param);
            }
        }
        if (insertParamList.size() > 0) {
            try {
                DbUtile.executeBatch(ctx, AtsAttCalProjectDealUtils.getAttResultTemplate(atsCalItemResultMap, TABLENAME, 0), insertParamList);
            }
            catch (BOSException e) {
                logger.error((Object)MessageFormat.format("saveItemResultData insert Exception : {0}  ", e.getMessage()));
            }
        }
    }

    public static void calDayResultByItemResult(Context ctx, Map<String, AttendanceDynamicResInfo> resultMap, Map<Object, Object> globalMap) {
        if (AtsCollectionUtile.isEmpty(globalMap)) {
            return;
        }
        Map atsItemResultDetailMap = (Map)globalMap.get("atsItemResultDetailMap");
        Map atsItemInfoByBillMap = (Map)globalMap.get("atsItemInfoByBillMap");
        if (AtsCollectionUtile.isEmpty(atsItemResultDetailMap) && AtsCollectionUtile.isEmpty(atsItemInfoByBillMap)) {
            globalMap.put("atsItemResultInfoMap", null);
            return;
        }
        HashMap<String, List<Map<String, Object>>> calItemResultInfoMap = new HashMap<String, List<Map<String, Object>>>();
        globalMap.put("atsItemResultInfoMap", calItemResultInfoMap);
        AtsAttItemResultUtils.calDayResultByItemResult(ctx, globalMap, resultMap, atsItemResultDetailMap, calItemResultInfoMap);
        AtsAttItemResultUtils.calDayResultByItemResult(ctx, globalMap, resultMap, atsItemInfoByBillMap, calItemResultInfoMap);
    }

    private static void calDayResultByItemResult(Context ctx, Map<Object, Object> globalMap, Map<String, AttendanceDynamicResInfo> resultMap, Map<String, List<AttDynamicItemResInfo>> ItemInfoResMap, Map<String, List<Map<String, Object>>> calItemResultInfoMap) {
        if (AtsCollectionUtile.isEmpty(ItemInfoResMap) || AtsCollectionUtile.isEmpty(resultMap)) {
            return;
        }
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map ppInfoMap = (Map)globalMap.get("ppInfoMap");
        Set<Map.Entry<String, List<AttDynamicItemResInfo>>> entrySet = ItemInfoResMap.entrySet();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String userId = null == user ? "" : user.getId().toString();
        Timestamp createTime = new Timestamp(new Date().getTime());
        for (Map.Entry<String, List<AttDynamicItemResInfo>> entry : entrySet) {
            String personAndDate = entry.getKey();
            List<AttDynamicItemResInfo> itemResInfoList = entry.getValue();
            if (StringUtils.isEmpty((String)personAndDate) || AtsCollectionUtile.isEmpty(itemResInfoList)) continue;
            AttendanceDynamicResInfo dynamicResResultInfo = resultMap.get(personAndDate);
            String personId = AtsCalCommonUtils.getPersonOrDateStrByType(personAndDate, 0);
            PersonPositionInfo personPositionInfo = (PersonPositionInfo)ppInfoMap.get(personId);
            String hrOrgUnitId = null == personPositionInfo.getHrOrgUnit() ? "" : personPositionInfo.getHrOrgUnit().getId().toString();
            List scheduleShiftList = (List)scheduleShiftItemMap.get(personAndDate);
            AttendanceFileInfo attendFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(personAndDate);
            String attadminOrgUnitId = null;
            String attpositionId = null;
            String atthrOrgUnitId = null;
            int isDefaultManage = 0;
            if (scheduleShiftList != null && scheduleShiftList.size() > 0) {
                attadminOrgUnitId = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getAdminOrgUnit() != null && ((ScheduleShiftInfo)scheduleShiftList.get(0)).getAdminOrgUnit().getId() != null ? ((ScheduleShiftInfo)scheduleShiftList.get(0)).getAdminOrgUnit().getId().toString() : attendFileInfo.getAttAdminOrgUnit().getId().toString();
                attpositionId = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getPosition() != null && ((ScheduleShiftInfo)scheduleShiftList.get(0)).getPosition().getId() != null ? ((ScheduleShiftInfo)scheduleShiftList.get(0)).getPosition().getId().toString() : attendFileInfo.getAttPosition().getId().toString();
                atthrOrgUnitId = ((ScheduleShiftInfo)scheduleShiftList.get(0)).getHrOrgUnit() != null && ((ScheduleShiftInfo)scheduleShiftList.get(0)).getHrOrgUnit().getId() != null ? ((ScheduleShiftInfo)scheduleShiftList.get(0)).getHrOrgUnit().getId().toString() : attendFileInfo.getHrOrgUnit().getId().toString();
            }
            String adminOrgId = "";
            String positionId = "";
            if (attendFileInfo != null) {
                if (attendFileInfo.getAttAdminOrgUnit() != null && attendFileInfo.getAttAdminOrgUnit().getId() != null && org.apache.commons.lang.StringUtils.isEmpty((String)attadminOrgUnitId)) {
                    attadminOrgUnitId = attendFileInfo.getAttAdminOrgUnit().getId().toString();
                }
                if (attendFileInfo.getAttPosition() != null && attendFileInfo.getAttPosition().getId() != null) {
                    attpositionId = attendFileInfo.getAttPosition().getId().toString();
                }
                if (attendFileInfo.getHrOrgUnit() != null && attendFileInfo.getHrOrgUnit().getId() != null) {
                    atthrOrgUnitId = attendFileInfo.getHrOrgUnit().getId().toString();
                }
                if (attendFileInfo.isIsDefaultManage()) {
                    isDefaultManage = 1;
                }
                if (attendFileInfo.getAdminOrgUnit() != null && attendFileInfo.getAdminOrgUnit().getId() != null) {
                    adminOrgId = attendFileInfo.getAdminOrgUnit().getId().toString();
                }
                if (attendFileInfo.getPosition() != null && attendFileInfo.getPosition().getId() != null) {
                    positionId = attendFileInfo.getPosition().getId().toString();
                }
            }
            for (int index = 0; index < itemResInfoList.size(); ++index) {
                AttDynamicItemResInfo itemResInfo = itemResInfoList.get(index);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("FID", BOSUuid.create((String)"F3AF93B7").toString());
                paramMap.put("FProposerID".toUpperCase(), personId);
                paramMap.put("FAttenceDate".toUpperCase(), new Timestamp(AtsDateUtils.stringToShortDate(AtsCalCommonUtils.getPersonOrDateStrByType(personAndDate, 1)).getTime()));
                paramMap.put("FAdminOrgUnitID".toUpperCase(), adminOrgId);
                paramMap.put("FPositionID".toUpperCase(), positionId);
                paramMap.put("FHrOrgUnitID".toUpperCase(), hrOrgUnitId);
                paramMap.put("FAttadminOrgUnitID".toUpperCase(), null == itemResInfo.getAttadminOrgUnit() ? adminOrgId : itemResInfo.getAttadminOrgUnit().getId().toString());
                paramMap.put("FAttpositionID".toUpperCase(), attpositionId);
                paramMap.put("FAtthrOrgUnitID".toUpperCase(), atthrOrgUnitId);
                paramMap.put("FCreatorID".toUpperCase(), userId);
                paramMap.put("FCreateTime".toUpperCase(), createTime);
                paramMap.put("FLastUpdateUserID".toUpperCase(), userId);
                paramMap.put("FLastUpdateTime".toUpperCase(), createTime);
                paramMap.put("FAttenceStatus".toUpperCase(), 1);
                paramMap.put("FIsDefaultManage".toUpperCase(), isDefaultManage);
                paramMap.put("FItemStartDate".toUpperCase(), itemResInfo.getItemStartDate());
                paramMap.put("FItemEndDate".toUpperCase(), itemResInfo.getItemEndDate());
                paramMap.put("FItemSourceType".toUpperCase(), itemResInfo.getItemSourceType().getValue());
                paramMap.put("FSegment".toUpperCase(), null == itemResInfo.getSegment() ? "" : itemResInfo.getSegment().getValue());
                paramMap.put("FConfirmState".toUpperCase(), 0);
                paramMap.put("FattendanceType".toUpperCase(), null == itemResInfo.getAttendanceType() ? "" : itemResInfo.getAttendanceType().getValue());
                paramMap.put("S1", itemResInfo.getOnTime());
                paramMap.put("S2", itemResInfo.getOffTime());
                paramMap.put("S7", null == itemResInfo.getLateValue() ? 0 : itemResInfo.getLateValue().intValue());
                paramMap.put("S10", null == itemResInfo.getLeaveValue() ? 0 : itemResInfo.getLeaveValue().intValue());
                paramMap.put("S13", null == itemResInfo.getAbsentValue() ? BigDecimal.ZERO : itemResInfo.getAbsentValue());
                paramMap.put("S16", null == itemResInfo.getDayHour() ? BigDecimal.ZERO : itemResInfo.getDayHour());
                paramMap.put("S17", null == itemResInfo.getDayHourFact() ? BigDecimal.ZERO : itemResInfo.getDayHourFact());
                paramMap.put("S18", null == itemResInfo.getLateTimes() ? 0 : itemResInfo.getLateTimes().intValue());
                paramMap.put("S19", null == itemResInfo.getLateMinuts() ? 0 : itemResInfo.getLateMinuts().intValue());
                paramMap.put("S20", null == itemResInfo.getLeaveTimes() ? 0 : itemResInfo.getLeaveTimes().intValue());
                paramMap.put("S21", null == itemResInfo.getLeaveMinuts() ? 0 : itemResInfo.getLeaveMinuts().intValue());
                paramMap.put("S22", null == itemResInfo.getAbsentTimes() ? 0 : itemResInfo.getAbsentTimes().intValue());
                paramMap.put("S23", null == itemResInfo.getAbsentHours() ? BigDecimal.ZERO : itemResInfo.getAbsentHours());
                paramMap.put("S24", null == itemResInfo.getFillTimes() ? 0 : itemResInfo.getFillTimes().intValue());
                paramMap.put("S25", null == itemResInfo.getSignTimes() ? 0 : itemResInfo.getSignTimes().intValue());
                paramMap.put("S26", null == itemResInfo.getLeaveAtsTimes() ? 0 : itemResInfo.getLeaveAtsTimes().intValue());
                paramMap.put("S27", null == itemResInfo.getLeaveAtsHours() ? BigDecimal.ZERO : itemResInfo.getLeaveAtsHours());
                paramMap.put("S28", null == itemResInfo.getLeaveAtsDays() ? BigDecimal.ZERO : itemResInfo.getLeaveAtsDays());
                paramMap.put("S29", null == itemResInfo.getTripTimes() ? 0 : itemResInfo.getTripTimes().intValue());
                paramMap.put("S30", null == itemResInfo.getTripDays() ? BigDecimal.ZERO : itemResInfo.getTripDays());
                paramMap.put("S31", null == itemResInfo.getTripHours() ? BigDecimal.ZERO : itemResInfo.getTripHours());
                paramMap.put("S32", null == itemResInfo.getTuneOT1Hours() ? BigDecimal.ZERO : itemResInfo.getTuneOT1Hours());
                paramMap.put("S33", null == itemResInfo.getTuneOT2Hours() ? BigDecimal.ZERO : itemResInfo.getTuneOT2Hours());
                paramMap.put("S34", null == itemResInfo.getTuneOT3Hours() ? BigDecimal.ZERO : itemResInfo.getTuneOT3Hours());
                paramMap.put("S35", null == itemResInfo.getOverTimeOT1Hours() ? BigDecimal.ZERO : itemResInfo.getOverTimeOT1Hours());
                paramMap.put("S36", null == itemResInfo.getOverTimeOT2Hours() ? BigDecimal.ZERO : itemResInfo.getOverTimeOT2Hours());
                paramMap.put("S37", null == itemResInfo.getOverTimeOT3Hours() ? BigDecimal.ZERO : itemResInfo.getOverTimeOT3Hours());
                paramMap.put("S38", null == itemResInfo.getLackCardTimes() ? 0 : itemResInfo.getLackCardTimes().intValue());
                paramMap.put("S41", null == itemResInfo.getSickLeaveTimes() ? 0 : itemResInfo.getSickLeaveTimes().intValue());
                paramMap.put("S42", null == itemResInfo.getSickLeaveDays() ? BigDecimal.ZERO : itemResInfo.getSickLeaveDays());
                paramMap.put("S43", null == itemResInfo.getSickLeaveHours() ? BigDecimal.ZERO : itemResInfo.getSickLeaveHours());
                paramMap.put("S44", null == itemResInfo.getYearLeaveTimes() ? 0 : itemResInfo.getYearLeaveTimes().intValue());
                paramMap.put("S45", null == itemResInfo.getYearLeaveDays() ? BigDecimal.ZERO : itemResInfo.getYearLeaveDays());
                paramMap.put("S46", null == itemResInfo.getYearLeaveHours() ? BigDecimal.ZERO : itemResInfo.getYearLeaveHours());
                paramMap.put("S47", null == itemResInfo.getMatterLeaveTimes() ? 0 : itemResInfo.getMatterLeaveTimes().intValue());
                paramMap.put("S48", null == itemResInfo.getMatterLeaveDays() ? BigDecimal.ZERO : itemResInfo.getMatterLeaveDays());
                paramMap.put("S49", null == itemResInfo.getMatterLeaveHours() ? BigDecimal.ZERO : itemResInfo.getMatterLeaveHours());
                paramMap.put("S50", null == itemResInfo.getAttendDays() ? BigDecimal.ZERO : itemResInfo.getAttendDays());
                paramMap.put("S51", null == itemResInfo.getAttendDaysFact() ? BigDecimal.ZERO : itemResInfo.getAttendDaysFact());
                paramMap.put("S52", null == itemResInfo.getTuneLeaveDays() ? BigDecimal.ZERO : itemResInfo.getTuneLeaveDays());
                paramMap.put("S53", null == itemResInfo.getTuneLeaveHours() ? BigDecimal.ZERO : itemResInfo.getTuneLeaveHours());
                paramMap.put("S54", null == itemResInfo.getMarryLeaveDays() ? BigDecimal.ZERO : itemResInfo.getMarryLeaveDays());
                paramMap.put("S55", null == itemResInfo.getBirthDays() ? BigDecimal.ZERO : itemResInfo.getBirthDays());
                paramMap.put("S56", null == itemResInfo.getAccompanyBirthDays() ? BigDecimal.ZERO : itemResInfo.getAccompanyBirthDays());
                paramMap.put("S57", null == itemResInfo.getBirthControlDays() ? BigDecimal.ZERO : itemResInfo.getBirthControlDays());
                paramMap.put("S58", null == itemResInfo.getInjuryDays() ? BigDecimal.ZERO : itemResInfo.getInjuryDays());
                paramMap.put("S59", null == itemResInfo.getVisitDays() ? BigDecimal.ZERO : itemResInfo.getVisitDays());
                paramMap.put("S60", null == itemResInfo.getFuneralDays() ? BigDecimal.ZERO : itemResInfo.getFuneralDays());
                paramMap.put("S61", null == itemResInfo.getOtherLeaveDays() ? BigDecimal.ZERO : itemResInfo.getOtherLeaveDays());
                paramMap.put("S62", null == itemResInfo.getOtherLeaveHours() ? BigDecimal.ZERO : itemResInfo.getOtherLeaveHours());
                paramMap.put("S63", null == itemResInfo.getCheckLeaveHours() ? BigDecimal.ZERO : itemResInfo.getCheckLeaveHours());
                paramMap.put("S64", null == itemResInfo.getIsAllDuty() ? 0 : itemResInfo.getIsAllDuty().intValue());
                paramMap.put("S65", null == itemResInfo.getOtHours() ? BigDecimal.ZERO : itemResInfo.getOtHours());
                paramMap.put("S66", itemResInfo.getShiftInfo());
                paramMap.put("S67", null == itemResInfo.getBreastFeddingDays() ? BigDecimal.ZERO : itemResInfo.getBreastFeddingDays());
                paramMap.put("S68", null == itemResInfo.getBreastFeddingHours() ? BigDecimal.ZERO : itemResInfo.getBreastFeddingHours());
                paramMap.put("S69", null == itemResInfo.getDayHourTrue() ? BigDecimal.ZERO : itemResInfo.getDayHourTrue());
                paramMap.put("S70", itemResInfo.getOnTimeLack());
                paramMap.put("S71", itemResInfo.getOffTimeLack());
                paramMap.put("S76", null == itemResInfo.getSupportHours() ? BigDecimal.ZERO : itemResInfo.getSupportHours());
                paramMap.put("S77", null == itemResInfo.getSupportDays() ? BigDecimal.ZERO : itemResInfo.getSupportDays());
                paramMap.put("S78", null == itemResInfo.getSupportTime() ? 0 : itemResInfo.getSupportTime().intValue());
                List<Map<String, Object>> itemResResultList = calItemResultInfoMap.get(personAndDate);
                if (AtsCollectionUtile.isEmpty(itemResResultList)) {
                    itemResResultList = new ArrayList<Map<String, Object>>();
                    calItemResultInfoMap.put(personAndDate, itemResResultList);
                }
                itemResResultList.add(paramMap);
                AtsAttItemResultUtils.calDayResultInfo(index, dynamicResResultInfo, paramMap, calResultInfoMap, attadminOrgUnitId, personAndDate);
            }
        }
    }

    private static void calDayResultInfo(int index, AttendanceDynamicResInfo dynamicResResultInfo, Map<String, Object> paramMap, Map<String, Map<String, Object>> calResultInfoMap, String attadminOrgUnitId, String personAndDate) {
        boolean insertFlag;
        if (null == calResultInfoMap || AtsCollectionUtile.isEmpty(paramMap)) {
            return;
        }
        Map<String, Object> resultInfo = calResultInfoMap.get(personAndDate);
        boolean bl = insertFlag = null == resultInfo || "insert".equals(resultInfo.get("dataOperateType".toUpperCase()));
        if (null == resultInfo) {
            resultInfo = new HashMap<String, Object>();
            resultInfo.put("FID", BOSUuid.create((String)"F8AED140").toString());
            resultInfo.put("dataOperateType".toUpperCase(), "insert");
            calResultInfoMap.put(personAndDate, resultInfo);
        }
        paramMap.put("FAttendResultID".toUpperCase(), resultInfo.get("FID"));
        if (0 == index) {
            resultInfo.put("FProposerID".toUpperCase(), paramMap.get("FProposerID".toUpperCase()));
            resultInfo.put("FAttenceDate".toUpperCase(), paramMap.get("FAttenceDate".toUpperCase()));
            resultInfo.put("FAdminOrgUnitID".toUpperCase(), paramMap.get("FAdminOrgUnitID".toUpperCase()));
            resultInfo.put("FPositionID".toUpperCase(), paramMap.get("FPositionID".toUpperCase()));
            resultInfo.put("FHrOrgUnitID".toUpperCase(), paramMap.get("FHrOrgUnitID".toUpperCase()));
            resultInfo.put("FAttadminOrgUnitID".toUpperCase(), attadminOrgUnitId);
            resultInfo.put("FAttpositionID".toUpperCase(), paramMap.get("FAttpositionID".toUpperCase()));
            resultInfo.put("FAtthrOrgUnitID".toUpperCase(), paramMap.get("FAtthrOrgUnitID".toUpperCase()));
            resultInfo.put("FCreatorID".toUpperCase(), paramMap.get("FCreatorID".toUpperCase()));
            resultInfo.put("FCreateTime".toUpperCase(), paramMap.get("FCreateTime".toUpperCase()));
            resultInfo.put("FLastUpdateUserID".toUpperCase(), paramMap.get("FLastUpdateUserID".toUpperCase()));
            resultInfo.put("FLastUpdateTime".toUpperCase(), paramMap.get("FLastUpdateTime".toUpperCase()));
            resultInfo.put("FAttenceStatus".toUpperCase(), 1);
            resultInfo.put("FIsDefaultManage".toUpperCase(), paramMap.get("FIsDefaultManage".toUpperCase()));
            resultInfo.put("dataOperateType".toUpperCase(), "insert".equals(resultInfo.get("dataOperateType".toUpperCase())) ? "insert" : "update");
            resultInfo.put("S29", null == dynamicResResultInfo ? 0 : dynamicResResultInfo.getTripTimes().intValue());
            resultInfo.put("S26", null == dynamicResResultInfo ? 0 : dynamicResResultInfo.getLeaveAtsTimes().intValue());
            resultInfo.put("S41", null == dynamicResResultInfo ? 0 : dynamicResResultInfo.getSickLeaveTimes().intValue());
            resultInfo.put("S44", null == dynamicResResultInfo ? 0 : dynamicResResultInfo.getYearLeaveTimes().intValue());
            resultInfo.put("S47", null == dynamicResResultInfo ? 0 : dynamicResResultInfo.getMatterLeaveTimes().intValue());
            resultInfo.put("S66", null == dynamicResResultInfo ? "" : dynamicResResultInfo.getShiftInfo());
            BigDecimal val = AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S28");
            val = val.add(dynamicResResultInfo == null || dynamicResResultInfo.getLeaveAtsDays() == null ? BigDecimal.ZERO : dynamicResResultInfo.getLeaveAtsDays());
            resultInfo.put("S28", val);
        }
        if (null != paramMap.get("FItemSourceType".toUpperCase()) && (Integer)paramMap.get("FItemSourceType".toUpperCase()) == 0) {
            if (index == 0) {
                resultInfo.put("S1", paramMap.get("S1"));
                resultInfo.put("S2", paramMap.get("S2"));
                resultInfo.put("S7", paramMap.get("S7"));
                resultInfo.put("S10", paramMap.get("S10"));
                resultInfo.put("S13", paramMap.get("S13"));
                resultInfo.put("S70", paramMap.get("S70"));
                resultInfo.put("S71", paramMap.get("S71"));
            } else if (index == 1) {
                resultInfo.put("S3", paramMap.get("S1"));
                resultInfo.put("S4", paramMap.get("S2"));
                resultInfo.put("S8", paramMap.get("S7"));
                resultInfo.put("S11", paramMap.get("S10"));
                resultInfo.put("S14", paramMap.get("S13"));
                resultInfo.put("S72", paramMap.get("S70"));
                resultInfo.put("S73", paramMap.get("S71"));
            } else if (index == 2) {
                resultInfo.put("S5", paramMap.get("S1"));
                resultInfo.put("S6", paramMap.get("S2"));
                resultInfo.put("S9", paramMap.get("S7"));
                resultInfo.put("S12", paramMap.get("S10"));
                resultInfo.put("S15", paramMap.get("S13"));
                resultInfo.put("S74", paramMap.get("S70"));
                resultInfo.put("S75", paramMap.get("S71"));
            }
            resultInfo.put("S64", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S64").intValue() == index + 1 ? 1 : 0);
        }
        resultInfo.put("S16", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S16"));
        resultInfo.put("S17", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S17"));
        resultInfo.put("S18", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S18").intValue());
        resultInfo.put("S19", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S19").intValue());
        resultInfo.put("S20", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S20").intValue());
        resultInfo.put("S21", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S21").intValue());
        resultInfo.put("S22", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S22").intValue());
        resultInfo.put("S23", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S23"));
        resultInfo.put("S24", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S24").intValue());
        resultInfo.put("S25", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S25").intValue());
        resultInfo.put("S27", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S27"));
        if (0 < index) {
            resultInfo.put("S28", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S28"));
        }
        resultInfo.put("S30", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S30"));
        resultInfo.put("S31", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S31"));
        resultInfo.put("S32", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S32"));
        resultInfo.put("S33", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S33"));
        resultInfo.put("S34", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S34"));
        resultInfo.put("S35", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S35"));
        resultInfo.put("S36", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S36"));
        resultInfo.put("S37", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S37"));
        resultInfo.put("S38", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S38").intValue());
        resultInfo.put("S42", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S42"));
        resultInfo.put("S43", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S43"));
        resultInfo.put("S45", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S45"));
        resultInfo.put("S46", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S46"));
        resultInfo.put("S48", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S48"));
        resultInfo.put("S49", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S49"));
        resultInfo.put("S50", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S50"));
        resultInfo.put("S51", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S51"));
        resultInfo.put("S52", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S52"));
        resultInfo.put("S53", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S53"));
        resultInfo.put("S54", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S54"));
        resultInfo.put("S55", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S55"));
        resultInfo.put("S56", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S56"));
        resultInfo.put("S57", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S57"));
        resultInfo.put("S58", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S58"));
        resultInfo.put("S59", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S59"));
        resultInfo.put("S60", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S60"));
        resultInfo.put("S61", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S61"));
        resultInfo.put("S62", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S62"));
        resultInfo.put("S63", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S63"));
        resultInfo.put("S65", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S65"));
        resultInfo.put("S67", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S67"));
        resultInfo.put("S68", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S68"));
        resultInfo.put("S69", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S69"));
        resultInfo.put("S76", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S76"));
        resultInfo.put("S77", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S77"));
        resultInfo.put("S78", AtsAttItemResultUtils.countProjectVal(resultInfo, paramMap, "S78").intValue());
        if (null == resultInfo.get("firstFlag".toUpperCase())) {
            resultInfo.put("firstFlag".toUpperCase(), true);
        }
    }

    public static BigDecimal countProjectVal(Map<String, Object> resultInfo, Map<String, Object> paramMap, String projectName) {
        BigDecimal oldProjectVal;
        if (AtsCollectionUtile.isEmpty(resultInfo) || AtsCollectionUtile.isEmpty(paramMap)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = oldProjectVal = null == resultInfo.get(projectName) ? BigDecimal.ZERO : new BigDecimal(resultInfo.get(projectName).toString());
        if (null == resultInfo.get("firstFlag".toUpperCase())) {
            oldProjectVal = BigDecimal.ZERO;
        }
        BigDecimal itemProjectVal = null == paramMap.get(projectName) ? BigDecimal.ZERO : new BigDecimal(paramMap.get(projectName).toString());
        BigDecimal returnProjectVal = oldProjectVal.add(itemProjectVal);
        if (("S50".equals(projectName) || "S51".equals(projectName)) && returnProjectVal.compareTo(BigDecimal.ONE) >= 0) {
            returnProjectVal = BigDecimal.ONE;
        }
        return returnProjectVal;
    }
}

