/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsBillEntryHandlerUtils {
    private static Logger logger = Logger.getLogger(AtsBillEntryHandlerUtils.class);

    public static Map<String, String> getEarliestEntryInfo(CoreBaseInfo billInfo, OperTypeEnum billType) {
        long longBeginTime = 0L;
        int minSeq = -1;
        String beginTime = "";
        String endTime = "";
        String personId = "";
        if (OperTypeEnum.leaveBill.getValue().equals(billType.getValue())) {
            AtsLeaveBillInfo leaveBillInfo = (AtsLeaveBillInfo)billInfo;
            for (int j = 0; j < leaveBillInfo.getEntries().size(); ++j) {
                long tempLongbeginTime = leaveBillInfo.getEntries().get(j).getRealBeginTime().getTime();
                if (tempLongbeginTime >= longBeginTime && longBeginTime != 0L) continue;
                longBeginTime = tempLongbeginTime;
                minSeq = j;
            }
            if (minSeq > -1) {
                personId = leaveBillInfo.getEntries().get(minSeq).getPerson().getId().toString();
                beginTime = AtsDateUtils.timestampToString(leaveBillInfo.getEntries().get(minSeq).getRealBeginTime());
                endTime = AtsDateUtils.timestampToString(leaveBillInfo.getEntries().get(minSeq).getRealEndTime());
            }
        } else if (OperTypeEnum.cancelLeaveBill.getValue().equals(billType.getValue())) {
            CancelLeaveBillInfo cancelleaveInfo = (CancelLeaveBillInfo)billInfo;
            for (int j = 0; j < cancelleaveInfo.getEntries().size(); ++j) {
                long tempLongbeginTime = cancelleaveInfo.getEntries().get(j).getRealLeaBeginTime().getTime();
                if (tempLongbeginTime >= longBeginTime && longBeginTime != 0L) continue;
                longBeginTime = tempLongbeginTime;
                minSeq = j;
            }
            if (minSeq > -1) {
                personId = cancelleaveInfo.getEntries().get(minSeq).getPerson().getId().toString();
                beginTime = AtsDateUtils.timestampToString(cancelleaveInfo.getEntries().get(minSeq).getRealLeaBeginTime());
                endTime = AtsDateUtils.timestampToString(cancelleaveInfo.getEntries().get(minSeq).getRealLeaEndTime());
            }
        } else if (OperTypeEnum.otBill.getValue().equals(billType.getValue())) {
            AtsOverTimeBillInfo atsOverTimeBillInfo = (AtsOverTimeBillInfo)billInfo;
            for (int j = 0; j < atsOverTimeBillInfo.getEntries().size(); ++j) {
                long tempLongbeginTime;
                long l = tempLongbeginTime = atsOverTimeBillInfo.getEntries().get(j).getRealStartTime() == null ? 0L : atsOverTimeBillInfo.getEntries().get(j).getRealStartTime().getTime();
                if (tempLongbeginTime >= longBeginTime && longBeginTime != 0L) continue;
                longBeginTime = tempLongbeginTime;
                minSeq = j;
            }
            if (minSeq > -1) {
                personId = atsOverTimeBillInfo.getEntries().get(minSeq).getPerson().getId().toString();
                beginTime = AtsDateUtils.timestampToString(atsOverTimeBillInfo.getEntries().get(minSeq).getRealStartTime());
                endTime = AtsDateUtils.timestampToString(atsOverTimeBillInfo.getEntries().get(minSeq).getRealEndTime());
            }
        } else if (OperTypeEnum.tripBill.getValue().equals(billType.getValue())) {
            AtsTripBillInfo atsTripBillInfo = (AtsTripBillInfo)billInfo;
            for (int j = 0; j < atsTripBillInfo.getEntries().size(); ++j) {
                long tempLongbeginTime = atsTripBillInfo.getEntries().get(j).getRealTripStartTime().getTime();
                if (tempLongbeginTime >= longBeginTime && longBeginTime != 0L) continue;
                longBeginTime = tempLongbeginTime;
                minSeq = j;
            }
            if (minSeq > -1) {
                personId = atsTripBillInfo.getEntries().get(minSeq).getPerson().getId().toString();
                beginTime = AtsDateUtils.timestampToString(atsTripBillInfo.getEntries().get(minSeq).getRealTripStartTime());
                endTime = AtsDateUtils.timestampToString(atsTripBillInfo.getEntries().get(minSeq).getRealTripEndTime());
            }
        } else if (OperTypeEnum.signCard.getValue().equals(billType.getValue())) {
            FillSignCardInfo fillInfo = (FillSignCardInfo)billInfo;
            for (int j = 0; j < fillInfo.getEntries().size(); ++j) {
                long tempLongbeginTime = fillInfo.getEntries().get(j).getAttendDate().getTime();
                if (tempLongbeginTime >= longBeginTime && longBeginTime != 0L) continue;
                longBeginTime = tempLongbeginTime;
                minSeq = j;
            }
            if (minSeq > -1) {
                personId = fillInfo.getEntries().get(minSeq).getPerson().getId().toString();
                beginTime = AtsDateUtils.dateShortToString(fillInfo.getEntries().get(minSeq).getAttendDate());
            }
            endTime = null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        map.put("personId", personId);
        return map;
    }
}

