/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.hr.ats.util.common.AbstractPagingProcessor;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TwoFieldProcessor<R>
extends AbstractPagingProcessor<Map<String, R>> {
    private Map<String, R> curPageDataForTwoField;
    private Map<String, R> allPageDataForTwoField;
    private boolean mutiModel = false;

    public TwoFieldProcessor() {
    }

    public TwoFieldProcessor(String sql, Context ctx) {
        super(sql, ctx);
    }

    @Override
    public TwoFieldProcessor<R> process() {
        if (StringUtils.isEmpty((String)this.sql)) {
            return this;
        }
        this.beforeProcess();
        this.initDataContainer();
        try {
            while (true) {
                this.beforeQuery();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.pagingHelper.getPagingSqlNoOptmize(this.ctx, this.sql, this.start, this.length));
                this.aftertExecQuery(this.ctx, rs);
                this.afterGetAllRow(this.ctx, this.curPageDataForTwoField);
                if (this.curPageDataForTwoField == null || this.curPageDataForTwoField.size() < this.length) break;
                this.start += this.length;
            }
            this.afterGetAllData(this.ctx, this.allPageDataForTwoField);
        }
        catch (Exception e) {
            if (this.isThrowException()) {
                throw new RuntimeException(e.getMessage(), e);
            }
            AtsLog.getLog().error((Object)e);
        }
        finally {
            this.afterProcess();
        }
        return this;
    }

    protected void afterGetAllRow(Context ctx, Map<String, R> rows) {
    }

    protected void afterGetAllData(Context ctx, Map<String, R> allData) {
    }

    protected boolean validateRowData(Object key, Object value) {
        return true;
    }

    @Override
    protected final HashMap<String, R> assembleRow(IRowSet rs) throws SQLException {
        Object value;
        String key = rs.getString(1);
        if (this.afterGetrow(key, value = rs.getObject(2)).validateRowData(key, value)) {
            if (this.mutiModel) {
                AtsCollectionUtile.updateTargetToValSet(key, value, (HashMap)this.curPageDataForTwoField);
                if (this.collectAllData) {
                    AtsCollectionUtile.updateTargetToValSet(key, value, (HashMap)this.allPageDataForTwoField);
                }
            } else {
                this.curPageDataForTwoField.put(key, value);
                if (this.collectAllData) {
                    this.allPageDataForTwoField.put(key, value);
                }
            }
        }
        return null;
    }

    @Override
    protected void beforeQuery() {
        if (this.curPageDataForTwoField != null) {
            this.curPageDataForTwoField.clear();
        }
    }

    @Override
    protected void initDataContainer() {
        this.initMutiModel();
        PagingHelper pagingHelper = this.pagingHelper = this.pagingHelper == null ? new PagingHelper() : this.pagingHelper;
        if (this.mutiModel) {
            this.curPageDataForTwoField = new LinkedHashMap<String, R>();
            this.allPageDataForTwoField = new LinkedHashMap<String, R>();
        } else {
            this.curPageDataForTwoField = new LinkedHashMap<String, R>();
            this.allPageDataForTwoField = new LinkedHashMap<String, R>();
        }
        this.start = this.start < 0 ? 0 : this.start;
        this.length = this.length > 0 ? this.length : 1;
    }

    protected final TwoFieldProcessor<R> afterGetrow(Object key, Object value) {
        return this;
    }

    private void initMutiModel() {
        try {
            Type c = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            if (Collection.class.isAssignableFrom((Class)((ParameterizedType)c).getRawType())) {
                this.mutiModel = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isMutiModel() {
        return this.mutiModel;
    }

    @Override
    public TwoFieldProcessor<R> setSql(String sql) {
        super.setSql(sql);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setCtx(Context ctx) {
        super.setCtx(ctx);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setOutData(Object outData) {
        super.setOutData(outData);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setCollectAllData(boolean collectAllData) {
        super.setCollectAllData(collectAllData);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setUseTempTable(boolean useTempTable) {
        super.setUseTempTable(useTempTable);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setLength(int length) {
        super.setLength(length);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setStart(int start) {
        super.setStart(start);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setOldSql(String oldSql) {
        super.setOldSql(oldSql);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setTempTableName(String tempTableName) {
        super.setTempTableName(tempTableName);
        return this;
    }

    @Override
    public TwoFieldProcessor<R> setSortExpression(String sordExpression) {
        super.setSortExpression(sordExpression);
        return this;
    }

    public TwoFieldProcessor<R> setMutiModel(boolean mutiModel) {
        this.mutiModel = mutiModel;
        return this;
    }

    public Map<String, R> getCurPageDataForTwoField() {
        return this.curPageDataForTwoField;
    }

    public TwoFieldProcessor<R> setCurPageDataForTwoField(Map<String, R> curPageDataForTwoField) {
        this.curPageDataForTwoField = curPageDataForTwoField;
        return this;
    }

    public Map<String, R> getAllPageDataForTwoField() {
        return this.allPageDataForTwoField;
    }

    public TwoFieldProcessor<R> setAllPageDataForTwoField(Map<String, R> allPageDataForTwoField) {
        this.allPageDataForTwoField = allPageDataForTwoField;
        return this;
    }

    @Override
    @Deprecated
    public List<Map<String, R>> getAllPageData() {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    public TwoFieldProcessor<R> setAllPageData(List<Map<String, R>> allPageData) {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    public List<Map<String, R>> getCurPageData() {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    public TwoFieldProcessor<R> setCurPageData(List<Map<String, R>> curPageData) {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    protected final boolean validateRowData(Map<String, R> curRowData) {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    protected final void afterGetAllRow(Context ctx, List<Map<String, R>> rows) {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    protected final TwoFieldProcessor<R> afterGetrow(Context ctx, List<Map<String, R>> rows, Map<String, R> row) {
        throw new NoSuchMethodError();
    }

    @Override
    @Deprecated
    protected final void afterGetAllData(Context ctx, List<Map<String, R>> allData) {
        throw new NoSuchMethodError();
    }
}

