/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.MergeHelper;
import com.kingdee.eas.hr.ats.validator.ValidatorTpl;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class BaseValidator<T extends CoreBaseInfo>
extends ValidatorTpl<T> {
    @Override
    protected void beforeValidate() throws Exception {
        super.beforeValidate();
        this.initConvertSelectFields();
        this.convert2Targets();
    }

    protected void initConvertSelectFields() {
    }

    protected void convert2Targets() throws BOSException {
        Object target;
        List<Object> targets = this.getValidateCtx().getValidateTargets();
        if (CollectionUtils.isEmpty(targets)) {
            return;
        }
        HashMap<String, Integer> convertIndexMap = new HashMap<String, Integer>(targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            target = targets.get(i);
            if (target == null) {
                targets.remove(i--);
                continue;
            }
            if (!this.isNeedConvert(target)) continue;
            convertIndexMap.put(target instanceof CoreBaseInfo ? ((CoreBaseInfo)target).getString("id") : target.toString(), i);
        }
        Map<String, CoreBaseInfo> convertMap = this.getConvertMap(convertIndexMap);
        MergeHelper mergeHelper = new MergeHelper();
        for (String id : convertIndexMap.keySet()) {
            if (!convertMap.containsKey(id)) continue;
            target = targets.get((Integer)convertIndexMap.get(id));
            if (!(target instanceof CoreBaseInfo)) {
                targets.set((Integer)convertIndexMap.get(id), convertMap.get(id));
                continue;
            }
            mergeHelper.mergeCoreBase((CoreBaseInfo)target, convertMap.get(id));
            targets.set((Integer)convertIndexMap.get(id), target);
        }
    }

    private Map<String, CoreBaseInfo> getConvertMap(Map<String, Integer> convertIndexMap) throws BOSException {
        if (CollectionUtils.isEmpty(convertIndexMap)) {
            return Collections.emptyMap();
        }
        EntityViewInfo entityViewInfo = AtsViewUtile.getViewBySelector(this.getValidateCtx().getConvertSelectFields());
        AtsViewUtile.getViewByFilter("id", convertIndexMap.keySet(), CompareType.INCLUDE, entityViewInfo);
        String billId = convertIndexMap.keySet().iterator().next();
        CoreBaseCollection coll = AtsEntityUtile.getBizInterface(this.getValidateCtx().getBosCtx(), billId).getCollection(entityViewInfo);
        return AtsCollectionUtile.toMap((IObjectCollection)coll, "id", null);
    }

    private boolean isNeedConvert(Object target) {
        if (target == null) {
            return false;
        }
        if (!(target instanceof CoreBaseInfo)) {
            return StringUtils.isNotBlank((CharSequence)target.toString());
        }
        CoreBaseInfo targetCore = (CoreBaseInfo)target;
        if (targetCore.getId() == null) {
            return false;
        }
        List<String> convertSelectFields = this.getValidateCtx().getConvertSelectFields();
        for (int i = 0; i < convertSelectFields.size(); ++i) {
            String[] fields = StringUtils.split((String)convertSelectFields.get(i), (char)'.');
            if (!this.isNeedConvert(targetCore, fields)) continue;
            return true;
        }
        return false;
    }

    private boolean isNeedConvert(CoreBaseInfo targetCore, String[] fields) {
        if (fields.length == 1) {
            return !targetCore.containsKey(fields[0]);
        }
        Object subObj = targetCore.get(fields[0]);
        if (subObj == null) {
            return true;
        }
        if (subObj instanceof CoreBaseInfo) {
            if (this.isNeedConvert((CoreBaseInfo)subObj, Arrays.copyOfRange(fields, 1, fields.length))) {
                return true;
            }
        } else if (subObj instanceof IObjectCollection) {
            Iterator it = ((IObjectCollection)subObj).iterator();
            while (it.hasNext()) {
                if (!this.isNeedConvert((CoreBaseInfo)it.next(), Arrays.copyOfRange(fields, 1, fields.length))) continue;
                return true;
            }
        }
        return false;
    }

    protected String getPersonIdByUser(Object user) throws Exception {
        BOSObjectType type;
        if (user instanceof UserInfo) {
            PersonInfo personInfo = ((UserInfo)user).getPerson();
            Object object = user = personInfo != null && personInfo.getString("id") != null ? personInfo : user;
        }
        if (user instanceof PersonInfo) {
            return ((PersonInfo)user).getString("id");
        }
        String id = user == null ? null : (user instanceof UserInfo ? ((UserInfo)user).getString("id") : String.valueOf(user));
        BOSObjectType bOSObjectType = type = BOSUuid.isValid((String)id, (boolean)true) ? BOSUuid.read((String)id).getType() : null;
        if (new PersonInfo().getBOSType().equals((Object)type)) {
            return id;
        }
        if (id == null || !new UserInfo().getBOSType().equals((Object)type)) {
            return null;
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("person");
        UserInfo userInfo = UserFactory.getLocalInstance((Context)this.getValidateCtx().getBosCtx()).getUserInfo((IObjectPK)new ObjectUuidPK(String.valueOf(id)), selectorItemCollection);
        PersonInfo personInfo = userInfo == null ? null : userInfo.getPerson();
        return personInfo == null ? null : personInfo.getString("id");
    }

    protected boolean isCurrentPerson(Object comparePerson) throws Exception {
        UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)this.getValidateCtx().getBosCtx());
        String currentPersonId = this.getPersonIdByUser(curUserInfo);
        String comparePersonId = this.getPersonIdByUser(comparePerson);
        return comparePersonId != null && comparePersonId.equals(currentPersonId);
    }

    protected String doValidatePerson(T target, String personField) throws Exception {
        String targetPersonId = this.getPersonIdByUser(target.get(personField));
        return this.isCurrentPerson(targetPersonId) ? null : MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", this.getValidateCtx().getBosCtx());
    }

    @Override
    public String validatePerson(T target) throws Exception {
        String errorMsg = super.validatePerson(target);
        return StringUtils.isBlank((CharSequence)errorMsg) ? this.doValidatePerson(target, "creator") : errorMsg;
    }

    protected String validateField(T target, String field) throws Exception {
        Iterator<Object> targetObj = target.get(field);
        if (targetObj == null) {
            return null;
        }
        targetObj = targetObj instanceof IObjectCollection ? ((IObjectCollection)targetObj).iterator() : (targetObj instanceof Collection ? ((Collection)((Object)targetObj)).iterator() : Collections.singletonList(targetObj).iterator());
        HashSet<String> tips = new HashSet<String>();
        Iterator<Object> iterator = targetObj;
        while (iterator.hasNext()) {
            String errorMsg = this.doValidateField(field, iterator.next(), target);
            if (errorMsg == null) continue;
            iterator.remove();
            tips.add(errorMsg);
        }
        String msg = this.afterValidateAllField(target);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            tips.add(msg);
        }
        return tips.size() == 0 ? null : StringUtils.join(tips, (String)"\r\n");
    }

    protected String afterValidateAllField(T target) {
        return null;
    }

    protected String doValidateField(String field, Object subTarget, T target) throws Exception {
        String errorMsg = this.validateFieldDAC(field, subTarget, target);
        return StringUtils.isBlank((CharSequence)errorMsg) && this.getValidateCtx().isNeedValidateBiz(target) ? this.validateFieldBiz(field, subTarget, target) : errorMsg;
    }

    protected String validateFieldDAC(String field, Object subTarget, T target) throws Exception {
        return null;
    }

    protected String validateFieldBiz(String field, Object subTarget, T target) throws Exception {
        return null;
    }
}

