/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstBizObjFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFillSignBizException;
import com.kingdee.eas.hr.ats.AtsFillSignCardResEnum;
import com.kingdee.eas.hr.ats.AtsOrdinalCommonResEnum;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftSegResEnum;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyCycleTypeEnum;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.BillSourceTypeEnum;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.FillSignCardCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardFactory;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.FillSignCardType;
import com.kingdee.eas.hr.ats.FillSignReasonCollection;
import com.kingdee.eas.hr.ats.FillSignReasonFactory;
import com.kingdee.eas.hr.ats.FillSignReasonInfo;
import com.kingdee.eas.hr.ats.IFillSignCard;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogsRecordUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FillsigncardHelper
extends BillHelper {
    public FillsigncardHelper(Context ctx) {
        super(ctx);
    }

    public FillsigncardHelper() {
    }

    public void validateBill(FillSignCardInfo billInfo) throws BOSException, EASBizException {
        this.verifyIsAttenceChecked(billInfo);
        this.verifyIsAdvanceAllow(billInfo.getEntries());
        this.pageDataRepeatChecked(billInfo.getEntries());
        this.DBDataRepeatChecked(billInfo);
        this.fillTimesControl(this.ctx, billInfo.getEntries());
        this.validateIsFillSignCard(this.ctx, billInfo);
    }

    public void fillTimesControl(Context ctx, FillSignCardEntryCollection entries) throws BOSException, HRCommonException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        HashMap<String, AttendanceFileHISInfo> personIdAttendanceFileHisMap = new HashMap<String, AttendanceFileHISInfo>();
        String rowNumStr = "";
        String personIdStr = "";
        String attendDateStr = "";
        for (int i = 0; i < entries.size(); ++i) {
            java.util.Date attenceDate = entries.get(i).getAttendDate();
            String dateStr = AtsDateUtils.dateShortToString(attenceDate);
            String personId = entries.get(i).getPerson().getString("id");
            rowNumStr = rowNumStr + (i + 1) + ",";
            personIdStr = personIdStr + (String)personId + ",";
            attendDateStr = attendDateStr + dateStr + ",";
            AttendanceFileHISInfo realAttendanceFile = FillsigncardHelper.getAttendanceFileHISInfoByAttenceDate(ctx, attenceDate, personId);
            AttendanceFileHISInfo realAttendanceFiles = FillsigncardHelper.getAttendanceFileHISInfoByAttenceDate(ctx, AtsDateUtils.getPreDay(attenceDate), personId);
            if (null == realAttendanceFile && null != realAttendanceFiles) {
                realAttendanceFile = realAttendanceFiles;
            }
            personIdAttendanceFileHisMap.put((String)personId + dateStr, realAttendanceFile);
        }
        rowNumStr = rowNumStr.substring(0, rowNumStr.length() - 1);
        personIdStr = personIdStr.substring(0, personIdStr.length() - 1);
        attendDateStr = attendDateStr.substring(0, attendDateStr.length() - 1);
        Map<Object, Object> res = new HashMap();
        try {
            res = this.getFillSignCradTimesResult(ctx, rowNumStr, personIdStr, attendDateStr, personIdAttendanceFileHisMap);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        HashSet set = new HashSet();
        if (!AtsCollectionUtile.isEmpty(res) && !((Boolean)res.get("errorFlag")).booleanValue()) {
            Map errorMap = (Map)res.get("errorMap");
            for (String key : errorMap.keySet()) {
                set.add(errorMap.get(key));
            }
        }
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)stringBuffer.toString())) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{stringBuffer.toString()});
        }
    }

    public Map<String, Object> getFillSignCradTimesResult(Context ctx, String rowNum, String personID, String attendDate, Map<String, AttendanceFileHISInfo> personIdAttendanceFileHisMap) throws EASBizException, BOSException, ParseException {
        boolean errorFlag = true;
        Map<Object, Object> errorInfo = new HashMap();
        Map<Object, Object> errorMap = new HashMap();
        if (errorMap.size() != 0) {
            errorFlag = false;
        } else {
            errorInfo = this.fillSignCardTimesControlHandler(ctx, rowNum, personID, attendDate, personIdAttendanceFileHisMap);
            if (errorInfo != null && !errorInfo.isEmpty() && !(errorMap = this.errorInfoBuilderTwo(ctx, errorInfo)).isEmpty()) {
                errorFlag = false;
            }
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("errorFlag", errorFlag);
        res.put("errorMap", errorMap);
        return res;
    }

    public Map<String, Object> fillSignCardTimesControlHandler(Context ctx, String rowNums, String personIDs, String attendDates, Map<String, AttendanceFileHISInfo> personIdAttendanceFileHisMap) throws EASBizException, ParseException {
        String[] rowNum = rowNums.split(",");
        String[] personID = personIDs.split(",");
        String[] attendDate = attendDates.split(",");
        Map<String, Object> errorMap = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> fillSignCardInfoMap = new HashMap<String, Map<String, String>>();
        this.fillSignCardInfoMapConstructor(rowNum, personID, attendDate, fillSignCardInfoMap, personIdAttendanceFileHisMap);
        if (fillSignCardInfoMap.isEmpty()) {
            return null;
        }
        Map<String, Integer> FSCTimesAllowMap = this.fillSignCardTimesControlFilterOne(ctx, personIDs, fillSignCardInfoMap, personIdAttendanceFileHisMap);
        Map<String, Map<String, String>> attendancePeriodMap = this.getAttendancePeriodByFillSignCardMulti(ctx, fillSignCardInfoMap, personIdAttendanceFileHisMap);
        Map<Integer, Integer> patternSaveTimes = this.getPatternSaveTimes(fillSignCardInfoMap, attendancePeriodMap);
        Map<String, Map> PatternMixedMap = this.countFillSingCardTimesAndSetPatternMulti(ctx, fillSignCardInfoMap, attendancePeriodMap);
        if (!(fillSignCardInfoMap.isEmpty() || FSCTimesAllowMap.isEmpty() || PatternMixedMap.isEmpty())) {
            errorMap = this.checkFillSignCardTimesCore(ctx, fillSignCardInfoMap, FSCTimesAllowMap, PatternMixedMap, attendancePeriodMap, patternSaveTimes);
        }
        return errorMap;
    }

    public Map<String, Object> checkFillSignCardTimesCore(Context ctx, Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, Integer> FSCTimesAllowMap, Map<String, Map> PatternMixedMap, Map<String, Map<String, String>> attendancePeriodMap, Map<Integer, Integer> patternSaveTimes) {
        Map PatternCodeMap = PatternMixedMap.get("PatternCodeMap");
        Map PatternTimesMap = PatternMixedMap.get("PatternTimesMap");
        HashMap PatternTimesMapOrigin = new HashMap();
        PatternTimesMapOrigin.putAll(PatternTimesMap);
        HashMap<String, String> errorPersonMap = new HashMap<String, String>();
        HashSet<Integer> errorPatternList = new HashSet<Integer>();
        ArrayList<String> errorIndexList = new ArrayList<String>();
        Map<String, Map> attencePolicyMap = this.getAttencePolicyMap(ctx);
        for (String index : fillSignCardInfoMap.keySet()) {
            boolean isControlFSCTimes;
            int patternCode = (Integer)PatternCodeMap.get(index);
            String personId = fillSignCardInfoMap.get(index).get("personId");
            String attendDate = fillSignCardInfoMap.get(index).get("attendDate");
            String attencyPolicyId = fillSignCardInfoMap.get(index).get("attencePolicyId");
            if (FSCTimesAllowMap.get(attencyPolicyId) == null) continue;
            int currentFSCTimes = (Integer)PatternTimesMap.get(patternCode);
            int FSCTimesAllow = FSCTimesAllowMap.get(attencyPolicyId);
            int thisAddTimes = patternSaveTimes.get(patternCode);
            Map tmpMap2 = attencePolicyMap.get(attencyPolicyId);
            if (tmpMap2 == null || !(isControlFSCTimes = Boolean.parseBoolean(tmpMap2.get("isControlFSCTimes").toString())) || currentFSCTimes + thisAddTimes <= FSCTimesAllow) continue;
            errorPatternList.add(patternCode);
            errorIndexList.add(index);
            errorPersonMap.put(index, fillSignCardInfoMap.get(index).get("personId"));
        }
        if (errorPatternList.isEmpty()) {
            return null;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        Map PatternDetailMap = PatternMixedMap.get("PatternDetailMap");
        resMap.put("errorIndexList", errorIndexList);
        resMap.put("errorPatternList", errorPatternList);
        resMap.put("PatternCodeMap", PatternCodeMap);
        resMap.put("PatternTimesMap", PatternTimesMapOrigin);
        resMap.put("PatternDetailMap", PatternDetailMap);
        resMap.put("errorPersonMap", errorPersonMap);
        resMap.put("FSCTimesAllowMap", FSCTimesAllowMap);
        resMap.put("PatternCurrentTimesMap", patternSaveTimes);
        resMap.put("attencePolicyMap", attencePolicyMap);
        return resMap;
    }

    public int getCurrentFillSignCardTimesSingle(Context ctx, String personId, String startDate, String endDate) {
        int resTimes = 0;
        StringBuffer Ksql = new StringBuffer();
        Ksql.append(" select count(*) total \n").append("   from t_hr_ats_fillsigncard a \n").append("   left join t_hr_ats_fillsigncardentry b \n").append("     on a.fid = b.fbillid \n").append("  where a.fbillstate in (1, 2, 3) \n").append("  and b.fpersonid='" + personId + "' \n").append("  and b.fattenddate >= {TS '" + startDate.substring(0, 10) + "'}\n").append("  and b.fattenddate <= {TS '" + endDate.substring(0, 10) + "'}\n");
        try {
            IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)Ksql.toString());
            iRow.next();
            resTimes = iRow.getInt("total");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resTimes;
    }

    public Map<String, Map> countFillSingCardTimesAndSetPatternMulti(Context ctx, Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, Map<String, String>> attendancePeriodMap) {
        HashMap<String, Integer> PatternCodeMap = new HashMap<String, Integer>();
        HashMap<Integer, Integer> PatternTimesMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String[]> PatternDetailMap = new HashMap<Integer, String[]>();
        Iterator<Map.Entry<String, Map<String, String>>> it = fillSignCardInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            String index = entry.getKey();
            String personId = entry.getValue().get("personId");
            String attencePolicyId = entry.getValue().get("attencePolicyId");
            Map<Object, Object> tempMap = new HashMap();
            tempMap = attendancePeriodMap.get(index);
            if (tempMap == null) {
                it.remove();
                continue;
            }
            String startDate = (String)tempMap.get("startDate");
            String endDate = (String)tempMap.get("endDate");
            int patternCode = (personId + attencePolicyId + startDate + endDate).hashCode();
            PatternCodeMap.put(index, patternCode);
            if (PatternTimesMap.containsKey(patternCode)) continue;
            int tmpCurrentFSCTimes = this.getCurrentFillSignCardTimesSingle(ctx, personId, startDate, endDate);
            PatternTimesMap.put(patternCode, tmpCurrentFSCTimes);
            String[] s = new String[]{startDate, endDate, personId, attencePolicyId};
            PatternDetailMap.put(patternCode, s);
        }
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        if (PatternCodeMap.isEmpty() || PatternTimesMap.isEmpty()) {
            return resMap;
        }
        resMap.put("PatternCodeMap", PatternCodeMap);
        resMap.put("PatternTimesMap", PatternTimesMap);
        resMap.put("PatternDetailMap", PatternDetailMap);
        return resMap;
    }

    public Map<Integer, Integer> getPatternSaveTimes(Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, Map<String, String>> attendancePeriodMap) {
        HashSet<String> personAndDateStrs = new HashSet<String>();
        for (String index : fillSignCardInfoMap.keySet()) {
            String personId = fillSignCardInfoMap.get(index).get("personId");
            String attencePolicyId = fillSignCardInfoMap.get(index).get("attencePolicyId");
            Map<String, String> tempMap = attendancePeriodMap.get(index);
            String startDateStr = tempMap.get("startDate");
            String endDateStr = tempMap.get("endDate");
            String personAndDateStr = personId + "," + startDateStr + "," + endDateStr + "," + attencePolicyId;
            personAndDateStrs.add(personAndDateStr);
        }
        HashMap<Integer, Integer> PatternCurrentTimesMap = new HashMap<Integer, Integer>();
        for (String index : fillSignCardInfoMap.keySet()) {
            String attendDateStr = fillSignCardInfoMap.get(index).get("attendDate");
            String personId = fillSignCardInfoMap.get(index).get("personId");
            for (String personAndDateStr : personAndDateStrs) {
                String personIdStr = personAndDateStr.split(",")[0];
                if (!personId.equals(personIdStr)) continue;
                String startDateStr = personAndDateStr.split(",")[1];
                String endDateStr = personAndDateStr.split(",")[2];
                String attencePolicyId = personAndDateStr.split(",")[3];
                String startDateStrLong = startDateStr.substring(0, 10);
                String endDateStrLong = endDateStr.substring(0, 10) + " 23:59:59";
                if (AtsDateUtils.stringToShortDate(attendDateStr).getTime() < AtsDateUtils.stringToShortDate(startDateStrLong).getTime() || AtsDateUtils.stringToShortDate(attendDateStr).getTime() > AtsDateUtils.stringToShortDate(endDateStrLong).getTime()) continue;
                int patternCode = (personId + attencePolicyId + startDateStr + endDateStr).hashCode();
                if (PatternCurrentTimesMap.get(patternCode) != null) {
                    Integer times = (Integer)PatternCurrentTimesMap.get(patternCode);
                    times = times + 1;
                    PatternCurrentTimesMap.put(patternCode, times);
                    continue;
                }
                PatternCurrentTimesMap.put(patternCode, 1);
            }
        }
        return PatternCurrentTimesMap;
    }

    public Map<String, Map<String, String>> getAttendancePeriodByFillSignCardMulti(Context ctx, Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, AttendanceFileHISInfo> personIdAttendanceFileHisMap) throws EASBizException, ParseException {
        HashMap<String, Map<String, String>> resMap = new HashMap<String, Map<String, String>>();
        Iterator<Map.Entry<String, Map<String, String>>> it = fillSignCardInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            String index = entry.getKey();
            Map<String, String> fillSignCardInfo = entry.getValue();
            String personId = fillSignCardInfo.get("personId");
            String attendDate = fillSignCardInfo.get("attendDate");
            if ("".equals(personId) || personId == null) continue;
            AttendanceFileHISInfo hisInfo = personIdAttendanceFileHisMap.get(personId + attendDate);
            Map<String, String> tempMap = this.getAttendancePeriodByFillSignCardSingle(ctx, personId, attendDate, hisInfo.getId().toString());
            if (tempMap == null) {
                it.remove();
                continue;
            }
            resMap.put(index, tempMap);
        }
        return resMap;
    }

    public Map<String, String> getAttendancePeriodByFillSignCardSingle(Context ctx, String personId, String attendDate, String attendanceFileHisId) throws ParseException, EASBizException {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if ("".equals(personId) || personId == null) {
            return null;
        }
        StringBuffer Ksql = new StringBuffer();
        List params = AtsCollectionUtile.toList(attendanceFileHisId);
        Ksql.append(" select d.fstartdate startdate,d.fenddate enddate \n").append("   from T_HR_ATS_AttendanceFileHis a \n").append("   left join T_HR_ATS_AttencePolicy b \n").append("     on a.FAttencePolicyID = b.fid \n").append("   left join T_ATS_AttenceCycle c \n").append("     on b.fattencecycleid = c.fid \n").append("   left join T_HR_ATS_AttendancePeriod d \n").append("     on c.fid = d.FGroupID \n").append(" where a.fid =? \n");
        if (!"".equals(attendDate) && attendDate != null) {
            Date attDate = Date.getDate(attendDate);
            params.add(attDate);
            params.add(attDate);
            Ksql.append(" and d.fstartdate <= ?\n").append(" and d.fenddate >= ?\n");
        }
        Ksql.append("order by d.fstartdate");
        try {
            IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)Ksql.toString(), (Object[])params.toArray());
            if (iRow.size() < 1) {
                return null;
            }
            while (iRow.next()) {
                String startDateStr = iRow.getString("startdate");
                String endDateStr = iRow.getString("enddate");
                tempMap.put("startDate", startDateStr);
                tempMap.put("endDate", endDateStr);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tempMap;
    }

    public Map<String, Integer> fillSignCardTimesControlFilterOne(Context ctx, String personIds, Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, AttendanceFileHISInfo> personIdAttendanceFileHisMap) {
        Map<String, Map> attencePolicyMap = this.getAttencePolicyMap(ctx);
        HashMap<String, Integer> FSCTimesAllowMap = new HashMap<String, Integer>();
        Iterator<Map.Entry<String, Map<String, String>>> it = fillSignCardInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            String index = entry.getKey();
            Map<String, String> tmpMap = entry.getValue();
            String personId = tmpMap.get("personId").toString();
            String attendDate = tmpMap.get("attendDate").toString();
            if (FSCTimesAllowMap.containsKey(personId)) continue;
            AttendanceFileHISInfo fileHisInfo = personIdAttendanceFileHisMap.get(personId + attendDate);
            String attencePolicyId = fileHisInfo.getAttencePolicy().getId().toString();
            if (attencePolicyId != null && !"".equals(attencePolicyId)) {
                Map tmpMap2 = attencePolicyMap.get(attencePolicyId);
                if (tmpMap2 != null) {
                    boolean isControlFSCTimes = Boolean.parseBoolean(tmpMap2.get("isControlFSCTimes").toString());
                    if (!isControlFSCTimes) continue;
                    int fillSignCardTimesAllow = (Integer)tmpMap2.get("fillSignCardTimesAllow");
                    FSCTimesAllowMap.put(attencePolicyId, fillSignCardTimesAllow);
                    continue;
                }
                it.remove();
                continue;
            }
            it.remove();
        }
        return FSCTimesAllowMap;
    }

    public Map<String, Map> getAttencePolicyMap(Context ctx) {
        HashMap<String, Map> attencePolicyMap = new HashMap<String, Map>();
        try {
            AttencePolicyCollection attencePolicyColl = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyCollection();
            for (int i = 0; i < attencePolicyColl.size(); ++i) {
                String attencePolicyBillId = attencePolicyColl.get(i).getId().toString();
                boolean isControlFSCTimes = attencePolicyColl.get(i).isIsControlFSCTimes();
                int fillSignCardTimesAllow = attencePolicyColl.get(i).getFillSignCardTimesAllow();
                HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                tmpMap.put("isControlFSCTimes", isControlFSCTimes);
                tmpMap.put("fillSignCardTimesAllow", fillSignCardTimesAllow);
                tmpMap.put("attencePolicyName", attencePolicyColl.get(i).getName());
                attencePolicyMap.put(attencePolicyBillId, tmpMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attencePolicyMap;
    }

    public void fillSignCardInfoMapConstructor(String[] rowNum, String[] personID, String[] attendDate, Map<String, Map<String, String>> fillSignCardInfoMap, Map<String, AttendanceFileHISInfo> personIdAttendanceFileHisMap) {
        for (int i = 0; i < rowNum.length; ++i) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            tmpMap.put("personId", personID[i]);
            tmpMap.put("attendDate", attendDate[i]);
            AttendanceFileHISInfo hisInfo = personIdAttendanceFileHisMap.get(personID[i] + attendDate[i]);
            tmpMap.put("attencePolicyId", hisInfo.getAttencePolicy().getId().toString());
            fillSignCardInfoMap.put(rowNum[i], tmpMap);
        }
    }

    public Map<String, String> errorInfoBuilderTwo(Context ctx, Map<String, Object> errorInfo) throws EASBizException, BOSException {
        Map PatternCodeMap = (Map)errorInfo.get("PatternCodeMap");
        Map PatternTimesMap = (Map)errorInfo.get("PatternTimesMap");
        Map PatternDetailMap = (Map)errorInfo.get("PatternDetailMap");
        Map errorPersonMap = (Map)errorInfo.get("errorPersonMap");
        ArrayList errorIndexList = (ArrayList)errorInfo.get("errorIndexList");
        Map FSCTimesAllowMap = (Map)errorInfo.get("FSCTimesAllowMap");
        Map PatternCurrentTimesMap = (Map)errorInfo.get("PatternCurrentTimesMap");
        HashMap<String, String> resMap = new HashMap<String, String>();
        Map attencePolicyMap = (Map)errorInfo.get("attencePolicyMap");
        for (String index : errorIndexList) {
            int patternCode = (Integer)PatternCodeMap.get(index);
            String personId = (String)errorPersonMap.get(index);
            ObjectUuidPK pk = new ObjectUuidPK(personId);
            PersonInfo ppi = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
            String personName = ppi.getName();
            String startDate = ((String[])PatternDetailMap.get(patternCode))[0].substring(0, 10);
            String endDate = ((String[])PatternDetailMap.get(patternCode))[1].substring(0, 10);
            String attencePolicyId = ((String[])PatternDetailMap.get(patternCode))[3];
            int currentFSCTimes = (Integer)PatternTimesMap.get(patternCode);
            int allowTimes = (Integer)FSCTimesAllowMap.get(attencePolicyId);
            int leftTimes = allowTimes - currentFSCTimes;
            leftTimes = leftTimes < 0 ? 0 : leftTimes;
            int currentTimes = (Integer)PatternCurrentTimesMap.get(patternCode);
            StringBuffer sb = new StringBuffer("");
            String attencePolicyName = (String)((Map)attencePolicyMap.get(attencePolicyId)).get("attencePolicyName");
            sb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.RestDetalAndFillSignTime, ctx, personName, attencePolicyName, startDate, endDate, currentTimes, leftTimes));
            resMap.put(index, sb.toString());
        }
        return resMap;
    }

    @Override
    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T bill) throws BOSException, EASBizException {
        super.storefields(ctx, bill);
        this.storeEntryfields(ctx, ((FillSignCardInfo)bill).getEntries());
        return bill;
    }

    public void storeEntryfields(Context ctx, FillSignCardEntryCollection entries) throws EASBizException, BOSException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            FillSignCardEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getType() == null) {
                entryInfo.setType(FillSignCardType.fillCard);
            }
            if (entryInfo.getFillCardTime() != null || entryInfo.getAttendDate() == null || entryInfo.getFillCardTimeStr() == null) continue;
            String temp_attendDate = Date.getNoNullDate(entryInfo.getAttendDate()).toDateStr();
            String temp_fillCardTime = temp_attendDate + " " + entryInfo.getFillCardTimeStr();
            entryInfo.setFillCardTime(Date.getNoNullTime(temp_fillCardTime));
        }
    }

    public String validateIsFillSignCard(Context ctx, FillSignCardInfo signCardInfo) throws EASBizException, BOSException {
        String errorString = "";
        String extraString = "";
        String buffer = "";
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (signCardInfo == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        FillSignCardEntryCollection signCardEntryCollection = signCardInfo.getEntries();
        if (signCardEntryCollection == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        Calendar applyCal = Calendar.getInstance();
        if (signCardInfo.getId() != null && this.isInWorkFlow(signCardInfo.getId().toString())) {
            FillSignCardInfo signCardInfoDB = signCardInfo;
            if (signCardInfo.getApplyDate() == null) {
                signCardInfoDB = FillSignCardFactory.getLocalInstance(ctx).getFillSignCardInfo((IObjectPK)new ObjectUuidPK(signCardInfo.getId().toString()));
            }
            applyCal.setTime(signCardInfoDB.getApplyDate());
        }
        applyCal.setTime(AttencePolicyFillUtil.formatCalendar(applyCal));
        java.util.Date applyDate = applyCal.getTime();
        Iterator itr = signCardEntryCollection.iterator();
        FillSignCardEntryInfo signCardEntryInfo = null;
        int rowNumber = 0;
        while (itr.hasNext()) {
            ++rowNumber;
            signCardEntryInfo = (FillSignCardEntryInfo)itr.next();
            String personId = signCardEntryInfo != null && signCardEntryInfo.getPerson() != null && signCardEntryInfo.getPerson().getId() != null ? signCardEntryInfo.getPerson().getId().toString() : "";
            errorString = "";
            boolean isFillSignCard = false;
            AttencePolicyInfo attencePolicyInfo = AttencePolicyFillUtil.getAttencePolicyInfo(ctx, null, personId, signCardEntryInfo.getAttendDate());
            java.util.Date attendDate = signCardEntryInfo.getAttendDate();
            if (attencePolicyInfo == null) {
                errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            } else {
                isFillSignCard = attencePolicyInfo.isIsFillSignCard();
            }
            if (!isFillSignCard) continue;
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (signCardEntryInfo.getAttendDate() == null && StringUtils.isEmpty((String)signCardEntryInfo.getFillCardTimeStr())) {
                errorString = MLUtile.getRes(AtsFillSignCardResEnum.NullFillCardTime, ctx) + "!";
            } else {
                String dtStr = df1.format(signCardEntryInfo.getAttendDate()) + " " + signCardEntryInfo.getFillCardTimeStr().trim() + ":00";
                Timestamp ts = null;
                try {
                    ts = new Timestamp(df2.parse(dtStr).getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                long time = null == ts ? null : Long.valueOf(ts.getTime());
                boolean isFillSignCardByTimeCtl = attencePolicyInfo.isFillSignCardByTimeCtl();
                boolean isFillSignCardByCycleCtrl = attencePolicyInfo.isFillSignCardByCycleCtl();
                if (isFillSignCardByTimeCtl) {
                    BigDecimal amount = attencePolicyInfo.getFillSignCardAmount();
                    FillAmountUnitEnum unit = attencePolicyInfo.getFillSignCardAmountUnit();
                    errorString = AttencePolicyFillUtil.validateByTimeControle(ctx, amount, unit, applyDate, 2, attencePolicyInfo, attendDate);
                }
                if (isFillSignCardByCycleCtrl && StringUtils.isEmpty((String)errorString)) {
                    if (AttencePolicyCycleTypeEnum.attendanceCycle.equals((Object)attencePolicyInfo.getFillSignCardCycleType()) && FillAmountUnitEnum.mouthEndDay.equals((Object)attencePolicyInfo.getFillSignCardAfterDayUnit())) {
                        Boolean ok = false;
                        try {
                            String attenceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                            int number = attencePolicyInfo.getFillSignCardAfterDay().intValue();
                            ok = AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(ctx, attenceCycleId, number, dtStr, signCardInfo.getApplyDate());
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                        errorString = null != ok && ok != false ? "" : MLUtile.getRes(AtsFillSignCardResEnum.OverFillAmount, ctx);
                    } else {
                        int fillSignCardCycleType = attencePolicyInfo.getFillSignCardCycleType().getValue();
                        BigDecimal afterDay = attencePolicyInfo.getFillSignCardAfterDay();
                        errorString = AttencePolicyFillUtil.validateByCycleControle(ctx, attencePolicyInfo, time, fillSignCardCycleType, afterDay.intValue(), 2);
                    }
                }
            }
            if (StringUtils.isEmpty((String)errorString)) continue;
            buffer = errorString;
            if (signCardInfo.getBillType() != null) {
                if (signCardInfo.getBillType().getValue() == 1) continue;
                rows.add(rowNumber);
                continue;
            }
            if (signCardEntryCollection.size() <= 1) continue;
            rows.add(rowNumber);
        }
        if (rows.size() > 0) {
            String rowTemp = "";
            for (int i = 0; i < rows.size(); ++i) {
                rowTemp = i == rows.size() - 1 ? rowTemp + rows.get(i) : rowTemp + rows.get(i) + "\u3001";
            }
            extraString = BillSourceTypeEnum.lightApp.equals(signCardInfo.get("billSourceType")) ? MLUtile.getRes((ResourceEnum)AtsCommonResEnum.Detail, ctx, rowTemp) : MLUtile.getRes((ResourceEnum)AtsCommonResEnum.Detail, ctx, rowTemp);
        }
        if (!StringUtils.isEmpty((String)(extraString + buffer))) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{extraString + buffer});
        }
        return extraString + buffer;
    }

    public boolean isInWorkFlow(String bizObjId) throws BOSException {
        if (StringUtils.isEmpty((String)bizObjId)) {
            return false;
        }
        boolean boo = false;
        String cndtn = null;
        if (bizObjId.indexOf(",") > 0) {
            String[] ids = org.apache.commons.lang3.StringUtils.split((String)bizObjId, (String)",");
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                cndtn = i == 0 ? "(bizObjID = '" + ids[i] + "' " : cndtn + "or bizObjID = '" + ids[i] + "' ";
            }
            cndtn = cndtn + ")";
        } else {
            cndtn = "(bizObjID = '" + bizObjId + "')";
        }
        String oql = "where " + cndtn;
        ProcInstBizObjCollection piboc = ProcInstBizObjFactory.getRemoteInstance().getCollection(oql);
        if (piboc != null && piboc.size() > 0) {
            boo = true;
        }
        return boo;
    }

    public ArrayList<RangeDate> getLastThreePeriod(Context ctx, String personId, java.util.Date date) throws BOSException {
        ArrayList<RangeDate> rangeDates = new ArrayList<RangeDate>();
        if (StringUtils.isEmpty((String)personId)) {
            return new ArrayList<RangeDate>();
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        Timestamp lastTwoMonthTime = new Timestamp(AtsDateUtils.dateAdd(date, 2, -2).getTime());
        StringBuffer sql = new StringBuffer();
        sql.append(" select  period.fstartdate  startdate, period.fenddate  enddate   from T_HR_ATS_AttendanceFileHIS his ");
        sql.append(" left join T_HR_ATS_AttencePolicy policy  on his.FAttencePolicyID = policy.fid ");
        sql.append(" left join T_ATS_AttenceCycle cycle on policy.FAttenceCycleID = cycle.fid ");
        sql.append(" left join T_HR_ATS_AttendancePeriod  period on period.FGroupID = cycle.fid and period.fattendPeriodState ='1' ");
        sql.append(" and period.fstartdate <= ? and period.fenddate >= ? ");
        sql.append(" where his.feffdt <= ? and fleffdt >= ? and his.fattendfilestate = '1' and his.fproposerid= ? ");
        sql.append(" order by period.fstartdate desc ");
        IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{timestamp, lastTwoMonthTime, timestamp, timestamp, personId});
        try {
            while (iRowSet != null && iRowSet.size() > 0 && iRowSet.next()) {
                rangeDates.add(new RangeDate(iRowSet.getDate("startdate"), iRowSet.getDate("enddate")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rangeDates;
    }

    public ArrayList<String> getPeriodBeginAndEndTime(Context ctx, String personId, java.util.Date date) throws BOSException {
        ArrayList<String> dateList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)personId)) {
            return new ArrayList<String>();
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        StringBuffer sql = new StringBuffer();
        sql.append(" select  period.fstartdate  startdate, period.fenddate  enddate from T_HR_ATS_AttendanceFileHIS his ");
        sql.append(" left join T_HR_ATS_AttencePolicy policy  on his.FAttencePolicyID = policy.fid ");
        sql.append(" left join T_ATS_AttenceCycle cycle on policy.FAttenceCycleID = cycle.fid ");
        sql.append(" left join T_HR_ATS_AttendancePeriod  period on period.FGroupID = cycle.fid and period.fstartdate <= ? and period.fenddate >= ? ");
        sql.append(" where his.feffdt <= ? and fleffdt >= ? and his.fattendfilestate = '1' and his.fproposerid= ? ");
        IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{timestamp, timestamp, timestamp, timestamp, personId});
        try {
            while (iRowSet != null && iRowSet.size() > 0 && iRowSet.next()) {
                String startdate = iRowSet.getString("startdate").substring(0, 10);
                String enddate = iRowSet.getString("enddate").substring(0, 10);
                dateList.add(startdate);
                dateList.add(enddate);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dateList;
    }

    public Map<String, Object> getLackpunchCard(Context ctx, String personId, String beginDate, String endDate) throws HRCommonException {
        int rows = 130;
        int page = 1;
        LinkedHashMap<String, Object> gridDataMap = new LinkedHashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("personId", personId);
        map.put("beginDate", beginDate);
        map.put("endDate", endDate);
        String sql = this.getDynamicQueryPageSql(map);
        List<Map<String, Object>> rowList = this.getLackPunchCardDetail(sql, rows, page, "", 0, map);
        int totalCount = Integer.parseInt(map.get("totalCount"));
        if (rows == 0 || totalCount % rows == 0) {
            gridDataMap.put("total", rows == 0 ? totalCount : totalCount / rows);
        } else {
            gridDataMap.put("total", totalCount / rows + 1);
        }
        gridDataMap.put("page", page);
        gridDataMap.put("records", totalCount);
        gridDataMap.put("rows", rowList);
        return gridDataMap;
    }

    public List<Map<String, Object>> getLackPunchCardDetail(String sql, int rows, int page, String flag, int totalCount, HashMap<String, String> params) throws HRCommonException {
        ArrayList<Map<String, Object>> detailList = new ArrayList<Map<String, Object>>();
        String[] segmentCN = MLUtile.getRes(AtsOrdinalCommonResEnum.TitleOneToThree, this.ctx).split(",");
        try {
            IRowSet rowSet = this.executeQueryPaging(sql, rows, page, flag, totalCount, params);
            int id = rows * (page - 1);
            while (rowSet.next()) {
                ++id;
                String personId = rowSet.getString("personfid");
                String personName = rowSet.getString("personname");
                String personNum = rowSet.getString("personnumber");
                String attenceDate = rowSet.getString("attencedate").substring(0, 10);
                String hrOrgUnitId = rowSet.getString("hrOrgUnitId");
                String hrOrgUnitName = rowSet.getString("hrOrgUnitName");
                int temp_pos = Integer.parseInt(rowSet.getString("segment").substring(1));
                int temp_segment = temp_pos <= 2 ? 1 : (temp_pos <= 4 ? 2 : 3);
                String temp_segmentCN = segmentCN[temp_segment - 1];
                String temp_timeCN = temp_pos % 2 == 0 ? MLUtile.getRes(AtsShiftResEnum.OffWork, this.ctx) : MLUtile.getRes(AtsShiftResEnum.OnWork, this.ctx);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("ID", id);
                map.put("proposerID", personId);
                map.put("proposerNumber", personNum);
                map.put("proposerName", personName);
                map.put("attendDate", attenceDate);
                map.put("hrOrgUnitId", hrOrgUnitId);
                map.put("hrOrgUnitName", hrOrgUnitName);
                map.put("punchCardTime", MLUtile.getRes((ResourceEnum)AtsShiftSegResEnum.ShiftRelate99, this.ctx, temp_segmentCN, temp_timeCN));
                map.put("segment", temp_pos);
                map.put("lackPunchCardTime", rowSet.getString("lackPunchCardTime"));
                detailList.add(map);
            }
        }
        catch (SQLException s) {
            s.printStackTrace();
        }
        return detailList;
    }

    public IRowSet executeQueryPaging(String sql, int rows, int page, String flag, int totalCount, HashMap<String, String> params) throws HRCommonException {
        Context ctx = this.getCtx();
        String afterPagingSql = "";
        int dbType = AtsBaseUtils.getDbType(ctx);
        try {
            PagingHelper pageHelper = new PagingHelper();
            int length = rows;
            if (StringUtils.isEmpty((String)flag)) {
                String totalSql = this.getDynamicQueryPageTotalSql(params);
                totalCount = this.getTotalCount(totalSql);
            }
            params.put("totalCount", String.valueOf(totalCount));
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            afterPagingSql = pageHelper.getPagingSqlNoOptmize(dbType, sql, (page - 1) * rows, length);
        }
        catch (Exception e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{e.getMessage()});
        }
        return FillsigncardHelper.executeQuery(ctx, afterPagingSql);
    }

    public String getDynamicQueryPageTotalSql(HashMap<String, String> params) throws EASBizException, BOSException {
        String personId = params.get("personId");
        String beginDate = params.get("beginDate");
        String endDate = params.get("endDate");
        String filterInfo = this.getFilterSql(personId, beginDate, endDate);
        String sql_s1 = this.getPageSqlSelectorTotal("s1") + filterInfo;
        String sql_s2 = this.getPageSqlSelectorTotal("s2") + filterInfo;
        String sql_s3 = this.getPageSqlSelectorTotal("s3") + filterInfo;
        String sql_s4 = this.getPageSqlSelectorTotal("s4") + filterInfo;
        String sql_s5 = this.getPageSqlSelectorTotal("s5") + filterInfo;
        String sql_s6 = this.getPageSqlSelectorTotal("s6") + filterInfo;
        StringBuffer dynamicQuery = new StringBuffer("");
        dynamicQuery.append(" SELECT sum(total) as total FROM ( ").append(sql_s1).append(" union all ").append(sql_s2).append(" union all ").append(sql_s3).append(" union all ").append(sql_s4).append(" union all ").append(sql_s5).append(" union all ").append(sql_s6).append(" )T1 ");
        String sort = "";
        return dynamicQuery.toString();
    }

    public static IRowSet executeQuery(Context ctx, String sql) {
        IRowSet rowSet = null;
        try {
            long begin = System.currentTimeMillis();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            System.out.println("data count:" + (System.currentTimeMillis() - begin));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    public int getTotalCount(String sql) throws BOSException {
        Context ctx = this.getCtx();
        String str = sql;
        if (sql.indexOf("order by ") != -1) {
            str = sql.substring(0, sql.indexOf("order by "));
        }
        String countSql = "SELECT ";
        countSql = countSql + (sql.toLowerCase().contains("total") ? "total" : "count(1)");
        countSql = countSql + " from (" + str + ")T";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
        int totalCount = FillsigncardHelper.getTotalCount(rowSet);
        return totalCount;
    }

    public static int getTotalCount(IRowSet rowSet) {
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                try {
                    totalCount = rowSet.getInt(1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return totalCount;
    }

    public String getDynamicQueryPageSql(HashMap<String, String> map) {
        String sidx = "";
        String sord = "";
        String personId = map.get("personId");
        String beginDate = map.get("beginDate");
        String endDate = map.get("endDate");
        String filterInfo = this.getFilterSql(personId, beginDate, endDate);
        String sql_s1 = this.getPageSqlSelector("s1") + filterInfo;
        String sql_s2 = this.getPageSqlSelector("s2") + filterInfo;
        String sql_s3 = this.getPageSqlSelector("s3") + filterInfo;
        String sql_s4 = this.getPageSqlSelector("s4") + filterInfo;
        String sql_s5 = this.getPageSqlSelector("s5") + filterInfo;
        String sql_s6 = this.getPageSqlSelector("s6") + filterInfo;
        StringBuffer dynamicQuery = new StringBuffer("");
        dynamicQuery.append(" SELECT attencedate,personname,personnumber,hrOrgUnitName,hrOrgUnitId,personfid,segment ,lackPunchCardTime  FROM ( ").append(sql_s1).append(" union all ").append(sql_s2).append(" union all ").append(sql_s3).append(" union all ").append(sql_s4).append(" union all ").append(sql_s5).append(" union all ").append(sql_s6).append(" )T1 ");
        String sort = "";
        if (StringUtils.isEmpty((String)sidx) || StringUtils.isEmpty((String)sord) || sidx.equalsIgnoreCase("punchCardTime") || sidx.equalsIgnoreCase("lackPunchCardTime")) {
            sort = " order by personnumber, attencedate asc,segment";
        } else {
            String sortName = "";
            sortName = sidx.equalsIgnoreCase("proposerNumber") ? "personnumber" : (sidx.equalsIgnoreCase("proposerName") ? "personname" : "attencedate");
            sort = " order by " + sortName + " " + sord;
        }
        dynamicQuery.append(sort);
        return dynamicQuery.toString();
    }

    public String getFilterSql(String personId, String beginDate, String endDate) {
        StringBuffer filterInfo = new StringBuffer("");
        if (!StringUtils.isEmpty((String)personId)) {
            filterInfo.append(" and person.fid  = '" + personId + "'");
        }
        if (!StringUtils.isEmpty((String)beginDate)) {
            filterInfo.append(" and result.FattenceDate >= {TS '" + beginDate + "'}");
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            filterInfo.append(" and result.FattenceDate <= {TS '" + endDate + "'}");
        }
        return filterInfo.toString();
    }

    public void verifyIsAdvanceAllow(FillSignCardEntryCollection entries) throws HRCommonException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        ArrayList<String> reasons = new ArrayList<String>();
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            for (int i = 0; i < entries.size(); ++i) {
                FillSignCardEntryInfo entry = entries.get(i);
                reasons.add(CoreBaseUtile.getId(AtsCommonUtile.getValueLazy(this.getCtx(), (IObjectValue)entry, "reason")));
            }
        }
        ArrayList<FillSignReasonInfo> fillSignReasonList = this.getFillSignReason(reasons);
        java.util.Date curDate = new java.util.Date();
        for (int i = 0; i < entries.size(); ++i) {
            FillSignCardEntryInfo fillSignCardEntryInfo = entries.get(i);
            String fillSignCardTimeStr = AtsDateUtils.dateShortToString(fillSignCardEntryInfo.getAttendDate()).substring(0, 10) + " " + fillSignCardEntryInfo.getFillCardTimeStr() + ":00";
            for (int j = 0; j < fillSignReasonList.size(); ++j) {
                FillSignReasonInfo reasonInfo = fillSignReasonList.get(j);
                if (!reasonInfo.getString("id").equalsIgnoreCase(fillSignCardEntryInfo.getReason().getString("id")) || reasonInfo.isIsAdvanceAllow() || !curDate.before(AtsDateUtils.stringToLongDate(fillSignCardTimeStr))) continue;
                String prefix = MLUtile.getRes((ResourceEnum)AtsCommonResEnum.Detail, this.getCtx(), j + 1) + ",";
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{prefix + new AtsFillSignBizException(AtsFillSignBizException.FORBIDAPPLYAHEADBYCAUSE).getMessage()});
            }
        }
    }

    public ArrayList<FillSignReasonInfo> getFillSignReason(ArrayList<String> reasons) {
        ArrayList<FillSignReasonInfo> reasonList = new ArrayList<FillSignReasonInfo>();
        if (AtsCollectionUtile.isEmpty(reasons)) {
            return reasonList;
        }
        HashSet<String> reasonSet = new HashSet<String>(reasons);
        try {
            FillSignReasonCollection defaultInfoColl = FillSignReasonFactory.getLocalInstance(this.ctx).getFillSignReasonCollection(" where id in (" + AtsCollectionUtile.joinForSql(reasonSet) + ")");
            if (defaultInfoColl != null && defaultInfoColl.size() > 0) {
                for (int i = 0; i < defaultInfoColl.size(); ++i) {
                    FillSignReasonInfo reasonInfo = new FillSignReasonInfo();
                    reasonInfo.setId(defaultInfoColl.get(i).getId());
                    reasonInfo.setName(defaultInfoColl.get(i).getName());
                    reasonInfo.setIsAdvanceAllow(defaultInfoColl.get(i).isIsAdvanceAllow());
                    reasonList.add(reasonInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reasonList;
    }

    public void verifyIsAttenceChecked(FillSignCardInfo billinfo) throws BOSException, HRCommonException {
        StringBuffer errorSb = new StringBuffer("");
        String hrOrgUnitId = billinfo.getHrOrgUnit().getString("id");
        String attDate = "";
        String personId = "";
        FillSignCardEntryCollection entries = billinfo.getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            FillSignCardEntryInfo entry = entries.get(i);
            personId = entry.getPerson().getString("id");
            java.util.Date attenceDate = entry.getAttendDate();
            attDate = AtsDateUtils.dateShortToString(entry.getAttendDate());
            AttendanceFileHISInfo realAttendanceFile = FillsigncardHelper.getAttendanceFileHISInfoByAttenceDate(this.ctx, attenceDate, personId);
            AttendanceFileHISInfo realAttendanceFile1 = FillsigncardHelper.getAttendanceFileHISInfoByAttenceDate(this.ctx, AtsDateUtils.getPreDay(attenceDate), personId);
            if (null == realAttendanceFile && realAttendanceFile1 != null) {
                realAttendanceFile = realAttendanceFile1;
            }
            if (realAttendanceFile == null) {
                errorSb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.ForbidFillSignOrder2Move, this.ctx, i + 1, attDate));
                continue;
            }
            if (!hrOrgUnitId.equals(realAttendanceFile.getHrOrgUnit().getId().toString())) {
                errorSb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.ForbidFillSignOrder4Move, this.ctx, i + 1, realAttendanceFile.getProposer().getName() + "(" + realAttendanceFile.getProposer().getNumber() + ")" + attDate, realAttendanceFile.getHrOrgUnit().getDisplayName(), AtsDateUtils.dateShortToString(realAttendanceFile.getEFFDT()), AtsDateUtils.dateShortToString(realAttendanceFile.getLEFFDT())));
            }
            if (realAttendanceFile.getIsAttendance().getValue().equals("0")) {
                errorSb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.ForbidFillSignOrder3Move, this.ctx, i + 1, attDate));
            }
            if (realAttendanceFile.getAttencePolicy() != null) continue;
            errorSb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.ForbidFillSignOrder1Move, this.ctx, i + 1, attDate));
        }
        if (!StringUtils.isEmpty((String)errorSb.toString())) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{errorSb.toString()});
        }
    }

    public static AttendanceFileHISInfo getAttendanceFileHISInfoByAttenceDate(Context ctx, java.util.Date attenceDate, String proposerId) throws BOSException {
        String oqlfile = " select * ,proposer.id,proposer.name,proposer.number,  attencePolicy.*,atsShift.*,adminOrgUnit.name,adminOrgUnit.id, adminOrgUnit.number,adminOrgUnit.longnumber,position.id,position.name, position.number,hrOrgUnit.id,hrOrgUnit.name,hrOrgUnit.displayName,hrOrgUnit.number  where attendFileState='1' and proposer.id = '" + proposerId + "'";
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oqlfile);
        for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
            if (attenceDate == null || attenceDate.getTime() < attendanceFileHISColl.get(i).getEFFDT().getTime() || attenceDate.getTime() > attendanceFileHISColl.get(i).getLEFFDT().getTime()) continue;
            return attendanceFileHISColl.get(i);
        }
        return null;
    }

    public void pageDataRepeatChecked(FillSignCardEntryCollection entries) throws HRCommonException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        StringBuffer errorSb = new StringBuffer();
        for (int i = 0; i < entries.size(); ++i) {
            StringBuilder interlist = new StringBuilder();
            String personId1 = entries.get(i).getPerson().getString("id");
            String fillCardTimeA = AtsDateUtils.dateShortToString(entries.get(i).getAttendDate()).substring(0, 10) + " " + entries.get(i).getFillCardTimeStr();
            for (int j = 0; j < i; ++j) {
                String personId2 = entries.get(j).getPerson().getString("id");
                String fillCardTimeB = AtsDateUtils.dateShortToString(entries.get(j).getAttendDate()).substring(0, 10) + " " + entries.get(j).getFillCardTimeStr();
                if (!personId1.equals(personId2) || !fillCardTimeA.equals(fillCardTimeB)) continue;
                interlist.append(interlist.length() > 0 ? "," : "").append(j + 1);
            }
            if ("".equals(interlist.toString())) continue;
            errorSb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.ForbidFillSignOrder6, this.ctx, i + 1, interlist.toString()));
        }
        if (!StringUtils.isEmpty((String)errorSb.toString())) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{errorSb.toString()});
        }
    }

    public String getPageSqlSelector(String segment) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select result.fattencedate attencedate, ").append(" person.fname" + MLUtile.getMlFlag(this.ctx) + " personname, ").append(" person.fnumber personnumber, ").append(" result.FAtthrOrgUnitID hrOrgUnitId, ").append(" Hro.fname" + MLUtile.getMlFlag(this.ctx) + " hrOrgUnitName, ").append(" person.fid personfid, ").append(" '" + segment + "' as segment ");
        if ("s1".equals(segment)) {
            sql.append(", S70  lackPunchCardTime ");
        } else if ("s2".equals(segment)) {
            sql.append(", S71  lackPunchCardTime ");
        } else if ("s3".equals(segment)) {
            sql.append(", S72  lackPunchCardTime ");
        } else if ("s4".equals(segment)) {
            sql.append(", S73  lackPunchCardTime ");
        } else if ("s5".equals(segment)) {
            sql.append(", S74  lackPunchCardTime ");
        } else if ("s6".equals(segment)) {
            sql.append(", S75  lackPunchCardTime ");
        }
        sql.append(" from T_HR_ATS_AttendanceResult result ").append(" inner join T_BD_Person person on result.Fproposerid = person.fid ").append(" left join T_ORG_Admin orgAdmin on result.FAdminOrgUnitID = orgAdmin.FID ").append(" inner join T_ORG_HRO Hro on result.FAtthrOrgUnitID = Hro.fid inner join T_HR_ATS_AttendanceFileHIS fileHis on (fileHis.FProposerID=result.Fproposerid and result.fattencedate<=fileHis.FLEFFDT and result.fattencedate>=fileHis.FEFFDT)").append(" where ( result.S19 > 0 or result.S21 > 0 or result.s23 > 0) ").append(" and result." + segment + " is null ");
        if ("s1".equals(segment)) {
            sql.append(" and S70 IS NOT NULL and S70 > '1970 01-01' ");
        } else if ("s2".equals(segment)) {
            sql.append(" and S71 IS NOT NULL and S71 > '1970 01-01' ");
        } else if ("s3".equals(segment)) {
            sql.append(" and S72 IS NOT NULL and S72 > '1970 01-01' ");
        } else if ("s4".equals(segment)) {
            sql.append(" and S73 IS NOT NULL and S73 > '1970 01-01' ");
        } else if ("s5".equals(segment)) {
            sql.append(" and S74 IS NOT NULL and S74 > '1970 01-01' ");
        } else if ("s6".equals(segment)) {
            sql.append(" and S75 IS NOT NULL and S75 > '1970 01-01' ");
        }
        sql.append(" and exists (select FLEFFDT from T_HR_ATS_AttendanceFile where FLEFFDT >= result.FattenceDate and FProposerID = result.Fproposerid  and FAttendFileState='1') ");
        return sql.toString();
    }

    public String getPageSqlSelectorTotal(String segment) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) total  ").append(" from T_HR_ATS_AttendanceResult result ").append(" inner join T_BD_Person person on result.Fproposerid = person.fid ").append(" left join T_ORG_Admin orgAdmin on result.FAdminOrgUnitID = orgAdmin.FID ").append(" inner join T_ORG_HRO Hro on result.FAtthrOrgUnitID = Hro.fid ").append(" inner join T_HR_ATS_AttendanceFileHIS fileHis on (fileHis.FProposerID=result.Fproposerid and result.fattencedate<=fileHis.FLEFFDT and result.fattencedate>=fileHis.FEFFDT)").append(" where ( result.S19 > 0 or result.S21 > 0 or result.s23 > 0) ").append(" and result." + segment + " is null ");
        if ("s1".equals(segment)) {
            sql.append(" and S70 IS NOT NULL ");
        } else if ("s2".equals(segment)) {
            sql.append(" and S71 IS NOT NULL ");
        } else if ("s3".equals(segment)) {
            sql.append(" and S72 IS NOT NULL ");
        } else if ("s4".equals(segment)) {
            sql.append(" and S73 IS NOT NULL ");
        } else if ("s5".equals(segment)) {
            sql.append(" and S74 IS NOT NULL ");
        } else if ("s6".equals(segment)) {
            sql.append(" and S75 IS NOT NULL ");
        }
        sql.append(" and exists (select FLEFFDT from T_HR_ATS_AttendanceFile where FLEFFDT >= result.FattenceDate and FProposerID = result.Fproposerid  and FAttendFileState='1') ");
        return sql.toString();
    }

    public void DBDataRepeatChecked(FillSignCardInfo fillSignCardInfo) throws HRCommonException {
        FillSignCardEntryCollection entries = fillSignCardInfo.getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        ArrayList<String> billid = new ArrayList<String>();
        ArrayList<String> rowNum = new ArrayList<String>();
        ArrayList<String> personID = new ArrayList<String>();
        ArrayList<String> fillCardTime = new ArrayList<String>();
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            for (int i = 0; i < entries.size(); ++i) {
                FillSignCardEntryInfo entry = entries.get(i);
                billid.add(entry.getString("id") != null ? entry.getString("id") : String.valueOf(i + 1));
                rowNum.add(String.valueOf(i + 1));
                personID.add(entry.getPerson().getString("id"));
                if (null == entry.getFillCardTime()) {
                    entry.setFillCardTime(AtsDateUtils.stringToTimestamp(AtsDateUtils.dateShortFormatToStr(entry.getAttendDate()) + " " + entry.getFillCardTimeStr() + ":00"));
                }
                fillCardTime.add(AtsDateUtils.timestampToString(entry.getFillCardTime()));
            }
        }
        String billId = CoreBaseUtile.getId(fillSignCardInfo);
        String sql = "select  t.fnumber,e.fattenddate, e.fillcardtimestr,e.fillcardtime,e.fid  from t_Hr_Ats_Fillsigncardentry e , T_HR_ATS_FillSignCard t where  e.fbillid=t.fid  and e.FPERSONID=? and  to_Char(e.FILLCARDTIME,'yyyy-mm-dd hh24:mi:ss')=?  and  t.fbillstate != 0  and  t.fbillstate != 4 ";
        if (BOSUuid.isValid((String)billId, (boolean)true)) {
            sql = sql + " and  t.fid <> '" + billId + "'";
        }
        StringBuffer errorSb = new StringBuffer("");
        block4: for (int i = 0; i < personID.size(); ++i) {
            try {
                IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{personID.get(i), fillCardTime.get(i)});
                while (row.next()) {
                    String time = row.getString("fillcardtime");
                    time = time.substring(0, 16);
                    String number = row.getString("fnumber");
                    String id = row.getString("fid");
                    if (id != null && !"".equals(id) && id.equals(billid.get(i))) continue block4;
                    errorSb.append(MLUtile.getRes((ResourceEnum)AtsFillSignCardResEnum.ForbidFillSignOrder5, this.ctx, rowNum.get(i), number, time));
                }
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((String)errorSb.toString())) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{errorSb.toString()});
        }
    }

    public String[] doAbortBill(Context ctx, String billIdParam) throws BOSException, EASBizException {
        HashSet atsInfoIds = new HashSet();
        String billIds = billIdParam.replaceAll(",", "','");
        String[] billIdArr = billIdParam.split(",");
        ArrayList<String> noSubmitBilList = new ArrayList<String>();
        ArrayList<String> approveBilList = new ArrayList<String>();
        String oql = " select billstate,id where id in ( '" + billIds + "' )";
        IFillSignCard iFillSignCard = FillSignCardFactory.getLocalInstance(ctx);
        FillSignCardCollection fillSignCardColl = iFillSignCard.getFillSignCardCollection(oql);
        for (int i = 0; i < fillSignCardColl.size(); ++i) {
            HRBillStateEnum billState = fillSignCardColl.get(i).getBillState();
            String billId = fillSignCardColl.get(i).getId().toString();
            if (HRBillStateEnum.SAVED.equals((Object)billState)) {
                noSubmitBilList.add(billId);
                continue;
            }
            if (!HRBillStateEnum.AUDITED.equals((Object)billState)) continue;
            approveBilList.add(billId);
        }
        if (noSubmitBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        if (approveBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        for (int j = 0; j < billIdArr.length; ++j) {
            String billId = billIdArr[j];
            try {
                iFillSignCard.abortBizBill(billId);
                FillsigncardHelper.uptBillSourceTypeWithBack(ctx, billId);
                if (atsInfoIds.contains(billId)) continue;
                DataLogsRecordUtil.processListObjectsLog((CoreBaseInfo)FillSignCardFactory.getLocalInstance(ctx).getFillSignCardInfo(" select *,entries.* where id in ( '" + billId + "' )"), OperActionEnum.abort, ctx);
                continue;
            }
            catch (EASBizException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return billIdArr;
    }
}

