/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.validator.AtsAcrossStoreValidator;
import com.kingdee.eas.hr.ats.validator.AtsScheshiftValidator;
import com.kingdee.eas.hr.ats.validator.BaseValidator;
import com.kingdee.eas.hr.ats.validator.BillValidator;
import com.kingdee.eas.hr.ats.validator.CanTripBillValidator;
import com.kingdee.eas.hr.ats.validator.CommonValidator;
import com.kingdee.eas.hr.ats.validator.FillSignCardValidator;
import com.kingdee.eas.hr.ats.validator.IValidator;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import com.kingdee.eas.hr.ats.validator.TripBillValidator;
import com.kingdee.eas.hr.ats.validator.ValidateCtx;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.commons.lang3.StringUtils;

public abstract class ValidateUtile {
    private static Set<String> validateMethods = new HashSet<String>();
    private static List<IValidator> validatorList = new ArrayList<IValidator>();
    private static List<String> validateBizMethod = new ArrayList<String>();
    private static List<String> updateMethod = new ArrayList<String>();

    private static void initParam() {
        String validateMethodsStr = ConfigAts.getPropertyFromConfig("validateMethods");
        if (StringUtils.isNotBlank((CharSequence)validateMethodsStr)) {
            validateMethods.addAll(Arrays.asList(StringUtils.split((String)validateMethodsStr, (String)",")));
        }
        validateMethods.addAll(Arrays.asList("delete", "view", "edit", "submit", "save", "submitEffect", "abortBill", "getOneDayAttendDetail"));
        String validateBizMethodStr = ConfigAts.getPropertyFromConfig("validateBizMethod");
        if (StringUtils.isNotBlank((CharSequence)validateBizMethodStr)) {
            validateBizMethod.addAll(Arrays.asList(StringUtils.split((String)validateBizMethodStr, (String)",")));
        }
        validateBizMethod.addAll(Arrays.asList("submit", "save", "submitEffect"));
        String updateMethodStr = ConfigAts.getPropertyFromConfig("updateMethod");
        if (StringUtils.isNotBlank((CharSequence)updateMethodStr)) {
            updateMethod.addAll(Arrays.asList(StringUtils.split((String)updateMethodStr, (String)",")));
        }
        updateMethod.addAll(Arrays.asList("submit", "save", "edit", "submitEffect", "delete", "abortBill", "againstApprove"));
        ValidateUtile.registValidator(new AtsAcrossStoreValidator());
        ValidateUtile.registValidator(new AtsScheshiftValidator());
        ValidateUtile.registValidator(new TripBillValidator());
        ValidateUtile.registValidator(new CanTripBillValidator());
        ValidateUtile.registValidator(new FillSignCardValidator());
        ValidateUtile.registValidator(new BillValidator());
        ValidateUtile.registValidator(new CommonValidator());
    }

    public static void registValidator(IValidator validator) {
        if (validator != null) {
            validatorList.add(validator);
        }
    }

    public static void registValidator(int order, IValidator validator) {
        if (validator != null) {
            validatorList.add(order, validator);
        }
    }

    public static List getAllValidator() {
        return Collections.unmodifiableList(validatorList);
    }

    public static boolean isValidateMethod(String methodName) {
        return AtsCollectionUtile.containsIgnoreCase(validateMethods, methodName);
    }

    public static boolean isValidateBizMethod(String methodName) {
        return AtsCollectionUtile.containsIgnoreCase(validateBizMethod, methodName);
    }

    public static boolean isUpdateMethod(String methodName) {
        return AtsCollectionUtile.containsIgnoreCase(updateMethod, methodName);
    }

    public static boolean addValidateMethod(String methodName) {
        return validateMethods.add(methodName);
    }

    public static Set<String> getValidateMethods() {
        return Collections.unmodifiableSet(validateMethods);
    }

    public static boolean addValidateBizMethod(String methodName) {
        return validateBizMethod.add(methodName);
    }

    public static List<String> getValidateBizMethods() {
        return Collections.unmodifiableList(validateBizMethod);
    }

    public static List<String> getUpdateMethods() {
        return Collections.unmodifiableList(updateMethod);
    }

    public static boolean addUpdateMethod(String methodName) {
        return updateMethod.add(methodName);
    }

    public static void setValidatorCtx(Object validatorCtxContainer, ValidateCtx validateCtx, String validateId) {
        if (validateCtx != null && validateId != null) {
            validateCtx.setValidateId(validateId);
        }
        ValidateUtile.setValidatorCtx(validatorCtxContainer, validateCtx);
    }

    public static void setValidatorCtx(Object validatorCtxContainer, ValidateCtx validateCtx) {
        if (null == validateCtx) {
            return;
        }
        if (validatorCtxContainer instanceof IObjectValue) {
            ((IObjectValue)validatorCtxContainer).put("$validatoCtx", (Object)validateCtx);
            return;
        }
        if (validatorCtxContainer instanceof Context) {
            Context ctx = (Context)validatorCtxContainer;
            PassiveExpiringMap validateCtxMap = (PassiveExpiringMap)ctx.get((Object)"$validatoCtx");
            if (validateCtxMap == null) {
                int timeToLeve = 15;
                validateCtxMap = new PassiveExpiringMap((long)timeToLeve, TimeUnit.MINUTES);
                ctx.put((Object)"$validatoCtx", (Object)validateCtxMap);
            }
            validateCtxMap.put((Object)validateCtx.getValidateId(), (Object)validateCtx);
        }
    }

    public static void removeValidateCtxParam(Context ctx, String validateId) {
        PassiveExpiringMap validateCtxMap = (PassiveExpiringMap)ctx.get((Object)"$validatoCtx");
        if (validateCtxMap != null) {
            validateCtxMap.remove((Object)validateId);
        }
    }

    public static ValidateCtx getValidateCtx(Context ctx, Object target) {
        ValidateCtx validatorCtx = null;
        if (target instanceof IObjectValue) {
            validatorCtx = (ValidateCtx)((IObjectValue)target).get("$validatoCtx");
        }
        if (validatorCtx == null) {
            String validateId = CoreBaseUtile.getId(target);
            if (null == validateId) {
                return null;
            }
            PassiveExpiringMap validateCtxMap = (PassiveExpiringMap)ctx.get((Object)"$validatoCtx");
            Iterator it = IteratorUtils.getIterator((Object)validateCtxMap);
            while (it.hasNext()) {
                validatorCtx = (ValidateCtx)it.next();
                boolean fit = validateId == null || StringUtils.equals((CharSequence)validatorCtx.getValidateId(), (CharSequence)validateId);
                boolean bl = fit = fit || Arrays.asList(StringUtils.split((String)validatorCtx.getValidateId(), (String)",")).contains(validateId);
                if (fit) break;
                validatorCtx = null;
            }
        }
        if (validatorCtx != null) {
            validatorCtx.setBosCtx(ctx);
        }
        return validatorCtx;
    }

    public static String convertValidateId(Object ... targets) {
        String validateId = null;
        for (Object target : targets) {
            validateId = CoreBaseUtile.getId(target);
            if (!StringUtils.isNotBlank((CharSequence)validateId)) continue;
            return validateId;
        }
        return ValidateUtile.class.getName();
    }

    public static IValidator getValidate(Context ctx, Object target) throws EASBizException {
        ValidateCtx validatorCtx = ValidateUtile.getValidateCtx(ctx, target);
        IValidator validator = ValidateUtile.getValidate(validatorCtx);
        if (validatorCtx != null && validator == null) {
            for (IValidator item : validatorList) {
                if (!item.fit(target)) continue;
                validator = item;
                break;
            }
        }
        if (validator == null) {
            return ValidateUtile.getEmptyValidator(ctx, validatorCtx);
        }
        return validator.setValidateCtx(validatorCtx);
    }

    public static IValidator getEmptyValidator(Context ctx, ValidateCtx validatorCtx) {
        validatorCtx = validatorCtx == null ? new ValidateCtx() : validatorCtx;
        validatorCtx.setBosCtx(ctx);
        BaseValidator validator = new BaseValidator();
        validator.setValidateCtx(validatorCtx).validate();
        return validator;
    }

    public static IValidator getValidate(ValidateCtx validateCtx) throws EASBizException {
        if (validateCtx == null || StringUtils.isBlank((CharSequence)validateCtx.getValidatorCls())) {
            return null;
        }
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)validateCtx.getValidatorCls());
            IValidator validator = (IValidator)clazz.newInstance();
            return validator;
        }
        catch (ClassNotFoundException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e);
        }
    }

    public static boolean validate(Context ctx, Object target) throws EASBizException {
        return ValidateUtile.validateWithReturn(ctx, target).validate();
    }

    public static IValidator validateWithReturn(Context ctx, Object target) throws EASBizException {
        IObjectCollection entries;
        IValidator validator = ValidateUtile.getValidate(ctx, target);
        validator.getValidateCtx().addTarget(target);
        validator.validate();
        Object entryVal = target instanceof AtsAffairBaseInfo ? ((AtsAffairBaseInfo)target).get("entries") : null;
        IObjectCollection iObjectCollection = entries = entryVal instanceof IObjectCollection ? (IObjectCollection)entryVal : null;
        if (entries != null) {
            String mlRes = null;
            if (AtsCollectionUtile.isEmpty(entries)) {
                mlRes = PlateformType.isSelf(validator.getValidateCtx().getPlateformType()) ? "NOT_SELF" : "NO_BILL_PERM";
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{mlRes});
            }
            if (validator.getValidateCtx().isUpdateMethod() && !validator.validate()) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{ValidateUtile.getValidatorMsg(validator)});
            }
        }
        return validator;
    }

    public static IValidator validateWithException(Context ctx, Object target) throws EASBizException {
        IValidator validator = ValidateUtile.validateWithReturn(ctx, target);
        return ValidateUtile.validateWithException(validator);
    }

    public static IValidator validateWithException(IValidator validator) throws EASBizException {
        if (validator.validate()) {
            return validator;
        }
        String msg = ValidateUtile.getValidatorMsg(validator);
        throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
    }

    public static String getValidatorMsg(IValidator validator) {
        BatchMessageTipsHeader tipObj = validator.getValidateCtx().getBatchMessageTipsHeader();
        HashSet<String> tips = new HashSet<String>();
        for (BatchMessageTipsBody t : tipObj.getResult()) {
            tips.add(t.getMuitTipsMessage());
        }
        return StringUtils.join(tips, (String)";\r\n");
    }

    static {
        ValidateUtile.initParam();
    }
}

