/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.validator.IValidator;
import com.kingdee.eas.hr.ats.validator.ValidateCtx;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ValidatorTpl<T>
implements IValidator<T> {
    private static Logger logger = Logger.getLogger(ValidatorTpl.class);
    private ValidateCtx validateCtx;

    @Override
    public final boolean validate() {
        this.validateCtx.init();
        if (this.validateCtx.isBeValidated()) {
            return this.validateCtx.isValid();
        }
        this.validateCtx.setBeValidated(true);
        try {
            this.beforeValidate();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.validateCtx.addValidateErrorMsg(null);
            return false;
        }
        for (Object target : this.validateCtx.getValidateTargets()) {
            String validateMsg;
            try {
                validateMsg = this.doValidate(target);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                validateMsg = ExceptionMessageUtility.getMessage((Throwable)e);
                validateMsg = StringUtils.isBlank((CharSequence)validateMsg) ? this.validateCtx.getOperateFailMsg() : validateMsg;
            }
            this.validateCtx.addValidateMsg(validateMsg, StringUtils.isEmpty((CharSequence)validateMsg));
        }
        this.afterValidate();
        return this.validateCtx.isValid();
    }

    protected void beforeValidate() throws Exception {
    }

    protected void afterValidate() {
    }

    protected String doValidate(T target) throws Exception {
        String errorStr = this.validateDAC(target);
        return StringUtils.isBlank((CharSequence)errorStr) && this.getValidateCtx().isNeedValidateBiz(target) ? this.validateBiz(target) : errorStr;
    }

    protected String validateDAC(T target) throws Exception {
        String errorStr = this.validateHRO(target);
        if (StringUtils.isNotBlank((CharSequence)errorStr)) {
            return errorStr;
        }
        if (!this.isDefaultManage(target)) {
            return null;
        }
        errorStr = this.validateAdmin(target);
        if (StringUtils.isNotBlank((CharSequence)errorStr)) {
            return errorStr;
        }
        return this.validatePerson(target);
    }

    protected boolean isDefaultManage(Object target) throws Exception {
        return true;
    }

    protected String validateBiz(T target) throws Exception {
        return null;
    }

    protected String validateHRO(T target) throws Exception {
        return null;
    }

    protected String validateAdmin(T target) throws Exception {
        return null;
    }

    protected String validatePerson(T target) throws Exception {
        return null;
    }

    protected T convert2Target(Object target) {
        return (T)target;
    }

    @Override
    public ValidateCtx getValidateCtx() {
        return this.validateCtx;
    }

    @Override
    public ValidatorTpl<T> setValidateCtx(ValidateCtx validateCtx) {
        this.validateCtx = validateCtx;
        return this;
    }

    @Override
    public boolean fit(Object tarInfo) {
        Type type = this.getClass().getGenericSuperclass();
        if (!ParameterizedType.class.isInstance(type)) {
            return true;
        }
        Object[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        if (AtsCollectionUtile.isEmpty(typeArguments)) {
            return true;
        }
        if (typeArguments[0] instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)typeArguments[0]).getBounds();
            Object[] objectArray = typeArguments = bounds == null ? typeArguments : bounds;
        }
        if (!Class.class.isInstance(typeArguments[0])) {
            return true;
        }
        return ((Class)typeArguments[0]).isInstance(tarInfo);
    }
}

