/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.vo.common;

import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.SystemClock;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;

public class Date
extends Timestamp {
    private static final long serialVersionUID = 1L;

    public Date(long date) {
        super(date);
    }

    public static Date getTimeInst() {
        return new Date(SystemClock.now());
    }

    public static Date getDateInst() {
        return new Date(SystemClock.now()).toDayStart();
    }

    public static Date getNoNullTime(Object date) {
        Date temp = Date.getTime(date);
        return temp == null ? Date.getTimeInst() : temp;
    }

    public static Date getNoNullDate(Object date) {
        Date temp = Date.getDate(date);
        temp = temp == null ? Date.getDateInst() : temp;
        return temp;
    }

    public static Date getDate(Object dateExpression) {
        Date date = Date.getTime(dateExpression);
        return date == null ? null : date.toDayStart();
    }

    public static Date getTime(Object dateExpression) {
        if (dateExpression == null) {
            return null;
        }
        if (java.util.Date.class.isAssignableFrom(dateExpression.getClass())) {
            return new Date(((java.util.Date)dateExpression).getTime());
        }
        if (Calendar.class.isAssignableFrom(dateExpression.getClass())) {
            return new Date(((Calendar)dateExpression).getTime().getTime());
        }
        if (AtsCommonUtile.isDigit(dateExpression)) {
            return new Date(Long.valueOf(dateExpression.toString()));
        }
        if (!(dateExpression instanceof String)) {
            return null;
        }
        String express = dateExpression.toString().trim();
        if (StringUtils.isBlank((String)express)) {
            return null;
        }
        express = AtsConstants.PATTERN_DATE_JOIN.matcher(dateExpression.toString()).replaceAll("-");
        String[] dateArr = express.split("-");
        if (dateArr.length > 3) {
            return null;
        }
        if (dateArr.length == 1) {
            express = Date.getTimeInst().toDateStr() + " " + express;
        }
        if (dateArr.length == 2) {
            express = Calendar.getInstance().get(1) + "-" + express;
        }
        express = AtsConstants.PATTERN_BLANK.matcher(express).replaceAll(" ");
        dateArr = (express = AtsConstants.PATTERN_TIME_JOIN.matcher(express).replaceAll(":")).split(":");
        if (dateArr.length == 1) {
            express = express + " 00:00:00";
        } else if (dateArr.length == 2) {
            express = express + ":00";
        } else if (dateArr.length > 3) {
            return null;
        }
        try {
            return new Date(AtsCommonUtile.getDateTimeFormat().parse(express).getTime());
        }
        catch (ParseException e2) {
            AtsLog.getLog().info((Object)("time transform error:" + dateExpression));
            return null;
        }
    }

    public static String formateDateNum() {
        return Date.formateDateNum(null);
    }

    public static String formateDateNum(Object date) {
        StringBuffer res = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.getNoNullTime(date));
        res.append(calendar.get(1));
        res.append(String.format("%02d", calendar.get(2) + 1));
        res.append(String.format("%02d", calendar.get(5)));
        return res.toString();
    }

    public Date newDayStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return Date.getTime(calendar);
    }

    public Date newDayEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 990);
        return Date.getTime(calendar);
    }

    public Date toDayStart() {
        this.setTime(this.newDayStart().getTime());
        return this;
    }

    public Date toDayEnd() {
        this.setTime(this.newDayEnd().getTime());
        return this;
    }

    public Date newNextDay() {
        return this.newNextDay(1);
    }

    public Date newNextDay(int diff) {
        return new Date(this.getTime() + (long)diff * 86400000L);
    }

    public Date nextDay() {
        return this.nextDay(1);
    }

    public Date nextDay(int diff) {
        this.setTime(this.getTime() + (long)diff * 86400000L);
        return this;
    }

    public Date preDay() {
        return this.nextDay(-1);
    }

    public Date newPreDay() {
        return this.newNextDay(-1);
    }

    public Date newNextWeek() {
        return this.newNextDay(7);
    }

    public Date nextWeek() {
        return this.nextDay(7);
    }

    public Date newPreWeek() {
        return this.newNextDay(-7);
    }

    public Date preWeek() {
        return this.nextDay(-7);
    }

    public Date newNextMonth() {
        return this.newNextMonth(1);
    }

    public Date nextMonth() {
        this.setTime(this.newNextMonth(1).getTime());
        return this;
    }

    public Date newPreMonth() {
        return this.newNextMonth(-1);
    }

    public Date preMonth() {
        this.setTime(this.newNextMonth(-1).getTime());
        return this;
    }

    public Date newNextMonth(int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getTime());
        calendar.add(2, diff);
        return new Date(calendar.getTimeInMillis());
    }

    public Date newNextYear() {
        return this.newNextYear(1);
    }

    public Date nextYear() {
        this.setTime(this.newNextYear(1).getTime());
        return this;
    }

    public Date newPreYear() {
        return this.newNextYear(-1);
    }

    public Date preYear() {
        this.setTime(this.newNextYear(-1).getTime());
        return this;
    }

    public Date newNextYear(int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getTime());
        calendar.add(1, diff);
        return new Date(calendar.getTimeInMillis());
    }

    public Calendar toCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar;
    }

    public String toDayStartStr() {
        return this.toDayStart().toDateTimeStr();
    }

    public String toDayEndStr() {
        return this.toDayEnd().toDateTimeStr();
    }

    public String toDateStr() {
        return AtsCommonUtile.formateDate(this);
    }

    public String toTimeStr() {
        return AtsCommonUtile.formateTime(this).substring(11);
    }

    public String toDateTimeStr() {
        return AtsCommonUtile.formateTime(this);
    }

    @Override
    public String toString() {
        return this.toDateTimeStr();
    }

    public String toSqlTimeStr() {
        return super.toString();
    }

    public static int diff(java.util.Date date1, java.util.Date date2, int calendarField) {
        Date large = Date.getTime(date2);
        if (large == null) {
            return Integer.MIN_VALUE;
        }
        return large.diff(date1, calendarField);
    }

    public int diff(java.util.Date date, int calendarField) {
        if (date == null) {
            return Integer.MAX_VALUE;
        }
        Calendar thisCal = this.toCalendar();
        Calendar thatCal = Calendar.getInstance();
        thatCal.setTime(date);
        int yearDiff = thisCal.get(1) - thatCal.get(1);
        long timeDiff = this.getTime() - date.getTime();
        switch (calendarField) {
            case 1: {
                return yearDiff;
            }
            case 2: {
                return yearDiff * 12 + thisCal.get(2) - thatCal.get(2);
            }
            case 5: 
            case 6: {
                Date target = Date.getTime(date);
                if (target == null) {
                    throw new RuntimeException("exist null val");
                }
                return (int)((this.toDayStart().getTime() - target.toDayStart().getTime()) / 86400000L);
            }
            case 10: {
                return (int)(timeDiff / 3600000L);
            }
            case 12: {
                return (int)(timeDiff / 60000L);
            }
            case 13: {
                return (int)(timeDiff / 60000L);
            }
        }
        return (int)timeDiff;
    }

    public static boolean isTimeFormat(String time) {
        if (time == null) {
            return false;
        }
        return AtsConstants.PATTERN_TIME.matcher(time.trim()).matches();
    }

    public static boolean containTimeFormat(String time) {
        if (time == null) {
            return false;
        }
        return AtsConstants.PATTERN_TIME.matcher(time.trim()).find();
    }

    public static boolean isDateFormat(String date) {
        if (date == null) {
            return false;
        }
        return AtsConstants.PATTERN_DATE.matcher(date.trim()).matches();
    }

    public static boolean containDateFormat(String date) {
        if (date == null) {
            return false;
        }
        return AtsConstants.PATTERN_DATE.matcher(date).find();
    }

    public static boolean isDateTimeFormat(String dateTime) {
        if (dateTime == null) {
            return false;
        }
        return AtsConstants.PATTERN_DATE_TIME.matcher(dateTime.trim()).matches();
    }

    public static boolean containDateTimeFormat(String dateTime) {
        if (dateTime == null) {
            return false;
        }
        return AtsConstants.PATTERN_DATE_TIME.matcher(dateTime.trim()).find();
    }
}

