/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsOrgAuthResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleConditionGroupCollection;
import com.kingdee.eas.hr.ats.AtsScheduleConditionGroupInfo;
import com.kingdee.eas.hr.ats.AtsScheduleIntelInfo;
import com.kingdee.eas.hr.ats.AtsSchedulePlanInfo;
import com.kingdee.eas.hr.ats.BaseSchedulePlanInfo;
import com.kingdee.eas.hr.ats.BaseSchedulePlanSetInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util.AtsIntelligentUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.eas.hr.ats.workShift.plan.IPlanManager;
import com.kingdee.eas.hr.ats.workShift.plan.RangeSettingAnalysor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class BasePlanManager
extends AtsCtx
implements IPlanManager {
    protected List<String> errorMsg = new ArrayList<String>();
    protected Calendar taskStartTime = Calendar.getInstance();
    protected Calendar taskTruncateDateTime = this.getInitTaskTruncateDateTime();

    public BasePlanManager() {
    }

    public BasePlanManager(Context ctx) {
        super(ctx);
    }

    @Override
    public final void execPlane(String ids) throws Exception {
        try {
            AtsLog.getWSLog().error((Object)("start execute schedule backJob" + ids));
            this.beforeExecPlane(ids);
            AtsLog.getWSLog().error((Object)("schedule backJob executing..." + ids));
            this.execPlaneInner(ids);
        }
        catch (Exception e) {
            AtsLog.getWSLog().error((Object)("schedule backJob executing error: " + e));
            this.handleException(e);
        }
        finally {
            AtsLog.getWSLog().error((Object)("schedule backJob execute complete:" + ids));
            this.afterExecPlane(ids);
        }
    }

    protected void execPlaneInner(String ids) throws Exception {
    }

    public void handleException(Exception e) throws Exception {
        throw new Exception(e);
    }

    @Override
    public Set<String> rangSettingCheck(Collection<String> ids) {
        return null;
    }

    protected void beforeExecPlane(String ids) throws Exception {
        ConfigAts.updateConfigAtsFromParam(this.ctx);
        ConfigAts.enableKSQLOutput();
    }

    protected void afterExecPlane(String ids) throws Exception {
        ConfigAts.enableKSQLOutput();
    }

    protected Set<String> rangSettingCheck(List<? extends BaseSchedulePlanInfo> plans, BaseSchedulePlanSetInfo planSet) {
        if (planSet.getHrOrgUnit() == null) {
            this.errorMsg.add(MLUtile.getRes(AtsOrgAuthResEnum.NoHrOrgOfPlan, this.ctx));
            return new LinkedHashSet<String>(this.errorMsg);
        }
        int nullPlanCount = 0;
        HashMap<Integer, Set<String>> allRange = new HashMap<Integer, Set<String>>(plans.size());
        for (int i = 0; i < plans.size(); ++i) {
            BaseSchedulePlanInfo entry = plans.get(i);
            RangeSettingAnalysor rangeSettingAnalysor = this.createRangeSettingAnalysor(entry, this.ctx);
            rangeSettingAnalysor.setUseAttFile(true);
            rangeSettingAnalysor.setHrOrgUnit(planSet.getHrOrgUnit());
            rangeSettingAnalysor.analyze();
            Set<String> rangeTargets = rangeSettingAnalysor.findRangeTarget();
            if (AtsCollectionUtile.isEmpty(rangeTargets)) {
                ++nullPlanCount;
                AtsLog.getWSLog().info((Object)("find no person which satisfy the entry of " + entry.getSchedulePriority() + " int the plan!"));
                this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.NoPersonAdaptPlanRow, this.ctx, i + 1));
                continue;
            }
            allRange.put(i, rangeTargets);
        }
        int totalCount = this.getPlanPerson(allRange).size();
        AtsLog.getWSLog().info((Object)("the total person plan relate to :" + totalCount));
        this.buildRepeatMsg(this.ctx, allRange, this.errorMsg);
        if (this.errorMsg.size() == nullPlanCount && totalCount != 0) {
            this.errorMsg.add(MLUtile.getRes(AtsFileResEnum.CheckNoRepeatPer, this.ctx));
        }
        this.errorMsg.add(0, MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.AttendanceSumPer, this.ctx, totalCount));
        return new LinkedHashSet<String>(this.errorMsg);
    }

    protected RangeSettingAnalysor createRangeSettingAnalysor(BaseSchedulePlanInfo baseSchedulePlanInfo, Context ctx) {
        RangeSettingAnalysor rangeSettingAnalysor = new RangeSettingAnalysor(ctx);
        rangeSettingAnalysor.setCtx(ctx);
        rangeSettingAnalysor.setAttenceGroups(baseSchedulePlanInfo.getAttenceGroupString());
        rangeSettingAnalysor.setAdminOrgUnits(baseSchedulePlanInfo.getAdminOrgUnitString());
        rangeSettingAnalysor.setSelectedPersons(baseSchedulePlanInfo.getPersonString());
        rangeSettingAnalysor.setIncludeEscrow(baseSchedulePlanInfo.isIsEscrow());
        rangeSettingAnalysor.setIncludeSub(baseSchedulePlanInfo.isIsSub());
        if (baseSchedulePlanInfo instanceof AtsSchedulePlanInfo && baseSchedulePlanInfo.isIncNoAttendance()) {
            rangeSettingAnalysor.setIncludeNonAttendance(AtsIntelligentUtil.isEnableATS_MDKPB(ctx));
        }
        if (StringUtils.isBlank((String)rangeSettingAnalysor.getAdminOrgUnits())) {
            if (AtsSchedulePlanInfo.class == baseSchedulePlanInfo.getClass()) {
                rangeSettingAnalysor.setAdminOrgUnits(((AtsSchedulePlanInfo)baseSchedulePlanInfo).getAtsSchedulePlanSet().getAdminOrgUnit().getLongNumber());
            } else if (AtsScheduleIntelInfo.class == baseSchedulePlanInfo.getClass()) {
                rangeSettingAnalysor.setAdminOrgUnits(((AtsScheduleIntelInfo)baseSchedulePlanInfo).getAtsScheduleIntelSet().getAdminOrgUnit().getLongNumber());
            }
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)baseSchedulePlanInfo.getConditionItems())) {
            return rangeSettingAnalysor;
        }
        ArrayList<String> rangeOthers = new ArrayList<String>();
        AtsScheduleConditionGroupCollection conditions = baseSchedulePlanInfo.getConditionItems();
        for (int i = 0; i < conditions.size(); ++i) {
            AtsScheduleConditionGroupInfo conditonGroup = conditions.get(i);
            if (conditonGroup == null || AtsCollectionUtile.isEmpty((IObjectCollection)conditonGroup.getItems())) continue;
            for (int j = 0; j < conditonGroup.getItems().size(); ++j) {
                if (!StringUtils.isNotEmpty((String)conditonGroup.getItems().get(j).getConfig())) continue;
                rangeOthers.add(conditonGroup.getItems().get(j).getConfig());
            }
        }
        rangeSettingAnalysor.setRangeOthers(rangeOthers);
        return rangeSettingAnalysor;
    }

    private Map<String, Set<Integer>> checkRepeat(Map<Integer, Set<String>> allRange) {
        Set<String> allPersonNums = this.getPlanPerson(allRange);
        HashMap personCountMap = new HashMap(allPersonNums.size());
        for (String personNum : allPersonNums) {
            HashSet<Integer> countSet = (HashSet<Integer>)personCountMap.get(personNum);
            if (countSet == null) {
                countSet = new HashSet<Integer>(8);
                personCountMap.put(personNum, countSet);
            }
            for (Map.Entry<Integer, Set<String>> entry : allRange.entrySet()) {
                if (!entry.getValue().contains(personNum)) continue;
                countSet.add(entry.getKey());
            }
        }
        HashMap<String, Set<Integer>> repeatMap = new HashMap<String, Set<Integer>>(allPersonNums.size());
        for (Map.Entry entry : personCountMap.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            repeatMap.put((String)entry.getKey(), (Set<Integer>)entry.getValue());
        }
        personCountMap = null;
        return repeatMap;
    }

    private Set<String> getPlanPerson(Map<Integer, Set<String>> allRange) {
        HashSet<String> allPersonNums = new HashSet<String>();
        for (Set<String> set : allRange.values()) {
            allPersonNums.addAll(set);
        }
        return allPersonNums;
    }

    public void buildRepeatMsg(Context ctx, Map<Integer, Set<String>> allRange, List<String> errorMsg) {
        Map<String, Set<Integer>> repeatMap = this.checkRepeat(allRange);
        PersonCollection colls = null;
        if (!AtsCollectionUtile.isEmpty(repeatMap)) {
            try {
                colls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select name,number where number in " + AtsCollectionUtile.joinForSqlWithBrackets(repeatMap.keySet()));
            }
            catch (BOSException e) {
                AtsLog.getWSLog().error((Object)"", (Throwable)e);
            }
        }
        if (!AtsCollectionUtile.isEmpty(colls)) {
            int total = colls.size();
            for (int i = 0; i < total; ++i) {
                errorMsg.add(MLUtile.getRes((ResourceEnum)AtsBillResEnum.RepeatInRule, ctx, colls.get(i).getName(), colls.get(i).getNumber(), AtsCollectionUtile.join((Collection)repeatMap.get(colls.get(i).getNumber()), "\u3001")));
            }
        }
    }

    public List<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(List<String> errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Calendar getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(Calendar taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    protected Calendar getInitTaskTruncateDateTime() {
        Calendar cal = (Calendar)this.taskStartTime.clone();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.setTimeInMillis(cal.getTimeInMillis() / 1000L * 1000L);
        return cal;
    }

    public Calendar getTaskTruncateDateTime() {
        return this.taskTruncateDateTime;
    }

    public void setTaskTruncateDateTime(Calendar taskTruncateDateTime) {
        this.taskTruncateDateTime = taskTruncateDateTime;
    }
}

