/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.autoSchedule;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByCopy;
import com.kingdee.eas.hr.ats.workShift.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShift.plan.IScheduleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.RangeSettingAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.ScheduleParamAnalysor;
import java.util.Set;

public class BaseAutoScheduleAnalysor
implements IScheduleAnalysor {
    private Context ctx;
    protected Set<String> scheduleTarget;
    protected String scheduleTargetSql;
    protected ScheduleParamAnalysor scheduleParamAnalysor;
    protected RangeSettingAnalysor rangeSettingAnalysor;
    protected BaseArrangeShift analyzeResults;
    protected String hrOrgUnitId;

    public BaseAutoScheduleAnalysor() {
    }

    public BaseAutoScheduleAnalysor(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void analyze() {
        this.scheduleParamAnalysor.analyze();
        if (!this.scheduleParamAnalysor.isSatisfyScheduleCondition()) {
            return;
        }
        this.analyzeResults = this.scheduleParamAnalysor.getAnalyzeResults();
        if (ArrangeShiftByCopy.class.isAssignableFrom(this.analyzeResults.getClass())) {
            ArrangeShiftByCopy arrangeShiftByCopy = (ArrangeShiftByCopy)this.analyzeResults;
            arrangeShiftByCopy.setHrOrgUnitIdD(this.hrOrgUnitId);
        }
        if (this.analyzeResults.getBeginDate() != null) {
            this.rangeSettingAnalysor.setBeginDate(AtsCommonUtile.getDayStartStr(this.analyzeResults.getBeginDate()));
        }
        if (this.analyzeResults.getEndDate() != null) {
            this.rangeSettingAnalysor.setEndDate(AtsCommonUtile.getDayEndStr(this.analyzeResults.getEndDate()));
        }
        this.rangeSettingAnalysor.analyze();
        this.scheduleTargetSql = this.rangeSettingAnalysor.getRangeSettingSql().toString();
        this.scheduleTarget = this.rangeSettingAnalysor.getAnalyResults();
    }

    public boolean isSatisfyScheduleCondition() {
        return this.scheduleParamAnalysor.isSatisfyScheduleCondition();
    }

    public Set<String> getScheduleTarget() {
        return this.scheduleTarget;
    }

    public void setScheduleTarget(Set<String> scheduleTarget) {
        this.scheduleTarget = scheduleTarget;
    }

    public ScheduleParamAnalysor getScheduleParamAnalysor() {
        return this.scheduleParamAnalysor;
    }

    public void setScheduleParamAnalysor(ScheduleParamAnalysor scheduleParamAnalysor) {
        this.scheduleParamAnalysor = scheduleParamAnalysor;
    }

    public RangeSettingAnalysor getRangeSettingAnalysor() {
        return this.rangeSettingAnalysor;
    }

    public void setRangeSettingAnalysor(RangeSettingAnalysor rangeSettingAnalysor) {
        this.rangeSettingAnalysor = rangeSettingAnalysor;
    }

    public BaseArrangeShift getAnalyzeResults() {
        return this.analyzeResults;
    }

    public void setAnalyzeResults(BaseArrangeShift analyzeResults) {
        this.analyzeResults = analyzeResults;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getScheduleTargetSql() {
        return this.scheduleTargetSql;
    }

    public void setScheduleTargetSql(String scheduleTargetSql) {
        this.scheduleTargetSql = scheduleTargetSql;
    }

    public String getHrOrgUnitId() {
        return this.hrOrgUnitId;
    }

    public void setHrOrgUnitId(String hrOrgUnitId) {
        this.hrOrgUnitId = hrOrgUnitId;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public IScheduleAnalysor next() {
        return null;
    }
}

