/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.save;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftElasticDirection;
import com.kingdee.eas.hr.ats.AtsShiftElasticType;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftTypeInfo;
import com.kingdee.eas.hr.ats.AttenceGroupFactory;
import com.kingdee.eas.hr.ats.AttenceGroupInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftFactory;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.IAttendanceGroupShift;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShiftGroup.save.ISaveShift;
import com.kingdee.eas.hr.ats.workShiftGroup.save.SaveShiftUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BaseSaveShift
implements ISaveShift {
    private Context ctx;
    IAttendanceGroupShift iScheduleShift;
    private String userInfo;
    private String CtrlUnitInfo;
    private String hrOrgUnitId;
    private Date minDate;
    private Date maxDate;
    private int defaultAdvcValue = 1;
    private SchlShiftSrcTypeEnum defaultScheduleSrcType = SchlShiftSrcTypeEnum.sysSchlShift;
    private AttendanceGroupShiftCollection toBeSavedShift;
    private Map<String, AttenceGroupInfo> attenceGroup = new HashMap<String, AttenceGroupInfo>();
    private Map<String, AtsShiftInfo> atsShiftGroup = new HashMap<String, AtsShiftInfo>();
    private Map<String, AttendanceGroupShiftInfo> existsSchedules;
    private RangeMap<Date, AttendanceGroupShiftInfo> scheduleShiftFromAttHis;
    CoreBaseCollection insertColl = new CoreBaseCollection();
    CoreBaseCollection updateColl = new CoreBaseCollection();
    List<Object[]> updateShiftParams = new ArrayList<Object[]>();
    List<Object[]> updateShiftItemParams = new ArrayList<Object[]>();
    List<Object[]> deleteShiftItemParams = new ArrayList<Object[]>();

    public BaseSaveShift() {
    }

    public BaseSaveShift(Context ctx) {
        this.ctx = ctx;
        try {
            this.iScheduleShift = AttendanceGroupShiftFactory.getLocalInstance(this.ctx);
            UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
            this.userInfo = currentUserInfo != null && currentUserInfo.getId() != null ? currentUserInfo.getId().toString() : "";
            CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
            this.CtrlUnitInfo = cu != null && cu.getId() != null ? cu.getId().toString() : "";
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static BaseSaveShift getManualInstance() {
        BaseSaveShift baseSaveShift = new BaseSaveShift();
        baseSaveShift.setDefaultAdvcValue(2);
        baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        return baseSaveShift;
    }

    public static BaseSaveShift getManualInstance(Context ctx, String hrOrgUnitId) {
        BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
        baseSaveShift.setDefaultAdvcValue(2);
        baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        baseSaveShift.setHrOrgUnitId(hrOrgUnitId);
        return baseSaveShift;
    }

    public static BaseSaveShift getAutoInstance() {
        return new BaseSaveShift();
    }

    public static BaseSaveShift getAutoInstance(Context ctx, String hrOrgUnitId) {
        BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
        baseSaveShift.setHrOrgUnitId(hrOrgUnitId);
        return baseSaveShift;
    }

    protected void initDate(AttendanceGroupShiftCollection toBeSavedShift) {
        this.minDate = this.maxDate = toBeSavedShift.get(0).getAttendDate();
        for (int i = 0; i < toBeSavedShift.size(); ++i) {
            if (toBeSavedShift.get(i).getAttendDate().before(this.minDate)) {
                this.minDate = toBeSavedShift.get(i).getAttendDate();
            }
            if (!toBeSavedShift.get(i).getAttendDate().after(this.maxDate)) continue;
            this.maxDate = toBeSavedShift.get(i).getAttendDate();
        }
    }

    public void save(Map<String, List<JSONObject>> schedules) {
        List<List<String>> groupedPersonNums = AtsCollectionUtile.group(schedules.keySet(), AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> personNumIterator = groupedPersonNums.iterator();
        this.toBeSavedShift = new AttendanceGroupShiftCollection();
        while (personNumIterator.hasNext()) {
            ArrayList<JSONObject> relateSchedules = new ArrayList<JSONObject>();
            List<String> personNums = personNumIterator.next();
            for (String personNum : personNums) {
                relateSchedules.addAll((Collection<JSONObject>)schedules.get(personNum));
            }
            List<String> realteShiftName = SaveShiftUtile.getShiftNameFromJson(relateSchedules);
            Map<String, AtsShiftInfo> atsShifts = SaveShiftUtile.getAtsShiftByNames(this.ctx, new HashSet<String>(realteShiftName));
            for (String personNum : personNums) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                this.toBeSavedShift.addCollection(SaveShiftUtile.resolveToScheduleShift(personInfo, schedules.get(personNum), atsShifts));
            }
        }
        this.save(this.toBeSavedShift);
    }

    public void save(AttendanceGroupShiftCollection toBeSavedShift) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)toBeSavedShift)) {
            return;
        }
        this.toBeSavedShift = toBeSavedShift;
        this.initDate(toBeSavedShift);
        List<List<Object>> scheduleGroup = AtsCollectionUtile.group((IObjectCollection)toBeSavedShift, AtsConstants.SIZE_COMMON_BATCH);
        for (List<Object> groupTemp : scheduleGroup) {
            ArrayList<AttendanceGroupShiftInfo> groupedSchedule = new ArrayList<AttendanceGroupShiftInfo>(groupTemp.size());
            for (Object o : groupTemp) {
                groupedSchedule.add((AttendanceGroupShiftInfo)o);
            }
            this.doSave(groupedSchedule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(List<AttendanceGroupShiftInfo> schedules) {
        HashSet<String> AttenceGroups = new HashSet<String>(AtsCollectionUtile.map(schedules, new AtsMapFn<AttendanceGroupShiftInfo, String>(){

            @Override
            public String map(AttendanceGroupShiftInfo t) {
                return t.getProposer().getNumber().toString();
            }
        }));
        this.existsSchedules = SaveShiftUtile.getExistsSchedule(this.ctx, AttenceGroups, this.minDate, this.maxDate);
        this.completeScheduleShift(schedules);
        try {
            this.saveOrUpdateEntity();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            this.resetSaveOrUpdateCollection();
        }
    }

    protected void resetSaveOrUpdateCollection() {
        this.insertColl.clear();
        this.updateColl.clear();
        this.updateShiftParams.clear();
        this.updateShiftItemParams.clear();
        this.deleteShiftItemParams.clear();
    }

    protected void save() {
    }

    protected void completeScheduleShift(List<AttendanceGroupShiftInfo> schedules) {
        for (int i = 0; i < schedules.size(); ++i) {
            AttendanceGroupShiftInfo schedule = schedules.get(i);
            String groupId = schedules.get(i).getProposer().getNumber().toString();
            if (schedule.getDefaultShift() != null) {
                if (this.atsShiftGroup == null) {
                    this.getAtsShiftGroup(schedule.getDefaultShift().getId().toString());
                } else if (!this.atsShiftGroup.containsKey(schedule.getDefaultShift().getId().toString())) {
                    this.getAtsShiftGroup(schedule.getDefaultShift().getId().toString());
                }
            }
            if (this.attenceGroup == null) {
                this.getAttenceGroup(groupId);
            } else if (!this.attenceGroup.containsKey(groupId)) {
                this.getAttenceGroup(groupId);
            }
            if (schedule.getDefaultShift() != null) {
                AtsShiftInfo info = this.atsShiftGroup.get(schedule.getDefaultShift().getId().toString());
                schedule.setOtCompens(info.getOtCompens());
                schedule.setCardRule(info.getCardRule());
                schedule.setStandardHour(info.getStandardHour());
                schedule.setShiftType(info.getShiftType());
                schedule.setIsHalfDay(info.isIsHalfDay());
                schedule.setElasticValue(info.getElasticValue());
                schedule.setElasticDirection(info.getElasticDirection());
                schedule.setShiftType(info.getShiftType());
                schedule.setIsElastic(info.isIsElastic());
                schedule.setElasticType(info.getElasticType());
            } else {
                AtsShiftInfo atsShiftInfo = BaseSaveShift.getOrgAvaiableShift(this.ctx, groupId);
                schedule.setStandardHour(atsShiftInfo.getStandardHour());
                schedule.setCardRule(atsShiftInfo.getCardRule());
                schedule.setOtCompens(atsShiftInfo.getOtCompens());
                schedule.setIsHalfDay(atsShiftInfo.isIsHalfDay());
                schedule.setElasticValue(atsShiftInfo.getElasticValue());
                schedule.setElasticDirection(atsShiftInfo.getElasticDirection());
                schedule.setShiftType(atsShiftInfo.getShiftType());
                schedule.setIsElastic(atsShiftInfo.isIsElastic());
                schedule.setElasticType(atsShiftInfo.getElasticType());
            }
            AttenceGroupInfo attGroup = this.attenceGroup.get(groupId);
            schedule.setAdminOrgUnit(attGroup.getAdminOrgUnit());
            schedule.setHrOrgUnit(attGroup.getHrOrgUnit());
            AttenceGroupInfo groupInfo = new AttenceGroupInfo();
            groupInfo.setId(attGroup.getId());
            schedule.setAttenceGroup(groupInfo);
            AttendanceGroupShiftInfo existsSchedule = this.existsSchedules.get(groupId + "_" + AtsCommonUtile.getDateFormat().format(schedule.getAttendDate()));
            if (existsSchedule != null) {
                schedule.setId(existsSchedule.getId());
                this.updateColl.add((CoreBaseInfo)schedule);
            } else {
                this.insertColl.add((CoreBaseInfo)schedule);
            }
            if (schedule.getAdvcValue() == 0) {
                schedule.setAdvcValue(this.defaultAdvcValue);
            }
            if (schedule.getSrcType() == null) {
                schedule.setSrcType(this.defaultScheduleSrcType);
            }
            schedule.getItems().clear();
            if (existsSchedule == null) continue;
            this.buildUpdateParam(schedule);
        }
    }

    public static AtsShiftInfo getOrgAvaiableShift(Context ctx, String id) {
        AttenceGroupInfo info = null;
        AdminOrgUnitCollection admin = null;
        try {
            info = AttenceGroupFactory.getLocalInstance(ctx).getAttenceGroupInfo("select adminOrgUnit where id='" + id + "'");
            admin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select longNumber where id='" + info.getAdminOrgUnit().getId().toString() + "'");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        AtsShiftInfo atsShiftInfo = new AtsShiftInfo();
        if (admin != null && admin.size() > 0) {
            StringBuffer sql = new StringBuffer().append(" select shift.fname" + MLUtile.getMlFlag(ctx) + " name,shift.fstandardHour standardHour,shift.FCardRuleID cardRule,shift.FOtCompensID otCompens,shift.FIsHalfDay isHalfDay").append(" ,shift.FShiftTypeID ShiftTypeID,shift.FIsElastic IsElastic,shift.FElasticType ElasticType,shift.FElasticDirection ElasticDirection,shift.FElasticValue ElasticValue ").append(" from T_HR_ATS_Shift shift").append(" inner join T_ORG_Admin admin on admin.fid=shift.fadminOrgUnitid").append(" where shift.FIsDefault=1 and shift.Fstate=1 and  (CHARINDEX( concat(admin.flongnumber,'!'),'" + admin.get(0).getLongNumber() + "' )=1  or '" + admin.get(0).getLongNumber() + "' = admin.flongnumber)    order by admin.flongNumber desc ");
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.size() == 0) {
                    StringBuffer buffer = new StringBuffer().append(" select shift.fstandardHour standardHour,shift.FCardRuleID cardRule,shift.FOtCompensID otCompens,shift.FIsHalfDay isHalfDay").append(" ,shift.FShiftTypeID ShiftTypeID,shift.FIsElastic IsElastic,shift.FElasticType ElasticType,shift.FElasticDirection ElasticDirection,shift.FElasticValue ElasticValue ").append(" from  T_ATS_AtsShiftAvaliable ashift inner join T_HR_ATS_Shift Shift on shift.fid=aShift.fbaseinfoid order by aShift.findex , shift.fnumber ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                }
                if (rs.next()) {
                    CardRuleInfo infos = new CardRuleInfo();
                    if (!"".equals(rs.getString("cardRule")) && rs.getString("cardRule") != null) {
                        infos.setId(BOSUuid.read((String)rs.getString("cardRule")));
                        atsShiftInfo.setCardRule(infos);
                    }
                    AtsShiftTypeInfo atsShiftType = new AtsShiftTypeInfo();
                    if (!"".equals(rs.getString("ShiftTypeID")) && rs.getString("ShiftTypeID") != null) {
                        atsShiftType.setId(BOSUuid.read((String)rs.getString("ShiftTypeID")));
                        atsShiftInfo.setShiftType(atsShiftType);
                    }
                    atsShiftInfo.setStandardHour(rs.getBigDecimal("standardHour"));
                    atsShiftInfo.setIsHalfDay(rs.getBoolean("isHalfDay"));
                    atsShiftInfo.setIsElastic(rs.getBoolean("isElastic"));
                    atsShiftInfo.setElasticType(AtsShiftElasticType.getEnum(rs.getInt("elasticType")));
                    atsShiftInfo.setElasticDirection(AtsShiftElasticDirection.getEnum(rs.getInt("elasticDirection")));
                    atsShiftInfo.setElasticValue(rs.getBigDecimal("elasticValue"));
                    OverTimeCompensInfo overTimeCompens = new OverTimeCompensInfo();
                    if (!"".equals(rs.getString("otCompens")) && rs.getString("otCompens") != null) {
                        overTimeCompens.setId(BOSUuid.read((String)rs.getString("otCompens")));
                        overTimeCompens.setId(BOSUuid.read((String)rs.getString("otCompens")));
                        atsShiftInfo.setOtCompens(overTimeCompens);
                    }
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return atsShiftInfo;
    }

    protected void getAttenceGroup(String attenceGroupId) {
        try {
            AttenceGroupInfo info = AttenceGroupFactory.getLocalInstance(this.ctx).getAttenceGroupInfo("select *  where id='" + attenceGroupId + "'");
            this.attenceGroup.put(attenceGroupId, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void getAtsShiftGroup(String atsShiftGroupId) {
        try {
            AtsShiftInfo info = AtsShiftFactory.getLocalInstance(this.ctx).getAtsShiftInfo("select otCompens.id,cardRule.id,standardHour,shiftType.id,isHalfDay,elasticValue,elasticDirection,isElastic,elasticType  where id='" + atsShiftGroupId + "'");
            this.atsShiftGroup.put(atsShiftGroupId, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void buildUpdateParam(AttendanceGroupShiftInfo schedule) {
        Object[] updateShiftParamsArr = SaveShiftUtile.getScheduleShiftParams(schedule, this.userInfo, this.CtrlUnitInfo);
        this.updateShiftParams.add(updateShiftParamsArr);
        if (schedule.getDefaultShift() != null && !AtsCollectionUtile.isEmpty((IObjectCollection)schedule.getDefaultShift().getItems())) {
            List<Object[]> updateShiftItemParamsArr = SaveShiftUtile.getScheduleShiftItemParams(schedule);
            Object[] deleteShiftItemParamsArr = new Object[]{schedule.getId().toString()};
            this.updateShiftItemParams.addAll(updateShiftItemParamsArr);
            this.deleteShiftItemParams.add(deleteShiftItemParamsArr);
        }
    }

    protected void setShiftRealteParam(AttendanceGroupShiftInfo schedule, AttendanceGroupShiftInfo defaultSchedle) {
        AtsShiftInfo shift = schedule.getDefaultShift();
        if (shift == null) {
            schedule.setShiftType(null);
            schedule.setStandardHour(defaultSchedle.getStandardHour());
            schedule.setCardRule(defaultSchedle.getCardRule());
            return;
        }
        schedule.setCardRule(shift.getCardRule());
        schedule.setStandardHour(shift.getStandardHour());
        schedule.setOtCompens(shift.getOtCompens());
        schedule.setShiftType(shift.getShiftType());
        schedule.setIsElastic(shift.isIsElastic());
        schedule.setElasticType(shift.getElasticType());
        schedule.setElasticDirection(shift.getElasticDirection());
        schedule.setElasticValue(shift.getElasticValue());
    }

    public void saveOrUpdateEntity() throws BOSException, EASBizException {
        if (!this.insertColl.isEmpty()) {
            this.iScheduleShift.addnew(this.insertColl);
        }
        if (!this.updateColl.isEmpty()) {
            StringBuffer deleteShiftItemSql = new StringBuffer("");
            deleteShiftItemSql.append(" delete from T_ATS_AttendanceGroupShiftItem where fgroupId = ?");
            DbUtil.executeBatch((Context)this.ctx, (String)deleteShiftItemSql.toString(), this.deleteShiftItemParams);
            StringBuffer updateShiftSql = new StringBuffer("");
            updateShiftSql.append(" update T_ATS_AttendanceGroupShift set fdayType = ?,FDefaultShiftID = ?,\n");
            updateShiftSql.append(" FCardRuleID = ?,FSrcType = ?,FAdvcValue = ?,FStandardHour = ?,FProposerId = ?,FPositionId = ?,");
            updateShiftSql.append(" FCreatorId = ?,FCreateTime = Now(),FLastUpdateUserId = ?,FLastUpdateTime = Now(),FAdminOrgUnitId = ?,");
            updateShiftSql.append(" FShiftTypeID = ?,FOtCompensID = ?,FAttendDate = ?,FControlUnitID = ?,FHrOrgUnitID = ?,FshiftByTurnSegment = ?,FTurnShiftID = ?,FIsHalfDay = ? where Fid = ?");
            DbUtil.executeBatch((Context)this.ctx, (String)updateShiftSql.toString(), this.updateShiftParams);
        }
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        List<Object> updateParamList = new ArrayList();
        if (this.insertColl != null && this.insertColl.size() > 0) {
            AttendanceGroupShiftInfo schedule2 = null;
            AtsShiftInfo atsShiftInfo = null;
            for (AttendanceGroupShiftInfo schedule2 : this.insertColl) {
                atsShiftInfo = schedule2.getDefaultShift();
                if (atsShiftInfo == null || AtsCollectionUtile.isEmpty((IObjectCollection)atsShiftInfo.getItems())) continue;
                insertParamList.addAll(SaveShiftUtile.getScheduleShiftItemParams(schedule2));
            }
        }
        if (this.updateColl != null && this.updateColl.size() > 0) {
            updateParamList = this.updateShiftItemParams;
        }
        StringBuffer insertShiftItemSql = new StringBuffer("");
        insertShiftItemSql.append(" insert into T_ATS_AttendanceGroupShiftItem(Fid,FShiftItemID,FSegment, FPreTime,FPreFloatAdjusted,FPreUnit,FPreIsPunchCard, FNextTime, FNextFloatAdjusted, FNextUnit, FNextIsPunchCard, FSegmentInRest, FAttendanceType,");
        insertShiftItemSql.append(" FPreTimeDayType, FNextTimeDayType, FPreDateTime, FNextDateTime, FRestPreTime, FRestNextTime, FRestPreDateTime, FRestNextDateTime,FGroupID)");
        insertShiftItemSql.append(" values(newbosid('4ECBA044'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        if (insertParamList != null && insertParamList.size() > 0) {
            DbUtil.executeBatch((Context)this.ctx, (String)insertShiftItemSql.toString(), insertParamList);
        }
        if (updateParamList != null && updateParamList.size() > 0) {
            DbUtil.executeBatch((Context)this.ctx, (String)insertShiftItemSql.toString(), updateParamList);
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getCtrlUnitInfo() {
        return this.CtrlUnitInfo;
    }

    public void setCtrlUnitInfo(String ctrlUnitInfo) {
        this.CtrlUnitInfo = ctrlUnitInfo;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getHrOrgUnitId() {
        return this.hrOrgUnitId;
    }

    public void setHrOrgUnitId(String hrOrgUnitId) {
        this.hrOrgUnitId = hrOrgUnitId;
    }

    public int getDefaultAdvcValue() {
        return this.defaultAdvcValue;
    }

    public void setDefaultAdvcValue(int defaultAdvcValue) {
        this.defaultAdvcValue = defaultAdvcValue;
    }

    public SchlShiftSrcTypeEnum getDefaultScheduleSrcType() {
        return this.defaultScheduleSrcType;
    }

    public void setDefaultScheduleSrcType(SchlShiftSrcTypeEnum defaultScheduleSrcType) {
        this.defaultScheduleSrcType = defaultScheduleSrcType;
    }
}

