/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.service.api;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import com.kingdee.shr.baseconfig.service.api.ISHRSqlBuilder;
import com.kingdee.shr.baseconfig.service.api.impl.AbstractSHRSqlBuilder;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class SHRSqlBuilderAPIFatory {
    private static Logger logger = Logger.getLogger(SHRSqlBuilderAPIFatory.class);

    public static ISHRSqlBuilder getSHRSqlBuilderAPI(Context ctx, String schemeNum) throws EASBizException, BOSException {
        StructureConfigSchemeInfo info = StructureConfigConvertHelper.getScheme((Context)ctx, (String)schemeNum);
        if (null == info || StringUtils.isEmpty((String)info.getSqlImplClass())) {
            return new CommonSHRSqlBuilder();
        }
        String clz = info.getSqlImplClass();
        try {
            Class<?> clazz = Class.forName(clz);
            Object obj = clazz.newInstance();
            if (!(obj instanceof ISHRSqlBuilder)) {
                throw new BaseConfigException(BaseConfigException.NO_IMPL_INTERFACE, new Object[]{clz, ISHRSqlBuilder.class.toString(), AbstractSHRSqlBuilder.class.toString(), CommonSHRSqlBuilder.class.toString()});
            }
            return (ISHRSqlBuilder)obj;
        }
        catch (ClassNotFoundException e) {
            return SHRSqlBuilderAPIFatory.getSHRSqlBuilderAPIByMsfClassLoader(ctx, clz);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static ISHRSqlBuilder getSHRSqlBuilderAPIByMsfClassLoader(Context ctx, String clz) throws EASBizException, BOSException {
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)clz);
            Object obj = clazz.newInstance();
            if (!(obj instanceof ISHRSqlBuilder)) {
                throw new BaseConfigException(BaseConfigException.NO_IMPL_INTERFACE, new Object[]{clz, ISHRSqlBuilder.class.toString(), AbstractSHRSqlBuilder.class.toString(), CommonSHRSqlBuilder.class.toString()});
            }
            return (ISHRSqlBuilder)obj;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BaseConfigException(BaseConfigException.IMPL_CLASS_NO_LOAD, new Object[]{clz});
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

