/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.fix;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.cmpdesign.exception.CmpMultiLanReformException;
import com.kingdee.shr.cmpdesign.fix.FixAdjustSalaryExecute;
import com.kingdee.shr.compensation.AdjustEmpORelationCollection;
import com.kingdee.shr.compensation.AdjustEmpORelationFactory;
import com.kingdee.shr.compensation.AdjustEmpORelationInfo;
import com.kingdee.shr.compensation.AdjustPersonRecordCollection;
import com.kingdee.shr.compensation.AdjustPersonRecordFactory;
import com.kingdee.shr.compensation.AdjustPersonRecordInfo;
import com.kingdee.shr.compensation.FixAdjustPayHrRecordCollection;
import com.kingdee.shr.compensation.FixAdjustPayHrRecordFactory;
import com.kingdee.shr.compensation.FixAdjustPayHrRecordInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryRecordFacadeFactory;
import com.kingdee.shr.compensation.FixPayHrEnum;
import com.kingdee.shr.compensation.LeffectSourceEnum;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApplyBill2FixAdjustSalary
implements FixAdjustSalaryExecute {
    Logger logger = Logger.getLogger(ApplyBill2FixAdjustSalary.class);
    private String personSqlId = "";
    private String itemSqlId = "";
    private String parrenUser = null;
    String maxDate = null;
    SimpleDateFormat format = null;
    private Map<String, Integer> dataDotMap = new HashMap<String, Integer>();
    private Map<String, AdjustEmpORelationInfo> aeoMap = new HashMap<String, AdjustEmpORelationInfo>();
    private Map<String, FixAdjustSalaryCollection> collMap = new HashMap<String, FixAdjustSalaryCollection>();
    private Map<String, String> payHrMap = new HashMap<String, String>();
    private Map<String, AdjustPersonRecordInfo> recordMap = new HashMap<String, AdjustPersonRecordInfo>();

    @Override
    public String save(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        String parrenUser = "yyyy-MM-dd";
        try {
            Map utcMap = UserNantionalUtil.getUserUTCInfo((Context)ctx);
            Map utcUserMap = (Map)utcMap.get("utcUser");
            Map patternUserMap = (Map)utcUserMap.get("pattern");
            parrenUser = patternUserMap.get("Date").toString();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        this.beforeSave(ctx, info);
        FixAdjustSalaryInfo lastInfo = null;
        FixAdjustSalaryInfo nextInfo = null;
        FixAdjustSalaryInfo currentInfo = null;
        String payHrOrgId = info.getPayHrOrgUnit() == null ? "" : info.getPayHrOrgUnit().getId().toString();
        String personId = info.getPerson().getId().toString();
        String itemId = info.getCmpItem().getId().toString();
        try {
            IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)("select FDataDot from T_HR_SCmpItem where FID = '" + itemId + "'"));
            while (rs.next()) {
                info.setMoney(info.getMoney().setScale(rs.getInt("FDataDot"), RoundingMode.HALF_UP));
            }
        }
        catch (Exception rs) {
            // empty catch block
        }
        Date effdt = info.getEffectDay();
        Date leffdt = null;
        String hrOrgUnitId = info.getAdjHrOrgUnit().getId().toString();
        Calendar calendar = Calendar.getInstance();
        Calendar maxCalendar = Calendar.getInstance();
        maxCalendar.set(2199, 11, 31, 0, 0, 0);
        SimpleDateFormat format = new SimpleDateFormat(parrenUser);
        String maxDate = format.format(maxCalendar.getTime());
        String oql = null;
        oql = StringUtils.isEmpty((String)payHrOrgId) ? " where person.id = '" + personId + "' and cmpItem.id = '" + itemId + "' and (payHrOrgUnit.id is null or payHrOrgUnit.id in (''))" : " where person.id = '" + personId + "' and cmpItem.id = '" + itemId + "' and payHrOrgUnit.id = '" + payHrOrgId + "' ";
        if (null != info.getId()) {
            oql = oql + " and id <> '" + info.getId().toString() + "'";
            currentInfo = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryInfo("where id = '" + info.getId().toString() + "'");
        }
        oql = oql + " order by effectDay ";
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FixAdjustSalaryInfo fixInfo = coll.get(i);
            if (fixInfo.getEffectDay().before(effdt)) {
                lastInfo = fixInfo;
                continue;
            }
            if (!fixInfo.getEffectDay().after(effdt) || null != nextInfo) continue;
            nextInfo = fixInfo;
        }
        Date leffectDay = info.getLeffectDay();
        if (null != leffectDay && null != nextInfo && format.format(leffectDay).compareTo(maxDate) < 0 && leffectDay.compareTo(nextInfo.getEffectDay()) >= 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK6, new Object[]{format.format(leffectDay), format.format(nextInfo.getEffectDay())});
        }
        if (null != lastInfo && format.format(lastInfo.getLeffectDay()).compareTo(maxDate) < 0 && lastInfo.getLeffectDay().compareTo(info.getEffectDay()) >= 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK5, new Object[]{format.format(info.getEffectDay()), format.format(lastInfo.getLeffectDay())});
        }
        oql = " where person.id = '" + personId + "' and hrOrgUnit.id = '" + hrOrgUnitId + "' ";
        AdjustPersonRecordCollection reCol = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(oql);
        AdjustPersonRecordInfo recordInfo = reCol.get(0);
        info.setLeffectSource(LeffectSourceEnum.MANUAL);
        if (null == info.getLeffectDay()) {
            info.setLeffectSource(LeffectSourceEnum.AUTO);
            leffdt = null != reCol && reCol.size() > 0 ? recordInfo.getLeffectDate() : maxCalendar.getTime();
        } else {
            if (recordInfo.getLeffectDate().before(leffectDay)) {
                throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK4, new Object[]{format.format(leffectDay), format.format(recordInfo.getLeffectDate())});
            }
            leffdt = info.getLeffectDay();
            if (format.format(leffdt).compareTo(maxDate) == 0) {
                info.setLeffectSource(LeffectSourceEnum.AUTO);
            }
        }
        info.setLeffectDay(leffdt);
        if (null != lastInfo) {
            if (lastInfo.getLeffectDay().compareTo(info.getEffectDay()) >= 0) {
                calendar.setTime(effdt);
                calendar.add(5, -1);
                lastInfo.setLeffectDay(calendar.getTime());
                lastInfo.setLeffectSource(LeffectSourceEnum.AUTO);
                FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)lastInfo);
                this.afterSave(ctx, lastInfo);
            }
            info.setOldFixAdjustSalary(lastInfo);
        }
        if (null != nextInfo) {
            calendar.setTime(nextInfo.getEffectDay());
            calendar.add(5, -1);
            if (null == leffectDay || format.format(leffectDay).compareTo(maxDate) >= 0) {
                info.setLeffectDay(calendar.getTime());
            }
        }
        Date effectDate = recordInfo.getEffectDate();
        Date leffectDate = recordInfo.getLeffectDate();
        if (info.getEffectDay().compareTo(effectDate) >= 0 && info.getEffectDay().compareTo(leffectDate) <= 0 && info.getLeffectDay().compareTo(leffectDate) > 0) {
            info.setLeffectDay(leffectDate);
        }
        if (!StringUtils.isEmpty((String)info.getRemark()) && null == info.get("isImport")) {
            HashMap mulMap = new HashMap();
            String language = ctx.getLocale().getLanguage();
            if (!info.getRemark().contains("{")) {
                mulMap.put(LocaleUtils.locale_l1.toString(), info.getRemark(LocaleUtils.locale_l1));
                mulMap.put(LocaleUtils.locale_l2.toString(), info.getRemark(LocaleUtils.locale_l2));
                mulMap.put(LocaleUtils.locale_l3.toString(), info.getRemark(LocaleUtils.locale_l3));
            } else {
                mulMap = JSONUtils.convertJsonToObject((Context)ctx, (String)info.getRemark());
            }
            if (null == info.getId()) {
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l1.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l1.toString()), LocaleUtils.locale_l1);
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l2.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l2.toString()), LocaleUtils.locale_l2);
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l3.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l3.toString()), LocaleUtils.locale_l3);
            } else {
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l1.toString()), LocaleUtils.locale_l1);
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l2.toString()), LocaleUtils.locale_l2);
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l3.toString()), LocaleUtils.locale_l3);
            }
        }
        IObjectPK pk = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        if (null != nextInfo) {
            nextInfo.setOldFixAdjustSalary(info);
            FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)nextInfo);
            this.afterSave(ctx, nextInfo);
        }
        this.afterSave(ctx, info);
        info = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryInfo(pk);
        String type = "";
        HashMap<FixAdjustSalaryInfo, FixAdjustSalaryInfo> fixAdjustRecordMap = new HashMap<FixAdjustSalaryInfo, FixAdjustSalaryInfo>();
        type = null != currentInfo ? "update" : "save";
        fixAdjustRecordMap.put(info, currentInfo);
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(type, fixAdjustRecordMap);
        return pk.toString();
    }

    public void afterSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        FixAdjustPayHrRecordInfo payInfo = new FixAdjustPayHrRecordInfo();
        payInfo.setSourceId(info.getId().toString());
        payInfo.setEFFDT(info.getEffectDay());
        payInfo.setLEFFDT(info.getLeffectDay());
        payInfo.setHrOrgUnit(info.getPayHrOrgUnit());
        payInfo.setType(FixPayHrEnum.AUTO);
        payInfo.setCmpItem(info.getCmpItem());
        payInfo.setPerson(info.getPerson());
        FixAdjustPayHrRecordCollection payColl = null;
        try {
            payColl = FixAdjustPayHrRecordFactory.getLocalInstance((Context)ctx).getFixAdjustPayHrRecordCollection("select id where sourceId = '" + info.getId().toString() + "'");
            if (null != payColl && payColl.size() > 0) {
                payInfo.setId(BOSUuid.read((String)payColl.get(0).getId().toString()));
            }
            FixAdjustPayHrRecordFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)payInfo);
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void beforeSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        FixAdjustSalaryCollection coll;
        String personId = info.getPerson().getId().toString();
        String payHrOrgId = info.getPayHrOrgUnit() == null ? "" : info.getPayHrOrgUnit().getId().toString();
        String itemId = info.getCmpItem().getId().toString();
        Date effectDay = info.getEffectDay();
        String id = null == info.getId() ? "" : info.getId().toString();
        String payHrOrgUnit = info.getPayHrOrgUnit() == null ? "" : info.getPayHrOrgUnit().getId().toString();
        Date leffectDay = info.getLeffectDay();
        if (null != leffectDay) {
            info.setLeffectSource(LeffectSourceEnum.MANUAL);
        } else {
            info.setLeffectSource(LeffectSourceEnum.AUTO);
            leffectDay = CmpDateUtil.getMaxEndDate();
        }
        String oql = null;
        String existsData = null;
        if (StringUtils.isEmpty((String)payHrOrgId)) {
            oql = "select adjHrOrgUnit.name where cmpItem.id='" + itemId + "' and effectDay={ts'" + effectDay + "'} and person.id = '" + personId + "' and (payHrOrgUnit.id is null or payHrOrgUnit.id in (''))";
            existsData = "select cmpItem.name where cmpItem.id='" + itemId + "' and person.id = '" + personId + "'  and  payHrOrgUnit.id is not null";
        } else {
            oql = "select adjHrOrgUnit.name where cmpItem.id='" + itemId + "' and effectDay={ts'" + effectDay + "'} and person.id = '" + personId + "' and payHrOrgUnit.id = '" + payHrOrgId + "'  ";
            existsData = "select cmpItem.name where cmpItem.id='" + itemId + "' and person.id = '" + personId + "'  and  (payHrOrgUnit.id is null or payHrOrgUnit.id in (''))  ";
        }
        if (!StringUtils.isEmpty((String)id)) {
            oql = oql + " and id <> '" + id + "' ";
        }
        if (null != (coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql)) && coll.size() > 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLEXSITITEM, new Object[]{coll.get(0).getAdjHrOrgUnit().getName()});
        }
        if (null != info.getId() && !StringUtils.isEmpty((String)info.getId().toString())) {
            existsData = existsData + " and id <> '" + info.getId().toString() + "'";
        }
        if (null != (coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(existsData)) && coll.size() > 0) {
            if (StringUtils.isEmpty((String)payHrOrgUnit)) {
                throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK8, new Object[]{coll.get(0).getCmpItem().getName()});
            }
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK7, new Object[]{coll.get(0).getCmpItem().getName()});
        }
        if (null != info.getLeffectDay() && info.getEffectDay().after(info.getLeffectDay())) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK3);
        }
    }

    @Override
    public void changeItem(Context ctx, FixAdjustSalaryInfo newInfo, String oldItemId, String oldPayHrOrgId) throws BOSException, EASBizException {
        String id = newInfo.getId().toString();
        String personId = newInfo.getPerson().getId().toString();
        String payHrOrgUnit = newInfo.getPayHrOrgUnit() == null ? "" : newInfo.getPayHrOrgUnit().getId().toString();
        String oql = null;
        oql = StringUtils.isEmpty((String)payHrOrgUnit) ? "where person.id = '" + personId + "' and cmpItem.id = '" + oldItemId + "' and id <> '" + id + "' and (payHrOrgUnit.id is null or payHrOrgUnit.id in ('')) order by effectDay desc " : "where person.id = '" + personId + "' and cmpItem.id = '" + oldItemId + "' and id <> '" + id + "' and payHrOrgUnit.id='" + payHrOrgUnit + "' order by effectDay desc ";
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        if (null == coll || coll.size() < 1) {
            return;
        }
        FixAdjustSalaryInfo info = coll.get(0);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        Date leffectDate = calendar.getTime();
        if (null != info.getAdjEmpORelation()) {
            AdjustEmpORelationInfo adjEmpInfo = AdjustEmpORelationFactory.getLocalInstance((Context)ctx).getAdjustEmpORelationInfo("where id = '" + info.getAdjEmpORelation().getId().toString() + "'");
            leffectDate = adjEmpInfo.getLeffectDate();
        }
        info.setLeffectDay(leffectDate);
        FixAdjustSalaryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
    }

    @Override
    public String save(Context ctx, FixAdjustSalaryCollection coll) throws BOSException, EASBizException {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            FixAdjustSalaryInfo info = coll.get(i);
            this.doSingleSave(ctx, info);
        }
        return null;
    }

    protected void initDate(Context ctx) throws BOSException {
        try {
            Map utcMap = UserNantionalUtil.getUserUTCInfo((Context)ctx);
            Map utcUserMap = (Map)utcMap.get("utcUser");
            Map patternUserMap = (Map)utcUserMap.get("pattern");
            this.parrenUser = patternUserMap.get("Date") != null ? patternUserMap.get("Date").toString() : "yyyy-MM-dd";
            Calendar maxCalendar = Calendar.getInstance();
            maxCalendar.set(2199, 11, 31, 0, 0, 0);
            this.format = new SimpleDateFormat(this.parrenUser);
            this.maxDate = this.format.format(maxCalendar.getTime());
        }
        catch (Exception e) {
            this.parrenUser = "yyyy-MM-dd";
            Calendar maxCalendar = Calendar.getInstance();
            maxCalendar.set(2199, 11, 31, 0, 0, 0);
            this.format = new SimpleDateFormat(this.parrenUser);
            this.maxDate = this.format.format(maxCalendar.getTime());
            this.logger.error((Object)e.getMessage());
        }
    }

    protected void initItemDot(Context ctx) throws BOSException {
        try {
            IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)("select FID, FDataDot from T_HR_SCmpItem where FID in " + this.itemSqlId + ""));
            while (rs.next()) {
                this.dataDotMap.put(rs.getString("FID"), rs.getInt("FDataDot"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void initHisFixAdjust(Context ctx) throws BOSException {
        String oql = " where person.id in " + this.personSqlId + " and cmpItem.id in " + this.itemSqlId;
        oql = oql + " order by person.id, payHrOrgUnit.id, cmpItem.id, effectDay ";
        FixAdjustSalaryCollection oldColl = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        FixAdjustSalaryCollection temp = null;
        String key = null;
        String personId = null;
        String cmpItemId = null;
        String payHrOrgUnitId = null;
        for (int i = 0; i < oldColl.size(); ++i) {
            FixAdjustSalaryInfo oldFix = oldColl.get(i);
            personId = oldFix.getPerson().getId().toString();
            cmpItemId = oldFix.getCmpItem().getId().toString();
            payHrOrgUnitId = oldFix.getPayHrOrgUnit() == null ? null : oldFix.getPayHrOrgUnit().getId().toString();
            key = personId + "_" + cmpItemId + "_" + payHrOrgUnitId;
            if (this.collMap.get(key) != null) {
                temp = this.collMap.get(key);
            } else {
                temp = new FixAdjustSalaryCollection();
                this.collMap.put(key, temp);
            }
            temp.add(oldFix);
        }
    }

    protected void initPersonRecord(Context ctx, String hrOrgUnitId) throws BOSException, CmpMultiLanReformException {
        String oql = " where person.id in " + this.personSqlId + " and hrOrgUnit.id = '" + hrOrgUnitId + "' ";
        AdjustPersonRecordCollection reCol = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(oql);
        for (int i = 0; i < reCol.size(); ++i) {
            this.recordMap.put(reCol.get(i).getPerson().getId().toString(), reCol.get(i));
        }
    }

    protected void initFixAdjustPayHrRecord(Context ctx, String hrOrgUnitId) throws BOSException {
        String oql = "select id, FSourceId where person.id in " + this.personSqlId + " and hrOrgUnit.id = '" + hrOrgUnitId + "' ";
        FixAdjustPayHrRecordCollection payHrColl = FixAdjustPayHrRecordFactory.getLocalInstance((Context)ctx).getFixAdjustPayHrRecordCollection(oql);
        for (int i = 0; i < payHrColl.size(); ++i) {
            this.payHrMap.put(payHrColl.get(i).getSourceId(), payHrColl.get(i).getId().toString());
        }
    }

    protected void initAdjEmpORelation(Context ctx) throws BOSException {
        String oql = "select id, FSourceId where person.id in " + this.personSqlId;
        AdjustEmpORelationCollection aeoColl = AdjustEmpORelationFactory.getLocalInstance((Context)ctx).getAdjustEmpORelationCollection(oql);
        for (int i = 0; i < aeoColl.size(); ++i) {
            this.aeoMap.put(aeoColl.get(i).getId().toString(), aeoColl.get(i));
        }
    }

    @Override
    public String doSingleSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        Date leffectDay;
        FixAdjustSalaryInfo lastInfo = null;
        FixAdjustSalaryInfo nextInfo = null;
        Object currentInfo = null;
        Date effdt = info.getEffectDay();
        if (effdt == null) {
            this.logger.error((Object)"effectDate is necessary, but now it`s empty!");
            return null;
        }
        Date leffdt = info.getLeffectDay();
        Calendar calendar = Calendar.getInstance();
        String cmpItemId = info.getCmpItem().getId().toString();
        String personId = info.getPerson().getId().toString();
        String payHrOrgUnitId = info.getPayHrOrgUnit() == null ? null : info.getPayHrOrgUnit().getId().toString();
        String key = personId + "_" + cmpItemId + "_" + payHrOrgUnitId;
        info.setMoney(info.getMoney().setScale((int)this.dataDotMap.get(cmpItemId), RoundingMode.HALF_UP));
        FixAdjustSalaryCollection coll = this.collMap.get(key);
        if (coll != null) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String oldEffdtStr;
                FixAdjustSalaryInfo fixInfo = coll.get(i);
                String effdtStr = CmpDateUtil.getDateStr((Date)effdt);
                if (effdtStr.equals(oldEffdtStr = CmpDateUtil.getDateStr((Date)fixInfo.getEffectDay()))) {
                    throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLEXSITITEM, new Object[]{fixInfo.getAdjHrOrgUnit().getName()});
                }
                if (payHrOrgUnitId == null && fixInfo.getPayHrOrgUnit() != null) {
                    throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK8, new Object[]{fixInfo.getCmpItem().getName()});
                }
                if (payHrOrgUnitId != null && fixInfo.getPayHrOrgUnit() == null) {
                    throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK7, new Object[]{fixInfo.getCmpItem().getName()});
                }
                if (fixInfo.getEffectDay().before(effdt)) {
                    lastInfo = fixInfo;
                    continue;
                }
                if (!fixInfo.getEffectDay().after(effdt) || null != nextInfo) continue;
                nextInfo = fixInfo;
            }
        }
        if (null != (leffectDay = info.getLeffectDay()) && null != nextInfo && this.format.format(leffectDay).compareTo(this.maxDate) < 0 && leffectDay.compareTo(nextInfo.getEffectDay()) >= 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK6, new Object[]{this.format.format(leffectDay), this.format.format(nextInfo.getEffectDay())});
        }
        if (null != lastInfo && this.format.format(lastInfo.getLeffectDay()).compareTo(this.maxDate) < 0 && lastInfo.getLeffectDay().compareTo(info.getEffectDay()) >= 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK5, new Object[]{this.format.format(info.getEffectDay()), this.format.format(lastInfo.getLeffectDay())});
        }
        AdjustPersonRecordInfo recordInfo = this.recordMap.get(personId);
        LeffectSourceEnum leffectSource = LeffectSourceEnum.MANUAL;
        if (null == leffdt) {
            leffectSource = LeffectSourceEnum.AUTO;
            leffdt = null != recordInfo ? recordInfo.getLeffectDate() : CmpDateUtil.getMaxEndDate();
        } else {
            if (recordInfo.getLeffectDate().before(leffdt)) {
                throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK4, new Object[]{this.format.format(leffdt), this.format.format(recordInfo.getLeffectDate())});
            }
            if (this.format.format(leffdt).compareTo(this.maxDate) == 0) {
                leffectSource = LeffectSourceEnum.AUTO;
            }
        }
        info.setLeffectDay(leffdt);
        info.setLeffectSource(leffectSource);
        if (null != lastInfo) {
            if (lastInfo.getLeffectDay().compareTo(info.getEffectDay()) >= 0) {
                calendar.setTime(effdt);
                calendar.add(5, -1);
                lastInfo.setLeffectDay(calendar.getTime());
                lastInfo.setLeffectSource(LeffectSourceEnum.AUTO);
                FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)lastInfo);
                this.singleAfterSave(ctx, lastInfo);
            }
            info.setOldFixAdjustSalary(lastInfo);
        }
        if (null != nextInfo) {
            calendar.setTime(nextInfo.getEffectDay());
            calendar.add(5, -1);
            if (null == leffectDay || this.format.format(leffectDay).compareTo(this.maxDate) >= 0) {
                info.setLeffectDay(calendar.getTime());
            }
        }
        Date effectDate = recordInfo.getEffectDate();
        Date leffectDate = recordInfo.getLeffectDate();
        if (info.getEffectDay().compareTo(effectDate) >= 0 && info.getEffectDay().compareTo(leffectDate) <= 0 && info.getLeffectDay().compareTo(leffectDate) > 0) {
            info.setLeffectDay(leffectDate);
        }
        if (!StringUtils.isEmpty((String)info.getRemark()) && null == info.get("isImport")) {
            HashMap mulMap = new HashMap();
            String language = ctx.getLocale().getLanguage();
            if (!info.getRemark().contains("{")) {
                mulMap.put(LocaleUtils.locale_l1.toString(), info.getRemark(LocaleUtils.locale_l1));
                mulMap.put(LocaleUtils.locale_l2.toString(), info.getRemark(LocaleUtils.locale_l2));
                mulMap.put(LocaleUtils.locale_l3.toString(), info.getRemark(LocaleUtils.locale_l3));
            } else {
                mulMap = JSONUtils.convertJsonToObject((Context)ctx, (String)info.getRemark());
            }
            if (null == info.getId()) {
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l1.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l1.toString()), LocaleUtils.locale_l1);
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l2.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l2.toString()), LocaleUtils.locale_l2);
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l3.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l3.toString()), LocaleUtils.locale_l3);
            } else {
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l1.toString()), LocaleUtils.locale_l1);
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l2.toString()), LocaleUtils.locale_l2);
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l3.toString()), LocaleUtils.locale_l3);
            }
        }
        IObjectPK pk = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        if (null != nextInfo) {
            nextInfo.setOldFixAdjustSalary(info);
            FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)nextInfo);
            this.singleAfterSave(ctx, nextInfo);
        }
        this.singleAfterSave(ctx, info);
        info.setId(BOSUuid.read((String)pk.toString()));
        HashMap<FixAdjustSalaryInfo, Object> fixAdjustRecordMap = new HashMap<FixAdjustSalaryInfo, Object>();
        String type = "save";
        fixAdjustRecordMap.put(info, currentInfo);
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(type, fixAdjustRecordMap);
        return pk.toString();
    }

    public void singleAfterSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        FixAdjustPayHrRecordInfo payInfo = new FixAdjustPayHrRecordInfo();
        payInfo.setSourceId(info.getId().toString());
        payInfo.setEFFDT(info.getEffectDay());
        payInfo.setLEFFDT(info.getLeffectDay());
        payInfo.setHrOrgUnit(info.getPayHrOrgUnit());
        payInfo.setType(FixPayHrEnum.AUTO);
        payInfo.setCmpItem(info.getCmpItem());
        payInfo.setPerson(info.getPerson());
        String sourceId = info.getId().toString();
        try {
            if (this.payHrMap.get(sourceId) != null) {
                payInfo.setId(BOSUuid.read((String)this.payHrMap.get(sourceId)));
            }
            FixAdjustPayHrRecordFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)payInfo);
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setPersonIdAndCmpItemId(String personSqlId, String itemSqlId) {
        this.personSqlId = personSqlId;
        this.itemSqlId = itemSqlId;
    }
}

