/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.fix;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.cmpdesign.exception.CmpMultiLanReformException;
import com.kingdee.shr.cmpdesign.fix.FixAdjustSalaryExecute;
import com.kingdee.shr.compensation.AdjustPersonRecordCollection;
import com.kingdee.shr.compensation.AdjustPersonRecordFactory;
import com.kingdee.shr.compensation.AdjustPersonRecordInfo;
import com.kingdee.shr.compensation.FixAdjustPayHrRecordCollection;
import com.kingdee.shr.compensation.FixAdjustPayHrRecordFactory;
import com.kingdee.shr.compensation.FixAdjustPayHrRecordInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryRecordFacadeFactory;
import com.kingdee.shr.compensation.FixPayHrEnum;
import com.kingdee.shr.compensation.LeffectSourceEnum;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FixAdjustSalaryExecuteCommon
implements FixAdjustSalaryExecute {
    @Override
    public String save(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        Map utcMap = UserNantionalUtil.getUserUTCInfo((Context)ctx);
        Map utcUserMap = (Map)utcMap.get("utcUser");
        Map patternUserMap = (Map)utcUserMap.get("pattern");
        String parrenUser = patternUserMap.get("Date").toString();
        this.beforeSave(ctx, info);
        FixAdjustSalaryInfo lastInfo = null;
        FixAdjustSalaryInfo nextInfo = null;
        FixAdjustSalaryInfo currentInfo = null;
        String personId = info.getPerson().getId().toString();
        String itemId = info.getCmpItem().getId().toString();
        Date effdt = info.getEffectDay();
        Date leffdt = null;
        String hrOrgUnitId = info.getAdjHrOrgUnit().getId().toString();
        Calendar calendar = Calendar.getInstance();
        Calendar maxCalendar = Calendar.getInstance();
        maxCalendar.set(2199, 11, 31, 0, 0, 0);
        SimpleDateFormat format = new SimpleDateFormat(parrenUser);
        String maxDate = format.format(maxCalendar.getTime());
        String payHrOrgId = info.getPayHrOrgUnit() == null ? "" : info.getPayHrOrgUnit().getId().toString();
        String oql = null;
        oql = StringUtils.isEmpty((String)payHrOrgId) ? " where person.id = '" + personId + "' and cmpItem.id = '" + itemId + "' and (payHrOrgUnit.id is null  or payHrOrgUnit.id in (''))" : " where person.id = '" + personId + "' and cmpItem.id = '" + itemId + "' and payHrOrgUnit.id = '" + payHrOrgId + "' ";
        if (null != info.getId()) {
            oql = oql + " and id <> '" + info.getId().toString() + "'";
            currentInfo = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryInfo("where id = '" + info.getId().toString() + "'");
        }
        oql = oql + " order by effectDay ";
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FixAdjustSalaryInfo fixInfo = coll.get(i);
            if (fixInfo.getEffectDay().before(effdt)) {
                lastInfo = fixInfo;
                continue;
            }
            if (!fixInfo.getEffectDay().after(effdt) || null != nextInfo) continue;
            nextInfo = fixInfo;
        }
        Date leffectDay = info.getLeffectDay();
        if (null != leffectDay && null != nextInfo && format.format(leffectDay).compareTo(maxDate) < 0 && leffectDay.compareTo(nextInfo.getEffectDay()) >= 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK6, new Object[]{format.format(leffectDay), format.format(nextInfo.getEffectDay())});
        }
        if (null != lastInfo && format.format(lastInfo.getLeffectDay()).compareTo(maxDate) < 0 && lastInfo.getLeffectDay().compareTo(info.getEffectDay()) >= 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK5, new Object[]{format.format(info.getEffectDay()), format.format(lastInfo.getLeffectDay())});
        }
        AdjustPersonRecordCollection reCol = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(" where person.id = '" + personId + "' and hrOrgUnit.id = '" + hrOrgUnitId + "' ");
        AdjustPersonRecordInfo recordInfo = reCol.get(0);
        if (null == info.getLeffectDay()) {
            leffdt = null != reCol && reCol.size() > 0 ? recordInfo.getLeffectDate() : maxCalendar.getTime();
        } else {
            if (recordInfo.getLeffectDate().before(leffectDay)) {
                throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK4, new Object[]{format.format(leffectDay), format.format(recordInfo.getLeffectDate())});
            }
            leffdt = info.getLeffectDay();
        }
        info.setLeffectDay(leffdt);
        if (null != lastInfo) {
            if (lastInfo.getLeffectDay().compareTo(info.getEffectDay()) >= 0) {
                calendar.setTime(effdt);
                calendar.add(5, -1);
                lastInfo.setLeffectDay(calendar.getTime());
                lastInfo.setLeffectSource(LeffectSourceEnum.AUTO);
                FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)lastInfo);
                this.afterSave(ctx, lastInfo);
            }
            info.setOldFixAdjustSalary(lastInfo);
        }
        if (null != nextInfo) {
            calendar.setTime(nextInfo.getEffectDay());
            calendar.add(5, -1);
            if (null == leffectDay || format.format(leffectDay).compareTo(maxDate) >= 0) {
                info.setLeffectDay(calendar.getTime());
            }
        }
        Date effectDate = recordInfo.getEffectDate();
        Date leffectDate = recordInfo.getLeffectDate();
        if (info.getEffectDay().compareTo(effectDate) >= 0 && info.getEffectDay().compareTo(leffectDate) <= 0 && info.getLeffectDay().compareTo(leffectDate) > 0) {
            info.setLeffectDay(leffectDate);
        }
        if (!StringUtils.isEmpty((String)info.getRemark()) && null == info.get("isImport")) {
            HashMap mulMap = new HashMap();
            String language = ctx.getLocale().getLanguage();
            if (!info.getRemark().contains("{")) {
                mulMap.put(LocaleUtils.locale_l1.toString(), info.getRemark(LocaleUtils.locale_l1));
                mulMap.put(LocaleUtils.locale_l2.toString(), info.getRemark(LocaleUtils.locale_l2));
                mulMap.put(LocaleUtils.locale_l3.toString(), info.getRemark(LocaleUtils.locale_l3));
            } else {
                mulMap = JSONUtils.convertJsonToObject((Context)ctx, (String)info.getRemark());
            }
            if (null == info.getId()) {
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l1.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l1.toString()), LocaleUtils.locale_l1);
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l2.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l2.toString()), LocaleUtils.locale_l2);
                info.setRemark(null == mulMap.get(LocaleUtils.locale_l3.toString()) ? (String)mulMap.get(language) : (String)mulMap.get(LocaleUtils.locale_l3.toString()), LocaleUtils.locale_l3);
            } else {
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l1.toString()), LocaleUtils.locale_l1);
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l2.toString()), LocaleUtils.locale_l2);
                info.setRemark((String)mulMap.get(LocaleUtils.locale_l3.toString()), LocaleUtils.locale_l3);
            }
        }
        IObjectPK pk = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        if (null != nextInfo) {
            nextInfo.setOldFixAdjustSalary(info);
            FixAdjustSalaryFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)nextInfo);
            this.afterSave(ctx, nextInfo);
        }
        this.afterSave(ctx, info);
        info = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryInfo(pk);
        String type = "";
        HashMap<FixAdjustSalaryInfo, FixAdjustSalaryInfo> fixAdjustRecordMap = new HashMap<FixAdjustSalaryInfo, FixAdjustSalaryInfo>();
        type = null != currentInfo ? "update" : "save";
        fixAdjustRecordMap.put(info, currentInfo);
        FixAdjustSalaryRecordFacadeFactory.getLocalInstance((Context)ctx).saveRecord(type, fixAdjustRecordMap);
        return pk.toString();
    }

    public void afterSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        FixAdjustPayHrRecordInfo payInfo = new FixAdjustPayHrRecordInfo();
        payInfo.setSourceId(info.getId().toString());
        payInfo.setEFFDT(info.getEffectDay());
        payInfo.setLEFFDT(info.getLeffectDay());
        payInfo.setHrOrgUnit(info.getPayHrOrgUnit());
        payInfo.setType(FixPayHrEnum.AUTO);
        payInfo.setCmpItem(info.getCmpItem());
        payInfo.setPerson(info.getPerson());
        FixAdjustPayHrRecordCollection payColl = null;
        try {
            payColl = FixAdjustPayHrRecordFactory.getLocalInstance((Context)ctx).getFixAdjustPayHrRecordCollection("select id where sourceId = '" + info.getId().toString() + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != payColl && payColl.size() > 0) {
            payInfo.setId(BOSUuid.read((String)payColl.get(0).getId().toString()));
        }
        try {
            FixAdjustPayHrRecordFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)payInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String save(Context ctx, FixAdjustSalaryCollection coll) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void beforeSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        FixAdjustSalaryCollection coll;
        Map utcMap = UserNantionalUtil.getUserUTCInfo((Context)ctx);
        Map utcUserMap = (Map)utcMap.get("utcUser");
        Map patternUserMap = (Map)utcUserMap.get("pattern");
        String parrenUser = patternUserMap.get("Date").toString();
        String personId = info.getPerson().getId().toString();
        String itemId = info.getCmpItem().getId().toString();
        Date effectDay = info.getEffectDay();
        String id = null == info.getId() ? "" : info.getId().toString();
        String payHrOrgUnit = info.getPayHrOrgUnit() == null ? "" : info.getPayHrOrgUnit().getId().toString();
        Date leffectDay = info.getLeffectDay();
        if (null != leffectDay && leffectDay.before(CmpDateUtil.getMaxEndDate())) {
            info.setLeffectSource(LeffectSourceEnum.MANUAL);
        } else {
            info.setLeffectSource(LeffectSourceEnum.AUTO);
            leffectDay = CmpDateUtil.getMaxEndDate();
        }
        String oql = null;
        String existsData = null;
        if (StringUtils.isEmpty((String)payHrOrgUnit)) {
            oql = "select adjHrOrgUnit.name where cmpItem.id='" + itemId + "' and effectDay={ts'" + effectDay + "'} and person.id = '" + personId + "' and (payHrOrgUnit.id is null or payHrOrgUnit.id in (''))  ";
            existsData = "select cmpItem.name where cmpItem.id='" + itemId + "' and person.id = '" + personId + "'  and  payHrOrgUnit.id is not null";
        } else {
            oql = "select adjHrOrgUnit.name where cmpItem.id='" + itemId + "' and effectDay={ts'" + effectDay + "'} and person.id = '" + personId + "' and payHrOrgUnit.id='" + payHrOrgUnit + "'  ";
            existsData = "select cmpItem.name where cmpItem.id='" + itemId + "' and person.id = '" + personId + "'  and  (payHrOrgUnit.id is null or payHrOrgUnit.id in (''))  ";
        }
        if (!StringUtils.isEmpty((String)id)) {
            oql = oql + " and id <> '" + id + "' ";
        }
        if (null != (coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql)) && coll.size() > 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLEXSITITEM, new Object[]{coll.get(0).getAdjHrOrgUnit().getName()});
        }
        if (null != info.getId() && !StringUtils.isEmpty((String)info.getId().toString())) {
            existsData = existsData + " and id <> '" + info.getId().toString() + "'";
        }
        if (null != (coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(existsData)) && coll.size() > 0) {
            if (StringUtils.isEmpty((String)payHrOrgUnit)) {
                throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK8, new Object[]{coll.get(0).getCmpItem().getName()});
            }
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK7, new Object[]{coll.get(0).getCmpItem().getName()});
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(parrenUser);
        String hrOrgUnitId = info.getAdjHrOrgUnit().getId().toString();
        AdjustPersonRecordCollection reCol = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(" where person.id = '" + personId + "' and hrOrgUnit.id = '" + hrOrgUnitId + "' ");
        AdjustPersonRecordInfo recordInfo = reCol.get(0);
        Date recoredEffectDate = recordInfo.getEffectDate();
        Date recoredLeffectDate = recordInfo.getLeffectDate();
        String recoredEffectDateStr = simpleDateFormat.format(recoredEffectDate);
        String recoredLeffectDateStr = simpleDateFormat.format(recoredLeffectDate);
        String effectDayStr = simpleDateFormat.format(effectDay);
        if (effectDayStr.compareTo(recoredEffectDateStr) < 0 || effectDayStr.compareTo(recoredLeffectDateStr) > 0) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK2, new Object[]{recoredEffectDateStr, recoredLeffectDateStr});
        }
        if (null != info.getLeffectDay() && info.getEffectDay().after(info.getLeffectDay())) {
            throw new CmpMultiLanReformException(CmpMultiLanReformException.BILLCHECK3);
        }
    }

    @Override
    public void changeItem(Context ctx, FixAdjustSalaryInfo newInfo, String oldItemId, String oldPayHrOrgId) throws BOSException, EASBizException {
        String id = newInfo.getId().toString();
        String personId = newInfo.getPerson().getId().toString();
        String oql = null;
        oql = StringUtils.isEmpty((String)oldPayHrOrgId) ? "where person.id = '" + personId + "' and cmpItem.id = '" + oldItemId + "' and id <> '" + id + "' and (payHrOrgUnit.id is null or payHrOrgUnit.id in ('')) order by effectDay desc " : "where person.id = '" + personId + "' and cmpItem.id = '" + oldItemId + "' and id <> '" + id + "' and payHrOrgUnit.id='" + oldPayHrOrgId + "' order by effectDay desc ";
        FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
        if (null == coll || coll.size() < 1) {
            return;
        }
        FixAdjustSalaryInfo info = coll.get(0);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2199, 11, 31, 0, 0, 0);
        Date leffectDate = calendar.getTime();
        String hrOrgUnitId = info.getAdjHrOrgUnit().getId().toString();
        AdjustPersonRecordCollection reCol = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(" where person.id = '" + personId + "' and hrOrgUnit.id = '" + hrOrgUnitId + "' ");
        AdjustPersonRecordInfo recordInfo = reCol.get(0);
        if (LeffectSourceEnum.AUTO.equals((Object)info.getLeffectSource())) {
            leffectDate = recordInfo.getLeffectDate();
            info.setLeffectDay(leffectDate);
            FixAdjustSalaryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        }
    }

    @Override
    public String doSingleSave(Context ctx, FixAdjustSalaryInfo info) throws BOSException, EASBizException {
        return null;
    }
}

