/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.BasicItemInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpAdjRecordCalFunctionService
extends SalaryCalFunction2 {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.service.CmpAdjRecordCalFunctionService");
    private static final String ADJ_MONEY_STR = "A";
    private static final String ADJ_STD_STR = "B";
    private static final String ADJ_STD_LEVEL_STR = "C";
    private static final String ADJ_STD_POINT_STR = "D";
    private static final String ADJ_STD_SCOPE_STR = "E";
    private static final String ADJ_STD_FLOAT_STR = "F";
    private static final String ADJ_CURRENCY_STR = "G";
    private static final String ADJ_EFFECTDAY_STR = "H";

    public String getHisAdjSalaryRecord(Context ctx, String mainTableName, Map paramMap, HashMap tempMap, BasicItemInfo calScheme, String mainTableRowFilter, String cmpItemName, String hrOrgUnitName, String valueType, double lastTimes) {
        HashMap result;
        String personid = (String)paramMap.get(mainTableName.toUpperCase(Locale.ENGLISH) + "_FPERSONID");
        String tempMapKey = "CmpAdjRecordCalFunctionService_getHisAdjSalaryRecord_" + cmpItemName + "_" + hrOrgUnitName + "_" + lastTimes;
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initHisAdjSalaryRecord(ctx, mainTableName, cmpItemName, hrOrgUnitName, lastTimes, mainTableRowFilter));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((result = (HashMap)tempMap.get(tempMapKey)).containsKey(personid)) {
            Map perPersonMap = (Map)result.get(personid);
            return (String)perPersonMap.get(valueType);
        }
        return "";
    }

    private Map<String, Map<String, String>> initHisAdjSalaryRecord(Context ctx, String mainTableName, String cmpItemName, String hrOrgUnitName, double lastTimes, String mainTableRowFilter) throws Exception {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" /*dialect*/ SELECT t1.* FROM ( ");
        sqlBuffer.append(" SELECT t.*, row_number() over(partition by t.personid order by t.effectDay desc) rn FROM  ");
        sqlBuffer.append(" ( ");
        sqlBuffer.append(" select adj.fpersonid personID,adj.fmoney money,le.floatRate floatRate,adj.feffectday effectDay,  ");
        sqlBuffer.append(" std.fname_").append(language).append(" stdName,le.fname_").append(language).append(" levelName,po.fname_").append(language).append(" pointName,sc.fname_").append(language).append(" scopeName ");
        sqlBuffer.append(" ,cu.fname_").append(language).append(" currencyName ");
        sqlBuffer.append(" from T_HR_SfixAdjustSalary adj ");
        sqlBuffer.append(" inner join T_HR_Sfixadjustpayhrrecord rec on adj.fid = rec.fsourceid ");
        sqlBuffer.append(" left join T_HR_SCmpStandard std on adj.fstandardid = std.fid ");
        sqlBuffer.append(" left join T_HR_SCmpStdLevel le on adj.fstdLevelId = le.fid ");
        sqlBuffer.append(" left join T_HR_SCmpStdPoint po on adj.fstdpointid = po.fid ");
        sqlBuffer.append(" left join T_HR_SCMPSTDSCOPE sc on adj.fstdscopeid = sc.fid ");
        sqlBuffer.append(" left join T_ORG_HRO hr on hr.FID = adj.FPAYHRORGUNITID ");
        sqlBuffer.append(" inner join  T_HR_SCmpItem item on adj.FCMPITEMID = item.FID  ");
        sqlBuffer.append(" inner join T_BD_currency cu on adj.fcurrencyid =cu.fid ");
        sqlBuffer.append(" where item.fname_").append(language).append(" = '").append(cmpItemName).append("' ");
        if (!StringUtils.isEmpty((CharSequence)hrOrgUnitName)) {
            sqlBuffer.append(" and (hr.fname_").append(language).append(" = '").append(hrOrgUnitName).append("' ");
            sqlBuffer.append("      or adj.FPAYHRORGUNITID").append(" is null )");
        }
        sqlBuffer.append(" and adj.fpersonid in ( select fpersonid from ").append(mainTableName).append(" where fid in (").append(mainTableRowFilter).append("))");
        sqlBuffer.append(" )t)t1 ");
        sqlBuffer.append(" where t1.rn = ").append(Math.abs(lastTimes) + 1.0);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (executeQuery == null || executeQuery.size() < 1) {
            return result;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        while (executeQuery.next()) {
            HashMap<String, String> perPersonMap = new HashMap<String, String>();
            perPersonMap.put(ADJ_MONEY_STR, executeQuery.getString("money"));
            perPersonMap.put(ADJ_STD_STR, executeQuery.getString("stdName"));
            perPersonMap.put(ADJ_STD_LEVEL_STR, executeQuery.getString("levelName"));
            perPersonMap.put(ADJ_STD_POINT_STR, executeQuery.getString("pointName"));
            perPersonMap.put(ADJ_STD_SCOPE_STR, executeQuery.getString("scopeName"));
            perPersonMap.put(ADJ_STD_FLOAT_STR, executeQuery.getString("floatRate"));
            perPersonMap.put(ADJ_CURRENCY_STR, executeQuery.getString("currencyName"));
            perPersonMap.put(ADJ_EFFECTDAY_STR, dateFormat.format(executeQuery.getDate("effectDay")));
            result.put(executeQuery.getString("personID"), perPersonMap);
        }
        return result;
    }
}

