/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.exception.AdjustBillException;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustEntryUtils;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.budget.dto.BudgetCalculateOuterData;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.SalaryCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalayCalculatorMgr2;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetAdjustCalculateHelper {
    private static final Logger logger = Logger.getLogger(BudgetAdjustCalculateHelper.class);
    private final Context ctx;
    private final String budgetSchemeId;
    private String budgetTemplateID = "";
    private final String condition;
    private Map<String, Object> subItemIdMap = null;
    private List<String> fieldSnList = null;
    private List<Object[]> assignDefaultParams = null;
    private Map<String, Integer> itemDataTypeMap = null;
    private BudgetCalculateOuterData calculateOuterData = null;
    private final CmpBudgetSchemeInfo schemeInfo;
    protected BudgetAdjustService service = new BudgetAdjustService();

    public BudgetAdjustCalculateHelper(Context ctx, String budgetSchemeId, String condition) throws EASBizException, BOSException, SQLException {
        this.ctx = ctx;
        this.budgetSchemeId = budgetSchemeId;
        this.condition = condition;
        this.schemeInfo = this.service.getSchemeInfo(ctx, budgetSchemeId);
        this.initBudgeTemplateID();
        this.initBudgetSchemeData();
    }

    public Map<String, Object> calculate() throws BOSException, SQLException, EASBizException {
        BaseFormulaCollection formulaCollection = this.initCalFormula();
        BaseFormulaCollection validateCol = new BaseFormulaCollection();
        if ((validateCol = this.addVerificationRule(this.ctx, this.budgetSchemeId, validateCol)).isEmpty()) {
            this.setForwarnContentNull();
        }
        formulaCollection.addCollection(validateCol);
        Sheet calResult = this.post(formulaCollection, false);
        this.updateSubEntryData(calResult);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", calResult);
        return resultMap;
    }

    public void setForwarnContentNull() throws BOSException {
        String updateSql = "update T_HR_SBudgetAdjustEntry set ForwarnContent=null where fid in (" + this.condition + ")";
        DbUtil.execute((Context)this.ctx, (String)updateSql);
    }

    public void assembleOuterData(String billId) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)billId) || this.schemeInfo == null || this.fieldSnList == null || this.fieldSnList.isEmpty() || this.itemDataTypeMap == null) {
            return;
        }
        BudgetAdjustEntryCollection entryCol = BudgetAdjustSqlUtils.queryAndAssembleEntryColByBill(this.ctx, billId, this.fieldSnList, this.itemDataTypeMap);
        if (entryCol == null || entryCol.isEmpty()) {
            return;
        }
        this.calculateOuterData = new BudgetCalculateOuterData(this.schemeInfo.getBudgetYear());
        HashMap<String, Map<String, Object>> outerData = new HashMap<String, Map<String, Object>>();
        ArrayList<String> costTypes = new ArrayList<String>();
        ArrayList<String> adminOrgUnitIds = new ArrayList<String>();
        ArrayList<String> updateIds = new ArrayList<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getId() == null || entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null) continue;
            String id = entryInfo.getId().toString();
            String adminId = entryInfo.getAdminOrgUnit().getId().toString();
            String costTypeId = entryInfo.getCostType().getId().toString();
            HashMap<String, Object> entryData = new HashMap<String, Object>();
            entryData.put("isNew", false);
            entryData.put("ADMINORGUNIT.FID", adminId);
            entryData.put("COSTTYPE.FID", costTypeId);
            for (String fieldSn : this.fieldSnList) {
                entryData.put("M" + fieldSn, entryInfo.get("M" + fieldSn));
            }
            outerData.put(id, entryData);
            updateIds.add(id);
            adminOrgUnitIds.add(adminId);
            costTypes.add(costTypeId);
        }
        this.calculateOuterData.setUpdateIds(updateIds);
        this.calculateOuterData.setCostTypes(costTypes);
        this.calculateOuterData.setBudgetSchemeId(this.schemeInfo.getId().toString());
        this.calculateOuterData.setAdminOrgUnitIds(adminOrgUnitIds);
        this.calculateOuterData.setData(outerData);
    }

    public BaseFormulaCollection addVerificationRule(Context ctx, String calSchemeID, BaseFormulaCollection realFormulaColl) throws BOSException {
        StringBuilder sqlBuffer = new StringBuilder();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT D.FID,B.FNAME_").append(language).append(" NAME,D.FEXPRESS,D.FBIGEXPRESS,D.FLISTITEM,D.FLISTFUNC,D.FLISTVAR ");
        sqlBuffer.append(" FROM T_HR_SBudgetTempVeriRule A ");
        sqlBuffer.append(" INNER JOIN T_HR_SVERIFICATIONRULE B ON A.FVERIFICATIONRULEID = B.FID ");
        sqlBuffer.append(" INNER JOIN T_HR_SBUSINESSRELATIONCONFIG C ON B.FID = C.FBUSINESSID ");
        sqlBuffer.append(" INNER JOIN T_HR_SBASEFORMULA D ON D.FBUSINESSRELATIONCONFIGID = C.FID ");
        sqlBuffer.append(" WHERE A.FBudgetTemplateID = '").append(this.budgetTemplateID).append("' ");
        sqlBuffer.append(" ORDER BY A.FSORTCODE ");
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sqlBuffer.toString());
        StringBuilder expressBuf = new StringBuilder();
        expressBuf.append("T_HR_SBudgetAdjustEntry_forwarncontent = \"\" ");
        StringBuilder listVarBuf = new StringBuilder();
        int index = 0;
        int size = rowSet.size();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                String name = rowSet.getString("NAME");
                String express = rowSet.getString("FEXPRESS");
                String bigExpress = rowSet.getString("FBIGEXPRESS");
                String listItem = rowSet.getString("FLISTITEM");
                String listFunc = rowSet.getString("FLISTFUNC");
                String listVar = rowSet.getString("FLISTVAR");
                BaseFormulaInfo verificationRule = new BaseFormulaInfo();
                verificationRule.setId(BOSUuid.read((String)id));
                verificationRule.setName(name);
                verificationRule.setExpress(express);
                verificationRule.setBigExpress(bigExpress);
                verificationRule.setListItem(listItem);
                verificationRule.setListFunc(listFunc);
                verificationRule.setListVar(listVar);
                String var = listVar.split("~")[2].substring(1);
                expressBuf.append(" + (\"\".equals(").append(var).append(") ? \"\" : (").append(var);
                if (index < size - 1) {
                    expressBuf.append(" + \";\"");
                }
                expressBuf.append("))");
                listVarBuf.append(";").append(listVar);
                ++index;
                this.replaceVerificationRule(verificationRule);
                realFormulaColl.add(verificationRule);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (realFormulaColl.isEmpty()) {
            return realFormulaColl;
        }
        BaseFormulaInfo verificationRule = new BaseFormulaInfo();
        verificationRule.setName(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label24", (Locale)ctx.getLocale()));
        verificationRule.setCalItem("forwarncontent");
        verificationRule.setListItem("String~T_HR_SBudgetAdjustEntry~forwarncontent");
        if (index > 0) {
            verificationRule.setListVar(listVarBuf.toString().replaceFirst(";", ""));
        }
        expressBuf.append(";");
        verificationRule.setExpress(expressBuf.toString());
        realFormulaColl.add(verificationRule);
        return realFormulaColl;
    }

    public void updateSubEntryData(Sheet calResult) throws BOSException {
        if (calResult == null) {
            return;
        }
        List changeDataList = calResult.getChangeDataList();
        if (changeDataList == null || changeDataList.isEmpty()) {
            return;
        }
        ArrayList<Object[]> batchUpdateSubEntryParams = new ArrayList<Object[]>();
        this.assignDefaultParams = new ArrayList<Object[]>();
        String updateSql = "update t_hr_SSubBudgetAdjustEntry set FAdjustYearBudget = ? where FYearBudgetEntryID = ? and FBudgetItemID = ?";
        for (Row row : changeDataList) {
            List cells = row.getCells();
            if (cells == null || cells.isEmpty()) continue;
            for (Cell cell : cells) {
                Object itemIdObject;
                ArrayList<Object> updateSubEntryParam = new ArrayList<Object>();
                String column = cell.getColumn();
                if (StringUtils.isEmpty((CharSequence)column) || !column.startsWith("M") || (itemIdObject = this.subItemIdMap.get(column.replace("M", ""))) == null || StringUtils.isEmpty((CharSequence)itemIdObject.toString())) continue;
                String value = cell.getValue();
                if (CmpStrUtil.isNumber(value)) {
                    value = CmpStrUtil.subZeroAndDot(value);
                    Pattern pattern = Pattern.compile("^-?[0-9]{1,10}([.][0-9]{0,10})?$");
                    Matcher matcher = pattern.matcher(value);
                    if (!matcher.matches()) {
                        throw new BOSException(BudgetAdjustEntryUtils.getMultiLan("label2", this.ctx));
                    }
                    updateSubEntryParam.add(new BigDecimal(value).setScale(2, RoundingMode.HALF_UP));
                } else {
                    updateSubEntryParam.add(value);
                }
                updateSubEntryParam.add(row.getFID());
                updateSubEntryParam.add(itemIdObject);
                batchUpdateSubEntryParams.add(updateSubEntryParam.toArray());
                ArrayList<Object> assignDefaultParam = new ArrayList<Object>();
                assignDefaultParam.add(row.getFID());
                assignDefaultParam.add(itemIdObject);
                this.assignDefaultParams.add(assignDefaultParam.toArray());
            }
        }
        if (!batchUpdateSubEntryParams.isEmpty()) {
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, batchUpdateSubEntryParams);
        }
    }

    public BaseFormulaCollection initCalFormula() throws AdjustBillException {
        BaseFormulaCollection formulaCollection;
        BaseFormulaCollection realFormulaColl = new BaseFormulaCollection();
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(" select id,name,calItem,express,listItem,listFunc,listVar,listTable,sortSn,bigExpress ");
        sqlBuffer.append(" where isCal = 1 and businessRelationConfig.businessId = '").append(this.budgetTemplateID).append("'");
        sqlBuffer.append(" order by sortSn");
        try {
            formulaCollection = BaseFormulaFactory.getLocalInstance((Context)this.ctx).getBaseFormulaCollection(sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new AdjustBillException(AdjustBillException.GETFORMULAERR, (Throwable)e);
        }
        int size = formulaCollection.size();
        for (int i = 0; i < size; ++i) {
            BaseFormulaInfo verificationRule = formulaCollection.get(i);
            this.replaceVerificationRule(verificationRule);
            realFormulaColl.add(verificationRule);
        }
        return realFormulaColl;
    }

    public void replaceVerificationRule(BaseFormulaInfo verificationRule) {
        String express = verificationRule.getExpress();
        String bigExpress = verificationRule.getBigExpress();
        String listItem = verificationRule.getListItem();
        if (StringUtils.isEmpty((CharSequence)express)) {
            express = "";
        }
        if (StringUtils.isEmpty((CharSequence)bigExpress)) {
            bigExpress = "";
        }
        if (StringUtils.isEmpty((CharSequence)listItem)) {
            listItem = "";
        }
        for (String fieldSn : this.fieldSnList) {
            express = express.replace("T" + fieldSn, "M" + fieldSn);
            bigExpress = bigExpress.replace("T" + fieldSn, "M" + fieldSn);
            listItem = listItem.replace("T" + fieldSn, "M" + fieldSn);
        }
        express = express.replace("T_HR_SBudgetManage", "T_HR_SBudgetAdjustEntry");
        bigExpress = bigExpress.replace("T_HR_SBudgetManage", "T_HR_SBudgetAdjustEntry");
        listItem = listItem.replace("T_HR_SBudgetManage", "T_HR_SBudgetAdjustEntry");
        verificationRule.setExpress(express);
        verificationRule.setBigExpress(bigExpress);
        verificationRule.setListItem(listItem);
    }

    public boolean initBudgetSchemeData() throws BOSException {
        BudgetAdjustService service = new BudgetAdjustService();
        BudgetItemMapInfo itemMap = service.getItemMapByScheme(this.ctx, this.budgetSchemeId);
        this.subItemIdMap = itemMap.getSubItemIdMap();
        this.itemDataTypeMap = itemMap.getItemDataTypeMap();
        List<String> fieldSnList = itemMap.getFieldSnList();
        fieldSnList.sort((fieldSn0, fieldSn1) -> fieldSn1.length() - fieldSn0.length());
        this.fieldSnList = fieldSnList;
        return true;
    }

    public void initBudgeTemplateID() throws BOSException, SQLException {
        String querySql = "select FTemplateID from T_HR_SCmpBudgetScheme where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)querySql, (Object[])new Object[]{this.budgetSchemeId});
        if (rs.next()) {
            this.budgetTemplateID = rs.getString("FTemplateID");
            if (StringUtils.isEmpty((CharSequence)this.budgetTemplateID)) {
                throw new BOSException("budgetTemplateID is null");
            }
        }
    }

    public Sheet post(BaseFormulaCollection formulaCollection, boolean isContainsVerification) throws BOSException, EASBizException {
        if (null == formulaCollection || formulaCollection.size() == 0) {
            return null;
        }
        SalaryCalculator2 cal = new SalaryCalculator2();
        SalayCalculatorMgr2.addTask((SalaryCalculator2)cal);
        String uid = cal.getUID();
        SalaryCalculatorProxy2 cal2 = new SalaryCalculatorProxy2(uid, true);
        cal2.setMainTableName("T_HR_SBudgetAdjustEntry");
        cal2.setMainTableAlias("budgetAdjEntry");
        cal2.setCalCategoryNum("CMP_BudgetAdjust_001");
        cal2.setSchemeID(this.budgetSchemeId);
        cal2.setCtx(this.ctx);
        cal2.setEndDate(new Date());
        cal2.setCalFormulaColl(formulaCollection);
        cal2.setMainTableRowFilter(this.condition);
        cal2.setOuterData((Object)this.calculateOuterData);
        cal2.setContainsVerification(isContainsVerification);
        try {
            cal2.post();
        }
        catch (Exception e) {
            logger.error((Object)("cal2.post:" + e.getMessage()), (Throwable)e);
        }
        return cal2.getCalResult();
    }

    public SubBudgetAdjustEntryCollection getAssignDefaultAfterUpdateSubEntryData(String billId, CmpBudgetSchemeInfo schemeInfo, List<String> periodColNames, List<String> periodFields, Map<String, Object> subBudgetAssignMap) throws BOSException, SQLException {
        if (schemeInfo == null || this.assignDefaultParams == null || this.assignDefaultParams.isEmpty() || periodColNames == null || periodColNames.isEmpty() || periodFields == null || periodFields.isEmpty()) {
            return null;
        }
        String createTempTable = BudgetAdjustSqlUtils.createTempTable(this.ctx, "T_HR_SSubBudgetAdjustEntry", "FYearBudgetEntryID,FBudgetItemID", this.assignDefaultParams);
        String filterSql = "inner join " + createTempTable + " temp1 on subentry.FYearBudgetEntryID=temp1.FYearBudgetEntryID and subentry.FBudgetItemID=temp1.FBudgetItemID where subentry.FBillId = ?";
        SubBudgetAdjustEntryCollection subCol = BudgetAdjustSqlUtils.queryAndAssembleSubEntryColByBill(this.ctx, billId, periodColNames, periodFields, filterSql);
        if (subCol != null && !subCol.isEmpty()) {
            for (int i = 0; i < subCol.size(); ++i) {
                SubBudgetAdjustEntryInfo subEntry = subCol.get(i);
                BudgetAdjustSqlUtils.subEntryAssignDefault(subEntry, schemeInfo, periodColNames, subBudgetAssignMap);
            }
        }
        return subCol;
    }
}

