/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calclute.job;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public final class CmpCalcluteJobHelper {
    private CmpCalcluteJobHelper() {
    }

    public static JobConfig assembleDefaultJobConfig(Context ctx) {
        return null;
    }

    public static String createJobProcessDef(Context ctx, String jobTitle, Map<String, Object> jobContext) throws HRCommonException {
        IEnactmentService service = CmpCalcluteJobHelper.getEnactmentServiceInstance(ctx);
        FunctionObjectInfo function = CmpCalcluteJobHelper.getFunctionObjectInfo(ctx);
        OperationInfo operation = CmpCalcluteJobHelper.getCmpCalFunOperationInfo(function);
        Date date = new Date();
        String scheduale = CmpCalcluteJobHelper.getSchedule(date);
        Locale locale = ctx.getLocale();
        String jobProcessDefId = "";
        try {
            jobProcessDefId = service.createJobProcessDef(jobTitle, function, operation, jobContext, scheduale, locale);
        }
        catch (WfException e) {
            e.printStackTrace();
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{e.getMessage()});
        }
        CmpCalcluteJobHelper.updateBackJobDefByDefId(ctx, jobProcessDefId);
        return jobProcessDefId;
    }

    public static void updateBackJobDefByDefId(Context ctx, String jobProcessDefId) {
        String fcreateUserID = null;
        if (ctx.getCaller() != null) {
            fcreateUserID = ctx.getCaller().toString();
        }
        if (fcreateUserID != null) {
            try {
                String sql = " update  T_JOB_DEF  set fcreateUserID = '" + fcreateUserID + "'  where  fjobdefid = '" + jobProcessDefId + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static OperationInfo getCmpCalFunOperationInfo(FunctionObjectInfo function) {
        OperationInfo operation = function.getOperation().get(0);
        return operation;
    }

    private static FunctionObjectInfo getFunctionObjectInfo(Context ctx) {
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)new MetaDataPK("com.kingdee.shr.compensation.CmpCalcluteJobFunction"));
        return function;
    }

    public static IEnactmentService getEnactmentServiceInstance(Context ctx) {
        try {
            return new EnactmentServiceProxy(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getSchedule(Date date) {
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(date);
        define.setEndTime(date);
        define.setUseCalendar(false);
        define.setInstructionType(1);
        define.setDefine(CmpCalcluteJobHelper.getScheduleDate(date));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private static String getScheduleDate(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }
}

