/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.combine.calData;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.calculate.combine.calData.EnumNameAndValueMap;
import com.kingdee.shr.compensation.calculate.helper.CallculateCacheTool;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpQueryConfigEmunService {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.combine.calData.CmpQueryConfigEmunService");
    private static final String CMP_ENUM_KEY = "CMP_QUERY_CONFIG_ENUM";

    public static Map<String, EnumNameAndValueMap> getEnumProperty(Context ctx) throws BOSException {
        Object data = CallculateCacheTool.getFromCache(CMP_ENUM_KEY);
        if (null != data) {
            return (Map)data;
        }
        HashMap<String, EnumNameAndValueMap> map = new HashMap<String, EnumNameAndValueMap>();
        CmpQueryConfigCollection coll = null;
        try {
            coll = CmpQueryConfigFactory.getLocalInstance(ctx).getCmpQueryConfigCollection("select structure.* ");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < coll.size(); ++i) {
            EntityObjectInfo entityInfo;
            if (null == coll.get(i).getStructure()) continue;
            String entityName = coll.get(i).getStructure().getEntityName();
            String clientNumber = coll.get(i).getStructure().getClientNumber().toUpperCase();
            if (CmpStrUtil.isEmpty(entityName) || (entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName))) == null || entityInfo.getProperties() == null) continue;
            PropertyCollection properties = entityInfo.getProperties();
            for (int k = 0; k < properties.size(); ++k) {
                String dataType;
                PropertyInfo propertyInfo = properties.get(k);
                IStateManager stateManager = propertyInfo.getStateManager();
                if (null == stateManager.getStateValue("dataType") || !"Enum".equalsIgnoreCase(dataType = stateManager.getStateValue("dataType").toString())) continue;
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)dataRef));
                BizEnumValueCollection enumValueColl = enumInfo.getEnumValue();
                EnumNameAndValueMap emuMap = new EnumNameAndValueMap(enumValueColl);
                map.put((clientNumber + "_" + propertyInfo.getMappingField().getName()).toUpperCase(), emuMap);
            }
        }
        CallculateCacheTool.addToCache(map, CMP_ENUM_KEY);
        return map;
    }
}

