/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.combine.calData;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.IStructureConfig;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.compensation.calculate.helper.CallculateCacheTool;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpQueryConfigService {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.combine.calData.CmpQueryConfigService");
    private static final String CMP_STRUCTURE_OO2_PROPRETIES_KEY = "CMP_STRUCTURE_OO2_PROPRETIES_KEY";
    private static final String CMP_STRUCTURE_OO2_TABLE = "CMP_STRUCTURE_OO2_TABLE";

    public static Map<String, Map<String, PropertyInfo>> getCalProperties(Context ctx) throws BOSException {
        Object data = CallculateCacheTool.getFromCache(CMP_STRUCTURE_OO2_PROPRETIES_KEY);
        if (null != data) {
            return (Map)data;
        }
        HashMap<String, Map<String, PropertyInfo>> map = new HashMap<String, Map<String, PropertyInfo>>();
        String oql = "SELECT ID,CLIENTNUMBER,NAME,ENTITYNAME WHERE SCHEME.NUMBER='002'";
        IStructureConfig structureConfig = StructureConfigFactory.getLocalInstance((Context)ctx);
        StructureConfigCollection coll = structureConfig.getStructureConfigCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            map.put(coll.get(i).getClientNumber().toUpperCase(), CmpQueryConfigService.getProperties(ctx, coll.get(i).getEntityName()));
        }
        CallculateCacheTool.addToCache(map, CMP_STRUCTURE_OO2_PROPRETIES_KEY);
        return map;
    }

    public static Map<String, String> getClientAndTableMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        Object data = CallculateCacheTool.getFromCache(CMP_STRUCTURE_OO2_TABLE);
        if (null != data) {
            return (Map)data;
        }
        StringBuilder str = new StringBuilder();
        str.append(" SELECT QU.FTABLENAME, CO.FCLIENTNUMBER, CO.FENTITYNAME ");
        str.append(" FROM T_HR_SCMPQUERYCONFIG QU ");
        str.append(" INNER JOIN T_HR_STRUCTURECONFIG CO ON QU.FSTRUCTUREID = CO.FID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString("FCLIENTNUMBER").toUpperCase(), rowSet.getString("FTABLENAME").toUpperCase());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        CallculateCacheTool.addToCache(map, CMP_STRUCTURE_OO2_TABLE);
        return map;
    }

    private static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        String tableField = "";
        ColumnInfo column = null;
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            column = propertyInfo.getMappingField();
            if (column == null || !(propertyInfo instanceof OwnPropertyInfo)) continue;
            tableField = column.getName().toUpperCase();
            if (((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                map.put(tableField, propertyInfo);
                map.put(tableField + "_L1", propertyInfo);
                map.put(tableField + "_L2", propertyInfo);
                map.put(tableField + "_L3", propertyInfo);
            } else {
                map.put(tableField, propertyInfo);
            }
            map.put(propertyInfo.getName().toUpperCase(), propertyInfo);
        }
        return map;
    }
}

