/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.currency;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpExchangeRuleEnum;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class CurrencyUtil {
    public static Date getEffdtByExchangeRule(CmpExchangeRuleEnum ruleEnum, Date effdt, Date leffdt) {
        Calendar calendar = Calendar.getInstance();
        if (ruleEnum.equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN)) {
            calendar.setTime(effdt);
        } else {
            calendar.setTime(leffdt);
        }
        return calendar.getTime();
    }

    public static ExchangeRateCollection getExchangeRate(Context ctx, String tableId, String sourceCurrencyId, Date effdt) throws BOSException {
        ExchangeRateCollection coll = new ExchangeRateCollection();
        String ksqlDate = CmpDateUtil.toKSqlDate(effdt);
        String str = " SELECT RATE.FAVAILTIME, RATE.FINVALIDTIME, RATE.FCONVERTRATE, AUX.FPRECISION, AUX.FEXCHANGERATETYPE, AUX.FSOURCECURRENCYID, AUX.FTARGETCURRENCYID FROM T_BD_EXCHANGERATE RATE  INNER JOIN T_BD_EXCHANGEAUX AUX ON RATE.FEXCHANGEAUXID = AUX.FID  WHERE AUX.FEXCHANGETABLEID = '" + tableId + "'  AND AUX.FSOURCECURRENCYID = '" + sourceCurrencyId + "'  AND RATE.FAVAILTIME <= " + ksqlDate + " AND RATE.FINVALIDTIME >= " + ksqlDate;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            while (rowSet.next()) {
                ExchangeRateInfo info = new ExchangeRateInfo();
                ExchangeAuxInfo auxInfo = new ExchangeAuxInfo();
                info.setAvailTime((Date)rowSet.getDate("FAVAILTIME"));
                info.setInvalidTime((Date)rowSet.getDate("FINVALIDTIME"));
                info.setConvertRate(rowSet.getBigDecimal("FCONVERTRATE"));
                auxInfo.setPrecision(rowSet.getInt("FPRECISION"));
                auxInfo.setExchangeRateType(ExchangeTypeEnum.getEnum((int)rowSet.getInt("FEXCHANGERATETYPE")));
                CurrencyInfo sourceCurrencyInfo = new CurrencyInfo();
                sourceCurrencyInfo.setId(BOSUuid.read((String)rowSet.getString("FSOURCECURRENCYID")));
                auxInfo.setSourceCurrency(sourceCurrencyInfo);
                CurrencyInfo targetCurrencyInfo = new CurrencyInfo();
                targetCurrencyInfo.setId(BOSUuid.read((String)rowSet.getString("FTARGETCURRENCYID")));
                auxInfo.setTargetCurrency(targetCurrencyInfo);
                info.setExchangeAux(auxInfo);
                coll.add(info);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return coll;
    }

    public static ExchangeRateCollection getTargetExchangeRate(Context ctx, String tableId, String targetCurrencyId, Date effdt) throws BOSException {
        ExchangeRateCollection coll = new ExchangeRateCollection();
        String ksqlDate = CmpDateUtil.toKSqlDate(effdt);
        String str = " SELECT RATE.FAVAILTIME, RATE.FINVALIDTIME, RATE.FCONVERTRATE, AUX.FPRECISION, AUX.FEXCHANGERATETYPE, AUX.FSOURCECURRENCYID, AUX.FTARGETCURRENCYID FROM T_BD_EXCHANGERATE RATE  INNER JOIN T_BD_EXCHANGEAUX AUX ON RATE.FEXCHANGEAUXID = AUX.FID  WHERE AUX.FEXCHANGETABLEID = '" + tableId + "'  AND AUX.FTARGETCURRENCYID = '" + targetCurrencyId + "'  AND RATE.FAVAILTIME <= " + ksqlDate + " AND RATE.FINVALIDTIME >= " + ksqlDate;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            while (rowSet.next()) {
                ExchangeRateInfo info = new ExchangeRateInfo();
                ExchangeAuxInfo auxInfo = new ExchangeAuxInfo();
                info.setAvailTime((Date)rowSet.getDate("FAVAILTIME"));
                info.setInvalidTime((Date)rowSet.getDate("FINVALIDTIME"));
                info.setConvertRate(rowSet.getBigDecimal("FCONVERTRATE"));
                auxInfo.setPrecision(rowSet.getInt("FPRECISION"));
                auxInfo.setExchangeRateType(ExchangeTypeEnum.getEnum((int)rowSet.getInt("FEXCHANGERATETYPE")));
                CurrencyInfo sourceCurrencyInfo = new CurrencyInfo();
                sourceCurrencyInfo.setId(BOSUuid.read((String)rowSet.getString("FSOURCECURRENCYID")));
                auxInfo.setSourceCurrency(sourceCurrencyInfo);
                CurrencyInfo targetCurrencyInfo = new CurrencyInfo();
                targetCurrencyInfo.setId(BOSUuid.read((String)rowSet.getString("FTARGETCURRENCYID")));
                auxInfo.setTargetCurrency(targetCurrencyInfo);
                info.setExchangeAux(auxInfo);
                coll.add(info);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return coll;
    }

    public static Map<String, BigDecimal> getTargetExchangeRateMap(Context ctx, String tableId, String targetCurrencyId, Date effdt) throws BOSException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String ksqlDate = CmpDateUtil.toKSqlDate(effdt);
        String str = " SELECT RATE.FAVAILTIME, RATE.FINVALIDTIME, RATE.FCONVERTRATE, AUX.FPRECISION, AUX.FEXCHANGERATETYPE, AUX.FSOURCECURRENCYID, AUX.FTARGETCURRENCYID FROM T_BD_EXCHANGERATE RATE  INNER JOIN T_BD_EXCHANGEAUX AUX ON RATE.FEXCHANGEAUXID = AUX.FID  WHERE AUX.FEXCHANGETABLEID = '" + tableId + "'  AND AUX.FTARGETCURRENCYID = '" + targetCurrencyId + "'  AND RATE.FAVAILTIME <= " + ksqlDate + " AND RATE.FINVALIDTIME >= " + ksqlDate;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString("FSOURCECURRENCYID"), rowSet.getBigDecimal("FCONVERTRATE"));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        map.put("getTargetExchangeRateMap", new BigDecimal(1));
        return map;
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, String tableId, String targetCurrencyId, String sourceCurrencyId, Date effdt) throws BOSException {
        ExchangeRateCollection coll = CurrencyUtil.getExchangeRate(ctx, tableId, sourceCurrencyId, effdt);
        if (coll.size() < 1) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            ExchangeRateInfo rateInfo = coll.get(i);
            if (!rateInfo.getTargetCurrency().getId().toString().equals(targetCurrencyId)) continue;
            return rateInfo;
        }
        return null;
    }

    public static BigDecimal getConvertRate(Context ctx, String tableId, String targetCurrencyId, String sourceCurrencyId, Date effdt) throws BOSException {
        ExchangeRateInfo info = CurrencyUtil.getExchangeRate(ctx, tableId, targetCurrencyId, sourceCurrencyId, effdt);
        if (null == info) {
            return new BigDecimal(1);
        }
        return info.getConvertRate();
    }

    public static ExchangeRateInfo getClosestCR(Context ctx, String tableId, String targetCurrencyId, String sourceCurrencyId, Date effdt) throws BOSException {
        ExchangeRateInfo info = null;
        if (StringUtils.equals((String)targetCurrencyId, (String)sourceCurrencyId)) {
            info = new ExchangeRateInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setAvailTime(new Date());
            info.setConvertRate(new BigDecimal(BigInteger.ONE));
            return info;
        }
        info = CurrencyUtil.getExchangeRate(ctx, tableId, targetCurrencyId, sourceCurrencyId, effdt);
        if (null == info) {
            CurrencyUtil.getClosestExchangeRate(ctx, tableId, targetCurrencyId, sourceCurrencyId, effdt);
        }
        if (null == info) {
            System.out.println("sourceCurrencyId\uff1a" + sourceCurrencyId + ",targetCurrencyId\uff1a" + targetCurrencyId + "can not get convertRate\uff01");
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitSchemeItemResource", (String)"label25", (Locale)ctx.getLocale()));
        }
        return info;
    }

    public static ExchangeRateInfo getClosestExchangeRate(Context ctx, String tableId, String targetCurrencyId, String sourceCurrencyId, Date effdt) throws BOSException {
        ExchangeRateInfo exchangeRateInfo = null;
        String ksqlDate = CmpDateUtil.toKSqlDate(effdt);
        String str = " SELECT TOP 1 RATE.FAVAILTIME, RATE.FINVALIDTIME, RATE.FCONVERTRATE, AUX.FPRECISION, AUX.FEXCHANGERATETYPE, AUX.FSOURCECURRENCYID, AUX.FTARGETCURRENCYID FROM T_BD_EXCHANGERATE RATE  INNER JOIN T_BD_EXCHANGEAUX AUX ON RATE.FEXCHANGEAUXID = AUX.FID  WHERE AUX.FEXCHANGETABLEID = '" + tableId + "'  AND AUX.FSOURCECURRENCYID = '" + sourceCurrencyId + "'  AND AUX.FTargetCurrencyID = '" + targetCurrencyId + "'  AND RATE.FAVAILTIME <= " + ksqlDate + " ORDER BY RATE.FAVAILTIME DESC ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            while (rowSet.next()) {
                exchangeRateInfo = new ExchangeRateInfo();
                ExchangeAuxInfo auxInfo = new ExchangeAuxInfo();
                exchangeRateInfo.setAvailTime((Date)rowSet.getDate("FAVAILTIME"));
                exchangeRateInfo.setInvalidTime((Date)rowSet.getDate("FINVALIDTIME"));
                exchangeRateInfo.setConvertRate(rowSet.getBigDecimal("FCONVERTRATE"));
                auxInfo.setPrecision(rowSet.getInt("FPRECISION"));
                auxInfo.setExchangeRateType(ExchangeTypeEnum.getEnum((int)rowSet.getInt("FEXCHANGERATETYPE")));
                CurrencyInfo sourceCurrencyInfo = new CurrencyInfo();
                sourceCurrencyInfo.setId(BOSUuid.read((String)rowSet.getString("FSOURCECURRENCYID")));
                auxInfo.setSourceCurrency(sourceCurrencyInfo);
                CurrencyInfo targetCurrencyInfo = new CurrencyInfo();
                targetCurrencyInfo.setId(BOSUuid.read((String)rowSet.getString("FTARGETCURRENCYID")));
                auxInfo.setTargetCurrency(targetCurrencyInfo);
                exchangeRateInfo.setExchangeAux(auxInfo);
            }
        }
        catch (SQLException e) {
            System.out.println("sourceCurrencyId\uff1a" + sourceCurrencyId + ",targetCurrencyId\uff1a" + targetCurrencyId + " exception occurred to the query\uff01");
            throw new BOSException(e.getMessage());
        }
        return exchangeRateInfo;
    }
}

