/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.AdminOrgUnitCostTypeBudgetAmountDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.AdminOrgUnitYearBudgetAmountDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetAmountDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemBoard;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemMappingDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetServiceParam;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.PeriodProp;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.YearPeriodProp;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.IBudgetDataServiceProcessor;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.util.BudgetAmountUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BaseBudgetDataServiceProcessor
implements IBudgetDataServiceProcessor {
    protected static final String BUDGET_TABLE_ALIAS = "budgetV";
    protected static final String STANDING_TABLE_ALIAS = "standingV";
    protected static final String YEAR_TAG = "YEAR";
    protected BudgetServiceParam budgetServiceParam;
    protected List<BudgetItemMappingDTO> budgetItemMappingDTOList;
    protected Context ctx;
    protected int realYear;

    public BaseBudgetDataServiceProcessor(Context ctx, BudgetServiceParam budgetServiceParam) throws BOSException {
        this.ctx = ctx;
        this.budgetServiceParam = budgetServiceParam;
        this.budgetItemMappingDTOList = this.initBudgetItemConfig();
        this.yearCalibration();
    }

    private void yearCalibration() throws BOSException {
        try {
            this.realYear = BudgetAmountUtil.templateYearCalibration(this.ctx, this.budgetServiceParam.getTemplateInfo().getId().toString(), this.budgetServiceParam.getYear());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<BudgetItemMappingDTO> getBudgetItemConfig() {
        return this.budgetItemMappingDTOList;
    }

    protected List<BudgetItemMappingDTO> initBudgetItemConfig() throws BOSException {
        HashMap<String, BudgetItemMappingDTO> budgetItemConfig = new HashMap<String, BudgetItemMappingDTO>();
        String l = LocaleUtils.getShortCode((Locale)this.ctx.getLocale());
        String sql = "select distinct cbi.fid as budgetItemId,cbi.fName_" + l + " as budgetItemName,cbi.fieldsn as budgetItemSn, balanceItem.fid as balanceItemId,balanceItem.fname_" + l + " as balanceItemName,balanceItem.fieldSn as balanceItemSn , btpi.FSortSn,cbi.fnumber from T_HR_SSchemeDeduConfig sdc inner join( select FCalSubmitSchemeID,FCalSubmitItemID,FCmpBudgetItemID,min(FDeduNode) as FDeduNode from T_HR_SSchemeDeduConfig group by FCalSubmitSchemeID,FCalSubmitItemID,FCmpBudgetItemID) tempdc on sdc.FCalSubmitSchemeID = tempdc.FCalSubmitSchemeID  and sdc.FCalSubmitItemID = tempdc.FCalSubmitItemID  and sdc.FCmpBudgetItemID = tempdc.FCmpBudgetItemID and sdc.FDeduNode = tempdc.FDeduNode inner join T_HR_SBudgetTemplateSTBItem btstb on sdc.FTemplateStbItemID = btstb.fid inner join T_HR_SCmpBudgetItem cbi on sdc.FCmpBudgetItemID = cbi.fid inner join T_HR_SStandingBookItem balanceItem on btstb.FBalanceLedgerItemID = balanceItem.fid inner join T_HR_SBudgetTemplate btp on btstb.FTemplateID = btp.fid inner join T_HR_SBudgetTemplateItem btpi on btpi.FTemplateID = btp.fid and btpi.FBudgetItemID = cbi.fid where btstb.FTemplateID = ? order by btpi.FSortSn ,cbi.fnumber";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{this.budgetServiceParam.getTemplateInfo().getId().toString()});
            while (rs.next()) {
                BudgetItemDTO balanceItem;
                String budgetItemId = rs.getString("budgetItemId");
                BudgetItemMappingDTO budgetItemMappingDTO = (BudgetItemMappingDTO)budgetItemConfig.get(budgetItemId);
                if (budgetItemMappingDTO == null) {
                    budgetItemMappingDTO = new BudgetItemMappingDTO(new BudgetItemDTO(budgetItemId, rs.getInt("budgetItemSn"), rs.getString("budgetItemName")));
                    budgetItemConfig.put(budgetItemId, budgetItemMappingDTO);
                }
                if ((balanceItem = budgetItemMappingDTO.getBalanceItem()) != null) continue;
                budgetItemMappingDTO.setBalanceItem(new BudgetItemDTO(rs.getString("balanceItemId"), rs.getInt("balanceItemSn"), rs.getString("balanceItemName")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new ArrayList<BudgetItemMappingDTO>(budgetItemConfig.values());
    }

    @Override
    public List<YearPeriodProp> getPre3YearBudgetSumData() throws BOSException {
        if (this.realYear == -1) {
            this.realYear = this.budgetServiceParam.getYear();
        }
        BudgetTemplateInfo templateInfo = this.budgetServiceParam.getTemplateInfo();
        Map<String, String> propMap = this.initPeriodPropMap(this.ctx, templateInfo);
        String selector = this.assembleItemSelector();
        if (selector.isEmpty()) {
            return null;
        }
        boolean isYearType = templateInfo.getBudgetPeriod() == BudgetPeriodEnum.YEAR;
        int perYearRange = 3;
        int cycleParamCount = 2;
        HashMap<Integer, String> timeMap = new HashMap<Integer, String>();
        HashMap<Integer, YearPeriodProp> yearPeriodPropMap = new HashMap<Integer, YearPeriodProp>();
        for (int i = 0; i < perYearRange; ++i) {
            int year = this.budgetServiceParam.getYear() - i;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, year);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timeMap.put(year, CmpDateUtil.toSimpleKSqlData(calendar.getTime()));
            YearPeriodProp yearPeriodProp = new YearPeriodProp(year);
            propMap.forEach((key, value) -> yearPeriodProp.putIntoTag_periodPropMap((String)key, new PeriodProp((String)key, (String)value)));
            yearPeriodPropMap.put(year, yearPeriodProp);
        }
        String sql = this.getPer3YearSql(selector, timeMap);
        Object[] param = new Object[perYearRange * cycleParamCount];
        for (int i = 0; i < perYearRange; ++i) {
            param[i * cycleParamCount] = templateInfo.getId().toString();
            param[i * cycleParamCount + 1] = this.budgetServiceParam.getAdminOrg().getLongNumber() + "!%";
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])param);
            while (rs.next()) {
                PeriodProp budgetAmountDTO;
                int budgetYear = rs.getInt("budgetYear");
                YearPeriodProp yearPeriodProp = (YearPeriodProp)yearPeriodPropMap.get(budgetYear);
                assert (yearPeriodProp != null);
                if (isYearType) {
                    PeriodProp periodProp = yearPeriodProp.getPeriodPropMap().get(YEAR_TAG);
                    if (periodProp == null) {
                        periodProp = yearPeriodProp.getTag_periodPropMap().get(YEAR_TAG);
                        yearPeriodProp.getPeriodPropMap().put(YEAR_TAG, periodProp);
                    }
                    budgetAmountDTO = periodProp;
                } else {
                    String period = rs.getString("FPeriod");
                    PeriodProp periodProp = yearPeriodProp.getPeriodPropMap().get(period);
                    if (periodProp == null) {
                        for (String tag : propMap.keySet()) {
                            if (!period.endsWith(tag)) continue;
                            periodProp = yearPeriodProp.getTag_periodPropMap().get(tag);
                            periodProp.setPeriod(period);
                            break;
                        }
                        yearPeriodProp.getPeriodPropMap().put(period, periodProp);
                    }
                    budgetAmountDTO = periodProp;
                }
                if (budgetAmountDTO == null) continue;
                this.fillBudgetAmount(budgetAmountDTO, rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new ArrayList<YearPeriodProp>(yearPeriodPropMap.values());
    }

    private Map<String, String> initPeriodPropMap(Context ctx, BudgetTemplateInfo templateInfo) {
        HashMap<String, String> tagAlias = new HashMap<String, String>();
        switch (templateInfo.getBudgetPeriod().getValue()) {
            case 0: {
                tagAlias.put(YEAR_TAG, EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label50", (Locale)ctx.getLocale()));
                break;
            }
            case 1: {
                tagAlias.put("H01", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label19", (Locale)ctx.getLocale()));
                tagAlias.put("H02", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label20", (Locale)ctx.getLocale()));
                break;
            }
            case 2: {
                tagAlias.put("Q01", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label21", (Locale)ctx.getLocale()));
                tagAlias.put("Q02", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label22", (Locale)ctx.getLocale()));
                tagAlias.put("Q03", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label23", (Locale)ctx.getLocale()));
                tagAlias.put("Q04", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label24", (Locale)ctx.getLocale()));
                break;
            }
            case 3: {
                tagAlias.put("M01", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label38", (Locale)ctx.getLocale()));
                tagAlias.put("M02", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label39", (Locale)ctx.getLocale()));
                tagAlias.put("M03", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label40", (Locale)ctx.getLocale()));
                tagAlias.put("M04", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label41", (Locale)ctx.getLocale()));
                tagAlias.put("M05", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label42", (Locale)ctx.getLocale()));
                tagAlias.put("M06", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label43", (Locale)ctx.getLocale()));
                tagAlias.put("M07", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label44", (Locale)ctx.getLocale()));
                tagAlias.put("M08", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label45", (Locale)ctx.getLocale()));
                tagAlias.put("M09", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label46", (Locale)ctx.getLocale()));
                tagAlias.put("M10", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label47", (Locale)ctx.getLocale()));
                tagAlias.put("M11", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label48", (Locale)ctx.getLocale()));
                tagAlias.put("M12", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label49", (Locale)ctx.getLocale()));
                break;
            }
        }
        return tagAlias;
    }

    @Override
    public Map<String, AdminOrgUnitYearBudgetAmountDTO> getAdminDetailData(AdminOrgUnitCollection childCollection, boolean needCostTypeDimension) throws BOSException {
        if (this.realYear == -1) {
            return null;
        }
        LinkedHashMap<String, AdminOrgUnitYearBudgetAmountDTO> budgetAmountDTOMap = new LinkedHashMap<String, AdminOrgUnitYearBudgetAmountDTO>();
        for (int i = 0; i < childCollection.size(); ++i) {
            AdminOrgUnitInfo adminOrgUnitInfo = childCollection.get(i);
            budgetAmountDTOMap.put(adminOrgUnitInfo.getLongNumber(), new AdminOrgUnitYearBudgetAmountDTO(adminOrgUnitInfo, this.realYear));
        }
        boolean singleOrgData = childCollection.size() == 1;
        AdminOrgUnitYearBudgetAmountDTO tempAmountDTO = singleOrgData ? (AdminOrgUnitYearBudgetAmountDTO)budgetAmountDTOMap.get(childCollection.get(0).getLongNumber()) : null;
        String selector = this.assembleItemSelector();
        if (selector.isEmpty()) {
            return budgetAmountDTOMap;
        }
        String sql = this.getQuerySql(selector, this.budgetServiceParam.isPeriod());
        Object[] param = new Object[]{this.budgetServiceParam.getTemplateInfo().getId().toString(), this.budgetServiceParam.getAdminOrg().getLongNumber() + "!%", this.realYear};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])param);
            while (rs.next()) {
                BudgetAmountDTO budgetAmountDTO = tempAmountDTO;
                if (!singleOrgData) {
                    String longNumber = rs.getString("longNumber");
                    budgetAmountDTO = this.findAdminAmountDTO(budgetAmountDTOMap, longNumber);
                }
                if (budgetAmountDTO == null) continue;
                if (needCostTypeDimension) {
                    String costTypeId;
                    Map<String, AdminOrgUnitCostTypeBudgetAmountDTO> costTypeAmountMap = budgetAmountDTO.getCostTypeAmountMap();
                    AdminOrgUnitCostTypeBudgetAmountDTO costTypeBudgetAmountDTO = costTypeAmountMap.get(costTypeId = rs.getString("costTypeId"));
                    if (costTypeBudgetAmountDTO == null) {
                        CostTypeInfo costTypeInfo = new CostTypeInfo();
                        costTypeInfo.setId(BOSUuid.read((String)costTypeId));
                        costTypeInfo.setName(rs.getString("costTypeName"), this.ctx.getLocale());
                        costTypeBudgetAmountDTO = new AdminOrgUnitCostTypeBudgetAmountDTO(costTypeInfo);
                        costTypeAmountMap.put(costTypeId, costTypeBudgetAmountDTO);
                    }
                    budgetAmountDTO = costTypeBudgetAmountDTO;
                }
                this.fillBudgetAmount(budgetAmountDTO, rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return budgetAmountDTOMap;
    }

    private void fillBudgetAmount(BudgetAmountDTO budgetAmountDTO, IRowSet rs) throws SQLException {
        for (BudgetItemMappingDTO budgetItemMappingDTO : this.budgetItemMappingDTOList) {
            BudgetItemDTO budgetItemDTO = budgetItemMappingDTO.getBudgetItemDTO();
            BudgetItemBoard budgetItemBoard = new BudgetItemBoard(budgetItemDTO);
            BigDecimal budgetItemValue = rs.getBigDecimal("T" + budgetItemDTO.getFieldSn());
            if (budgetItemValue != null) {
                budgetItemBoard.addAllAmount(budgetItemValue);
            }
            BudgetItemDTO balanceItem = budgetItemMappingDTO.getBalanceItem();
            BigDecimal balanceItemValue = rs.getBigDecimal("s" + balanceItem.getFieldSn());
            if (balanceItemValue != null) {
                budgetItemBoard.addRemainAmount(balanceItemValue);
            }
            budgetAmountDTO.addBudgetItem(budgetItemDTO, budgetItemBoard);
        }
    }

    private AdminOrgUnitYearBudgetAmountDTO findAdminAmountDTO(Map<String, AdminOrgUnitYearBudgetAmountDTO> budgetAmountDTOMap, String longNumber) {
        for (Map.Entry<String, AdminOrgUnitYearBudgetAmountDTO> entry : budgetAmountDTOMap.entrySet()) {
            String key = entry.getKey();
            if (!key.equals(longNumber) && !longNumber.startsWith(key + "!")) continue;
            return entry.getValue();
        }
        return null;
    }

    private String getPer3YearSql(String selector, Map<Integer, String> timeMap) {
        StringBuilder sql = new StringBuilder();
        int i = 0;
        if (this.budgetServiceParam.getTemplateInfo().getBudgetPeriod() == BudgetPeriodEnum.YEAR) {
            for (Map.Entry<Integer, String> entry : timeMap.entrySet()) {
                if (i++ != 0) {
                    sql.append(" union all ");
                }
                sql.append("select ").append(selector).append(entry.getKey()).append(" as budgetYear, adminOrg.fLongNumber as longNumber");
                sql.append(" from T_HR_SBudgetManage budgetV");
                sql.append(" inner join T_HR_SCmpBudgetScheme cbs on budgetV.FBudgetSchemeID = cbs.fid ");
                sql.append(" inner join T_HR_SBudgetTemplate btp on cbs.FTemplateID = btp.fid ");
                sql.append(" inner join t_org_admin adminOrg on budgetV.FAdminOrgUnitID = adminOrg.FID ");
                sql.append(" inner join T_HR_SCMPSTANDINGBOOK standingV");
                sql.append(" on budgetV.fid = standingV.FBudgetManageID ");
                sql.append(" where btp.fid = ? ");
                sql.append(" and adminOrg.fid in (").append(this.budgetServiceParam.getAdminOrgRangeSql()).append(")");
                sql.append(" and adminOrg.fLongNumber LIKE ? ");
                sql.append(" and cbs.feffectdate <= ").append(entry.getValue()).append(" and cbs.fexpirydate >= ").append(entry.getValue());
            }
        } else {
            for (Map.Entry<Integer, String> entry : timeMap.entrySet()) {
                if (i++ != 0) {
                    sql.append(" union all ");
                }
                sql.append("select ").append(selector).append(BUDGET_TABLE_ALIAS).append(".FPeriod,").append(entry.getKey()).append(" as budgetYear, adminOrg.fLongNumber as longNumber");
                sql.append(" from T_HR_SBudgetManage bdm ");
                sql.append(" inner join T_HR_SCmpBudgetScheme cbs on bdm.FBudgetSchemeID = cbs.fid ");
                sql.append(" inner join T_HR_SBudgetTemplate btp on cbs.FTemplateID = btp.fid ");
                sql.append(" inner join t_org_admin adminOrg on bdm.FAdminOrgUnitID = adminOrg.FID ");
                sql.append(" inner join T_HR_SSubBudgetQuery budgetV");
                sql.append(" on bdm.fid = budgetV.FBudgetManageID ");
                sql.append(" inner join T_HR_SubCmpStandingBook standingV");
                sql.append(" on budgetV.fid = standingV.FSubBudgetQueryID ");
                sql.append(" where btp.fid = ? ");
                sql.append(" and adminOrg.fid in (").append(this.budgetServiceParam.getAdminOrgRangeSql()).append(")");
                sql.append(" and adminOrg.fLongNumber LIKE ? ");
                sql.append(" and cbs.feffectdate <= ").append(entry.getValue()).append(" and cbs.fexpirydate >= ").append(entry.getValue());
            }
        }
        return sql.toString();
    }

    private String getQuerySql(String selector, boolean isPeriod) {
        String sql = null;
        String l = LocaleUtils.getShortCode((Locale)this.ctx.getLocale());
        if (!isPeriod || this.budgetServiceParam.getTemplateInfo().getBudgetPeriod() == BudgetPeriodEnum.YEAR) {
            sql = "select " + selector + BUDGET_TABLE_ALIAS + ".FBudgetYear, adminOrg.fLongNumber as longNumber,ct.fid as costTypeId,ct.fName_" + l + " as costTypeName from T_HR_SBudgetManage " + BUDGET_TABLE_ALIAS + " inner join T_HR_CostType ct on " + BUDGET_TABLE_ALIAS + ".FCostTypeID = ct.fid inner join T_HR_SCmpBudgetScheme cbs on " + BUDGET_TABLE_ALIAS + ".FBudgetSchemeID = cbs.fid  inner join T_HR_SBudgetTemplate btp on cbs.FTemplateID = btp.fid  inner join t_org_admin adminOrg on " + BUDGET_TABLE_ALIAS + ".FAdminOrgUnitID = adminOrg.FID  inner join T_HR_SCMPSTANDINGBOOK " + STANDING_TABLE_ALIAS + " on " + BUDGET_TABLE_ALIAS + ".fid = " + STANDING_TABLE_ALIAS + ".FBudgetManageID  where btp.fid = ?  and adminOrg.fid in (" + this.budgetServiceParam.getAdminOrgRangeSql() + ") and adminOrg.fLongNumber LIKE ?  and " + BUDGET_TABLE_ALIAS + ".FBudgetYear = ?";
        } else {
            String today = CmpDateUtil.toSimpleKSqlData(new Date());
            sql = "select " + selector + BUDGET_TABLE_ALIAS + ".FPeriod, bdm.FBudgetYear, adminOrg.fLongNumber as longNumber,ct.fid as costTypeId,ct.fName_" + l + " as costTypeName from T_HR_SBudgetManage bdm  inner join T_HR_CostType ct on bdm.FCostTypeID = ct.fid inner join T_HR_SCmpBudgetScheme cbs on bdm.FBudgetSchemeID = cbs.fid  inner join T_HR_SBudgetTemplate btp on cbs.FTemplateID = btp.fid  inner join t_org_admin adminOrg on bdm.FAdminOrgUnitID = adminOrg.FID  inner join T_HR_SSubBudgetQuery " + BUDGET_TABLE_ALIAS + " on bdm.fid = " + BUDGET_TABLE_ALIAS + ".FBudgetManageID  inner join T_HR_SubCmpStandingBook " + STANDING_TABLE_ALIAS + " on " + BUDGET_TABLE_ALIAS + ".fid = " + STANDING_TABLE_ALIAS + ".FSubBudgetQueryID  and " + BUDGET_TABLE_ALIAS + ".FEffectDate <= " + today + " and " + BUDGET_TABLE_ALIAS + ".FExpiryDate >=  " + today + " where btp.fid = ?  and adminOrg.fid in (" + this.budgetServiceParam.getAdminOrgRangeSql() + ") and adminOrg.fLongNumber LIKE ?  and bdm.FBudgetYear = ?";
        }
        return sql;
    }

    private String assembleItemSelector() {
        HashSet<Integer> budgetItemFieldSn = new HashSet<Integer>();
        HashSet<Integer> balanceItemFieldSn = new HashSet<Integer>();
        if (this.budgetItemMappingDTOList != null) {
            for (BudgetItemMappingDTO budgetItemMappingDTO : this.budgetItemMappingDTOList) {
                budgetItemFieldSn.add(budgetItemMappingDTO.getBudgetItemDTO().getFieldSn());
                balanceItemFieldSn.add(budgetItemMappingDTO.getBalanceItem().getFieldSn());
            }
        }
        StringBuilder selector = new StringBuilder();
        for (Integer i : balanceItemFieldSn) {
            selector.append(STANDING_TABLE_ALIAS).append(".s").append(i).append(" as s").append(i).append(",");
        }
        for (Integer i : budgetItemFieldSn) {
            selector.append(BUDGET_TABLE_ALIAS).append(".T").append(i).append(" as T").append(i).append(",");
        }
        return selector.toString();
    }
}

