/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.integrate.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.ISubmitBillEntryExchangeInfoFacade;
import com.kingdee.shr.compensation.app.integrate.SubmitBillEntryExchangeInfoFacadeFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookInfo;
import com.kingdee.shr.compensation.exception.SubmitBillVerifyException;
import com.kingdee.shr.compensation.integrate.verify.AbstractSubmitBillVerify;
import com.kingdee.shr.compensation.integrate.verify.SubmitBillDisableElementSubmitPeriodVerify;
import com.kingdee.shr.compensation.util.budget.MiaBudgetUpgradeUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BudgetVerify
extends AbstractSubmitBillVerify {
    private static final String DECLARED_AMOUNT_FIELD = "S1";

    @Override
    protected void beforeVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        super.beforeVerify(ctx, model, otherParams);
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.checkBudget(ctx, info);
    }

    protected void checkBudget(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        String targetCurrencyId;
        BigDecimal totalAmount;
        if (MiaBudgetUpgradeUtil.isMiaBudgetUpgrade(ctx)) {
            return;
        }
        BOSUuid costBearOrgId = info.getCostBearOrg().getId();
        String costBearOrg = null != costBearOrgId ? costBearOrgId.toString() : null;
        StandingBookInfo standingBookInfo = StandingBookFactory.getLocalInstance((Context)ctx).getStandingBookInfoByBillInfo(info);
        BigDecimal withHoleBalance = standingBookInfo.getWithHoleBalance();
        if (withHoleBalance.compareTo(totalAmount = this.sumAmount(ctx, info, targetCurrencyId = standingBookInfo.getLimitManagement().getCurrency().getId().toString())) < 0) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION7, new Object[]{this.getOrgName(ctx, costBearOrg), info.getBudgetYear()});
        }
    }

    protected BigDecimal sumAmount(Context ctx, BatchSubmitShemeBillInfo info, String targetCurrencyId) throws BOSException, EASBizException {
        BigDecimal sunAmount = new BigDecimal("0");
        CalSubmitSchemeInfo calSubmitSchemeInfo = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(info.getSubmitScheme().getId()));
        String exchangeTableId = null != calSubmitSchemeInfo ? calSubmitSchemeInfo.getExchangeTable().getId().toString() : null;
        ISubmitBillEntryExchangeInfoFacade entryExchangeRateInstance = SubmitBillEntryExchangeInfoFacadeFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            BatchSubmitShemeBillEntryInfo billEntryInfo = info.getEntry().get(i);
            String submitAmountStr = (String)billEntryInfo.get(DECLARED_AMOUNT_FIELD);
            BigDecimal submitMoney = StringUtils.isEmpty((CharSequence)submitAmountStr) ? new BigDecimal("0") : new BigDecimal(submitAmountStr);
            BigDecimal convertRate = entryExchangeRateInstance.getExchangeRateInfo(billEntryInfo, targetCurrencyId, exchangeTableId).getConvertRate();
            BigDecimal submitExchangeAmount = submitMoney.multiply(convertRate);
            sunAmount = sunAmount.add(submitExchangeAmount);
        }
        return sunAmount;
    }

    protected String getOrgName(Context ctx, String costBearOrg) throws BOSException, EASBizException {
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        adminOrgUnitInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(costBearOrg));
        return adminOrgUnitInfo.getName();
    }

    @Override
    protected void verifySubmitPeriod(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        new SubmitBillDisableElementSubmitPeriodVerify().verify(ctx, info);
    }
}

