/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.execution;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelBizType;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.CmpTaxMatchDataFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpTaxMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.DealType;
import com.kingdee.shr.compensation.app.intelligent.HandleTypeEnum;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgCollection;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.intelligent.dto.ChangeDay;
import com.kingdee.shr.compensation.intelligent.dto.ChangeTaxUnit;
import com.kingdee.shr.compensation.intelligent.dto.TaxUnitCondition;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelTaxUnitJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.PersonRange;
import com.kingdee.shr.compensation.intelligent.execution.AbstractCmpIntelExecution;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentFilterUtil;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public class TaxUnitIncreasePersonExecution
extends AbstractCmpIntelExecution {
    protected String bizManageType = "CMP02";
    protected CmpIntelRuleInfo ruleInfo;
    protected CmpIntelCatalogInfo catalogInfo;

    @Override
    protected CoreBaseCollection buildMatchData() throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void execute() throws EASBizException, BOSException {
        this.beforeExecute();
        this.doExecute();
        this.afterExecute();
    }

    protected void beforeExecute() throws EASBizException, BOSException {
        this.ruleInfo = new CmpIntelRuleInfo();
        this.ruleInfo.setId(BOSUuid.read((String)this.ruleId));
        this.catalogInfo = new CmpIntelCatalogInfo();
        this.catalogInfo.setId(BOSUuid.read((String)this.catalogId));
    }

    protected void afterExecute() throws EASBizException, BOSException {
    }

    protected void doExecute() throws BOSException, EASBizException {
        Map<CmpItelTaxUnitJsonBean, CmpIntelEntryAdminOrgCollection> taxUnitConfigs = this.getCmpIntelTaxUnitConfig(this.ctx, this.ruleId, this.catalogId);
        if (taxUnitConfigs.size() == 0) {
            return;
        }
        String effectDateFilter = "";
        Object effectDate = this.cacheMap.get("effectDate");
        if (effectDate != null) {
            effectDateFilter = effectDate.toString();
        }
        Map orgLongNumberMap = (Map)this.cacheMap.get("orgLongNumberMap");
        Iterator<Map.Entry<CmpItelTaxUnitJsonBean, CmpIntelEntryAdminOrgCollection>> iterator = taxUnitConfigs.entrySet().iterator();
        while (iterator.hasNext()) {
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            Map.Entry<CmpItelTaxUnitJsonBean, CmpIntelEntryAdminOrgCollection> next = iterator.next();
            CmpItelTaxUnitJsonBean config = next.getKey();
            CmpIntelEntryAdminOrgCollection orgEntry = next.getValue();
            PersonRange personRange = config.getPersonRange();
            boolean containsChangeTypeFilter = false;
            String customCondition = null;
            if (personRange.getCustomFilter() != null && CmpStrUtil.isNotEmpty(personRange.getCustomFilter().getConditionText())) {
                String parseOtherFilter = CmpIntelligentFilterUtil.parseOtherFilter(personRange.getCustomFilter());
                customCondition = CmpIntelligentFilterUtil.getOtherFilterFromStructrue(this.ctx, parseOtherFilter, null);
                customCondition = " id in ( " + customCondition + " ) ";
                containsChangeTypeFilter = parseOtherFilter.contains("changeType");
            }
            String affairActionReasonFilter = "";
            if (!containsChangeTypeFilter) {
                affairActionReasonFilter = this.getAffairActionReasonFilter(containsChangeTypeFilter);
            }
            TaxUnitResRule resRule = this.getResRult(config);
            String adminFilter = this.buildAdminFilter(orgEntry, orgLongNumberMap);
            String sql = this.getConfirmFilterOql(adminFilter, customCondition, effectDateFilter, affairActionReasonFilter);
            PersonBURelaConfirmCollection coll = PersonBURelaConfirmFactory.getLocalInstance((Context)this.ctx).getPersonBURelaConfirmCollection(sql.toString());
            HashSet<String> hasDoneConfirmSet = new HashSet<String>();
            this.doWithConfirmResult(coll, resRule, coreBaseColl, hasDoneConfirmSet);
            CmpTaxMatchDataFactory.getLocalInstance((Context)this.ctx).save(coreBaseColl);
        }
    }

    protected String buildAdminFilter(CmpIntelEntryAdminOrgCollection orgEntry, Map<String, String> orgLongNumberMap, boolean reverse) {
        StringBuilder sb = new StringBuilder();
        boolean isInverse = false;
        StringBuilder adminRange = new StringBuilder();
        for (int i = 0; i < orgEntry.size(); ++i) {
            CmpIntelEntryAdminOrgInfo cmpIntelEntryAdminOrgInfo = orgEntry.get(i);
            String orgId = cmpIntelEntryAdminOrgInfo.getAdminOrg().getId().toString();
            isInverse |= cmpIntelEntryAdminOrgInfo.isIfcontainBefore();
            if (i != 0) {
                adminRange.append(" union ");
            }
            adminRange.append("select fid from t_org_admin where fid = '").append(orgId).append("'");
            if (!cmpIntelEntryAdminOrgInfo.isIfInclude()) continue;
            String longNumber = orgLongNumberMap.get(orgId);
            adminRange.append(" or flongNumber like '").append(longNumber).append("!%'");
        }
        if (adminRange.length() == 0) {
            return "";
        }
        String tempTable = SQLHandleUtil.getTempTable(this.ctx, adminRange.toString());
        String pre = null;
        String suff = null;
        if (!reverse) {
            pre = "newEmpOrgRelation";
            suff = "oldEmpOrgRelation";
        } else {
            pre = "oldEmpOrgRelation";
            suff = "newEmpOrgRelation";
        }
        String field = pre + ".adminOrg.id";
        sb.append(field + " in (" + tempTable + ")");
        if (isInverse) {
            sb.append(" and (" + suff + " is null or " + suff + ".adminOrg.id not in (" + tempTable).append("))");
        }
        return sb.toString();
    }

    protected String getAffairActionReasonFilter(boolean containsChangeTypeFilter) {
        return "(affairActionReason.longNumber like '01!%' or affairActionReason.longNumber like '03!%')";
    }

    protected void doWithConfirmResult(PersonBURelaConfirmCollection coll, TaxUnitResRule resRule, CoreBaseCollection coreBaseColl, Set<String> hasDoneConfirmSet) {
        if (coll == null || coll.size() == 0) {
            return;
        }
        for (int j = 0; j < coll.size(); ++j) {
            PersonBURelaConfirmInfo confirmInfo = coll.get(j);
            String checkKey = confirmInfo.getPerson().getId() + "_" + (confirmInfo.getOldEmpOrgRelation() == null ? "" : confirmInfo.getOldEmpOrgRelation().getId()) + "_" + (confirmInfo.getNewEmpOrgRelation() == null ? "" : confirmInfo.getNewEmpOrgRelation().getId()) + "_" + CmpDateUtil.getDateStr(confirmInfo.getChangeDate());
            if (hasDoneConfirmSet.contains(checkKey)) continue;
            Date changeDate = confirmInfo.getChangeDate();
            Calendar c = Calendar.getInstance();
            c.setTime(changeDate);
            int k = c.get(5);
            if (k <= resRule.getBeforeDay()) {
                this.assmbleMatchData(confirmInfo, resRule.getBeforeCondition(), coreBaseColl);
                hasDoneConfirmSet.add(checkKey);
                continue;
            }
            if (k <= resRule.getAfterDay()) continue;
            this.assmbleMatchData(confirmInfo, resRule.getAfterCondition(), coreBaseColl);
            hasDoneConfirmSet.add(checkKey);
        }
    }

    protected TaxUnitResRule getResRult(CmpItelTaxUnitJsonBean config) {
        TaxUnitResRule resRule = new TaxUnitResRule();
        List<TaxUnitCondition> taxUnitCondition = config.getTaxUnitCondition();
        for (TaxUnitCondition condition : taxUnitCondition) {
            ChangeDay changeDay = condition.getChangeDay();
            if (changeDay.getFlag().equals("before")) {
                resRule.setBeforeCondition(condition);
                resRule.setBeforeDay(Integer.valueOf(changeDay.getDay()));
                continue;
            }
            if (!changeDay.getFlag().equals("after")) continue;
            resRule.setAfterCondition(condition);
            resRule.setAfterDay(Integer.valueOf(changeDay.getDay()));
        }
        return resRule;
    }

    protected String getConfirmFilterOql(String adminFilter, String customCondition, String effectDateFilter, String affairActionReasonFilter) {
        StringBuilder sql = new StringBuilder();
        sql.append("select person.id,oldEmpOrgRelation.id,newEmpOrgRelation.id,changeDate");
        sql.append(" where bizManageType.number = '" + this.bizManageType + "' and ").append(this.getNewEmpOrgRelationRange());
        sql.append(" and affairActionReason.id is not null ");
        if (CmpStrUtil.isNotEmpty(adminFilter)) {
            sql.append(" and ").append(adminFilter);
        }
        if (CmpStrUtil.isNotEmpty(customCondition)) {
            sql.append(" and ").append(customCondition);
        }
        if (CmpStrUtil.isNotEmpty(effectDateFilter)) {
            sql.append(" and changeDate >= ").append(effectDateFilter);
        }
        if (CmpStrUtil.isNotEmpty(affairActionReasonFilter)) {
            sql.append(" and ").append(affairActionReasonFilter);
        }
        sql.append(" and id not in (select matchData.FPbuConfirmID from T_hr_SCmpTaxMatchData matchData ");
        sql.append(" inner join T_HR_PersonBURelaConfirm confirm on matchData.FPbuConfirmID = confirm.fid ");
        sql.append(" where matchData.FCmpIntelCatalogID = '" + this.catalogId + "'");
        if (CmpStrUtil.isNotEmpty(effectDateFilter)) {
            sql.append(" and confirm.fchangeDate >= ").append(effectDateFilter);
        }
        sql.append(")");
        sql.append(this.getConfirmOrderBySql());
        return sql.toString();
    }

    protected String getConfirmOrderBySql() {
        return " order by affairActionReason.longNumber";
    }

    protected String getNewEmpOrgRelationRange() {
        return "newEmpOrgRelation.id in (select fid from T_HR_EmpOrgRelation where FIsLatestInAday = 1 and fisInner = 1)";
    }

    protected void assmbleMatchData(PersonBURelaConfirmInfo confirmInfo, TaxUnitCondition condition, CoreBaseCollection coreBaseColl) {
        Date changeDate;
        if (condition == null) {
            return;
        }
        Date now = new Date();
        CmpTaxMatchDataInfo recordMatchData = new CmpTaxMatchDataInfo();
        recordMatchData.setCmpIntelRule(this.ruleInfo);
        recordMatchData.setCmpIntelCatalog(this.catalogInfo);
        recordMatchData.setPbuConfirm(confirmInfo);
        recordMatchData.setEffdt(now);
        recordMatchData.setState(CmpIntelState.UNCONFIRMED);
        recordMatchData.setIsHandled(false);
        String addMonth = condition.getChangeMonth().getMonth();
        recordMatchData.setParse(addMonth);
        Date handleDate = changeDate = confirmInfo.getChangeDate();
        if (!"0".equals(addMonth)) {
            handleDate = CmpDateUtil.getAddMonth(changeDate, Integer.parseInt(addMonth));
        }
        recordMatchData.setHandleDate(handleDate);
        recordMatchData.setHandleType(HandleTypeEnum.AUTO);
        recordMatchData.setChangeDate(confirmInfo.getChangeDate());
        recordMatchData.setBizType(CmpIntelBizType.TAX);
        recordMatchData.setPerson(confirmInfo.getPerson());
        ChangeTaxUnit changeTaxUnit = condition.getChangeTaxUnit().get(0);
        TaxUnitInfo taxUnitInfo = new TaxUnitInfo();
        taxUnitInfo.setId(BOSUuid.read((String)changeTaxUnit.getId()));
        recordMatchData.setTaxUnit(taxUnitInfo);
        recordMatchData.setMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label80", (Locale)this.ctx.getLocale()) + changeTaxUnit.getName());
        recordMatchData.setDealType(DealType.CMP_RECORD);
        CmpTaxMatchDataInfo taxMatchData = new CmpTaxMatchDataInfo();
        BeanUtils.copyProperties((Object)recordMatchData, (Object)taxMatchData);
        taxMatchData.setHandleType(HandleTypeEnum.MASTER);
        taxMatchData.setMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label81", (Locale)this.ctx.getLocale()) + changeTaxUnit.getName());
        taxMatchData.setDealType(DealType.TAX_RECORD);
        coreBaseColl.add((CoreBaseInfo)recordMatchData);
        coreBaseColl.add((CoreBaseInfo)taxMatchData);
    }

    protected String buildAdminFilter(CmpIntelEntryAdminOrgCollection orgEntry, Map<String, String> orgLongNumberMap) {
        return this.buildAdminFilter(orgEntry, orgLongNumberMap, false);
    }

    protected Map<CmpItelTaxUnitJsonBean, CmpIntelEntryAdminOrgCollection> getCmpIntelTaxUnitConfig(Context ctx, String ruleId, String catalogId) throws BOSException {
        LinkedHashMap<CmpItelTaxUnitJsonBean, CmpIntelEntryAdminOrgCollection> map = new LinkedHashMap<CmpItelTaxUnitJsonBean, CmpIntelEntryAdminOrgCollection>();
        String oql = "select data,orgEntry.* where cmpIntelRule.id='" + ruleId + "' and cmpIntelCatalog.id='" + catalogId + "' order by index";
        CmpIntelEntryCollection coll = CmpIntelEntryFactory.getLocalInstance((Context)ctx).getCmpIntelEntryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CmpIntelEntryInfo cmpIntelEntryInfo = coll.get(i);
            String entryJsonData = cmpIntelEntryInfo.getData();
            CmpItelTaxUnitJsonBean taxUnitIntelConfig = CmpIntelligentUtil.getJsonObj(entryJsonData, new CmpItelTaxUnitJsonBean());
            map.put(taxUnitIntelConfig, cmpIntelEntryInfo.getOrgEntry());
        }
        return map;
    }

    public CmpIntelRuleInfo getRuleInfo() {
        return this.ruleInfo;
    }

    public CmpIntelCatalogInfo getCatalogInfo() {
        return this.catalogInfo;
    }

    protected class TaxUnitResRule {
        TaxUnitCondition beforeCondition = null;
        TaxUnitCondition afterCondition = null;
        int beforeDay = 0;
        int afterDay = 0;

        public TaxUnitResRule(TaxUnitCondition beforeCondition, TaxUnitCondition afterCondition, int beforeDay, int afterDay) {
            this.beforeCondition = beforeCondition;
            this.afterCondition = afterCondition;
            this.beforeDay = beforeDay;
            this.afterDay = afterDay;
        }

        public TaxUnitResRule() {
        }

        public TaxUnitCondition getBeforeCondition() {
            return this.beforeCondition;
        }

        public void setBeforeCondition(TaxUnitCondition beforeCondition) {
            this.beforeCondition = beforeCondition;
        }

        public TaxUnitCondition getAfterCondition() {
            return this.afterCondition;
        }

        public void setAfterCondition(TaxUnitCondition afterCondition) {
            this.afterCondition = afterCondition;
        }

        public int getBeforeDay() {
            return this.beforeDay;
        }

        public void setBeforeDay(int beforeDay) {
            this.beforeDay = beforeDay;
        }

        public int getAfterDay() {
            return this.afterDay;
        }

        public void setAfterDay(int afterDay) {
            this.afterDay = afterDay;
        }
    }
}

