/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.WorkRelation;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryInfo;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelEntry;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgCollection;
import com.kingdee.shr.compensation.intelligent.dto.CalSchemeIncreaseEntry;
import com.kingdee.shr.compensation.intelligent.dto.CmpF7FilterData;
import com.kingdee.shr.compensation.intelligent.dto.CustomFilterData;
import com.kingdee.shr.compensation.intelligent.dto.PbuConfirmFilter;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpSyncOrgPositionBean;
import com.kingdee.shr.compensation.intelligent.dto.json.CustomFilter;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.resource.CmpPropertiesUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class CmpIntelligentFilterUtil {
    private static final Logger logger = Logger.getLogger(CmpIntelligentFilterUtil.class);

    public static String includeSubHandle(List<CmpF7FilterData> data, Map<String, String> orgLongNumberMap) {
        StringBuilder sb = new StringBuilder("(select fid from t_org_admin where 1=1 ");
        String longNumber = "";
        int i = 0;
        String id = "";
        for (CmpF7FilterData filterData : data) {
            if (i == 0) {
                sb.append("and (");
            }
            id = CmpIntelligentUtil.uriDecode(filterData.getId());
            longNumber = orgLongNumberMap.get(id);
            String filterStr = "flongNumber like '" + longNumber + "%' ";
            sb.append(filterStr);
            if (i == data.size() - 1) {
                sb.append(")");
            } else {
                sb.append(" or ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String includeSubHandle(String id, Map<String, String> orgLongNumberMap) {
        StringBuilder sb = new StringBuilder(" ( select fid from t_org_admin where 1=1 ");
        String longNumber = "";
        sb.append("and (");
        longNumber = orgLongNumberMap.get(id);
        String filterStr = "flongNumber like '" + longNumber + "%' ";
        sb.append(filterStr);
        sb.append(") ) ");
        return sb.toString();
    }

    public static String notIncludeSubHandle(List<CmpF7FilterData> data) {
        ArrayList<String> ids = new ArrayList<String>();
        String id = "";
        for (CmpF7FilterData f7Data : data) {
            id = CmpIntelligentUtil.uriDecode(f7Data.getId());
            ids.add(id);
        }
        String idStr = "(" + CmpStrUtil.convertListToString(ids) + ")";
        return idStr;
    }

    public static String buildCustomFilter(List<CustomFilterData> customFilter) {
        if (customFilter.size() == 0) {
            return null;
        }
        String field_type = "";
        String prop_field = "";
        String prop_op = "";
        String prop_value = "";
        String oldField = "";
        String oqlField = "";
        StringBuilder sb = new StringBuilder();
        List<PbuConfirmFilter> andList = null;
        PbuConfirmFilter filter = null;
        CustomFilterData customFilterData = null;
        Properties filterConfig = CmpPropertiesUtil.getCustomFilterConfigs();
        int orSize = customFilter.size();
        for (int i = 0; i < orSize; ++i) {
            sb.append("(");
            customFilterData = customFilter.get(i);
            andList = customFilterData.getPbuConfirmFilter();
            int andSize = andList.size();
            for (int j = 0; j < andSize; ++j) {
                filter = andList.get(j);
                field_type = filter.getField_type();
                prop_field = filter.getProp_field();
                oldField = prop_field.substring(0, prop_field.lastIndexOf("."));
                if (oldField.startsWith("intel_job") && !"intel_job".equals(oldField)) {
                    CmpIntelligentFilterUtil.buildJobFilter(sb, filter, oldField);
                    if (j == andSize - 1) continue;
                    sb.append(" ").append("and").append(" ");
                    continue;
                }
                if ("intel_empType".equals(oldField)) {
                    CmpIntelligentFilterUtil.buildEmployeeTypeFilter(sb, filter, oldField);
                    if (j == andSize - 1) continue;
                    sb.append(" ").append("and").append(" ");
                    continue;
                }
                if (filterConfig.containsKey(oldField)) {
                    oqlField = (String)filterConfig.get(oldField);
                    prop_field = prop_field.replace(oldField, oqlField);
                }
                prop_op = filter.getProp_op();
                prop_value = filter.getProp_value();
                sb.append(prop_field).append(" ");
                sb.append(prop_op).append(" ");
                if ("like".equals(prop_op)) {
                    prop_value = "%" + prop_value + "%";
                }
                if ("String".equals(field_type)) {
                    sb.append("'").append(prop_value).append("'");
                } else {
                    sb.append(prop_value);
                }
                if (j == andSize - 1) continue;
                sb.append(" ").append("and").append(" ");
            }
            sb.append(")").append(" or ");
        }
        String customFilterStr = sb.substring(0, sb.length() - 4);
        return customFilterStr;
    }

    private static void buildJobFilter(StringBuilder sb, PbuConfirmFilter filter, String oldField) {
        String prop_field = filter.getProp_field();
        String prop_op = filter.getProp_op();
        String field_type = filter.getField_type();
        String prop_value = filter.getProp_value();
        prop_field = prop_field.split("_")[1];
        prop_field = prop_field.replace("name", "fname_l2");
        if ("like".equals(prop_op)) {
            prop_value = "%" + prop_value + "%";
        }
        if ("intel_jobLevel".equals(oldField) || "intel_jobGrade".equals(oldField)) {
            sb.append("newEmpOrgRelation.id in(");
            sb.append("select relation.fid from t_hr_emporgrelation relation");
            sb.append("  left join T_HR_EmpPostRank erank on erank.fpersonId = relation.fpersonid and erank.FEFFDT<=relation.FLEFFDT and relation.FLEFFDT<=erank.FLEFFDT ");
            sb.append("  left join t_hr_joblevel jobLevel on jobLevel.fid=erank.FJobLevelID");
            sb.append("  left join t_hr_jobGrade jobGrade on jobGrade.fid=erank.FJobGradeID");
        } else {
            sb.append(" newEmpOrgRelation.id in( ");
            sb.append(" select relation.fid from t_hr_emporgrelation relation ");
            sb.append(" left join t_org_position pos on relation.fpositionid=pos.fid ");
            sb.append(" left join T_HR_HRJob hrJob on pos.FJOBID=hrJob.FJOBID ");
            sb.append(" left join T_HR_HRJobSubCategory jobSubCat on hrJob.fhrjobsubcategoryid=jobSubCat.fid ");
            sb.append(" left join T_HR_HRJobCategory jobCat on hrJob.fhrjobcategoryid=jobCat.fid ");
            sb.append(" left join T_HR_HRJobFamily jobFamily on hrJob.fhrjobfamilyid=jobFamily.fid ");
        }
        sb.append(" where ").append(prop_field).append(" ").append(prop_op).append(" ");
        if ("String".equals(field_type)) {
            sb.append("'").append(prop_value).append("'");
        } else {
            sb.append(prop_value);
        }
        sb.append(")");
    }

    private static void buildEmployeeTypeFilter(StringBuilder sb, PbuConfirmFilter filter, String oldField) {
        String prop_field = filter.getProp_field();
        String prop_op = filter.getProp_op();
        String field_type = filter.getField_type();
        String prop_value = filter.getProp_value();
        prop_field = prop_field.split("_")[1];
        prop_field = prop_field.replace("name", "fname_l2");
        if ("like".equals(prop_op)) {
            prop_value = "%" + prop_value + "%";
        }
        sb.append(" newEmpOrgRelation.id in( ");
        sb.append(" select relation.fid from t_hr_emporgrelation relation ");
        sb.append(" left join t_hr_emplaborRelationHis laborRelationHis on relation.FlaborRelationID = laborRelationHis.FHistoryRelateID ");
        sb.append(" and laborRelationHis.FStartDateTime <=relation.FEndDateTime and relation.FEndDateTime<=laborRelationHis.FEndDateTime ");
        sb.append(" left join T_HR_BDEmployeeType empType on empType.fid =laborRelationHis.FLaborRelationStateID ");
        sb.append(" where ").append(prop_field).append(" ").append(prop_op).append(" ");
        if ("String".equals(field_type)) {
            sb.append("'").append(prop_value).append("'");
        } else {
            sb.append(prop_value);
        }
        sb.append(")");
    }

    public static String getOtherFilterFromStructrue(Context ctx, String conditionText, String filter) {
        try {
            FilterInfo filterInfo = null;
            filterInfo = new FilterInfo(conditionText);
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("personBURelaConfirm.id", "fid");
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filterInfo);
            sqlParam.setScheme("016");
            sqlParam.setHistoryMode(true);
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            if (StringUtils.isEmpty((String)conditionText)) {
                sql = sql + " WHERE 1=1";
            }
            if (!StringUtils.isEmpty((String)filter)) {
                sql = sql + " AND (" + filter + ")";
            }
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "select * into " + tempTable + " from ( " + sql + " ) t where 1=1 ";
            DbUtil.execute((Context)ctx, (String)creatTable);
            sql = "select * from  " + tempTable;
            return sql;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getOtherFilterNew(Context ctx, CustomFilter otherFilter, String filter) {
        String conditionText = CmpIntelligentFilterUtil.parseOtherFilter(otherFilter);
        return CmpIntelligentFilterUtil.getOtherFilterFromStructrue(ctx, conditionText, filter);
    }

    public static Boolean checkOtherFilterEmpty(CustomFilter otherFilter) {
        if (otherFilter == null) {
            return true;
        }
        String conditionText = otherFilter.getConditionText();
        List<PbuConfirmFilter> conditions = otherFilter.getConditions();
        return StringUtils.isEmpty((String)conditionText) && CollectionUtils.isEmpty(conditions);
    }

    public static String getSyncOrgPositionOtherFilter(Context ctx, CustomFilter otherFilter, FilterInfo filter, String ExtFilter) throws EASBizException, BOSException {
        if (otherFilter == null || CmpStrUtil.isEmpty(otherFilter.getConditionText())) {
            return null;
        }
        String conditionText = CmpIntelligentFilterUtil.parseOtherFilter(otherFilter);
        try {
            FilterInfo filterInfo = null;
            filterInfo = new FilterInfo(conditionText);
            if (filter != null) {
                filterInfo.mergeFilter(filter, "AND");
            }
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("SYNC_CTB.id", "fid");
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filterInfo);
            sqlParam.setScheme("CMP_INTELCAL");
            sqlParam.setHistoryMode(true);
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            if (!StringUtils.isEmpty((String)ExtFilter)) {
                sql = sql + " AND (" + ExtFilter + ")";
            }
            System.out.println(" getSyncOrgPositionOtherFilter: " + sql);
            System.out.println(" getSyncOrgPositionOtherFilter conditionText: " + conditionText);
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "select * into " + tempTable + " from ( " + sql + " ) t where 1=1 ";
            DbUtil.execute((Context)ctx, (String)creatTable);
            sql = "select * from " + tempTable;
            return sql;
        }
        catch (ParserException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getSyncOrgPositionOtherFilter(Context ctx, CustomFilter otherFilter, String filter) {
        String conditionText = CmpIntelligentFilterUtil.parseOtherFilter(otherFilter);
        if (CmpStrUtil.isEmpty(conditionText)) {
            return null;
        }
        try {
            FilterInfo filterInfo = null;
            filterInfo = new FilterInfo(conditionText);
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("SYNC_CTB.id", "fid");
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filterInfo);
            sqlParam.setScheme("CMP_INTELCAL");
            sqlParam.setHistoryMode(true);
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            if (StringUtils.isEmpty((String)conditionText)) {
                sql = sql + " WHERE 1=1";
            }
            if (!StringUtils.isEmpty((String)filter)) {
                sql = sql + " AND (" + filter + ")";
            }
            System.out.println(" getSyncOrgPositionOtherFilter: " + sql);
            System.out.println(" getSyncOrgPositionOtherFilter conditionText: " + conditionText);
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "select * into " + tempTable + " from ( " + sql + " ) t where 1=1 ";
            DbUtil.execute((Context)ctx, (String)creatTable);
            sql = "select * from " + tempTable;
            return sql;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return "";
        }
    }

    public static String parseOtherFilter(CustomFilter otherFilter) {
        StringBuilder sb = new StringBuilder();
        String conditionText = otherFilter.getConditionText();
        List<PbuConfirmFilter> conditions = otherFilter.getConditions();
        if (StringUtils.isEmpty((String)conditionText) || CollectionUtils.isEmpty(conditions)) {
            return "";
        }
        conditionText = conditionText.toUpperCase(Locale.ENGLISH);
        conditionText = conditionText.replace("OR", " OR ");
        conditionText = conditionText.replace("AND", " AND ");
        conditionText = conditionText.replace("(", " ( ");
        conditionText = conditionText.replace(")", " ) ");
        conditionText = conditionText + " ";
        PbuConfirmFilter condition = null;
        try {
            for (int i = 0; i < conditions.size(); ++i) {
                boolean no_content = false;
                boolean content = false;
                condition = conditions.get(i);
                String prop_field = condition.getProp_field();
                String field_type = condition.getField_type();
                String prop_op = condition.getProp_op();
                if ("is null".equals(prop_op)) {
                    no_content = true;
                } else if ("is not null".equals(prop_op)) {
                    content = true;
                }
                String prop_value = condition.getProp_value();
                String enumSource = condition.getEnumSource();
                String conditionName = condition.getConditionName();
                sb.append(prop_field).append(" ");
                if ("IntEnum".equals(field_type) && !no_content && !content) {
                    prop_value = CmpIntelligentFilterUtil.getEnumPropValue(prop_value, enumSource);
                }
                if (prop_op != null && prop_op.contains("like")) {
                    prop_value = "%" + prop_value + "%";
                }
                if ("String".equals(field_type) || "StringEnum".equals(field_type) || "Enum".equals(field_type)) {
                    if ("StringEnum".equals(field_type) || "Enum".equals(field_type)) {
                        prop_value = CmpIntelligentFilterUtil.getEnumPropValue(prop_value, enumSource);
                    }
                    if (no_content || content) {
                        sb.append(prop_op).append(" ");
                    } else {
                        sb.append(prop_op).append(" '").append(prop_value).append("' ");
                    }
                } else if ("Date".equals(field_type)) {
                    prop_value = prop_value.substring(0, 10);
                    prop_value = "{ts '" + prop_value + "'}";
                    if (no_content || content) {
                        sb.append(prop_op).append(" ");
                    } else {
                        sb.append(prop_op).append(prop_value);
                    }
                } else if (no_content || content) {
                    sb.append(prop_op).append(" ");
                } else {
                    sb.append(prop_op).append(prop_value);
                }
                conditionText = conditionText.replace(conditionName.toUpperCase(Locale.ENGLISH) + " ", "(" + sb.toString() + ")");
                sb.setLength(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return conditionText;
    }

    public static String getEnumPropValue(String prop_value, String enumSource) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List enums = EnumUtils.getEnumList((String)enumSource);
        if (CollectionUtils.isEmpty((Collection)enums)) {
            return prop_value;
        }
        for (int k = 0; k < enums.size(); ++k) {
            Enum _enum = (Enum)enums.get(k);
            String str = _enum.getAlias();
            if (prop_value == null || !prop_value.equals(str)) continue;
            prop_value = String.valueOf(enums.get(k).getClass().getMethod("getValue", new Class[0]).invoke(enums.get(k), new Object[0]));
            break;
        }
        return prop_value;
    }

    public static String getOtherFilter(Context ctx, List<CustomFilter> otherFilter, String filter) {
        String sql = "";
        String scheme = "016";
        SqlParam sqlParam = new SqlParam();
        FilterInfo filterInfo = null;
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        selectMapping.put("personBURelaConfirm.id", "fid");
        boolean flagOr = false;
        try {
            for (int j = 0; j < otherFilter.size(); ++j) {
                List<PbuConfirmFilter> pbuConfirmFilter = otherFilter.get(j).getConditions();
                String str = " or ";
                boolean temp = false;
                int size = pbuConfirmFilter.size();
                for (int i = 0; i < size; ++i) {
                    if (temp) {
                        str = " and ";
                    }
                    boolean no_content = false;
                    boolean content = false;
                    PbuConfirmFilter buConfirmFilter = pbuConfirmFilter.get(i);
                    String prop_field = buConfirmFilter.getProp_field();
                    String field_type = buConfirmFilter.getField_type();
                    String prop_op = buConfirmFilter.getProp_op();
                    if ("is null".equals(prop_op)) {
                        no_content = true;
                    } else if ("is not null".equals(prop_op)) {
                        content = true;
                    }
                    String prop_value = buConfirmFilter.getProp_value();
                    String enumSource = buConfirmFilter.getEnumSource();
                    if (temp || flagOr) {
                        sb.append(str).append(prop_field).append(" ");
                    } else {
                        sb.append(prop_field).append(" ");
                    }
                    if ("IntEnum".equals(field_type) && !no_content && !content) {
                        List enums = EnumUtils.getEnumList(Class.forName(enumSource));
                        for (int k = 0; k < enums.size(); ++k) {
                            Enum _enum = (Enum)enums.get(k);
                            String str11 = _enum.getAlias();
                            WorkRelation.getEnum((int)1).getValue();
                            if (prop_value == null || !prop_value.equals(str11)) continue;
                            prop_value = String.valueOf(enums.get(k).getClass().getMethod("getValue", new Class[0]).invoke(enums.get(k), new Object[0]));
                        }
                    }
                    if (prop_op != null && prop_op.indexOf("like") != -1) {
                        prop_value = "%" + prop_value + "%";
                    }
                    if ("String".equals(field_type) || "StringEnum".equals(field_type)) {
                        if (no_content || content) {
                            sb.append(prop_op).append(" ");
                        } else {
                            sb.append(prop_op).append(" '").append(prop_value).append("' ");
                        }
                    } else if (null != prop_value && "Date".equals(field_type)) {
                        prop_value = prop_value.substring(0, 10);
                        prop_value = "{ts '" + prop_value + "'}";
                        if (no_content || content) {
                            sb.append(prop_op).append(" ");
                        } else {
                            sb.append(prop_op).append(prop_value);
                        }
                    } else if (no_content || content) {
                        sb.append(prop_op).append(" ");
                    } else {
                        sb.append(prop_op).append(prop_value);
                    }
                    temp = true;
                }
                flagOr = true;
            }
            filterInfo = new FilterInfo(sb.toString());
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filterInfo);
            sqlParam.setScheme(scheme);
            sqlParam.setHistoryMode(true);
            sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            if (!StringUtils.isEmpty((String)filter)) {
                sql = String.valueOf(sql) + "AND (" + filter + ")";
            }
            System.out.println(" getOtherFiltersql " + sql);
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "select * into " + tempTable + " from ( " + sql + " ) t where 1=1 ";
            DbUtil.execute((Context)ctx, (String)creatTable);
            sql = "select * from  " + tempTable;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql;
    }

    public static List<Map<CmpItelJsonBean, CmpIntelEntryAdminOrgCollection>> getSchemeEntrys(Context ctx, String ruleId, String catalogId) throws BOSException {
        ArrayList<Map<CmpItelJsonBean, CmpIntelEntryAdminOrgCollection>> list = new ArrayList<Map<CmpItelJsonBean, CmpIntelEntryAdminOrgCollection>>();
        ICmpIntelEntry cmpIntelEntry = CmpIntelEntryFactory.getLocalInstance((Context)ctx);
        String oql = "select data,orgEntry.* where cmpIntelRule.id='" + ruleId + "' and cmpIntelCatalog.id='" + catalogId + "' order by index";
        String entryJsonData = "";
        CmpIntelEntryInfo cmpIntelEntryInfo = null;
        CalSchemeIncreaseEntry matchEntry = new CalSchemeIncreaseEntry();
        CmpIntelEntryCollection coll = cmpIntelEntry.getCmpIntelEntryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            HashMap<CmpItelJsonBean, CmpIntelEntryAdminOrgCollection> map = new HashMap<CmpItelJsonBean, CmpIntelEntryAdminOrgCollection>();
            cmpIntelEntryInfo = coll.get(i);
            entryJsonData = cmpIntelEntryInfo.getData();
            CmpItelJsonBean saveDate = CmpIntelligentUtil.getJsonObj(entryJsonData, new CmpItelJsonBean());
            CmpIntelEntryAdminOrgCollection orgColl = cmpIntelEntryInfo.getOrgEntry();
            map.put(saveDate, orgColl);
            list.add(map);
        }
        return list;
    }

    public static List<CmpSyncOrgPositionBean> getCmpSyncOrgPositionBean(Context ctx, String ruleId, String catalogId) throws BOSException {
        ArrayList<CmpSyncOrgPositionBean> list = new ArrayList<CmpSyncOrgPositionBean>();
        ICmpIntelEntry cmpIntelEntry = CmpIntelEntryFactory.getLocalInstance((Context)ctx);
        String oql = "select data,orgEntry.* where cmpIntelRule.id='" + ruleId + "' and cmpIntelCatalog.id='" + catalogId + "' order by index";
        String entryJsonData = "";
        CmpIntelEntryInfo cmpIntelEntryInfo = null;
        CmpIntelEntryCollection coll = cmpIntelEntry.getCmpIntelEntryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            cmpIntelEntryInfo = coll.get(i);
            entryJsonData = cmpIntelEntryInfo.getData();
            CmpSyncOrgPositionBean saveDate = CmpIntelligentUtil.getJsonObj(entryJsonData, new CmpSyncOrgPositionBean());
            list.add(saveDate);
        }
        return list;
    }
}

