/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.factory.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.sql.record.SocRecordSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.shr.socialSecurity.SocEmpPayStatusFactory;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesFactory;
import com.kingdee.shr.socialSecurity.SocPayFactory;
import com.kingdee.shr.socialSecurity.SocPersonRecordFactory;
import com.kingdee.shr.socialSecurity.SocPersonRecordHisFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SocRecordImpl
extends AbstractRecord {
    @Override
    public List<String> createRecords(Context ctx, List<RecordDataInfo> recList) throws BOSException, EASBizException {
        ArrayList<String> returnList = new ArrayList<String>();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        StringBuilder personBURelStr = new StringBuilder();
        StringBuilder perStr = new StringBuilder();
        ArrayList<String> disablePbuList = new ArrayList<String>();
        if (null == recList || recList.size() <= 0) {
            return disablePbuList;
        }
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SSocPersonRecord", "Fid,FHrOrgUnitID,FPersonId,FPersonBURelationID,FEmpOrgRelationID,FEmpPostExpHisID,FEffectDate,FLeffectDate,FUseDefault,FEmpEffdt");
        int size = recList.size();
        for (int i = 0; i < size; ++i) {
            String id = BOSUuid.create((String)"99AD827E").toString();
            Object[] batchParam = new Object[10];
            RecordDataInfo recordDataInfo = recList.get(i);
            personBURelStr.append("'").append(recordDataInfo.getPersonBURelId()).append("',");
            perStr.append("'").append(recordDataInfo.getPersonId()).append("',");
            batchParam[0] = id;
            batchParam[1] = recordDataInfo.getHrOrgUnitId();
            batchParam[2] = recordDataInfo.getPersonId();
            batchParam[3] = recordDataInfo.getPersonBURelId();
            batchParam[4] = recordDataInfo.getEmpOrgRelationId();
            batchParam[5] = recordDataInfo.getEmpPostExpHisId();
            batchParam[6] = recordDataInfo.getEffdt().before(recordDataInfo.getEnterDate()) ? recordDataInfo.getEnterDate() : recordDataInfo.getEffdt();
            batchParam[7] = null == recordDataInfo.getLeffdt() ? CmpDateUtil.toSqlDate(CmpDateUtil.toDate("2199-12-31")) : recordDataInfo.getLeffdt();
            batchParam[8] = recordDataInfo.getUseDefault();
            batchParam[9] = null == recordDataInfo.getEnterDate() ? recordDataInfo.getEffdt() : (recordDataInfo.getEffdt().before(recordDataInfo.getEnterDate()) ? recordDataInfo.getEnterDate() : recordDataInfo.getEffdt());
            paramsList.add(batchParam);
            returnList.add(id);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return returnList;
    }

    @Override
    public void updateRecords(Context ctx, List<RecordDataInfo> updateList) throws BOSException, EASBizException {
        RecordDataInfo recordDataInfo;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<String> personList = new ArrayList<String>();
        StringBuffer str = new StringBuffer();
        StringBuilder recordBu = new StringBuilder();
        StringBuilder oldPbuBu = new StringBuilder();
        if (null == updateList || updateList.size() <= 0) {
            return;
        }
        for (RecordDataInfo info : updateList) {
            str.append("'").append(info.getPersonBURelId()).append("',");
        }
        HashSet<String> hisSet = new HashSet<String>();
        String hisSql = SocRecordSQL.getNeedToHisRecordSQL(str.substring(0, str.length() - 1));
        IRowSet r = CmpSQLUtil.executeQuery(ctx, hisSql);
        try {
            while (r.next()) {
                hisSet.add(r.getString(1));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        if (hisSet.size() > 0) {
            int size;
            ArrayList<Object[]> paramsList1 = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsList2 = new ArrayList<Object[]>();
            String insertSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SSocPersonRecordHis", "Fid,FHrOrgUnitID,FPersonId,FPersonBURelationID,FEmpOrgRelationID,FEmpPostExpHisID,FEffectDate,FLeffectDate,FUseDefault,FHistoryRelateId,FEmpEffdt");
            String updateNowSql = "update T_HR_SSocPersonRecord set FEffectDate = ? where fid = ?";
            String updateHisSql = "update T_HR_SSocPersonRecordHis set FEffectDate = ? where FHistoryRelateId = ?";
            for (int i = size = updateList.size() - 1; i >= 0; --i) {
                recordDataInfo = updateList.get(i);
                personList.add(recordDataInfo.getPersonId());
                if (!hisSet.contains(recordDataInfo.getPersonBURelId())) continue;
                Object[] batchParam = new Object[11];
                Date effdt = null == recordDataInfo.getOldFEffDate() ? recordDataInfo.getEffdt() : (recordDataInfo.getOldFEffDate().before(recordDataInfo.getEffdt()) ? recordDataInfo.getOldFEffDate() : recordDataInfo.getEffdt());
                effdt = effdt.before(recordDataInfo.getEnterDate()) ? recordDataInfo.getEnterDate() : effdt;
                batchParam[0] = BOSUuid.create((String)"A685A034").toString();
                batchParam[1] = recordDataInfo.getHrOrgUnitId();
                batchParam[2] = recordDataInfo.getPersonId();
                batchParam[3] = recordDataInfo.getPersonBURelId();
                batchParam[4] = recordDataInfo.getEmpOrgRelationId();
                batchParam[5] = recordDataInfo.getEmpPostExpHisId();
                batchParam[6] = effdt;
                batchParam[7] = CmpDateUtil.toSqlDate(CmpDateUtil.toDate("2199-12-31"));
                batchParam[8] = recordDataInfo.getUseDefault();
                batchParam[9] = recordDataInfo.getRecordId();
                batchParam[10] = effdt;
                paramsList1.add(batchParam);
                updateList.remove(i);
                batchParam = new Object[]{effdt, recordDataInfo.getRecordId()};
                paramsList2.add(batchParam);
            }
            CmpSQLUtil.executeBatch(ctx, insertSql, paramsList1);
            CmpSQLUtil.executeBatch(ctx, updateNowSql, paramsList2);
            CmpSQLUtil.executeBatch(ctx, updateHisSql, paramsList2);
            ArrayList<String> pbuIdList = new ArrayList<String>();
            for (String pbuId : hisSet) {
                pbuIdList.add(pbuId);
            }
            RecordUtil.updatePBUState(ctx, pbuIdList, 2, false);
        }
        if (updateList.size() < 1) {
            return;
        }
        str = new StringBuffer();
        str.append(" update T_HR_SSocPersonRecord ");
        str.append(" set FEmpEffdt = ?, FPersonBURelationID = ?, FEmpOrgRelationID = ?,FEmpPostExpHisID = ?, FUseDefault = ?, ");
        str.append(" FLeffectDate = ? ");
        str.append(" where Fid = ? ");
        String updateSql = str.toString();
        int size = updateList.size();
        for (int i = 0; i < size; ++i) {
            recordDataInfo = updateList.get(i);
            Object[] batchParam = new Object[]{recordDataInfo.getEffdt(), recordDataInfo.getPersonBURelId(), recordDataInfo.getEmpOrgRelationId(), recordDataInfo.getEmpPostExpHisId(), recordDataInfo.getUseDefault(), CmpDateUtil.toSqlDate(CmpDateUtil.toDate("2199-12-31")), recordDataInfo.getRecordId()};
            paramsList.add(batchParam);
            if (CmpStrUtil.isEmpty(recordDataInfo.getOldPersonBURelId())) continue;
            recordBu.append("'" + recordDataInfo.getRecordId() + "',");
            oldPbuBu.append("'" + recordDataInfo.getOldPersonBURelId() + "',");
        }
        if (recordBu.length() > 0) {
            String recordId = recordBu.substring(0, recordBu.lastIndexOf(","));
            String sqlExist = " select fid from T_HR_SSocPersonRecordHis where FHISTORYRELATEID in (" + recordId + ")";
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sqlExist);
            if (rs.size() == 0) {
                String recordHisSql = SocRecordSQL.getInsertRecordHisSQL(recordId);
                CmpSQLUtil.executeUpdate(ctx, recordHisSql);
            }
        }
        if (oldPbuBu.length() > 0) {
            String oldPbuIds = oldPbuBu.substring(0, oldPbuBu.lastIndexOf(","));
            RecordUtil.updatePBUState(ctx, oldPbuIds, 2, false);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    @Deprecated
    private void loseRecordByNewRecord(Context ctx, String personBURelIds, String personIds) {
        String udpateSql = SocRecordSQL.getNeedLoseRecordSQL(personBURelIds, personIds);
        try {
            CmpSQLUtil.executeUpdate(ctx, udpateSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loseRecords(Context ctx, List<String> cmpRecordIds, Date leffectDate) throws BOSException, EASBizException {
        String sqlStr = SocRecordSQL.getloseCmpRecordsSQL(CmpStrUtil.convertListToString(cmpRecordIds), leffectDate);
        CmpSQLUtil.executeUpdate(ctx, sqlStr);
    }

    @Override
    public void loseRecords(Context ctx, Map<String, Date> recordMap) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        for (Map.Entry<String, Date> entry : recordMap.entrySet()) {
            Object[] batchParam = new Object[]{entry.getValue(), entry.getKey()};
            paramsList.add(batchParam);
        }
        String recordSql = SQLHandleUtil.getUpdateSql("T_HR_SSocPersonRecord", "FLeffectDate", "fid", null);
        CmpSQLUtil.executeBatch(ctx, recordSql, paramsList);
        String recordIds = CmpStrUtil.converMapToString(recordMap);
        String pbuIds = "select FPersonBURelationID from T_HR_SSocPersonRecord where fid in (" + recordIds + ")";
        RecordUtil.updatePBUState(ctx, pbuIds, 2, false);
    }

    @Override
    public void deleteRecords(Context ctx, String recordIds, boolean isDelete) throws BOSException, EASBizException {
        if (!recordIds.contains("'")) {
            recordIds = "'" + recordIds + "'";
        }
        String oql = " select FPersonBURelationID from T_HR_SSocPersonRecord where fid in (" + recordIds + ")";
        if (isDelete) {
            PersonBURelationFactory.getLocalInstance((Context)ctx).delete(" where id in (" + oql + ")");
        } else {
            String updateSql = "update T_HR_PersonBURelation set FState = 0, FEndDate = NOW() where fid = (" + oql + ")";
            CmpSQLUtil.executeUpdate(ctx, updateSql);
        }
        SocPayFactory.getLocalInstance((Context)ctx).delete("where socPersonRecord.id in (" + recordIds + ")");
        SocEmpPayStatusFactory.getLocalInstance((Context)ctx).delete("where socPersonRecord.id in (" + recordIds + ")");
        SocEmpSocFilesFactory.getLocalInstance((Context)ctx).delete("where id in (select fid from T_HR_SSocEmpSocFiles where FBillID in(" + recordIds + "))");
        String pbuHisSql = "select FPersonBURelationID from T_HR_SSocPersonRecordHis where FHistoryRelateId in (" + recordIds + ")";
        PersonBURelationFactory.getLocalInstance((Context)ctx).delete(" where id in (" + pbuHisSql + ")");
        SocPersonRecordHisFactory.getLocalInstance((Context)ctx).delete(" where historyRelateId in (" + recordIds + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SCmpIntelMatchData where FCMPINTELCATALOGID in ('4zLXKaEJukGwTPFYcVyZlQB4WXA=','ecnRgrVrakexjc9fhpQpwwB4WXA=') and  FPersonID in (select FPersonId from T_HR_SSocPersonRecord where fid in (" + recordIds + ") ) ");
        SocPersonRecordFactory.getLocalInstance((Context)ctx).delete(" where id in (" + recordIds + ")");
    }
}

