/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.validator;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.sql.record.AdjustRecordSQL;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public class RecordValidatorUtils {
    private JSONObject getErrorInfo(String personId, String dataType, String domain, String module, String operation, String msg) {
        JSONObject info = new JSONObject();
        if ("PERSON".equals(dataType)) {
            info.put("personId", (Object)personId);
        } else if ("RELATION".equals(dataType)) {
            info.put("code", (Object)personId);
        }
        info.put("domain", (Object)domain);
        info.put("modules", (Object)module);
        info.put("operation", (Object)operation);
        info.put("msg", (Object)msg);
        return info;
    }

    public JSONObject getTaxUnitPerson(Context ctx, String personIds) throws SQLException, BOSException {
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" SELECT A02.FNAME_" + l + " PERSONNAME, A03.FNAME_L2 TAXNAME, A02.FID FPERSONID");
        str.append(" FROM T_HR_STAXOPTIMIZE A01 ");
        str.append(" INNER JOIN T_BD_PERSON A02 ON A01.FPERSONID = A02.FID ");
        str.append(" INNER JOIN T_HR_TAXUNIT A03 ON A01.FTAXUNITID = A03.FID ");
        str.append(" WHERE A02.FID IN ('" + personIds + "')");
        IRowSet r = CmpSQLUtil.executeQuery(ctx, str.toString());
        JSONObject info = null;
        if (r.next()) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label46", (Locale)ctx.getLocale()), r.getString("PERSONNAME"), r.getString("TAXNAME"));
            info = this.getErrorInfo(r.getString("FPERSONID"), "PERSON", EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label51", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label52", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label53", (Locale)ctx.getLocale()), msg);
        }
        return info;
    }

    public JSONObject getCmpCalTablePerson(Context ctx, String billId, String dataType) throws SQLException, BOSException, EASBizException {
        String sql = "PERSON".equals(dataType) ? CmpRecordSQL.beforeDeletePerson(billId, ctx) : CmpRecordSQL.beforeDeletePersonByRelationID(billId, ctx);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        JSONObject info = null;
        if (rowSet.next()) {
            String message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label54", (Locale)ctx.getLocale());
            info = this.getErrorInfo(rowSet.getString("PersonId"), dataType, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label51", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label52", (Locale)ctx.getLocale()), "CALTABLE", message);
        }
        return info;
    }

    public JSONObject getFixAdjustSalaryPerson(Context ctx, String billId, String dataType) throws BOSException, SQLException {
        String sql = "PERSON".equals(dataType) ? AdjustRecordSQL.beforeDeletePerson(billId, ctx) : AdjustRecordSQL.beforeDeletePersonByRelationID(billId, ctx);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql.toString());
        JSONObject info = null;
        if (rowSet.next()) {
            info = this.getErrorInfo(rowSet.getString("PersonId"), dataType, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label51", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label55", (Locale)ctx.getLocale()), "ADJUSTSALARY", EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label56", (Locale)ctx.getLocale()));
        }
        return info;
    }

    public JSONObject getBatchAdjustBillPerson(Context ctx, String billId, String dataType) throws BOSException, SQLException {
        String sql = "PERSON".equals(dataType) ? AdjustRecordSQL.getBatchAdjustBillPerson(billId, ctx) : AdjustRecordSQL.getBatchAdjustBillPersonByRelationID(billId, ctx);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql.toString());
        String personId = "";
        String billTips = "";
        while (rowSet.next()) {
            personId = rowSet.getString(1);
            billTips = billTips + rowSet.getString(2) + ",";
        }
        JSONObject info = null;
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)billTips)) {
            billTips = billTips.substring(0, billTips.length() - 1);
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label57", (Locale)ctx.getLocale()), billTips);
            info = this.getErrorInfo(personId, dataType, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label51", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label55", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label58", (Locale)ctx.getLocale()), msg);
        }
        return info;
    }

    public JSONObject getBatchSubmitBillPerson(Context ctx, String billId, String dataType) throws BOSException, SQLException {
        StringBuilder queryTableSql = new StringBuilder();
        queryTableSql.append("select fbillentrytablename from T_HR_SCalShemeTableRelation  R where R.fbillentrytablename is not null");
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, queryTableSql.toString());
        ArrayList<String> entryTableNames = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        while (rowSet.next()) {
            String entryTable = rowSet.getString("fbillEntryTableName");
            sql.append("select count(*) as result from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fcmpemporelationid' and KSQL_COL_TABNAME='" + entryTable + "'");
            IRowSet r = CmpSQLUtil.executeQuery(ctx, sql.toString());
            if (r.next() && r.getInt("result") > 0) {
                entryTableNames.add(entryTable);
            }
            sql.setLength(0);
        }
        StringBuilder queryEntrySql = new StringBuilder();
        int size = entryTableNames.size();
        String personId = "";
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            String querySql = "PERSON".equals(dataType) ? AdjustRecordSQL.getBatchSubmitBillPerson(billId, (String)entryTableNames.get(i)) : AdjustRecordSQL.getBatchSubmitBillPersonByRelationID(billId, (String)entryTableNames.get(i));
            queryEntrySql.append(querySql);
            if (i != 0 && i % 10 == 0 || i == size - 1) {
                rowSet = CmpSQLUtil.executeQuery(ctx, queryEntrySql.toString());
                while (rowSet.next()) {
                    personId = rowSet.getString("fpersonid");
                    billIds.add(rowSet.getString("fbillid"));
                }
                queryEntrySql.setLength(0);
                continue;
            }
            queryEntrySql.append(" UNION ALL ");
        }
        String billTips = "";
        if (billIds.size() > 0) {
            StringBuilder queryBillSql = new StringBuilder();
            queryBillSql.append("select fnumber from T_HR_SBatchSubmitShemeBill where fid in (" + CmpStrUtil.convertSetToSqlString(billIds) + ")");
            rowSet = CmpSQLUtil.executeQuery(ctx, queryBillSql.toString());
            while (rowSet.next()) {
                billTips = billTips + rowSet.getString("fnumber") + ",";
            }
            if (!StringUtils.isEmpty((String)billTips)) {
                billTips = billTips.substring(0, billTips.length() - 1);
            }
        }
        JSONObject info = null;
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)billTips)) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label59", (Locale)ctx.getLocale()), billTips);
            info = this.getErrorInfo(personId, dataType, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label51", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label52", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label60", (Locale)ctx.getLocale()), msg);
        }
        return info;
    }

    public JSONObject getAdjustSalaryApplyPerson(Context ctx, String billId, String dataType) throws BOSException, SQLException {
        StringBuilder queryTableSql = new StringBuilder();
        queryTableSql.append("select fbillentrytablename from T_HR_SAdjSalaryTableRelation  R where R.fbillentrytablename is not null");
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, queryTableSql.toString());
        ArrayList<String> entryTableNames = new ArrayList<String>();
        while (rowSet.next()) {
            entryTableNames.add(rowSet.getString("fbillEntryTableName"));
        }
        StringBuilder queryEntrySql = new StringBuilder();
        int size = entryTableNames.size();
        String personId = "";
        String billTips = "";
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            String sql = "PERSON".equals(dataType) ? AdjustRecordSQL.getAdjustSalaryApplyPerson(billId, (String)entryTableNames.get(i)) : AdjustRecordSQL.getAdjustSalaryApplyPersonByRelationID(billId, (String)entryTableNames.get(i));
            queryEntrySql.append(sql);
            if (i % 10 == 0 || i == size - 1) {
                rowSet = CmpSQLUtil.executeQuery(ctx, queryEntrySql.toString());
                while (rowSet.next()) {
                    personId = rowSet.getString("fpersonid");
                    billIds.add(rowSet.getString("fbillid"));
                }
                queryEntrySql.setLength(0);
                continue;
            }
            queryEntrySql.append(" UNION ALL ");
        }
        if (billIds.size() > 0) {
            StringBuilder queryBillSql = new StringBuilder();
            queryBillSql.append("select fnumber from T_HR_SAdjustSalaryApply where fid in (" + CmpStrUtil.convertSetToSqlString(billIds) + ")");
            rowSet = CmpSQLUtil.executeQuery(ctx, queryBillSql.toString());
            while (rowSet.next()) {
                billTips = billTips + rowSet.getString("fnumber") + ",";
            }
            if (!StringUtils.isEmpty((String)billTips)) {
                billTips = billTips.substring(0, billTips.length() - 1);
            }
        }
        JSONObject info = null;
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)billTips)) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label61", (Locale)ctx.getLocale()), billTips);
            info = this.getErrorInfo(personId, dataType, EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label51", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label55", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label62", (Locale)ctx.getLocale()), msg);
        }
        return info;
    }
}

