/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.budget.dto.BudgetDataTreeNodeInfo;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalFuncGetOrgBudgetService
extends SalaryCalFunction2 {
    private final String itemKey = "CalFuncGetOrgBudgetService_getSubOrgBudgetSum_ITEM";

    public double getSubOrgBudgetSum(Context ctx, String mainTableName, String calSchemeId, Map paramMap, HashMap tempMap, String mainTableRowFilter, String itemNumber) {
        String tn = this.getTnByNumber(ctx, calSchemeId, tempMap, itemNumber);
        if (tn == null) {
            return 0.0;
        }
        Map<String, BudgetDataTreeNodeInfo> budgetDataTree = this.getBudgetDataTree(ctx);
        String curAdmin = (String)paramMap.get("T_ORG_ADMIN_ADMINORGUNIT_FID");
        String curCostType = (String)paramMap.get("T_HR_COSTTYPE_COSTTYPE_FID");
        BudgetDataTreeNodeInfo nodeInfo = budgetDataTree.get(curAdmin);
        List<BudgetDataTreeNodeInfo> children = nodeInfo.getChildren();
        BigDecimal sum = BigDecimal.ZERO;
        if (null != children) {
            String fieldKey = curCostType + "_" + tn;
            for (BudgetDataTreeNodeInfo info : children) {
                BigDecimal valueB = this.getRealValue(info, fieldKey, true);
                sum = sum.add(valueB);
            }
        }
        return sum.doubleValue();
    }

    protected String getTnByNumber(Context ctx, String calSchemeId, HashMap tempMap, String itemNumber) {
        if (tempMap.get("CalFuncGetOrgBudgetService_getSubOrgBudgetSum_ITEM") == null) {
            tempMap.put("CalFuncGetOrgBudgetService_getSubOrgBudgetSum_ITEM", this.getBudgetTempItemMap(ctx, calSchemeId));
        }
        Map resultMap = (Map)tempMap.get("CalFuncGetOrgBudgetService_getSubOrgBudgetSum_ITEM");
        return (String)resultMap.get(itemNumber);
    }

    protected Map<String, BudgetDataTreeNodeInfo> getBudgetDataTree(Context ctx) {
        String uid = this.getUid();
        String cacheKey = MD5Util.getMD5String((String)(uid + ctx));
        CacheService cacheService = CacheService.getInstance();
        return (Map)cacheService.hget("shr.validateruleCache", cacheKey, "BUDGET_MANAGE_TREEDATA_CACHE_KEY");
    }

    protected BigDecimal getBigValue(Object value) {
        BigDecimal objectBigDecimal = value instanceof String ? new BigDecimal(value.toString()) : (value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.ZERO);
        return objectBigDecimal;
    }

    protected Map<String, String> getBudgetTempItemMap(Context ctx, String calSchemeId) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" SELECT ");
        sqlBuilder.append(" c.FieldSn,c.fnumber  ");
        sqlBuilder.append(" FROM T_HR_SBudgetTemplateItem ti ");
        sqlBuilder.append(" left join T_HR_SCmpBudgetScheme s on s.FTemplateID = ti.FTemplateID ");
        sqlBuilder.append(" left join T_HR_SCmpBudgetItem c on c.FID=ti.FBudgetItemID ");
        sqlBuilder.append(" where s.FID = ? ");
        sqlBuilder.append(" order by ti.FSortSn asc,c.FIndex asc ");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{calSchemeId});
            while (executeQuery.next()) {
                String resultKey = executeQuery.getString("fnumber");
                String resultValue = "T" + executeQuery.getString("FIELDSN");
                resultMap.put(resultKey, resultValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public double getParentBudget(Context ctx, String mainTableName, String calSchemeId, Map paramMap, HashMap tempMap, String mainTableRowFilter, String itemNumber) {
        double result = Double.MAX_VALUE;
        String tn = this.getTnByNumber(ctx, calSchemeId, tempMap, itemNumber);
        if (tn == null) {
            return 0.0;
        }
        Map<String, BudgetDataTreeNodeInfo> budgetDataTree = this.getBudgetDataTree(ctx);
        String curAdmin = (String)paramMap.get("T_ORG_ADMIN_ADMINORGUNIT_FID");
        String curCostType = (String)paramMap.get("T_HR_COSTTYPE_COSTTYPE_FID");
        BudgetDataTreeNodeInfo nodeInfo = budgetDataTree.get(curAdmin);
        String parentId = nodeInfo.getParentId();
        BudgetDataTreeNodeInfo parent = budgetDataTree.get(parentId);
        if (null != parent) {
            String fieldKey = curCostType + "_" + tn;
            BigDecimal valueB = this.getRealValue(parent, fieldKey, false);
            result = valueB.doubleValue();
        }
        return result;
    }

    public double getCurLevelOrgBudgetSum(Context ctx, String mainTableName, String calSchemeId, Map paramMap, HashMap tempMap, String mainTableRowFilter, String itemNumber) {
        double result = 0.0;
        String tn = this.getTnByNumber(ctx, calSchemeId, tempMap, itemNumber);
        if (tn == null) {
            return result;
        }
        Map<String, BudgetDataTreeNodeInfo> budgetDataTree = this.getBudgetDataTree(ctx);
        String curAdmin = (String)paramMap.get("T_ORG_ADMIN_ADMINORGUNIT_FID");
        String curCostType = (String)paramMap.get("T_HR_COSTTYPE_COSTTYPE_FID");
        BudgetDataTreeNodeInfo nodeInfo = budgetDataTree.get(curAdmin);
        String parentId = nodeInfo.getParentId();
        BudgetDataTreeNodeInfo parent = budgetDataTree.get(parentId);
        BigDecimal sum = BigDecimal.ZERO;
        if (null != parent && null != parent.getChildren()) {
            String fieldKey = curCostType + "_" + tn;
            List<BudgetDataTreeNodeInfo> children = parent.getChildren();
            for (BudgetDataTreeNodeInfo info : children) {
                BigDecimal valueB = this.getRealValue(info, fieldKey, true);
                sum = sum.add(valueB);
            }
        }
        return sum.doubleValue();
    }

    private BigDecimal getRealValue(BudgetDataTreeNodeInfo info, String fieldKey, boolean isMaxValue) {
        Map<String, Object> curData = info.getCurData();
        BigDecimal valueB = BigDecimal.ZERO;
        BigDecimal curV = BigDecimal.ZERO;
        if (null != curData && curData.containsKey(fieldKey)) {
            Object value = curData.get(fieldKey);
            curV = this.getBigValue(value);
        }
        Map<String, Object> processData = info.getProcessData();
        String fieldKeyM = fieldKey.replace("_T", "_M");
        if (null == processData || !processData.containsKey(fieldKeyM)) {
            return curV;
        }
        BigDecimal proV = BigDecimal.ZERO;
        if (null != processData && processData.containsKey(fieldKeyM)) {
            Object valuePO = processData.get(fieldKeyM);
            proV = this.getBigValue(valuePO);
        }
        valueB = isMaxValue ? (curV.compareTo(proV) > 0 ? curV : proV) : (curV.compareTo(proV) > 0 ? proV : curV);
        return valueB;
    }
}

