/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotTotalCmpCollection;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotTotalCmpFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotTotalCmpInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpStandingBookInfo;
import com.kingdee.shr.compensation.app.budget.DataStateEnum;
import com.kingdee.shr.compensation.app.budget.ExpenseDetailsCmpCollection;
import com.kingdee.shr.compensation.app.budget.ExpenseDetailsCmpFactory;
import com.kingdee.shr.compensation.app.budget.ExpenseDetailsCmpInfo;
import com.kingdee.shr.compensation.app.budget.SubCmpStandingBookInfo;
import com.kingdee.shr.compensation.app.budget.UpdateDirectionEnum;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigCollection;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigInfo;
import com.kingdee.shr.compensation.app.cmpBudget.DeduNodeEnum;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.service.budget.BudgetAndUsedData;
import com.kingdee.shr.compensation.service.budget.BudgetData;
import com.kingdee.shr.compensation.service.budget.CalTableExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.DeductionCmpCalUnit;
import com.kingdee.shr.compensation.service.budget.DeductionParam;
import com.kingdee.shr.compensation.service.budget.DeductionParamCmpCal;
import com.kingdee.shr.compensation.service.budget.ExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.OrgDeduction;
import com.kingdee.shr.compensation.service.budget.impl.AbstractDeductionService;
import com.kingdee.shr.compensation.service.budget.impl.CmpCalPersonParam;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class CmpCalDeductionService
extends AbstractDeductionService {
    private BudgetDeductionConfigCollection deduConfigCollection;
    private BudgetDeductionConfigCollection offsetConfigCollection;
    protected List<BudgetSnapshotTotalCmpInfo> initDeduSnapshots = new ArrayList<BudgetSnapshotTotalCmpInfo>();
    protected List<BudgetSnapshotTotalCmpInfo> finalDeduSnapshots = new ArrayList<BudgetSnapshotTotalCmpInfo>();
    protected BudgetSnapshotTotalCmpCollection lastDeductSnapshots;
    protected Map<String, ExchangeRateInfo> rateInfoMap = new HashMap<String, ExchangeRateInfo>();
    private static final Logger LOG = Logger.getLogger(CmpCalDeductionService.class);
    private BudgetDeductionConfigInfo deduConfig;
    private String costBearOrgId;
    private DeductionCmpCalUnit currentDeductUnit;

    @Override
    protected boolean isReverseApprove(DeductionParam deductionParam) {
        return false;
    }

    @Override
    protected void doRollback(boolean isReverseApprove) throws BOSException, EASBizException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String calTableIds = param.getCmpCalTableIds(this.ctx);
        BudgetSnapshotTotalCmpCollection snapshotCollection = this.getSnapshot4RollBackByNode(calTableIds, param.getCmpDeductNodeEnum());
        Map<String, BudgetSnapshotTotalCmpCollection> nodes = this.groupBudgetSnapshotTotalCmpInfoByNode(snapshotCollection);
        for (BudgetSnapshotTotalCmpCollection collection : nodes.values()) {
            CmpBudgetItemInfo cmpBudgetItem = collection.get(0).getCmpBudgetItem();
            BudgetTemplateSTBItemInfo templateStbItem = collection.get(0).getTemplateStbItem();
            this.budgetPeriod = templateStbItem.getTemplate().getBudgetPeriod();
            this.rollbackByNode(cmpBudgetItem, templateStbItem, param.getCmpDeductNodeEnum(), collection);
        }
    }

    private Map<String, BudgetSnapshotTotalCmpCollection> groupBudgetSnapshotTotalCmpInfoByNode(BudgetSnapshotTotalCmpCollection snapshotCollection) {
        HashMap<String, BudgetSnapshotTotalCmpCollection> nodes = new HashMap<String, BudgetSnapshotTotalCmpCollection>();
        for (int i = 0; i < snapshotCollection.size(); ++i) {
            String key = snapshotCollection.get(i).getCmpBudgetItem().getId().toString();
            BudgetSnapshotTotalCmpCollection collection = (BudgetSnapshotTotalCmpCollection)nodes.get(key);
            if (collection == null) {
                collection = new BudgetSnapshotTotalCmpCollection();
                nodes.put(key, collection);
            }
            collection.add(snapshotCollection.get(i));
        }
        return nodes;
    }

    protected void rollbackByNode(CmpBudgetItemInfo cmpBudgetItem, BudgetTemplateSTBItemInfo templateStbItem, DeduNodeEnum deduNode, BudgetSnapshotTotalCmpCollection snapshotCollection) throws BOSException, EASBizException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String stdBookItem = "S" + templateStbItem.getStandingBookItem().getFieldSn();
        if (snapshotCollection == null || snapshotCollection.isEmpty()) {
            LOG.error((Object)"=====>\u5f53\u524d\u7684\u914d\u7f6e\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u5feb\u7167\u6570\u636e, \u56de\u6eda\u5904\u7406\u5931\u8d25");
            return;
        }
        HashMap<String, BigDecimal> sumValueForOffsetMap = new HashMap<String, BigDecimal>();
        String splitFlag = "###";
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotTotalCmpInfo snapshotInfo = snapshotCollection.get(j);
            String bookTableId = snapshotInfo.getCmpStandingBook().getId().toString();
            SubCmpStandingBookInfo sub = snapshotInfo.getSubCmpStandingBook();
            String subBookTableId = "";
            if (null != sub) {
                subBookTableId = snapshotInfo.getSubCmpStandingBook().getId().toString();
            }
            if (StringUtils.isEmpty((String)bookTableId)) {
                LOG.error((Object)"=====>bookTableId\u4e3a\u7a7a, \u56de\u6eda\u5904\u7406\u5931\u8d25");
                continue;
            }
            String key = bookTableId + splitFlag + subBookTableId;
            BigDecimal sumVal = (BigDecimal)sumValueForOffsetMap.get(key);
            if (sumVal == null) {
                sumVal = BigDecimal.ZERO;
            }
            BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
            sumVal = sumVal.add(value);
            sumValueForOffsetMap.put(key, sumVal);
            snapshotInfo.setIsRollback(true);
        }
        this.updateBookTableDataOfRollback(templateStbItem, sumValueForOffsetMap, splitFlag);
        this.recordRollbackSnapshot(snapshotCollection);
        String reverseOffsetOql = "select cmpBudgetItemRel.cmpBudgetItem.fieldSn, cmpBudgetItemRel.cmpBudgetItem.id, cmpBudgetItemRel.standingBookItem.id, cmpBudgetItemRel.standingBookItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.id where calScheme = '" + this.deductionParam.getCalSchemeId() + "' and cmpBudgetItemRel.cmpBudgetItem.id = '" + cmpBudgetItem.getId().toString() + "' and offsetNode = " + deduNode.getValue();
        BudgetDeductionConfigCollection offsetConfigCollection = BudgetDeductionConfigFactory.getLocalInstance((Context)this.ctx).getBudgetDeductionConfigCollection(reverseOffsetOql);
        if (offsetConfigCollection == null || offsetConfigCollection.isEmpty()) {
            this.deleteExpenseDetails(param.getCmpCalTableIds(this.ctx));
            return;
        }
        this.updateExpenseDetailsAfterRollback(stdBookItem, snapshotCollection);
        BudgetSnapshotTotalCmpCollection collection = this.reverseOffsetData(param.getCmpCalTableIds(this.ctx), offsetConfigCollection.get(0));
        String offsetField = "S" + offsetConfigCollection.get(0).getCmpBudgetItemRel().getStandingBookItem().getFieldSn();
        this.updateExpenseDetails4Offset(offsetField, collection);
    }

    protected void updateExpenseDetails4Offset(String offsetField, BudgetSnapshotTotalCmpCollection snapshots) throws BOSException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object[]> snapshotParams = new ArrayList<Object[]>();
        boolean hasPeriod = this.budgetPeriod != BudgetPeriodEnum.YEAR;
        for (int i = 0; i < snapshots.size(); ++i) {
            Object[] snapshotParam = new Object[]{snapshots.get(i).isIsRollbackOffset() ? 1 : 0, snapshots.get(i).getId().toString()};
            snapshotParams.add(snapshotParam);
            Object[] param = hasPeriod ? new Object[4] : new Object[]{snapshots.get(i).getValue(), snapshots.get(i).getCalTable().getId().toString(), snapshots.get(i).getCostBearOrg().getId().toString()};
            if (hasPeriod) {
                param[3] = snapshots.get(i).getSubCmpStandingBook().getId().toString();
            }
            params.add(param);
        }
        String updateSQL = hasPeriod ? "update T_HR_SExpenseDetailsBase set " + offsetField + " = " + offsetField + " + ? where fid in (select base.fid from T_HR_SExpenseDetailsBase base, T_HR_SExpenseDetailsCmp smt     where base.fid = smt.fBaseId and smt.FCmpCalTableId = ? and base.FCostBearOrgId = ? and base.FSubStandingBookId = ?)" : "update T_HR_SExpenseDetailsBase set " + offsetField + " = " + offsetField + " + ? where fid in (select base.fid from T_HR_SExpenseDetailsBase base, T_HR_SExpenseDetailsCmp smt     where base.fid = smt.fBaseId and smt.FCmpCalTableId = ? and base.FCostBearOrgId = ?)";
        DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
        DbUtil.executeBatch((Context)this.ctx, (String)"update T_HR_BudgetSnapshotTotalCmp set FIsRollbackOffset = ? where fid = ?", snapshotParams);
    }

    protected void updateExpenseDetailsAfterRollback(String stdBookItem, BudgetSnapshotTotalCmpCollection snapshots) throws BOSException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        boolean hasPeriod = this.budgetPeriod != BudgetPeriodEnum.YEAR;
        for (int i = 0; i < snapshots.size(); ++i) {
            Object[] param = hasPeriod ? new Object[4] : new Object[]{snapshots.get(i).getValue(), snapshots.get(i).getCalTable().getId().toString(), snapshots.get(i).getCostBearOrg().getId().toString()};
            if (hasPeriod) {
                param[3] = snapshots.get(i).getSubCmpStandingBook().getId().toString();
            }
            params.add(param);
        }
        String updateSQL = hasPeriod ? "update T_HR_SExpenseDetailsBase set " + stdBookItem + " = " + stdBookItem + " - ? where fid in (select base.fid from T_HR_SExpenseDetailsBase base, T_HR_SExpenseDetailsCmp smt     where base.fid = smt.fBaseId and smt.FCmpCalTableId = ? and base.FCostBearOrgId = ? and base.FSubStandingBookId = ?)" : "update T_HR_SExpenseDetailsBase set " + stdBookItem + " = " + stdBookItem + " - ? where fid in (select base.fid from T_HR_SExpenseDetailsBase base, T_HR_SExpenseDetailsCmp smt     where base.fid = smt.fBaseId and smt.FCmpCalTableId = ? and base.FCostBearOrgId = ?)";
        DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, params);
    }

    protected BudgetSnapshotTotalCmpCollection reverseOffsetData(String cmpCalTableIds, BudgetDeductionConfigInfo offsetConfig) throws BOSException, EASBizException {
        BudgetSnapshotTotalCmpCollection collection = new BudgetSnapshotTotalCmpCollection();
        BudgetTemplateSTBItemInfo templateStbItemOffset = offsetConfig.getCmpBudgetItemRel();
        if (templateStbItemOffset == null || templateStbItemOffset.getId() == null || templateStbItemOffset.getStandingBookItem() == null) {
            return collection;
        }
        CmpBudgetItemInfo cmpBudgetItemOffset = offsetConfig.getCmpBudgetItemRel().getCmpBudgetItem();
        if (cmpBudgetItemOffset == null || cmpBudgetItemOffset.getId() == null) {
            return collection;
        }
        BudgetSnapshotTotalCmpCollection snapshotNeedToReverseOffset = this.getSnapshotNeedToReverseOffset(cmpCalTableIds, cmpBudgetItemOffset.getId().toString(), templateStbItemOffset.getId().toString());
        String reSplitFlag = "###";
        HashMap<String, BigDecimal> sumValueForReOffsetMap = new HashMap<String, BigDecimal>();
        for (int k = 0; k < snapshotNeedToReverseOffset.size(); ++k) {
            String key;
            BigDecimal sumVal;
            BudgetSnapshotTotalCmpInfo snapshotInfo = snapshotNeedToReverseOffset.get(k);
            String bookTableId = snapshotInfo.getCmpStandingBook().getId().toString();
            SubCmpStandingBookInfo sub = snapshotInfo.getSubCmpStandingBook();
            String subBookTableId = "";
            if (null != sub) {
                subBookTableId = snapshotInfo.getSubCmpStandingBook().getId().toString();
            }
            if ((sumVal = (BigDecimal)sumValueForReOffsetMap.get(key = bookTableId + reSplitFlag + subBookTableId)) == null) {
                sumVal = BigDecimal.ZERO;
            }
            BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
            sumVal = sumVal.subtract(value);
            sumValueForReOffsetMap.put(key, sumVal);
            snapshotInfo.setIsRollbackOffset(true);
            collection.add(snapshotInfo);
        }
        this.updateBookTableDataOfReOffset(offsetConfig.getCmpBudgetItemRel(), sumValueForReOffsetMap, reSplitFlag);
        this.recordReOffsetSnapshot(snapshotNeedToReverseOffset);
        return collection;
    }

    protected void recordReOffsetSnapshot(BudgetSnapshotTotalCmpCollection snapshotCollection) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotTotalCmpInfo snapshotInfo = snapshotCollection.get(j);
            if (!snapshotInfo.isIsRollbackOffset()) continue;
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setLastUpdateUser(this.user);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotFactory.getLocalInstance((Context)this.ctx).saveBatchData(updateSnapshotColl);
        }
    }

    protected BudgetSnapshotTotalCmpCollection getSnapshotNeedToReverseOffset(String entryIdInSql, String budgetItemId, String templateStbItemId) throws BOSException {
        String oqlBuilder = "select *, templateStbItem.standingBookItem.fieldSn where calScheme.id ='" + this.deductionParam.getCalSchemeId() + "' and cmpBudgetItem.id = '" + budgetItemId + "' and templateStbItem.id ='" + templateStbItemId + "' and calTable.id in " + entryIdInSql + " and dataState = " + 30 + " and isOffset = 1  and (isRollbackOffset = 0 or isRollbackOffset is null) ";
        return BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).getBudgetSnapshotTotalCmpCollection(oqlBuilder);
    }

    private void deleteExpenseDetails(String calTableIds) throws BOSException {
        String sql = "delete from T_HR_SExpenseDetailsBase where Fid in (select FBaseId from T_HR_SExpenseDetailsCmp where FCmpCalTableID in " + calTableIds + ")";
        DbUtil.execute((Context)this.ctx, (String)sql);
        sql = "delete from T_HR_SExpenseDetailsCmp where FCmpCalTableID in " + calTableIds;
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    protected void recordRollbackSnapshot(BudgetSnapshotTotalCmpCollection snapshotCollection) throws BOSException, EASBizException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        CoreBaseCollection insertCoreBaseColl = new CoreBaseCollection();
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotTotalCmpInfo snapshotInfo = snapshotCollection.get(j);
            snapshotInfo.setId(null);
            snapshotInfo.setCreateTime(this.now);
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setDataState(DataStateEnum.ROLLBACK);
            snapshotInfo.setUpdateDirection(UpdateDirectionEnum.ADD);
            snapshotInfo.setUpdateNode(param.getCmpDeductNodeEnum());
            snapshotInfo.setIsOffset(false);
            snapshotInfo.setIsRollback(false);
            snapshotInfo.setIsRollbackOffset(false);
            snapshotInfo.setCreator(this.user);
            snapshotInfo.setLastUpdateUser(this.user);
            snapshotInfo.setIsRollback(true);
            insertCoreBaseColl.add((CoreBaseInfo)snapshotInfo);
        }
        if (insertCoreBaseColl.size() > 0) {
            BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).saveBatchData(insertCoreBaseColl);
        }
    }

    protected BudgetSnapshotTotalCmpCollection getSnapshot4RollBackByNode(String calTableIds, DeduNodeEnum deduNode) throws BOSException {
        String oqlBuilder = "select *, cmpBudgetItem.id, cmpBudgetItem.fieldSn, templateStbItem.id, templateStbItem.standingBookItem.id, templateStbItem.standingBookItem.fieldSn, templateStbItem.balanceLedgerItem.fieldSn, templateStbItem.template.budgetPeriod  where calScheme.id ='" + this.deductionParam.getCalSchemeId() + "' and updateNode = " + deduNode.getValue() + " and calTable.id in " + calTableIds + " and dataState != " + 30 + " order by createTime desc";
        BudgetSnapshotTotalCmpCollection collection = BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).getBudgetSnapshotTotalCmpCollection(oqlBuilder);
        if (collection.isEmpty()) {
            return collection;
        }
        Iterator iterator = collection.iterator();
        HashSet rollbackSet = Sets.newHashSet();
        HashSet deductionSet = Sets.newHashSet();
        while (iterator.hasNext()) {
            BudgetSnapshotTotalCmpInfo info = (BudgetSnapshotTotalCmpInfo)iterator.next();
            String cmpCalTableId = info.getCalTable().getId().toString();
            String costBearOrgId = info.getCostBearOrg().getId().toString();
            String subCmpStandingBookId = info.getSubCmpStandingBook() == null ? null : info.getSubCmpStandingBook().getId().toString();
            String budgetItemId = info.getCmpBudgetItem().getId().toString();
            String key = cmpCalTableId + "_" + costBearOrgId + "_" + budgetItemId + "_" + subCmpStandingBookId;
            boolean isRollback = info.isIsRollback();
            boolean isRollbackOffset = info.isIsRollbackOffset();
            if (isRollback || isRollbackOffset) {
                rollbackSet.add(key);
                iterator.remove();
                continue;
            }
            if (deductionSet.contains(key) || rollbackSet.contains(key)) {
                iterator.remove();
                continue;
            }
            DataStateEnum dataState = info.getDataState();
            if (dataState != DataStateEnum.DEDUCT) continue;
            deductionSet.add(key);
        }
        return collection;
    }

    @Override
    protected boolean loadRollbackDeduConfigInfo(boolean isReverseApprove) throws BOSException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String deductOql = "select deduNode, rollBackNode, offsetNode, calScheme.budgetTemplate.budgetPeriod, cmpBudgetItemRel.id, cmpBudgetItemRel.cmpBudgetItem.id, cmpBudgetItemRel.cmpBudgetItem.fieldSn, cmpBudgetItemRel.standingBookItem.id, cmpBudgetItemRel.standingBookItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.id where calScheme = '" + param.getCalSchemeId() + "' and rollBackNode = " + param.getCmpRollbackNodeEnum().getValue();
        this.deduConfigCollection = BudgetDeductionConfigFactory.getLocalInstance((Context)this.ctx).getBudgetDeductionConfigCollection(deductOql);
        return this.deduConfigCollection != null && !this.deduConfigCollection.isEmpty();
    }

    @Override
    protected String getExtendInsertSQL(ExpenseDetailsVO expense, String baseId) {
        CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)expense;
        return "insert into T_HR_SExpenseDetailsCmp (Fid, FBudgetYear, FCmpCalTableId, FCalCurrencyId, FBaseId) values (newBosId('6E1FA015'), " + expense.getBudgetYear() + ", '" + vo.getCmpCalTableId() + "', '" + vo.getCalCurrencyId() + "', '" + baseId + "')";
    }

    @Override
    protected void initLastDeductionSnapshots() throws BOSException {
        if (this.offsetConfigCollection.isEmpty()) {
            return;
        }
        HashSet<String> rels = new HashSet<String>();
        for (int i = 0; i < this.offsetConfigCollection.size(); ++i) {
            rels.add(this.offsetConfigCollection.get(i).getCmpBudgetItemRel().getId().toString());
        }
        this.lastDeductSnapshots = this.getLastDeductSnapshots(rels);
    }

    @Override
    protected void loadDeductionAndSnapshot() throws BOSException {
        DeductionParamCmpCal deductionParamCmpCal = (DeductionParamCmpCal)this.deductionParam;
        String calCurrencyId = deductionParamCmpCal.getCalCurrencyId();
        this.expenseList = this.loadExpenseList();
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        for (DeductionCmpCalUnit unit : deductionParamCmpCal.getUnits()) {
            String costBearOrgId = unit.getCostBearOrgId();
            String costTypeId = unit.getCostTypeId();
            List<CmpCalPersonParam> personList = unit.getPersonList();
            for (CmpCalPersonParam param : personList) {
                this.initExpense(param, costBearOrgId, costTypeId, calCurrencyId);
                List<BudgetSnapshotTotalCmpInfo> list = this.initSnapshot(param, unit, deductionParamCmpCal, rateMap);
                this.initDeduSnapshots.addAll(list);
            }
        }
        this.setRate4Expense(rateMap);
    }

    private void setRate4Expense(Map<String, BigDecimal> rateMap) {
        this.expenseList.forEach(e -> {
            CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)e;
            e.setRate((BigDecimal)rateMap.get(vo.getCmpCalTableId()));
        });
    }

    protected List<ExpenseDetailsVO> loadExpenseList() throws BOSException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String oql = "select cmpCalTable.id, calCurrency.id, budgetYear, base.person.id,  base.subStandingBook.id, base.id, base.budgetYear, base.cmpEmpORelation.id, base.budgetTemplate.id, base.budgetScheme.id, base.budgetManage.id, base.costBearOrg.id, base.costType.id, base.currency.id, base.standingBook.id, base.subBudgetQuery.id where cmpCalTable.id in " + param.getCmpCalTableIds(this.ctx) + " and budgetYear = " + this.budgetYear + " and base.budgetYear = " + this.budgetYear;
        ExpenseDetailsCmpCollection expenseList = ExpenseDetailsCmpFactory.getLocalInstance((Context)this.ctx).getExpenseDetailsCmpCollection(oql);
        ArrayList<ExpenseDetailsVO> list = new ArrayList<ExpenseDetailsVO>();
        if (expenseList.isEmpty()) {
            return list;
        }
        for (int i = 0; i < expenseList.size(); ++i) {
            ExpenseDetailsCmpInfo info = expenseList.get(i);
            CalTableExpenseDetailsVO vo = new CalTableExpenseDetailsVO();
            vo.setCmpCalTableId(info.getCmpCalTable().getId().toString());
            vo.setCalCurrencyId(info.getCalCurrency().getId().toString());
            vo.setBudgetYear(info.getBudgetYear());
            vo.setSubStandingBookId(info.getBase().getSubStandingBook() == null ? null : info.getBase().getSubStandingBook().getId().toString());
            vo.setId(info.getBase().getId().toString());
            if (null != info.getBase().getCmpEmpORelation() && null != info.getBase().getCmpEmpORelation().getId()) {
                vo.setCmpEmpORelationId(info.getBase().getCmpEmpORelation().getId().toString());
            }
            if (null != info.getBase().getPerson() && null != info.getBase().getPerson().getId()) {
                vo.setPersonId(info.getBase().getPerson().getId().toString());
            }
            vo.setBudgetTemplateId(info.getBase().getBudgetTemplate().getId().toString());
            vo.setBudgetSchemeId(info.getBase().getBudgetScheme().getId().toString());
            vo.setBudgetManageId(info.getBase().getBudgetManage().getId().toString());
            vo.setCostBearOrgId(info.getBase().getCostBearOrg().getId().toString());
            vo.setCostTypeId(info.getBase().getCostType().getId().toString());
            vo.setCurrencyId(info.getBase().getCurrency().getId().toString());
            vo.setStandingBookId(info.getBase().getStandingBook().getId().toString());
            vo.setSubBudgetQueryId(info.getBase().getSubBudgetQuery() == null ? null : info.getBase().getSubBudgetQuery().getId().toString());
            list.add(vo);
        }
        return list;
    }

    protected List<BudgetSnapshotTotalCmpInfo> initSnapshot(CmpCalPersonParam param, DeductionCmpCalUnit unit, DeductionParamCmpCal deductionParam, Map<String, BigDecimal> rateMap) throws BOSException {
        ArrayList<BudgetSnapshotTotalCmpInfo> list = new ArrayList<BudgetSnapshotTotalCmpInfo>();
        BudgetSnapshotTotalCmpInfo snapshot = new BudgetSnapshotTotalCmpInfo();
        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
        adminOrgUnitInfo.setId(BOSUuid.read((String)param.getAdminOrgUnitId()));
        snapshot.setAdminOrgUnit(adminOrgUnitInfo);
        snapshot.setBudgetYear(this.budgetScheme.getBudgetYear());
        snapshot.setCalTime(param.getCalTimes());
        if (!StringUtils.isEmpty((String)param.getCalCurrencyId())) {
            CurrencyInfo calCurrency = new CurrencyInfo();
            calCurrency.setId(BOSUuid.read((String)param.getCalCurrencyId()));
            snapshot.setCalCurrency(calCurrency);
        }
        CalSchemeInfo calSchemeInfo = new CalSchemeInfo();
        calSchemeInfo.setId(BOSUuid.read((String)deductionParam.getCalSchemeId()));
        snapshot.setCalScheme(calSchemeInfo);
        CmpCalTableInfo calTable = new CmpCalTableInfo();
        calTable.setId(BOSUuid.read((String)param.getCalTableId()));
        snapshot.setCalTable(calTable);
        snapshot.setBudgetCurrency(this.budgetScheme.getCurrency());
        snapshot.setBudgetTemplate(this.budgetTemplate);
        AdminOrgUnitInfo costBearOrg = new AdminOrgUnitInfo();
        costBearOrg.setId(BOSUuid.read((String)unit.getCostBearOrgId()));
        snapshot.setCostBearOrg(costBearOrg);
        CostTypeInfo costTypeInfo = new CostTypeInfo();
        costTypeInfo.setId(BOSUuid.read((String)unit.getCostTypeId()));
        snapshot.setCostType(costTypeInfo);
        snapshot.setDataState(param.getDataState());
        HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
        hrOrgUnitInfo.setId(BOSUuid.read((String)param.getHrOrgUnitId()));
        snapshot.setHrOrgUnit(hrOrgUnitInfo);
        snapshot.setPeriodMonth(param.getPeriodMonth());
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)param.getPersonId()));
        snapshot.setPerson(person);
        snapshot.setPeriodYear(param.getPeriodYear());
        snapshot.setCreateTime(this.now);
        snapshot.setLastUpdateTime(this.now);
        snapshot.setCreator(this.user);
        snapshot.setLastUpdateUser(this.user);
        snapshot.setUpdateNode(deductionParam.getCmpDeductNodeEnum());
        snapshot.setUpdateDirection(UpdateDirectionEnum.SUBTRACT);
        for (Map.Entry<String, BigDecimal> entry : param.getAmountMap().entrySet()) {
            BudgetTemplateSTBItemInfo rel = this.filterFromDeduConfig(entry.getKey());
            if (null == rel) {
                LOG.error((Object)("=======>data error: no BudgetTemplateSTBItemInfo for id: " + entry.getKey()));
                continue;
            }
            BudgetSnapshotTotalCmpInfo snapshotTotalCmpInfo = this.copySnapshot(snapshot);
            snapshotTotalCmpInfo.setId(BOSUuid.create((BOSObjectType)snapshot.getBOSType()));
            snapshotTotalCmpInfo.setTemplateStbItem(rel);
            snapshotTotalCmpInfo.setCmpBudgetItem(rel.getCmpBudgetItem());
            BigDecimal deductValue = this.getExchangeValueAndSetRate(entry.getValue(), param.getExchangeTableId(), this.budgetScheme.getCurrency(), snapshotTotalCmpInfo);
            snapshotTotalCmpInfo.setValue(deductValue);
            list.add(snapshotTotalCmpInfo);
            rateMap.put(snapshotTotalCmpInfo.getCalTable().getId().toString(), snapshotTotalCmpInfo.getRate());
            this.addOrgDeduction(unit.getOrgDeductionList(), rel, deductValue);
        }
        return list;
    }

    protected void addOrgDeduction(List<OrgDeduction> orgDeductionList, BudgetTemplateSTBItemInfo rel, BigDecimal deductValue) {
        String budgetItemId = rel.getCmpBudgetItem().getId().toString();
        Optional<OrgDeduction> optional = orgDeductionList.stream().filter(e -> e.getBudgetItemId().equals(budgetItemId)).findFirst();
        if (optional.isPresent()) {
            OrgDeduction orgDeduction = optional.get();
            orgDeduction.setValue(orgDeduction.getValue().add(deductValue));
        } else {
            OrgDeduction orgDeduction = new OrgDeduction();
            orgDeduction.setValue(deductValue);
            String balanceField = "S" + rel.getBalanceLedgerItem().getFieldSn();
            orgDeduction.setBalanceField(balanceField);
            String budgetField = "T" + rel.getCmpBudgetItem().getFieldSn();
            orgDeduction.setBudgetField(budgetField);
            String stdField = "S" + rel.getStandingBookItem().getFieldSn();
            orgDeduction.setStdField(stdField);
            orgDeduction.setBudgetItemId(budgetItemId);
            orgDeductionList.add(orgDeduction);
        }
    }

    protected BigDecimal getExchangeValueAndSetRate(BigDecimal value, String exchangeTableId, CurrencyInfo currency, BudgetSnapshotTotalCmpInfo snapshot) throws BOSException {
        if (null == exchangeTableId || null == currency || null == snapshot.getCalCurrency()) {
            return value;
        }
        String sourceCurrency = snapshot.getCalCurrency().getId().toString();
        String targetCurrency = currency.getId().toString();
        ExchangeRateInfo exchangeRateInfo = this.rateInfoMap.get(sourceCurrency);
        if (null == exchangeRateInfo) {
            exchangeRateInfo = CurrencyUtil.getClosestExchangeRate(this.ctx, exchangeTableId, targetCurrency, sourceCurrency, this.now);
            this.rateInfoMap.put(sourceCurrency, exchangeRateInfo);
        }
        if (null == exchangeRateInfo) {
            snapshot.setRate(BigDecimal.ONE);
            return value;
        }
        BigDecimal convertRate = exchangeRateInfo.getConvertRate();
        snapshot.setRate(convertRate);
        int scale = value.scale();
        return value.multiply(convertRate).setScale(scale, RoundingMode.HALF_UP);
    }

    private BudgetTemplateSTBItemInfo filterFromDeduConfig(String relId) {
        for (int i = 0; i < this.deduConfigCollection.size(); ++i) {
            BudgetTemplateSTBItemInfo rel = this.deduConfigCollection.get(i).getCmpBudgetItemRel();
            if (!relId.equals(rel.getId().toString())) continue;
            return rel;
        }
        return null;
    }

    private void initExpense(CmpCalPersonParam param, String costBearOrgId, String costTypeId, String calCurrencyId) {
        Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> {
            CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)e;
            return vo.getCmpCalTableId().equals(param.getCalTableId()) && vo.getCostBearOrgId().equals(costBearOrgId);
        }).findAny();
        if (optional.isPresent()) {
            return;
        }
        CalTableExpenseDetailsVO expense = new CalTableExpenseDetailsVO();
        expense.setCmpCalTableId(param.getCalTableId());
        expense.setBudgetYear(this.budgetScheme.getBudgetYear());
        expense.setBudgetSchemeId(this.budgetSchemeId);
        expense.setBudgetTemplateId(this.budgetTemplateId);
        expense.setCostTypeId(costTypeId);
        expense.setCmpEmpORelationId(param.getCmpEmpORelationId());
        expense.setPersonId(param.getPersonId());
        expense.setCostBearOrgId(costBearOrgId);
        expense.setCurrencyId(this.budgetScheme.getCurrency().getId().toString());
        expense.setCalCurrencyId(calCurrencyId);
        this.expenseList.add(expense);
    }

    @Override
    protected void executeOffSet() throws BOSException, EASBizException {
        if (null == this.offsetConfigCollection || this.offsetConfigCollection.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.offsetConfigCollection.size(); ++i) {
            BudgetDeductionConfigInfo configInfo = this.offsetConfigCollection.get(i);
            BudgetTemplateSTBItemInfo rel = configInfo.getCmpBudgetItemRel();
            BOSUuid cmpBudgetItemId = rel.getCmpBudgetItem().getId();
            BudgetSnapshotTotalCmpCollection snapshotCollection = this.filterByNode(this.lastDeductSnapshots, rel);
            HashMap<String, BigDecimal> sumValueForOffsetMap = new HashMap<String, BigDecimal>();
            String splitFlag = "###";
            for (int j = 0; j < snapshotCollection.size(); ++j) {
                String subBookTableId;
                BudgetSnapshotTotalCmpInfo snapshotInfo = snapshotCollection.get(j);
                String bookTableId = snapshotInfo.getCmpStandingBook().getId().toString();
                String string = subBookTableId = snapshotInfo.getSubCmpStandingBook() == null ? null : snapshotInfo.getSubCmpStandingBook().getId().toString();
                if (StringUtils.isEmpty((String)bookTableId)) continue;
                String key = bookTableId + splitFlag + subBookTableId;
                BigDecimal sumVal = sumValueForOffsetMap.computeIfAbsent(key, k -> BigDecimal.ZERO);
                BigDecimal value = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
                sumVal = sumVal.add(value);
                sumValueForOffsetMap.put(key, sumVal);
                snapshotInfo.setIsOffset(true);
            }
            this.updateBookTableDataOfReOffset(rel, sumValueForOffsetMap, splitFlag);
            String stdField = "S" + rel.getStandingBookItem().getFieldSn();
            this.recordOffsetSnapshot(snapshotCollection, stdField, cmpBudgetItemId);
        }
    }

    private BudgetSnapshotTotalCmpCollection filterByNode(BudgetSnapshotTotalCmpCollection lastDeductSnapshots, BudgetTemplateSTBItemInfo rel) {
        if (lastDeductSnapshots == null || lastDeductSnapshots.isEmpty()) {
            return new BudgetSnapshotTotalCmpCollection();
        }
        BudgetSnapshotTotalCmpCollection collection = new BudgetSnapshotTotalCmpCollection();
        for (int i = 0; i < lastDeductSnapshots.size(); ++i) {
            if (!lastDeductSnapshots.get(i).getTemplateStbItem().getId().equals((Object)rel.getId())) continue;
            collection.add(lastDeductSnapshots.get(i));
        }
        return collection;
    }

    protected void recordOffsetSnapshot(BudgetSnapshotTotalCmpCollection snapshotCollection, String stdField, BOSUuid cmpBudgetItemId) throws BOSException, EASBizException {
        CoreBaseCollection updateSnapshotColl = new CoreBaseCollection();
        boolean havingPeriods = this.budgetTemplate.getBudgetPeriod() != BudgetPeriodEnum.YEAR;
        for (int j = 0; j < snapshotCollection.size(); ++j) {
            BudgetSnapshotTotalCmpInfo snapshotInfo = snapshotCollection.get(j);
            snapshotInfo.setLastUpdateTime(this.now);
            snapshotInfo.setLastUpdateUser(this.user);
            updateSnapshotColl.add((CoreBaseInfo)snapshotInfo);
            BigDecimal offsetVal = snapshotInfo.getValue() == null ? BigDecimal.ZERO : snapshotInfo.getValue();
            Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> {
                CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)e;
                if (havingPeriods) {
                    return vo.getCmpCalTableId().equals(snapshotInfo.getCalTable().getId().toString()) && snapshotInfo.getSubCmpStandingBook().getId().toString().equals(vo.getSubStandingBookId()) && vo.getCostBearOrgId().equals(snapshotInfo.getCostBearOrg().getId().toString());
                }
                return vo.getCmpCalTableId().equals(snapshotInfo.getCalTable().getId().toString()) && vo.getCostBearOrgId().equals(snapshotInfo.getCostBearOrg().getId().toString());
            }).findFirst();
            if (!optional.isPresent()) continue;
            ExpenseDetailsVO vo = optional.get();
            BigDecimal val = vo.getExpenseMap().computeIfAbsent(stdField, k -> BigDecimal.ZERO);
            if (!cmpBudgetItemId.equals((Object)snapshotInfo.getCmpBudgetItem().getId())) continue;
            vo.getExpenseMap().put(stdField, val.subtract(offsetVal));
        }
        if (updateSnapshotColl.size() > 0) {
            BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).saveBatchData(updateSnapshotColl);
        }
    }

    protected BudgetSnapshotTotalCmpCollection getLastDeductSnapshots(Set<String> templateStbItemIds) throws BOSException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String oqlBuilder = " where calTable.id in " + param.getCmpCalTableIds(this.ctx) + " and templateStbItem.id in (" + CmpStrUtil.convertCollectionToSql(templateStbItemIds) + ") and dataState = " + 10 + " order by createTime desc";
        BudgetSnapshotTotalCmpCollection collection = BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).getBudgetSnapshotTotalCmpCollection(oqlBuilder);
        if (collection.isEmpty()) {
            return collection;
        }
        Iterator iterator = collection.iterator();
        HashMap deductionTimeMap = Maps.newHashMap();
        while (iterator.hasNext()) {
            BudgetSnapshotTotalCmpInfo info = (BudgetSnapshotTotalCmpInfo)iterator.next();
            String cmpCalTableId = info.getCalTable().getId().toString();
            Long createTime = (Long)deductionTimeMap.get(cmpCalTableId);
            if (createTime != null && createTime.compareTo(info.getCreateTime().getTime()) > 0) {
                iterator.remove();
                continue;
            }
            deductionTimeMap.put(cmpCalTableId, info.getCreateTime().getTime());
        }
        return collection;
    }

    @Override
    protected void doDeductionByPeriod() throws BOSException, EASBizException {
        if (this.deduConfigCollection.isEmpty()) {
            return;
        }
        DeductionParamCmpCal deductionParamCmpCal = (DeductionParamCmpCal)this.deductionParam;
        for (DeductionCmpCalUnit unit : deductionParamCmpCal.getUnits()) {
            for (int i = 0; i < this.deduConfigCollection.size(); ++i) {
                this.deduConfig = this.deduConfigCollection.get(i);
                BudgetTemplateSTBItemInfo rel = this.deduConfig.getCmpBudgetItemRel();
                String budgetSnCol = "T" + rel.getCmpBudgetItem().getFieldSn();
                String stbSnCol = "S" + rel.getStandingBookItem().getFieldSn();
                String leftSnCol = "S" + rel.getBalanceLedgerItem().getFieldSn();
                String budgetItemId = rel.getId().toString();
                this.setCostBearOrgId(unit.getCostBearOrgId());
                this.currentDeductUnit = unit;
                this.doPeriodDeduction(stbSnCol, leftSnCol, budgetSnCol, budgetItemId);
            }
        }
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (BudgetSnapshotTotalCmpInfo snapshotInfo : this.finalDeduSnapshots) {
            coreBaseCollection.add((CoreBaseInfo)snapshotInfo);
        }
        BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).saveBatchData(coreBaseCollection);
        this.genOffsetSnapshotData();
    }

    @Override
    protected void doDeductionByYear() throws BOSException, EASBizException {
        DeductionParamCmpCal deductionParamCmpCal = (DeductionParamCmpCal)this.deductionParam;
        for (DeductionCmpCalUnit unit : deductionParamCmpCal.getUnits()) {
            for (OrgDeduction orgDeduction : unit.getOrgDeductionList()) {
                String budgetSnCol = orgDeduction.getBudgetField();
                String stbSnCol = orgDeduction.getStdField();
                String leftSnCol = orgDeduction.getBalanceField();
                String budgetItemId = orgDeduction.getBudgetItemId();
                BudgetData budgetData = this.initBudgetData(unit.getCostBearOrgId(), unit.getCostTypeId(), budgetSnCol, stbSnCol, leftSnCol, budgetItemId);
                String standingBookId = this.doYearlyDeduction(stbSnCol, leftSnCol, budgetData, orgDeduction.getValue());
                this.initDeduSnapshots.forEach(snapshot -> {
                    if (this.isCurrentDeduction(unit, (BudgetSnapshotTotalCmpInfo)snapshot)) {
                        CmpStandingBookInfo standingBookInfo = new CmpStandingBookInfo();
                        standingBookInfo.setId(BOSUuid.read((String)standingBookId));
                        snapshot.setCmpStandingBook(standingBookInfo);
                        for (ExpenseDetailsVO expense : this.expenseList) {
                            CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)expense;
                            if (!vo.getCostBearOrgId().equals(snapshot.getCostBearOrg().getId().toString()) || !vo.getCmpCalTableId().equals(snapshot.getCalTable().getId().toString()) || !budgetItemId.equals(snapshot.getCmpBudgetItem().getId().toString())) continue;
                            vo.getExpenseMap().put(stbSnCol, snapshot.getValue());
                            vo.setStandingBookId(standingBookId);
                            vo.setBudgetManageId(budgetData.getBudgetManageId());
                            vo.setBudgetSchemeId(this.budgetSchemeId);
                            vo.setBudgetTemplateId(this.budgetTemplateId);
                        }
                    }
                });
            }
        }
        this.saveSnapshots(this.initDeduSnapshots);
        this.genOffsetSnapshotData();
    }

    protected void saveSnapshots(List<BudgetSnapshotTotalCmpInfo> initDeduSnapshots) throws BOSException, EASBizException {
        CoreBaseCollection collection = new CoreBaseCollection();
        initDeduSnapshots.forEach(arg_0 -> ((CoreBaseCollection)collection).add(arg_0));
        BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).saveBatchData(collection);
    }

    protected void genOffsetSnapshotData() throws BOSException, EASBizException {
        if (this.lastDeductSnapshots == null || this.lastDeductSnapshots.isEmpty()) {
            return;
        }
        CoreBaseCollection offsetSnapshots = new CoreBaseCollection();
        for (int i = 0; i < this.lastDeductSnapshots.size(); ++i) {
            BudgetSnapshotTotalCmpInfo snapshot = this.lastDeductSnapshots.get(i);
            BOSUuid id = snapshot.getId();
            snapshot.setId(BOSUuid.create((BOSObjectType)snapshot.getBOSType()));
            snapshot.setDataState(DataStateEnum.OFFSET);
            snapshot.setUpdateDirection(UpdateDirectionEnum.ADD);
            snapshot.setLastUpdateUser(this.user);
            snapshot.setCreator(this.user);
            snapshot.setCreateTime(this.now);
            snapshot.setLastUpdateTime(this.now);
            snapshot.setIsOffset(true);
            snapshot.setOffsetSnapshotId(id.toString());
            offsetSnapshots.add((CoreBaseInfo)snapshot);
        }
        BudgetSnapshotTotalCmpFactory.getLocalInstance((Context)this.ctx).saveBatchData(offsetSnapshots);
    }

    protected boolean isCurrentDeduction(DeductionCmpCalUnit unit, BudgetSnapshotTotalCmpInfo e) {
        return e.getCostBearOrg().getId().toString().equals(unit.getCostBearOrgId()) && e.getCostType().getId().toString().equals(unit.getCostTypeId());
    }

    @Override
    protected boolean isOverdraw(BigDecimal isEnoughData) {
        return false;
    }

    @Override
    protected boolean loadDeduConfigInfo() throws BOSException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String deductOql = "select cmpBudgetItemRel.id, cmpBudgetItemRel.cmpBudgetItem.id, cmpBudgetItemRel.cmpBudgetItem.fieldSn, cmpBudgetItemRel.standingBookItem.id, cmpBudgetItemRel.standingBookItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.id where calScheme = '" + param.getCalSchemeId() + "' and deduNode = " + param.getCmpDeductNodeEnum().getValue();
        this.deduConfigCollection = BudgetDeductionConfigFactory.getLocalInstance((Context)this.ctx).getBudgetDeductionConfigCollection(deductOql);
        return this.deduConfigCollection != null && !this.deduConfigCollection.isEmpty();
    }

    @Override
    protected void loadOffSetConfigInfo() throws BOSException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String deductOql = "select cmpBudgetItemRel.cmpBudgetItem.id, cmpBudgetItemRel.cmpBudgetItem.fieldSn, cmpBudgetItemRel.standingBookItem.id, cmpBudgetItemRel.standingBookItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.fieldSn, cmpBudgetItemRel.balanceLedgerItem.id where calScheme = '" + param.getCalSchemeId() + "' and offsetNode = " + param.getCmpDeductNodeEnum().getValue();
        this.offsetConfigCollection = BudgetDeductionConfigFactory.getLocalInstance((Context)this.ctx).getBudgetDeductionConfigCollection(deductOql);
    }

    @Override
    protected void checkAcross() throws BOSException, EASBizException {
        this.budgetPeriod = this.getBudgetPeriodEnum();
    }

    @Override
    protected boolean checkBudgetData() {
        String operateKsqlDate = this.getDeductDate();
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        String sqlBuilder = " SELECT cs.FBudgetTemplateId, cbs.fid budgetSchemeId, bm.fid budgetManageId, bm.FAdminOrgUnitId, bm.FCostTypeId, cbs.FBudgetYear  FROM T_HR_SCalScheme cs  left join T_HR_SCmpBudgetScheme cbs on cs.FBudgetTemplateID = cbs.FTemplateID    and cbs.FEffectDate <= " + operateKsqlDate + "    and cbs.FExpiryDate >= " + operateKsqlDate + " left join T_HR_SBudgetManage bm on cbs.Fid = bm.FBudgetSchemeID where cs.FID = ? ";
        List<DeductionCmpCalUnit> units = param.getUnits();
        Iterator<DeductionCmpCalUnit> iterator = units.iterator();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuilder, (Object[])new Object[]{this.deductionParam.getCalSchemeId()});
            while (iterator.hasNext()) {
                boolean hasBudgetManage = false;
                DeductionCmpCalUnit unit = iterator.next();
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    String fBudgetTemplateId = rowSet.getString("FBudgetTemplateId");
                    String fBudgetSchemeId = rowSet.getString("budgetSchemeId");
                    String costBearOrgId = rowSet.getString("FAdminOrgUnitId");
                    String costTypeId = rowSet.getString("FCostTypeId");
                    if (!unit.getCostBearOrgId().equals(costBearOrgId) || !unit.getCostTypeId().equals(costTypeId)) continue;
                    hasBudgetManage = true;
                    this.budgetYear = rowSet.getInt("FBudgetYear");
                    if (!StringUtils.isEmpty((String)fBudgetTemplateId)) {
                        this.budgetTemplateId = fBudgetTemplateId;
                    }
                    if (StringUtils.isEmpty((String)fBudgetSchemeId)) break;
                    this.budgetSchemeId = fBudgetSchemeId;
                    break;
                }
                if (hasBudgetManage) continue;
                this.deductionResult.getFailedOrgIds().add(unit.getCostBearOrgId());
                this.clearRelatedPersons(unit);
                iterator.remove();
            }
            if (!this.deductionResult.getFailedOrgIds().isEmpty()) {
                this.setErrMsg();
            }
        }
        catch (BOSException | SQLException e) {
            throw new RuntimeException(e);
        }
        if (units.isEmpty()) {
            return false;
        }
        for (DeductionCmpCalUnit unit : units) {
            if (unit.getPersonList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void clearRelatedPersons(DeductionCmpCalUnit unit) {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        List<DeductionCmpCalUnit> units = param.getUnits();
        List<CmpCalPersonParam> personList = unit.getPersonList();
        ArrayList<CmpCalPersonParam> copyPersonList = new ArrayList<CmpCalPersonParam>(personList);
        for (CmpCalPersonParam person : copyPersonList) {
            units.forEach(e -> e.getPersonList().removeIf(p -> {
                boolean matched = p.getCalTableId().equals(person.getCalTableId());
                if (matched) {
                    this.deductionResult.getFailedCalTableIds().add(person.getCalTableId());
                }
                return matched;
            }));
        }
    }

    private void setErrMsg() throws BOSException {
        String oql = "select name where id in (" + CmpStrUtil.convertCollectionToSql(this.deductionResult.getFailedOrgIds()) + ")";
        AdminOrgUnitCollection orgList = AdminOrgUnitFactory.getLocalInstance((Context)this.ctx).getAdminOrgUnitCollection(oql);
        StringBuilder orgNames = new StringBuilder();
        for (int i = 0; i < orgList.size(); ++i) {
            if (orgNames.length() > 0) {
                orgNames.append(", ");
            }
            orgNames.append(orgList.get(i).getName());
        }
        String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label51", (Locale)this.ctx.getLocale());
        errMsg = MessageFormat.format(errMsg, orgNames.toString());
        this.deductionResult.setErrMsg(errMsg);
    }

    @Override
    protected String getDeductDate() {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        Date deductDate = param.getDeductionDate();
        return CmpDateUtil.toKSqlDate(deductDate);
    }

    @Override
    public String getCostTypeId() {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        return param.getUnits().get(0).getCostTypeId();
    }

    @Override
    protected void deductSubmitData(List<BudgetAndUsedData> leftDataList, boolean hasDeduction) throws BOSException {
        BudgetTemplateSTBItemInfo rel = this.deduConfig.getCmpBudgetItemRel();
        CmpBudgetItemInfo cmpBudgetItem = rel.getCmpBudgetItem();
        String budgetSnCol = "T" + cmpBudgetItem.getFieldSn();
        String stbSnCol = "S" + rel.getStandingBookItem().getFieldSn();
        String leftSnCol = "S" + rel.getBalanceLedgerItem().getFieldSn();
        this.setLeftDataListId(leftDataList);
        if (hasDeduction) {
            for (BudgetAndUsedData leftDataMap : leftDataList) {
                BigDecimal balance = leftDataMap.getItemMap().get(leftSnCol) == null ? BigDecimal.ZERO : leftDataMap.getItemMap().get(leftSnCol);
                leftDataMap.getItemMap().put(budgetSnCol, balance);
            }
        }
        List<BudgetSnapshotTotalCmpInfo> lastDeductionSnapshots = this.filterByBudgetItemAndAminOrg(this.lastDeductSnapshots, cmpBudgetItem.getId(), this.currentDeductUnit.getCostBearOrgId());
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        if (!lastDeductionSnapshots.isEmpty()) {
            List<BudgetSnapshotTotalCmpInfo> currentDeductionSnapshots = this.copySnapshots(lastDeductionSnapshots);
            for (BudgetSnapshotTotalCmpInfo info : currentDeductionSnapshots) {
                info.setCreateTime(this.now);
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setTemplateStbItem(rel);
                info.setUpdateNode(param.getCmpDeductNodeEnum());
            }
            this.finalDeduSnapshots.addAll(currentDeductionSnapshots);
            for (BudgetAndUsedData leftDataMap : leftDataList) {
                Map<String, BigDecimal> itemMap = leftDataMap.getItemMap();
                List list = currentDeductionSnapshots.stream().filter(e -> leftDataMap.getTrueSubStandingBookId().equals(e.getSubCmpStandingBook().getId().toString())).collect(Collectors.toList());
                if (list.isEmpty()) continue;
                for (BudgetSnapshotTotalCmpInfo snapshotInfo : list) {
                    BigDecimal val = snapshotInfo.getValue();
                    BigDecimal expense = itemMap.computeIfAbsent(stbSnCol, k -> BigDecimal.ZERO);
                    itemMap.put(stbSnCol, expense.add(val));
                    BigDecimal balance = itemMap.computeIfAbsent(budgetSnCol, k -> BigDecimal.ZERO);
                    itemMap.put(budgetSnCol, balance.subtract(val));
                    this.convertRow2Columns(stbSnCol, leftDataMap, snapshotInfo);
                }
            }
            return;
        }
        List snapshotInfoList = this.initDeduSnapshots.stream().filter(e -> e.getCmpBudgetItem().getId().equals((Object)cmpBudgetItem.getId()) && e.getCostBearOrg().getId().toString().equals(this.currentDeductUnit.getCostBearOrgId())).collect(Collectors.toList());
        block4: for (BudgetSnapshotTotalCmpInfo initSnapshot : snapshotInfoList) {
            int subPeriodCount = leftDataList.size();
            BigDecimal deductValue = initSnapshot.getValue();
            for (int i = 0; i < subPeriodCount; ++i) {
                BudgetAndUsedData leftDataMap = leftDataList.get(i);
                Map<String, BigDecimal> itemMap = leftDataMap.getItemMap();
                BigDecimal leftBudgetData = itemMap.get(budgetSnCol) == null ? BigDecimal.ZERO : itemMap.get(budgetSnCol);
                boolean isLastPeriod = this.isLast(i, subPeriodCount);
                if (BigDecimal.ZERO.compareTo(leftBudgetData) >= 0 && !isLastPeriod) continue;
                BigDecimal data = leftBudgetData.subtract(deductValue);
                BigDecimal curUsedData = itemMap.get(stbSnCol) == null ? BigDecimal.ZERO : itemMap.get(stbSnCol);
                boolean isBudgetEnough = data.compareTo(BigDecimal.ZERO) >= 0;
                BudgetSnapshotTotalCmpInfo snapshot = this.copySnapshot(initSnapshot);
                if (!isBudgetEnough && !isLastPeriod) {
                    curUsedData = curUsedData.add(leftBudgetData);
                    deductValue = deductValue.subtract(leftBudgetData);
                    BigDecimal val = leftBudgetData;
                    leftBudgetData = BigDecimal.ZERO;
                    snapshot.setValue(val);
                } else {
                    curUsedData = curUsedData.add(deductValue);
                    leftBudgetData = leftBudgetData.subtract(deductValue);
                    snapshot.setValue(deductValue);
                    isBudgetEnough = true;
                }
                this.finalDeduSnapshots.add(snapshot);
                itemMap.put(stbSnCol, curUsedData);
                itemMap.put(budgetSnCol, leftBudgetData);
                SubCmpStandingBookInfo subCmpStandingBookInfo = new SubCmpStandingBookInfo();
                subCmpStandingBookInfo.setId(BOSUuid.read((String)leftDataMap.getTrueSubStandingBookId()));
                snapshot.setSubCmpStandingBook(subCmpStandingBookInfo);
                CmpStandingBookInfo cmpStandingBookInfo = new CmpStandingBookInfo();
                cmpStandingBookInfo.setId(BOSUuid.read((String)leftDataMap.getStandingBookId()));
                snapshot.setCmpStandingBook(cmpStandingBookInfo);
                this.convertRow2Columns(stbSnCol, leftDataMap, snapshot);
                if (isBudgetEnough) continue block4;
            }
        }
    }

    private List<BudgetSnapshotTotalCmpInfo> filterByBudgetItemAndAminOrg(BudgetSnapshotTotalCmpCollection lastDeductSnapshots, BOSUuid budgetItemId, String costBearOrgId) {
        ArrayList<BudgetSnapshotTotalCmpInfo> list = new ArrayList<BudgetSnapshotTotalCmpInfo>();
        if (null == lastDeductSnapshots) {
            return list;
        }
        for (int i = 0; i < lastDeductSnapshots.size(); ++i) {
            BudgetSnapshotTotalCmpInfo info = lastDeductSnapshots.get(i);
            if (!info.getCmpBudgetItem().getId().equals((Object)budgetItemId) || !info.getCostBearOrg().getId().toString().equals(costBearOrgId)) continue;
            list.add(info);
        }
        return list;
    }

    private List<BudgetSnapshotTotalCmpInfo> copySnapshots(List<BudgetSnapshotTotalCmpInfo> initSnapshots) throws BOSException {
        ArrayList<BudgetSnapshotTotalCmpInfo> currentSnapshots = new ArrayList<BudgetSnapshotTotalCmpInfo>();
        try {
            for (BudgetSnapshotTotalCmpInfo e : initSnapshots) {
                BudgetSnapshotTotalCmpInfo info = new BudgetSnapshotTotalCmpInfo();
                BeanUtils.copyProperties((Object)info, (Object)e);
                currentSnapshots.add(info);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return currentSnapshots;
    }

    private void convertRow2Columns(String stbSnCol, BudgetAndUsedData leftDataMap, BudgetSnapshotTotalCmpInfo snapshot) throws BOSException {
        String subStandingBookId = leftDataMap.getTrueSubStandingBookId();
        Optional<ExpenseDetailsVO> optional = this.expenseList.stream().filter(e -> {
            CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)e;
            return vo.getCmpCalTableId().equals(snapshot.getCalTable().getId().toString()) && vo.getCostBearOrgId().equals(snapshot.getCostBearOrg().getId().toString()) && subStandingBookId.equals(vo.getSubStandingBookId());
        }).findFirst();
        if (optional.isPresent()) {
            CalTableExpenseDetailsVO expense = (CalTableExpenseDetailsVO)optional.get();
            expense.getExpenseMap().put(stbSnCol, snapshot.getValue());
            return;
        }
        optional = this.expenseList.stream().filter(e -> {
            CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)e;
            return vo.getCmpCalTableId().equals(snapshot.getCalTable().getId().toString()) && vo.getCostBearOrgId().equals(snapshot.getCostBearOrg().getId().toString()) && vo.getSubStandingBookId() == null;
        }).findFirst();
        if (optional.isPresent()) {
            CalTableExpenseDetailsVO expense = (CalTableExpenseDetailsVO)optional.get();
            expense.setSubStandingBookId(leftDataMap.getTrueSubStandingBookId());
            expense.setStandingBookId(leftDataMap.getStandingBookId());
            expense.setBudgetManageId(leftDataMap.getBudgetId());
            expense.setSubBudgetQueryId(leftDataMap.getSubBudgetQueryId());
            expense.getExpenseMap().put(stbSnCol, snapshot.getValue());
            return;
        }
        optional = this.expenseList.stream().filter(e -> {
            CalTableExpenseDetailsVO vo = (CalTableExpenseDetailsVO)e;
            return vo.getCmpCalTableId().equals(snapshot.getCalTable().getId().toString()) && vo.getCostBearOrgId().equals(snapshot.getCostBearOrg().getId().toString());
        }).findFirst();
        if (optional.isPresent()) {
            CalTableExpenseDetailsVO expense = (CalTableExpenseDetailsVO)optional.get();
            CalTableExpenseDetailsVO newExpense = this.copyExpense(expense);
            newExpense.setExpenseMap(new HashMap<String, BigDecimal>());
            newExpense.setId(null);
            newExpense.getExpenseMap().put(stbSnCol, snapshot.getValue());
            newExpense.setSubStandingBookId(leftDataMap.getTrueSubStandingBookId());
            newExpense.setStandingBookId(leftDataMap.getStandingBookId());
            newExpense.setBudgetManageId(leftDataMap.getBudgetId());
            newExpense.setSubBudgetQueryId(leftDataMap.getSubBudgetQueryId());
            this.expenseList.add(newExpense);
        }
    }

    private CalTableExpenseDetailsVO copyExpense(CalTableExpenseDetailsVO expense) throws BOSException {
        CalTableExpenseDetailsVO vo = new CalTableExpenseDetailsVO();
        try {
            BeanUtils.copyProperties((Object)vo, (Object)expense);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return vo;
    }

    private BudgetSnapshotTotalCmpInfo copySnapshot(BudgetSnapshotTotalCmpInfo initSnapshot) throws BOSException {
        BudgetSnapshotTotalCmpInfo realSnapshot = new BudgetSnapshotTotalCmpInfo();
        try {
            BeanUtils.copyProperties((Object)realSnapshot, (Object)initSnapshot);
            realSnapshot.setId(BOSUuid.create((BOSObjectType)realSnapshot.getBOSType()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return realSnapshot;
    }

    private boolean isLast(int i, int size) {
        return i == size - 1;
    }

    @Override
    protected BigDecimal getTotalDeduction() {
        BigDecimal submitBigDecimalOfSum = BigDecimal.ZERO;
        BudgetTemplateSTBItemInfo rel = this.deduConfig.getCmpBudgetItemRel();
        for (OrgDeduction orgDeduction : this.currentDeductUnit.getOrgDeductionList()) {
            if (!orgDeduction.getBudgetItemId().equals(rel.getCmpBudgetItem().getId().toString())) continue;
            submitBigDecimalOfSum = submitBigDecimalOfSum.add(orgDeduction.getValue());
        }
        return submitBigDecimalOfSum;
    }

    @Override
    protected String getCostBearOrgComparator() {
        return "in";
    }

    @Override
    protected String getCompareValue() throws BOSException {
        DeductionParamCmpCal param = (DeductionParamCmpCal)this.deductionParam;
        return param.getCostBearOrgIds(this.ctx);
    }

    @Override
    public String getCostBearOrgId() {
        return this.costBearOrgId;
    }

    public void setCostBearOrgId(String costBearOrgId) {
        this.costBearOrgId = costBearOrgId;
    }
}

