/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.util.filter.CmpPermFilter;
import com.kingdee.shr.socialSecurity.util.SocPermFilter;
import com.kingdee.util.StringUtils;

public abstract class CmpPermissionSQL {
    public static String getCmpRecordUserRangeSql(Context ctx, String userId, String permItemId, boolean isSubQuery) {
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuilder str = new StringBuilder();
        str.append(" select per.fid as personId ");
        String l = LocaleUtils.getShortCode((Context)ctx);
        if (!isSubQuery) {
            str.append(",per.FName_" + l + " as name, per.FNumber as number, ");
            str.append(" hr.fid as hrId, hr.FName_" + l + " as hrName, hr.FNumber as hrNumber, ");
            str.append(" org.fid as orgId, org.FName_" + l + " as orgName, org.FNumber as orgNumber, ");
            str.append(" pos.FName_" + l + " as posName, pos.FNumber as posNumber, ");
            str.append(" rel.fid as relId, rel.FEffectDate as relEffectDate, rel.FLeffectDate as relLeffectDate ");
        }
        str.append(" from T_BD_Person per ");
        str.append(" left join T_HR_SPersonCmp rec on per.Fid = rec.FPersonId ");
        str.append(" left join T_ORG_HRO hr on rec.FHrOrgUnitID = hr.fid ");
        str.append(" left join T_HR_SCmpEmpORelation rel on rec.fid = rel.FPersonCmpID ");
        str.append(" left join T_HR_EmpOrgRelation emp on rel.FEmpOrgRelationID = emp.Fid ");
        str.append(" left join T_ORG_Admin org on emp.FAdminOrgID = org.fid ");
        str.append(" left join T_ORG_Position pos on emp.FPositionID = pos.fid ");
        str.append(" where rec.FHrOrgUnitID in (").append(userHROrgRangeSQL).append(") ");
        str.append(" and (emp.FAdminOrgId in (").append(userAdminRangeSQL).append(") ");
        str.append(" or rel.FUseDefault = 0) ");
        String permFilter = CmpPermFilter.getPermSQL(ctx, "006", permItemId, true);
        if (!StringUtils.isEmpty((String)permFilter)) {
            str.append(" and per.fid in (").append(permFilter).append(")");
        }
        return str.toString();
    }

    public static String getAdjRecordUserRangeSql(Context ctx, String userId, String permItemId, boolean isSubQuery) {
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select per.fid ");
        if (!isSubQuery) {
            str.append(",per.FName_" + l + " as name, per.FNumber as number, rec.FHrOrgUnitId, emp.FAdminOrgId as FAdminOrgUnitId ");
        }
        str.append(" from T_BD_Person per ");
        str.append(" inner join T_HR_SAdjustPersonRecord rec on per.Fid = rec.FPersonId ");
        str.append(" inner join T_HR_SAdjustEmpORelation rel on rec.fid = rel.FPersonRecordID ");
        str.append(" inner join T_HR_EmpOrgRelation emp on rel.FEmpOrgRelationId = emp.Fid ");
        str.append(" where rec.FHrOrgUnitID in (").append(userHROrgRangeSQL).append(") ");
        str.append(" and (emp.FAdminOrgId in (").append(userAdminRangeSQL).append(") ");
        str.append(" or rel.FUseDefault = 0)");
        return str.toString();
    }

    public static String getAdjEORelationSql(Context ctx, String userId, String permItemId) throws BOSException {
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select per.fid as FPersonId, per.FName_" + l + " as perName, per.FNumber as perNum, ");
        str.append("        rec.FHrOrgUnitId as hrOrgUnitId, hr.FName_" + l + " as hrName, hr.FNumber as hrNum, ");
        str.append("        emp.FAdminOrgId as adminOrgUnidId, org.FName_" + l + " as orgName, org.FNumber as orgNum, ");
        str.append("        tree.FDisplayName as orgDisName, tree.FLongNumber as orgLongNum, ");
        str.append("        emp.FPositionID as positionId, pos.FName_" + l + " as posName, pos.FNumber as posNum, ");
        str.append("        rel.FEffectDate as effectDate, rel.FEffectDate as leffectDate ");
        str.append(" from T_BD_Person per ");
        str.append(" inner join T_HR_SAdjustPersonRecord rec on per.Fid = rec.FPersonId ");
        str.append(" inner join T_ORG_HRO hr on rec.FHrOrgUnitId = hr.fid ");
        str.append(" inner join T_HR_SCmpEmpORelation rel on rec.fid = rel.FPersonRecordID ");
        str.append(" inner join T_HR_EmpOrgRelation emp on rel.FEmpOrgRelationID = emp.Fid ");
        str.append(" inner join T_ORG_AdminHis org on emp.FAdminOrgId = org.FHistoryRelateId ");
        str.append(" and emp.FEndDateTime >= org.FEFFDT and emp.FEndDateTime <= org.FLEFFDT ");
        str.append(" inner join T_ORG_AdminOrgTreeHis tree on emp.FAdminOrgId = tree.FAdminOrgID ");
        str.append(" and emp.FEndDateTime >= tree.FEFFDT and emp.FEndDateTime <= tree.FLEFFDT ");
        str.append(" inner join T_ORG_PositionHIS pos on emp.FPositionID = pos.FHistoryRelateId ");
        str.append(" and emp.FEndDateTime >= pos.FEFFDT and emp.FEndDateTime <= pos.FLEFFDT ");
        str.append(" where (rec.FHrOrgUnitID in (").append(userHROrgRangeSQL).append(") ");
        str.append(" and emp.FAdminOrgId in (").append(userAdminRangeSQL).append(") ");
        str.append(" and rel.FUseDefault = 1) or (rec.FHrOrgUnitID in (").append(userHROrgRangeSQL).append(") ");
        str.append(" and rel.FUseDefault = 0)");
        return str.toString();
    }

    public static String getUserAllCmpItem(Context ctx, String permItemId, boolean isDataPerm) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuilder str = new StringBuilder();
        str.append(" select distinct item.fid, item.FieldSn, item.FDataType ");
        str.append(" from T_HR_SCmpItemRelHR relRef ");
        str.append(" inner join T_HR_SCmpItem item on relRef.FBaseInfoId = item.fid ");
        str.append(" where relRef.FHrOrgUseId in (").append(userHROrgRangeSQL).append(") ");
        if (isDataPerm) {
            str.append(" and item.fid in (");
            str.append(" select FCmpItemId from T_HR_SCmpItemDataPerm where FPersonId = '").append(personId).append("') ");
        }
        return str.toString();
    }

    public static String getUserCalSchemeRangeSql(Context ctx, String permItemId, boolean isDataPerm) throws BOSException, EASBizException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid from T_HR_SCalScheme where (FAdminOrgUnitId in (");
        sql.append(userAdminRangeSQL);
        sql.append(") or FAdminOrgUnitId is null) ");
        sql.append(" and (FHrOrgUnitID in ( ");
        sql.append(userHROrgRangeSQL);
        sql.append(" ) or FHrOrgUnitID is null) ");
        if (isDataPerm) {
            sql.append("and FCreatorId = '").append(userId).append("'");
            sql.append(" or Fid in (select FCalSchemeID from T_HR_SCmpCalSchemeDataPerm where FPersonID='");
            sql.append(personId);
            sql.append("')");
        }
        return sql.toString();
    }

    public static String getSocRecordUserRangeSql(Context ctx, String userId, String permItemId) {
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuilder str = new StringBuilder();
        str.append(" select per.fid ");
        str.append(" from T_BD_Person per ");
        str.append(" inner join T_HR_SSocPersonRecord rec on per.Fid = rec.FPersonIdID ");
        str.append(" inner join T_HR_EmpOrgRelation emp on rec.FEmpOrgRelationID = emp.Fid ");
        str.append(" where rec.FHrOrgUnitID in (").append(userHROrgRangeSQL).append(") ");
        str.append(" and (emp.FAdminOrgId in (").append(userAdminRangeSQL).append(") ");
        str.append(" or rec.FUseDefault = 0)");
        String socPermFilter = SocPermFilter.getSocPermSQL((Context)ctx, (String)permItemId, (boolean)true);
        if (!StringUtils.isEmpty((String)socPermFilter)) {
            str.append(" and per.fid in (").append(socPermFilter).append(")");
        }
        return str.toString();
    }

    public static String getUserAdminRangeSql1(Context ctx, String permItemId) {
        String userID = HRFilterUtils.getCurrentUserId((Context)ctx);
        String orgRangeSql = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userID, (String)permItemId);
        return orgRangeSql;
    }
}

