/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.sql.record;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public abstract class AdjustRecordSQL {
    public static String getDisableERSql(String personBURelationIds, Date leffectDate) {
        StringBuilder str = new StringBuilder();
        str.append("update T_HR_SAdjustEmpORelation ");
        str.append(" set FLeffectDate = ");
        str.append(leffectDate);
        str.append(" where FEmpOrgRelationID in (");
        str.append(personBURelationIds);
        str.append(")");
        return str.toString();
    }

    public static String getDisableERByRecordSql(String recordIds) {
        StringBuilder str = new StringBuilder();
        str.append(" select emp.fid, emp.FLEFFDT, cmpEmp.fid as empFid, cmpEmp.FPersonBURelationID ");
        str.append(" from T_HR_EmpOrgRelation emp ");
        str.append(" inner join T_HR_SAdjustEmpORelation as cmpEmp ");
        str.append(" on emp.fid = cmpEmp.FEmpOrgRelationID ");
        str.append(" inner join T_HR_SAdjustPersonRecord as rec ");
        str.append(" on cmpEmp.FPersonRecordID = rec.fid ");
        str.append(" where rec.fid in(").append(recordIds).append(")");
        str.append(" and cmpEmp.FLeffectDate >= {ts '2199-12-31'}");
        str.append(" and emp.FEndDateTime < {ts '2199-12-31'}");
        return str.toString();
    }

    public static String getEnableDataSql(String personBURelationIds) {
        StringBuilder str = new StringBuilder();
        str.append("select rel.FPersonId, rel.FHrOrgUnitID, rel.FEmpOrgRelationID, rel.FEmpPostExpHisID,");
        str.append("       rel.fid FPersonBURelId, rel.Feffdt, rel.FEndDate, rel.FUseDefault as useDefault, ");
        str.append("       rec.fid as recFid, rec.FLeffectDate as recLeffdt, rec.feffectdate as recFEffectDate, ");
        str.append("\t   labor.FEnterDate enterDate, ");
        str.append("\t   eor.fassignType assignType, eor.feffdt empFEffdt,eor.FLEFFDT as empFLEffdt, ");
        str.append("       emp.FEmpOrgRelationID as cmpEmpORelationId, emp.FUseDefault as empUseDefault, emp.Fid as empFid, emp.FPersonBURelationID as oldPersonBURelId, ");
        str.append("       emp.FEffectDate as oldFEffDate ");
        str.append(" from T_HR_PersonBURelation rel ");
        str.append("  inner join T_HR_EmpLaborRelation labor on rel.FPersonId = labor.FPersonId ");
        str.append(" inner join T_HR_EmpOrgRelation eor on rel.FEmpOrgRelationID = eor.fid ");
        str.append(" left join T_HR_SAdjustPersonRecord rec ");
        str.append(" on rel.FPersonId = rec.FPersonId and rel.FHrOrgUnitId = rec.FHrOrgUnitId ");
        str.append(" left join T_HR_SAdjustEmpORelation emp ");
        str.append(" on emp.FPersonRecordID = rec.fid and emp.FEmpOrgRelationID = rel.FEmpOrgRelationID ");
        str.append(" where rel.fid in (");
        str.append(personBURelationIds);
        str.append(")");
        str.append(" order by eor.FPersonId, eor.FStartDateTime desc");
        return str.toString();
    }

    public static String getDisablePBURelationDataSql(String personBURelationIds, Date leffectDate) {
        StringBuilder str = new StringBuilder();
        str.append(" select pbu.fid as FPersonBURelId ");
        str.append(" from T_HR_SAdjustEmpORelation emp ");
        str.append(" inner join T_HR_SAdjustSalaryBill bill on bill.FAdjEmpORelationID = emp.fid ");
        str.append(" where emp.FPersonBURelationID in (").append(personBURelationIds).append(")");
        str.append(" and bill.FBillState in (0,1,2)");
        return str.toString();
    }

    public static String getUndoPBURelationDataSql(String personBURelationIds) {
        StringBuilder str = new StringBuilder();
        str.append(" select emp.FPersonBURelationID as FPersonBURelId");
        str.append(" from T_HR_SAdjustEmpORelation emp ");
        str.append(" inner on T_HR_SFixAdjustSalary adj on emp.fid = adj.FAdjEmpORelationID ");
        str.append(" where emp.FPersonBURelationID in (").append(personBURelationIds).append(")");
        str.append(" union ");
        str.append(" select emp.FPersonBURelationID as FPersonBURelId");
        str.append(" from T_HR_SAdjustEmpORelation emp ");
        str.append(" inner join T_HR_SAdjustSalaryBill bill on emp.Fid = bill.FAdjEmpORelationID ");
        str.append(" where emp.FPersonBURelationID in (").append(personBURelationIds).append(")");
        str.append(" and bill.FBillState in (0,1,2)");
        str.append(" union ");
        str.append(" select pbu.fid as FPersonBURelId");
        str.append(" from T_HR_PersonBURelation pbu ");
        str.append(" where pbu.fid in (").append(personBURelationIds).append(")");
        str.append(" and pbu.FState = 0");
        return str.toString();
    }

    public static String getOnoToOneEmpWithRecordSql(String personBURelationIds) {
        StringBuilder str = new StringBuilder();
        str.append(" select recFid from (");
        str.append(" select rec.fid as recFid, count(1) as cnt ");
        str.append(" from T_HR_SAdjustPersonRecord rec ");
        str.append(" inner join T_HR_SAdjustEmpORelation emp on rec.Fid = emp.FPersonRecordID ");
        str.append(" where emp.FPersonBURelationID in ");
        str.append(" (").append(personBURelationIds).append(") ");
        str.append(" group by rec.Fid ");
        str.append(" having count(1) = 1 ) record ");
        return str.toString();
    }

    public static String getRecordEffect(String recordIds) {
        StringBuilder str = new StringBuilder();
        str.append(" select fid as recordId, FEffectDate as effectDate");
        str.append(" from T_HR_SAdjustPersonRecord ");
        str.append(" where fid in (" + recordIds + ")");
        return str.toString();
    }

    public static String getCmpEmpDatasByRecord(String recordIds) {
        return " select FPersonRecordID as recFid, tt.fid as empFid, FPersonBURelationID as FPersonBURelId  from T_HR_SAdjustEmpORelation tt  inner join T_HR_SAdjustPersonRecord t1 on tt.FPersonRecordID = t1.fid  where t1.Fid in (" + recordIds + ") and tt.FLeffectDate >= t1.FLeffectDate ";
    }

    public static String getReocrdInfoByEmpId(String cmpEmpId) {
        StringBuffer str = new StringBuffer();
        str.append(" select t0.FPersonId, t0.fid as recFid, t0.FHrOrgUnitID, ");
        str.append(" t2.fid as empFid, t1.FPersonBURelationID as FPersonBURelId, ");
        str.append(" t2.fid as FEmpOrgRelationID, t2.FParentID, t2.FAssignType ");
        str.append(" from T_HR_SAdjustPersonRecord t0 ");
        str.append(" inner join T_HR_SAdjustEmpORelation t1 on t0.fid = t1.FPersonRecordID ");
        str.append(" inner join T_HR_EmpOrgRelation t2 on t1.FEmpOrgRelationID = t2.fid ");
        str.append(" where exists (");
        str.append(" select 1 from T_HR_SAdjustEmpORelation t3 where t3.FEmpOrgRelationID = '" + cmpEmpId + "' ");
        str.append(" and t3.FPersonRecordID = t0.fid) ");
        return str.toString();
    }

    public static String getRecoverEmpSql(String empId, String recordId) {
        StringBuffer str = new StringBuffer();
        str.append(" select FPersonBURelationID from T_HR_SAdjustEmpORelation ");
        str.append(" where FEmpOrgRelationID ='" + empId + "' ");
        str.append(" and FPersonRecordID = '" + recordId + "'");
        return str.toString();
    }

    public static String updateRecoverEmpSql(String pbuId) {
        StringBuffer str = new StringBuffer();
        str.append(" update T_HR_SAdjustEmpORelation set FLeffectDate = {ts '2199-12-31'} ");
        str.append(" where FPersonBURelationID ='" + pbuId + "' ");
        return str.toString();
    }

    public static String getEmpCountInRecord(String cmpEmpId) {
        StringBuilder str = new StringBuilder();
        str.append(" select count(1) as count, t0.fid as recordId ");
        str.append(" from T_HR_SAdjustPersonRecord t0 ");
        str.append(" inner join T_HR_SAdjustEmpORelation t1 on t0.fid = t1.FPersonRecordID ");
        str.append(" where exists (");
        str.append(" select 1 from T_HR_SAdjustEmpORelation t2 where t2.fid = '" + cmpEmpId + "' ");
        str.append(" and t2.FPersonRecordID = t0.fid ) ");
        str.append(" group by t0.fid ");
        return str.toString();
    }

    public static String beforeDeletePerson(String personIds, Context ctx) {
        StringBuffer str = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select distinct t1.FName_" + l + " as perName, t1.fid as personId ");
        str.append(" from T_HR_SFixAdjustSalary t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" where t0.FPersonId in ('" + personIds + "') ");
        return str.toString();
    }

    public static String beforeDeletePersonByRelationID(String cmpEmpORelationID, Context ctx) {
        StringBuffer str = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select distinct t1.FName_" + l + " as perName, t1.fid as personId ");
        str.append(" from T_HR_SFixAdjustSalary t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" where t0.fadjemporelationid in ('" + cmpEmpORelationID + "') ");
        return str.toString();
    }

    public static String getPBUIdByEmpORelation(String empIds) {
        StringBuilder str = new StringBuilder();
        str.append(" select t0.FEmpOrgRelationID as FEmpOrgRelationID, t1.fid as FPersonBURelId ");
        str.append(" from T_HR_SAdjustEmpORelation t0 ");
        str.append(" inner join T_HR_PersonBURelation t1 on t0.FPersonBURelationID = t1.fid ");
        str.append(" where t0.FEmpOrgRelationID in (" + empIds + ")");
        return str.toString();
    }

    public static String getRepeatPersonRelation(String userId, Context ctx) {
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select distinct t1.FName_" + l + " perName ");
        str.append(" from T_HR_PersonBURelation t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.Fid ");
        str.append(" inner join T_HR_PersonBUBrowse t2 on t0.FPersonId = t2.FPersonId ");
        str.append(" and t0.FHrOrgUnitID = t2.FNewHROrgUnitID and t0.FEmpOrgRelationID = t2.FEmpOrgRelationID ");
        str.append(" and t0.FBizManageTypeID = t2.FBizManageTypeID ");
        str.append(" where t0.FItemState in (0, 1, 3) ");
        str.append(" and t0.FBizManageTypeID = 'cEzQ1pHpEE+h9QzcFAj//2WJ1dE=' ");
        str.append(" and t2.FCreatorId = '" + userId + "'");
        return str.toString();
    }

    public static String updateFixAdjustEmpState(int empState, String empId) {
        StringBuilder str = new StringBuilder();
        str.append(" update T_HR_SFixAdjustSalary set FEmpState = ").append(empState);
        str.append(" where FAdjEmpORelationID in (");
        str.append(" select fid from T_HR_SAdjustEmpORelation ");
        str.append(" where FEmpOrgRelationID = '").append(empId).append("') ");
        return str.toString();
    }

    public static String updateBatchaAdjustEmpState(int empState, String empId) {
        StringBuilder str = new StringBuilder();
        str.append(" update T_HR_SBatchAdjustBillEntry set FEmpState = ").append(empState);
        str.append(" where FAdjEmpORelationID in (");
        str.append(" select fid from T_HR_SAdjustEmpORelation ");
        str.append(" where FEmpOrgRelationID = '").append(empId).append("') ");
        return str.toString();
    }

    public static String updatePersonRecord(String ids) {
        StringBuilder str = new StringBuilder();
        str.append(" update T_HR_SAdjustEMPORelation tt set FPersonRecordID = (");
        str.append(" select t0.fid ");
        str.append(" from T_HR_SAdjustPersonRecord t0 ");
        str.append(" inner join T_HR_PersonBURelation t1 on t0.FPersonId = t1.FPersonId and t0.FHRORGUNITID = t1.FHRORGUNITID ");
        str.append(" where tt.FPERSONBURELATIONID = t1.fid and tt.FPersonId = t1.FPersonId) ");
        str.append(" where tt.FPersonRecordID is null ");
        str.append(" and tt.fid in (" + ids + ")");
        return str.toString();
    }

    public static String getRecordIdByEmp(String ids) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select tt.fid ");
        sb.append(" from T_HR_SAdjustPersonRecord tt ");
        sb.append(" inner join T_HR_SAdjustEmpORelation t0 on tt.fid = t0.FPersonRecordID ");
        sb.append(" where t0.fid in (" + ids + ") ");
        return sb.toString();
    }

    public static String getMaxAdjustEmpDateByRecord(String recordIds, Date date, Context ctx) {
        String sqlDate = CmpDateUtil.toKSqlDate(date);
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select t0.FPersonRecordID as recFid, t1.fid as FPersonId, t1.FName_" + l + " as perName, max(t0.FleffectDate) as FRealEndDate ");
        str.append(" from T_HR_SAdjustEmpORelation t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" inner join T_HR_SAdjustPersonRecord t2 on t0.FPersonRecordID = t2.fid ");
        str.append(" where t0.FPersonRecordID in (" + recordIds + ") and t0.FleffectDate < {ts '2199-12-31'} ");
        str.append(" and t0.FleffectDate <> t2.FleffectDate ");
        str.append(" group by t0.FPersonRecordID, t1.fid, t1.FName_" + l + " ");
        str.append(" having max(t0.FleffectDate) > " + sqlDate);
        str.append(" union ");
        str.append(" select t0.FPersonRecordID as recFid, t1.fid as FPersonId, t1.FName_" + l + " as perName, max(t0.FEffectDate) as FRealEndDate ");
        str.append(" from T_HR_SAdjustEmpORelation t0 ");
        str.append(" inner join T_BD_Person t1 on t0.FPersonId = t1.fid ");
        str.append(" where t0.FPersonRecordID in (" + recordIds + ") ");
        str.append(" group by t0.FPersonRecordID, t1.fid, t1.FName_" + l + " ");
        str.append(" having max(t0.FEffectDate) > " + sqlDate);
        return str.toString();
    }

    public static String getMaxFixByRecord(String recordIds, Date date, Context ctx) {
        String sqlDate = CmpDateUtil.toKSqlDate(date);
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append(" select t2.FID as recFid, t1.fid as FPersonId, t1.FName_" + l + " as perName, max(tt.FLeffectDay) as FRealEndDate ");
        str.append(" from T_HR_SFixAdjustSalary tt ");
        str.append(" inner join T_BD_Person t1 on tt.FPersonId = t1.fid ");
        str.append(" inner join T_HR_SAdjustPersonRecord t2 on tt.FPersonId = t2.FPersonId and tt.FAdjHrOrgUnitID = t2.FHrOrgUnitID ");
        str.append(" where t2.FID in (" + recordIds + ") and tt.FLeffectDay < {ts '2199-12-31'} ");
        str.append(" and tt.FLeffectDay <> t2.FleffectDate ");
        str.append(" group by t2.FID, t1.fid, t1.FName_" + l + " ");
        str.append(" having max(tt.FLeffectDay) > " + sqlDate);
        str.append(" union ");
        str.append(" select t2.FID as recFid, t1.fid as FPersonId, t1.FName_" + l + " as perName, max(tt.FeffectDay) as FRealEndDate ");
        str.append(" from T_HR_SFixAdjustSalary tt ");
        str.append(" inner join T_BD_Person t1 on tt.FPersonId = t1.fid ");
        str.append(" inner join T_HR_SAdjustPersonRecord t2 on tt.FPersonId = t2.FPersonId and tt.FAdjHrOrgUnitID = t2.FHrOrgUnitID ");
        str.append(" where t2.FID in (" + recordIds + ") ");
        str.append(" group by t2.FID, t1.fid, t1.FName_" + l + " ");
        str.append(" having max(tt.FeffectDay) > " + sqlDate);
        return str.toString();
    }

    public static String getAdjustEmpORelationNewSQL(Object[] array) {
        StringBuilder str = new StringBuilder();
        str.append(" select t.FPersonBURelationID ,t.fid  from T_HR_SAdjustEmpORelation t ");
        str.append(" inner join T_HR_SAdjustEmpORelation n on t.FPersonRecordID = n.FPersonRecordID ");
        str.append(" left join T_HR_EmpOrgRelation ten on ten.Fid = t.FEmpOrgRelationID  ");
        str.append(" left join T_HR_EmpOrgRelation nen on nen.Fid = n.FEmpOrgRelationID  ");
        str.append(" where t.feffectdate <= n.feffectdate and ten.FStartDateTime < nen.FStartDateTime and t.fid  in (" + CmpStrUtil.convertListToString(array) + ") ");
        return str.toString();
    }

    public static String updateAdjustEmpORelationLeffectDate(List<String> list) {
        StringBuilder str = new StringBuilder();
        str.append(" update  T_HR_SAdjustEmpORelation  set FLeffectDate = (select fleffdt from T_HR_EmpOrgRelation t where t.fid =FEmpOrgRelationID  )");
        str.append(" where FPersonRecordID in  (" + CmpStrUtil.convertListToString(list) + ") and FLeffectDate<{ts'2199-12-31'} ");
        return str.toString();
    }

    public static String getAdjustBillEntry(Context ctx, String recordIds, Date date) {
        StringBuilder str = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        str.append("SELECT rec.FID as recFid, p.Fname_" + l + " as perName, bill.FNUMBER as billNum FROM t_hr_sbatchAdjustBillEntry entry ");
        str.append("inner join T_HR_SBatchAdjustBill bill on entry.FBILLID = bill.FID ");
        str.append("inner join T_HR_SAdjustPersonRecord rec on rec.FHrOrgUnitID = bill.FHrOrgUnitID and rec.FPersonId = entry.FPersonId ");
        str.append("inner join T_BD_Person p on entry.FPERSONID = p.FID ");
        str.append("where rec.FID in (" + recordIds + ") ");
        str.append("and bill.FBillState in (1,2) ");
        return str.toString();
    }

    public static String getAdjustSalaryApplyEntry(Context ctx, String recordIds, Date date) throws SQLException, BOSException {
        StringBuilder str = new StringBuilder();
        str.append("SELECT distinct tableRel.FAdjustSalaryRule, tableRel.FBillEntryTableName FROM T_HR_SAdjustSalaryApply bill ");
        str.append("inner join T_HR_SAdjSalaryTableRelation tableRel on bill.FAdjustSalaryRuleID = tableRel.FAdjustSalaryRule ");
        str.append("and bill.FBILLSTATE in (1,2) ");
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, str.toString());
        str.setLength(0);
        String billEntryTableName = null;
        int index = 0;
        String l = LocaleUtils.getShortCode((Context)ctx);
        while (rs.next()) {
            billEntryTableName = rs.getString("FBillEntryTableName");
            if (index > 0) {
                str.append(" union ");
            }
            str.append("SELECT rec.FID as recFid, p.Fname_" + l + " as perName, bill.FNUMBER as billNum FROM " + billEntryTableName + " entry ");
            str.append("inner join T_HR_SAdjustSalaryApply bill on entry.FBILLID = bill.FID ");
            str.append("inner join T_HR_SAdjustPersonRecord rec on rec.FHrOrgUnitID = bill.FHrOrgUnitID and rec.FPersonId = entry.FPersonId ");
            str.append("inner join T_BD_Person p on entry.FPERSONID = p.FID ");
            str.append("where rec.FID in (" + recordIds + ") ");
            str.append("and bill.FBillState in (1,2) ");
            ++index;
        }
        return str.toString();
    }

    public static String getBatchAdjustBillPerson(String personId, Context ctx) {
        String sql = "select FPersonId,A02.fnumber billNumber from T_HR_SBatchAdjustBillEntry A01  inner join T_HR_SBatchAdjustBill A02 on A01.FBillId = A02.fid and A02.FBillState not in (3,4)  where A01.FPersonID ='" + personId + "'";
        return sql;
    }

    public static String getBatchAdjustBillPersonByRelationID(String empId, Context ctx) {
        String sql = "select FPersonId,A02.fnumber billNumber from T_HR_SBatchAdjustBillEntry A01  inner join T_HR_SBatchAdjustBill A02 on A01.FBillId = A02.fid and A02.FBillState not in (3,4)  where FAdjEmpORelationID ='" + empId + "'";
        return sql;
    }

    public static String getAdjustSalaryApplyPerson(String personId, String tableName) {
        String sql = "SELECT ENTRY.fpersonid,ENTRY.fbillid FROM " + tableName + " ENTRY  inner join T_BD_PERSON P ON P.FID = ENTRY.fpersonid  where ENTRY.fpersonid in ('" + personId + "')";
        return sql;
    }

    public static String getAdjustSalaryApplyPersonByRelationID(String empId, String tableName) {
        String sql = "SELECT ENTRY.fpersonid,ENTRY.fbillid FROM " + tableName + " ENTRY  inner join T_BD_PERSON P ON P.FID = ENTRY.fpersonid  where ENTRY.fadjustemporelationid in ('" + empId + "')";
        return sql;
    }

    public static String getBatchSubmitBillPerson(String personId, String tableName) {
        String sql = "SELECT ENTRY.fpersonid,ENTRY.fbillid FROM " + tableName + " ENTRY  inner join T_BD_PERSON P ON P.FID = ENTRY.fpersonid  where ENTRY.fpersonid in ('" + personId + "')";
        return sql;
    }

    public static String getBatchSubmitBillPersonByRelationID(String empId, String tableName) {
        String sql = "SELECT ENTRY.fpersonid,ENTRY.fbillid FROM " + tableName + " ENTRY  inner join T_BD_PERSON P ON P.FID = ENTRY.fpersonid  where ENTRY.fcmpemporelationid in ('" + empId + "')";
        return sql;
    }
}

