/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.TaxDeclareStatusEnum;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarResultDataVO;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarResultVO;
import com.kingdee.shr.compensation.app.entity.taxdeclar.TaxDeclarTbTypeDataVO;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarInfo;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTask;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceFacadeFactory;
import com.kingdee.shr.compensation.tax.task.impl.TaxReportService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.SHRStringUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxReportFeedBackService
extends TaxReportService {
    private static Logger logger = Logger.getLogger(TaxReportFeedBackService.class);
    private static final List<String> TAX_DECLARE_FIELDS = Lists.newArrayList((Object[])new String[]{"Fid", "FPersonID", "FPeriodYear", "FPeriodMonth", "FTaxPeriodBegin", "FTaxPeriodEnd", "FTaxUnitID", "FIdType", "FIdNO", "FTaxPayerNum", "FIsPersonal", "FProceedItem", "FIncome", "FCost", "FExemptIncome", "FDeductions", "FBasicPension", "FBasicMedical", "FUnemployment", "FHousingFund", "FAnnuity", "FComHelath", "FTaxDeferred", "FOriginalValue", "FTaxAllowReduct", "FOtherDeductions", "FIncomeSum", "FDeductionSum", "FSpecialDeductSum", "FChildEducateSum", "FOldSupportSum", "FLoanInterestSum", "FHousingRentSum", "FContinueEducateSum", "FOtherDeductionSum", "FTaxableRatio", "FAllowDonationSum", "FTaxableIncomeSum", "FTaxRatio", "FQuickDeduct", "FTaxPayableSum", "FTaxCreditSum", "FTaxPaidSum", "FTaxSupOrRefund", "FSourceType", "FItemDefine", "FSumOperate", "FDescription_l2", "FCREATETIME", "FLASTUPDATETIME", "FInfantSum", "fReportName", "FPersonalPension"});

    @Override
    public boolean isData4Resolving(String code) {
        return true;
    }

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        TaxDeclarResultVO taxDeclarResultVO = (TaxDeclarResultVO)JSON.parseObject((String)response, TaxDeclarResultVO.class);
        TaxDeclarResultDataVO data = taxDeclarResultVO.getData();
        TaxDeclarTbTypeDataVO ykyjsbjg = data.getYkyjsbjg();
        TaxDeclarTbTypeDataVO flsdsbjg = data.getFlsdsbjg();
        TaxDeclarTbTypeDataVO fjmsbjg = data.getFjmsbjg();
        String ykyjsbErrInfo = ykyjsbjg.getErrorinfo();
        String flsdsbErrInfo = flsdsbjg.getErrorinfo();
        String fjmsbErrorInfo = fjmsbjg.getErrorinfo();
        StringBuilder errorMsgBuf = new StringBuilder();
        this.constructErrorInfo(taxDeclarResultVO, errorMsgBuf, ykyjsbErrInfo, flsdsbErrInfo, fjmsbErrorInfo);
        String taskId = taskInfo.getId().toString();
        IncomeTaxDeclarInfo declareInfo = this.getIncomeTaxDeclareInfo(ctx, taskId);
        String tbTypeVal = declareInfo.getTbType().getValue();
        String taxUnitId = declareInfo.getTaxUnit().getId().toString();
        String yearMonth = declareInfo.getYearMonth();
        ITaxCalTask iTaxCalTask = TaxCalTaskFactory.getLocalInstance((Context)ctx);
        if ("0000".equals(taxDeclarResultVO.getCode())) {
            int sbfkbz = 0;
            if ("1".equals(tbTypeVal)) {
                sbfkbz = ykyjsbjg.getSbfkbz() == null ? 0 : ykyjsbjg.getSbfkbz();
            } else if ("2".equals(tbTypeVal)) {
                sbfkbz = flsdsbjg.getSbfkbz() == null ? 0 : flsdsbjg.getSbfkbz();
            } else if ("3".equals(tbTypeVal)) {
                sbfkbz = fjmsbjg.getSbfkbz() == null ? 0 : fjmsbjg.getSbfkbz();
            }
            switch (sbfkbz) {
                case 3: {
                    iTaxCalTask.updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label156", (Locale)ctx.getLocale()));
                    this.updateDeclareStatus(ctx, declareInfo.getId().toString(), "2", 0);
                    this.updateTaxDeclareRecordStatus(ctx, tbTypeVal, taxUnitId, yearMonth, "2");
                    this.insertDataToTaxDeclareResult(ctx, tbTypeVal, taxUnitId, yearMonth);
                    try {
                        this.sendMsgForTaxReport(ctx, taskId, declareInfo, TaxDeclareStatusEnum.DECLARE_SUCCESS);
                    }
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    TaxPaymentServiceFacadeFactory.getLocalInstance((Context)ctx).initPaymentData(taskId);
                    break;
                }
                case 4: {
                    this.handleFailTaxDeclare(ctx, tbTypeVal, taskId, errorMsgBuf, declareInfo, taxUnitId, yearMonth);
                    try {
                        this.sendMsgForTaxReport(ctx, taskId, declareInfo, TaxDeclareStatusEnum.DECLARE_FAIL);
                    }
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    break;
                }
                case 5: {
                    iTaxCalTask.updateStateMsgById(taskId, TaxCalTaskStateEnum.RUNNING, EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label157", (Locale)ctx.getLocale()));
                    break;
                }
                default: {
                    iTaxCalTask.updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label156", (Locale)ctx.getLocale()));
                    break;
                }
            }
        } else {
            try {
                this.handleFailTaxDeclare(ctx, tbTypeVal, taskId, errorMsgBuf, declareInfo, taxUnitId, yearMonth);
                this.sendMsgForTaxReport(ctx, taskId, declareInfo, TaxDeclareStatusEnum.DECLARE_FAIL);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private IncomeTaxDeclarInfo getIncomeTaxDeclareInfo(Context ctx, String taskId) throws BOSException {
        String oql = "select id,taxUnit.id,taxUnit.name,yearMonth,declareStatus,tbType where taxRebackTask.id='" + taskId + "'";
        try {
            return IncomeTaxDeclarFactory.getLocalInstance((Context)ctx).getIncomeTaxDeclarInfo(oql);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void handleFailTaxDeclare(Context ctx, String tbTypeVal, String taskId, StringBuilder errorMsgBuf, IncomeTaxDeclarInfo declarInfo, String taxUnitId, String yearMonth) throws BOSException {
        logger.info((Object)("HandleTaxDeclarRebackResultService updateStateMsgByAcceptID---\u5176\u4ed6-->msg:" + errorMsgBuf.toString()));
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FAIDED, errorMsgBuf.toString());
        this.updateDeclareStatus(ctx, declarInfo.getId().toString(), "3");
        this.updateTaxDeclareRecordStatus(ctx, tbTypeVal, taxUnitId, yearMonth, "3");
    }

    private void updateDeclareStatus(Context ctx, String declareId, String status) throws BOSException {
        String sql = "update t_hr_sIncomeTaxDeclar set FDeclareStatus = ? where fid = ?";
        Object[] param = new Object[]{status, declareId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    private void updateDeclareStatus(Context ctx, String declareId, String status, int isCancelled) throws BOSException {
        String sql = "update t_hr_sIncomeTaxDeclar set FDeclareStatus = ?, FIsCancelled = ? where fid = ?";
        Object[] param = new Object[]{status, isCancelled, declareId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    private void insertDataToTaxDeclareResult(Context ctx, String tbTypeVal, String taxUnitId, String yearMonth) throws BOSException {
        StringBuilder inserSqlBuf = new StringBuilder();
        Date nowDate = new Date();
        String kSqlDate = CmpDateUtil.toKSqlDate(nowDate);
        String[] arr = yearMonth.split("-");
        int year = Integer.parseInt(arr[0]);
        int month = Integer.parseInt(arr[1]);
        this.getTaxDeclarationInsertSQL(inserSqlBuf);
        StringBuilder selSqlBuffer = new StringBuilder();
        selSqlBuffer.append(" SELECT newbosid('F5587F94'),d.FPERSONID,d.FPERIODYEAR,d.FPERIODMONTH,d.FPERIODBEGIN,d.FPERIODEND,d.FTAXUNITID,d.FIDTYPE,d.FIDNO,d.FTAXPAYERNUM,d.FISPERSONAL,d.FPROCEEDITEM,");
        selSqlBuffer.append(" T1,T25,T2,T23,T3,T4,T5,T6,T12,T13,T14,T42,T18, ");
        selSqlBuffer.append(" T15,T20,T24,T26,T7,T11,T9,T10,T8,T28,T45, ");
        selSqlBuffer.append(" T43,T29,T30,T31,T32,T33,T34,T36,T37,FItemDefine,T41, ");
        selSqlBuffer.append(kSqlDate).append(" as FCREATETIME, ");
        selSqlBuffer.append(kSqlDate).append(" as FLASTUPDATETIME, t.fReportName fReportName, t46");
        selSqlBuffer.append(" from T_HR_STaxDeclareRecord d left join t_hr_sTaxPersonRecord t on d.FPERSONID=t.FPERSONID ");
        selSqlBuffer.append(" WHERE fTaxUnitId = '");
        selSqlBuffer.append(taxUnitId).append("' ");
        if ("1".equals(tbTypeVal)) {
            selSqlBuffer.append(" and FIsPersonal=0 ");
        } else if ("3".equals(tbTypeVal)) {
            selSqlBuffer.append(" and FIsPersonal=1 ");
        }
        selSqlBuffer.append(" and FPeriodYear = ").append(year);
        selSqlBuffer.append(" and FPeriodMonth = ").append(month);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selSqlBuffer.toString());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        if (rowSet.size() == 0) {
            return;
        }
        try {
            while (rowSet.next()) {
                Object[] base = new Object[53];
                base[0] = BOSUuid.create((String)"F5587F94").toString();
                base[1] = rowSet.getObject("FPERSONID");
                base[2] = rowSet.getObject("FPERIODYEAR");
                base[3] = rowSet.getObject("FPERIODMONTH");
                base[4] = rowSet.getObject("FPERIODBEGIN");
                base[5] = rowSet.getObject("FPERIODEND");
                base[6] = rowSet.getObject("FTAXUNITID");
                base[7] = rowSet.getObject("FIDTYPE");
                base[8] = rowSet.getObject("FIDNO");
                base[9] = rowSet.getObject("FTAXPAYERNUM");
                base[10] = rowSet.getObject("FISPERSONAL");
                base[11] = rowSet.getObject("FPROCEEDITEM");
                base[12] = rowSet.getObject("T1");
                base[13] = rowSet.getObject("T25");
                base[14] = rowSet.getObject("T2");
                base[15] = rowSet.getObject("T23");
                base[16] = rowSet.getObject("T3");
                base[17] = rowSet.getObject("T4");
                base[18] = rowSet.getObject("T5");
                base[19] = rowSet.getObject("T6");
                base[20] = rowSet.getObject("T12");
                base[21] = rowSet.getObject("T13");
                base[22] = rowSet.getObject("T14");
                base[23] = rowSet.getObject("T42");
                base[24] = rowSet.getObject("T18");
                base[25] = rowSet.getObject("T15");
                base[26] = rowSet.getObject("T20");
                base[27] = rowSet.getObject("T24");
                base[28] = rowSet.getObject("T26");
                base[29] = rowSet.getObject("T7");
                base[30] = rowSet.getObject("T11");
                base[31] = rowSet.getObject("T9");
                base[32] = rowSet.getObject("T10");
                base[33] = rowSet.getObject("T8");
                base[34] = rowSet.getObject("T28");
                BigDecimal t43 = null;
                String t43Str = rowSet.getString("T43");
                if (!StringUtils.isEmpty((String)t43Str)) {
                    t43 = new BigDecimal(t43Str);
                }
                base[35] = t43;
                base[36] = rowSet.getObject("T29");
                base[37] = rowSet.getObject("T30");
                base[38] = rowSet.getObject("T31");
                base[39] = rowSet.getObject("T32");
                base[40] = rowSet.getObject("T33");
                base[41] = rowSet.getObject("T34");
                base[42] = rowSet.getObject("T36");
                base[43] = rowSet.getObject("T37");
                base[44] = "inner";
                base[45] = rowSet.getObject("FItemDefine");
                base[46] = 0;
                base[47] = rowSet.getObject("T41");
                base[48] = rowSet.getObject("FCREATETIME");
                base[49] = rowSet.getObject("FLASTUPDATETIME");
                base[50] = rowSet.getObject("T45");
                base[51] = rowSet.getObject("fReportName");
                base[52] = rowSet.getObject("t46");
                paramList.add(base);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        this.deleteOldData(ctx, tbTypeVal, taxUnitId, year, month);
        DbUtil.executeBatch((Context)ctx, (String)inserSqlBuf.toString(), paramList);
    }

    private void getTaxDeclarationInsertSQL(StringBuilder insertSQL) {
        int i;
        insertSQL.append("insert into T_HR_STaxDeclaration (");
        int len = TAX_DECLARE_FIELDS.size();
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                insertSQL.append(",");
            }
            insertSQL.append(TAX_DECLARE_FIELDS.get(i));
        }
        insertSQL.append(") values (");
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                insertSQL.append(",");
            }
            insertSQL.append("?");
        }
        insertSQL.append(")");
    }

    private void deleteOldData(Context ctx, String tbTypeVal, String taxUnitId, int year, int month) throws BOSException {
        int isPersonal = "1".equals(tbTypeVal) ? 0 : 1;
        Object[] delParam = new Object[]{taxUnitId, year, month, isPersonal};
        String deleteSQL = "delete from T_HR_STaxDeclaration where fTaxUnitId = ? and FPeriodYear = ? and FPeriodMonth = ? and FIsPersonal = ?";
        DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])delParam);
    }

    private void constructErrorInfo(TaxDeclarResultVO taxDeclarResultVO, StringBuilder errorMsgBuf, String ykyjErrinfo, String flsdErrinfo, String fjmErrinfo) {
        errorMsgBuf.append(SHRStringUtil.getStr(taxDeclarResultVO.getMsg()));
        if (SHRStringUtil.isNotBlank(ykyjErrinfo)) {
            errorMsgBuf.append(ykyjErrinfo);
        }
        if (SHRStringUtil.isNotBlank(flsdErrinfo)) {
            errorMsgBuf.append(flsdErrinfo);
        }
        if (SHRStringUtil.isNotBlank(fjmErrinfo)) {
            errorMsgBuf.append(fjmErrinfo);
        }
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String taskId = taskInfo.getId().toString();
        try {
            IncomeTaxDeclarInfo declareInfo = this.getIncomeTaxDeclareInfo(ctx, taskId);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("declareStatus"));
            declareInfo.setDeclareStatus(TaxDeclareStatusEnum.getEnum("3"));
            IncomeTaxDeclarFactory.getLocalInstance((Context)ctx).updatePartial(declareInfo, selectorItemCollection);
            String tbTypeVal = declareInfo.getTbType().getValue();
            String yearMonth = declareInfo.getYearMonth();
            this.updateTaxDeclareRecordStatus(ctx, tbTypeVal, taskInfo.getTaxUnit().getId().toString(), yearMonth, "3");
            this.sendMsgForTaxReport(ctx, taskId, declareInfo, TaxDeclareStatusEnum.DECLARE_FAIL);
        }
        catch (EASBizException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
            throw new BOSException(e);
        }
    }

    private void updateTaxDeclareRecordStatus(Context ctx, String tbTypeVal, String taxUnitId, String yearMonth, String declareStatusVal) throws BOSException {
        StringBuilder updateBuffer = new StringBuilder();
        updateBuffer.append(" UPDATE T_HR_STaxDeclareRecord SET FDeclareStatus='").append(declareStatusVal).append("'");
        updateBuffer.append(" WHERE FTaxUnitId = '");
        updateBuffer.append(taxUnitId).append("'");
        if ("1".equals(tbTypeVal)) {
            updateBuffer.append(" and FIsPersonal=0 ");
        } else if ("3".equals(tbTypeVal)) {
            updateBuffer.append(" and FIsPersonal=1 ");
        }
        String[] arr = yearMonth.split("-");
        int year = Integer.parseInt(arr[0]);
        int month = Integer.parseInt(arr[1]);
        updateBuffer.append(" and FPeriodYear = ").append(year);
        updateBuffer.append(" and FPeriodMonth = ").append(month);
        DbUtil.execute((Context)ctx, (String)updateBuffer.toString());
    }
}

