/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTask;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTaskDetail;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskDetailCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskDetailFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskDetailInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.taxCal.IHandleFailureAfterGetReportInfo;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HandleFailure4FbSubmit
implements IHandleFailureAfterGetReportInfo {
    private static final Logger logger = Logger.getLogger(HandleFailure4FbSubmit.class);

    @Override
    public void execute(Context ctx, String taskID, String errorMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set FSTATE = ? , FMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((CharSequence)errorMsg) ? "\u9644\u8868\u4e0a\u4f20\u5931\u8d25" : errorMsg, taskID};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        try {
            this.updateReductionInfo(ctx, taskID);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.sendMsg2TaskCreator(ctx, taskID);
    }

    public void updateReductionInfo(Context ctx, String taskId) throws BOSException, SQLException {
        this.updateSummaryStatus(ctx, taskId);
        String sql = "select s.fid, s.fCatalog from T_HR_SReductionSummary s, T_HR_STaskIncomeTaxRelation r where s.fid = r.fBizId and r.fTaskId = '" + taskId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String summaryId = rs.getString("fid");
            int catalog = rs.getInt("fCatalog");
            String updateSQL = catalog == 1 ? "update T_HR_SReductionItem set FStatus = -1 where FSummaryId = '" + summaryId + "'" : (catalog == 2 ? "update T_HR_SCommInsuranceItem set FStatus = -1 where FSummaryId = '" + summaryId + "'" : "update T_HR_STaxDelayInsuranceItem set FStatus = -1 where FSummaryId = '" + summaryId + "'");
            DbUtil.execute((Context)ctx, (String)updateSQL);
        }
    }

    private void updateSummaryStatus(Context ctx, String taskId) throws BOSException {
        String sql = "update T_HR_SReductionSummary set fStatus =-1 where fid in (select fBizId from T_HR_STaskIncomeTaxRelation where fTaskId = '" + taskId + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void sendMsg2TaskCreator(Context ctx, String taskID) {
        try {
            ITaxCalTask taxCalTask = TaxCalTaskFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("state");
            selector.add("number");
            selector.add("taxUnit.id");
            selector.add("taxUnit.name");
            selector.add("period");
            selector.add("creator");
            TaxCalTaskInfo taxCalTaskInfo = taxCalTask.getTaxCalTaskInfo((IObjectPK)new ObjectUuidPK(taskID), selector);
            String number = taxCalTaskInfo.getNumber();
            String state = taxCalTaskInfo.getState().getAlias();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            String incomeItemName = "";
            String title = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label113", (Locale)ctx.getLocale());
            title = MessageFormat.format(title, number);
            String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label114", (Locale)ctx.getLocale());
            String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label107", (Locale)ctx.getLocale());
            ITaxCalTaskDetail taxCalTaskDetail = TaxCalTaskDetailFactory.getLocalInstance((Context)ctx);
            String getDetailOQL = "select person.number,person.name,incomeItem.name where calTask = '" + taskID + "'";
            TaxCalTaskDetailCollection taxCalTaskDetailCollection = taxCalTaskDetail.getTaxCalTaskDetailCollection(getDetailOQL);
            HashSet<String> dupPersonNames = new HashSet<String>();
            ArrayList<String> personNames = new ArrayList<String>();
            if (null != taxCalTaskDetailCollection && taxCalTaskDetailCollection.size() > 0) {
                String personName;
                PersonInfo personInfo;
                TaxCalTaskDetailInfo taxCalTaskDetailInfo;
                int i;
                personNames = new ArrayList();
                int size = taxCalTaskDetailCollection.size();
                for (i = 0; i < size; ++i) {
                    taxCalTaskDetailInfo = taxCalTaskDetailCollection.get(i);
                    personInfo = taxCalTaskDetailInfo.getPerson();
                    personName = personInfo.getName();
                    if (personNames.contains(personName)) {
                        dupPersonNames.add(personName);
                        continue;
                    }
                    personNames.add(personName);
                }
                personNames = new ArrayList();
                size = taxCalTaskDetailCollection.size();
                for (i = 0; i < size; ++i) {
                    taxCalTaskDetailInfo = taxCalTaskDetailCollection.get(i);
                    if (i == 0) {
                        incomeItemName = taxCalTaskDetailInfo.getIncomeItem().getName();
                    }
                    if (dupPersonNames.contains(personName = (personInfo = taxCalTaskDetailInfo.getPerson()).getName())) {
                        String personNumber = personInfo.getNumber();
                        personName = personName + "\uff08" + personNumber + "\uff09";
                    }
                    personNames.add(personName);
                }
            }
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period, incomeItemName, ((Object)personNames).toString().replace("[", "\u3010").replace("]", "\u3011"), state);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, title, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

