/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal.analysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFacadeFactory;
import com.kingdee.shr.compensation.app.tax.IsAllowedQuoted;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalFieldConfigCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalFieldConfigFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalFieldConfigInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CombineDataForTaxCal {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.taxCal.analysis.CombineDataForTaxCal");
    private Map<String, TaxCalFieldConfigCollection> apiFieldMap = new HashMap<String, TaxCalFieldConfigCollection>();
    protected static final List<String> ACCUMULATE_INCOME_CODE = Arrays.asList("0401", "0499", "0500");
    private String taxItems;
    private boolean isDel = false;
    private Set<String> persons;

    public String execute(Context ctx, String taskId) throws BOSException, SQLException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.persons = new HashSet<String>();
        this.intiTaxItem(ctx);
        TaxCalTaskInfo taskInfo = this.combineDataForBody(ctx, taskId, paramMap);
        this.combineIncomeData(ctx, taskId, paramMap);
        this.addPersons4Statistics(paramMap);
        if (null != taskInfo && taskInfo.getCatalog() != TaxCalTaskCatalogEnum.TaxCalDelete) {
            this.addReductionItems(ctx, taskId, paramMap);
        }
        return JSON.toJSONStringWithDateFormat(paramMap, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]);
    }

    private void addReductionItems(Context ctx, String taskId, Map<String, Object> paramMap) throws BOSException, SQLException {
        String updateSQL;
        List<String> idList;
        Map data = (Map)paramMap.get("data");
        boolean flag = this.assembleReductionItems(ctx, taskId, data);
        if (flag) {
            String updateSQL2 = "update T_HR_SReductionItem set fStatus = ? where fid in (select item.fid from t_hr_sReductionItem item, t_hr_sTaxCalTaskDetail task where item.fTaxUnitId = task.fTaxUnitId and item.fPersonId = task.fPersonId and item.fPeriodDate = task.fPeriodBegin and task.fCalTaskId = ?)";
            Object[] param = new Object[]{1, taskId};
            DbUtil.execute((Context)ctx, (String)updateSQL2, (Object[])param);
        }
        if (!(idList = this.assembleCommercialInsItems(ctx, taskId, data)).isEmpty()) {
            updateSQL = "update T_HR_SCommInsuranceItem set fStatus = ? where fid = ?";
            this.updateStatus4Items(ctx, updateSQL, idList);
        }
        if (!(idList = this.assembleTaxDelayInsItems(ctx, taskId, data)).isEmpty()) {
            updateSQL = "update T_HR_STaxDelayInsuranceItem set fStatus = ? where fid = ?";
            this.updateStatus4Items(ctx, updateSQL, idList);
        }
        ReductionSummaryFacadeFactory.getLocalInstance((Context)ctx).updateStatusByTaskId(taskId);
    }

    private void updateStatus4Items(Context ctx, String updateSQL, List<String> idList) throws BOSException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String id : idList) {
            Object[] param = new Object[]{1, id};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
    }

    private List<String> assembleTaxDelayInsItems(Context ctx, String taskId, Map<String, Object> dataMap) throws BOSException, SQLException {
        String sql = "select distinct item.fid, pre.fPayerType payerType, tpr.FCardType zzlx, tpr.FCardNumber zzhm,item.FAccountNo syylzhbh, item.FCheckCode bsjym,item.FAnnualFee ndbf,item.FMonthlyFee ydbf, item.FAmount bqkcje, task.fPeriodBegin periodDate  from t_hr_sTaxDelayInsuranceItem item inner join t_hr_sTaxCalTaskDetail task on item.fTaxUnitId = task.fTaxUnitId and item.fPersonId = task.fPersonId and item.fPeriodDate = task.fPeriodBegin inner join t_hr_sTaxPersonRecord tpr on item.fPersonId = tpr.fPersonId inner join t_hr_sTaxPersonRecordEntry pre on item.fPersonId = pre.fPersonId and item.fTaxUnitId = pre.fTaxUnitId where task.fCalTaskId = '" + taskId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<HashMap<String, Object>> ykyjJmsxList = new ArrayList<HashMap<String, Object>>();
        ArrayList<String> idList = new ArrayList<String>();
        String incomeCode = "syylbxlb";
        while (rs.next()) {
            String payerType = rs.getString("payerType");
            if (StringUtils.isEmpty((String)payerType)) {
                logger.error((Object)("combineTaxDelayInsItems error, please report person first\uff0cperson: " + rs.getString("zzhm")));
                throw new BOSException("\u8bf7\u5148\u5b8c\u6210\u4eba\u5458\u62a5\u9001");
            }
            BigDecimal bqkcje = rs.getBigDecimal("bqkcje");
            if (null == bqkcje) continue;
            TaxCalFieldConfigCollection fields = this.getTaxCalFields(ctx, payerType, incomeCode);
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.initIncomeData(rs, fields, map);
            idList.add(rs.getString("fid"));
            if (!"0".equals(payerType)) continue;
            ykyjJmsxList.add(map);
        }
        if (!ykyjJmsxList.isEmpty()) {
            HashMap ykyjMap = (HashMap)dataMap.get("ykyj");
            if (null == ykyjMap) {
                ykyjMap = new HashMap();
                dataMap.put("ykyj", ykyjMap);
            }
            ykyjMap.put(incomeCode, ykyjJmsxList);
        }
        return idList;
    }

    private List<String> assembleCommercialInsItems(Context ctx, String taskId, Map<String, Object> dataMap) throws BOSException, SQLException {
        String sql = "select distinct item.fid, pre.fPayerType payerType, tpr.FCardType zzlx, tpr.FCardNumber zzhm,item.FTaxPriorityCode sysbm, item.FEffectiveDate bdsxrq,item.FAnnualFee ndbf,item.FMonthlyFee ydbf, item.FAmount bqkcje  from T_HR_SCommInsuranceItem item inner join t_hr_sTaxCalTaskDetail task on item.fTaxUnitId = task.fTaxUnitId and item.fPersonId = task.fPersonId and item.fPeriodDate = task.fPeriodBegin inner join t_hr_sTaxPersonRecord tpr on item.fPersonId = tpr.fPersonId inner join t_hr_sTaxPersonRecordEntry pre on item.fPersonId = pre.fPersonId and item.fTaxUnitId = pre.fTaxUnitId where task.fCalTaskId = '" + taskId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<HashMap<String, Object>> ykyjJmsxList = new ArrayList<HashMap<String, Object>>();
        ArrayList<String> idList = new ArrayList<String>();
        String incomeCode = "syjkbxlb";
        while (rs.next()) {
            String payerType = rs.getString("payerType");
            if (StringUtils.isEmpty((String)payerType)) {
                logger.error((Object)("combineCommercialInsItems error, please report person first\uff0cperson: " + rs.getString("zzhm")));
                throw new BOSException("\u8bf7\u5148\u5b8c\u6210\u4eba\u5458\u62a5\u9001");
            }
            BigDecimal bqkcje = rs.getBigDecimal("bqkcje");
            if (null == bqkcje) continue;
            TaxCalFieldConfigCollection fields = this.getTaxCalFields(ctx, payerType, incomeCode);
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.initIncomeData(rs, fields, map);
            idList.add(rs.getString("fid"));
            if (!"0".equals(payerType)) continue;
            ykyjJmsxList.add(map);
        }
        if (!ykyjJmsxList.isEmpty()) {
            HashMap ykyjMap = (HashMap)dataMap.get("ykyj");
            if (null == ykyjMap) {
                ykyjMap = new HashMap();
                dataMap.put("ykyj", ykyjMap);
            }
            ykyjMap.put(incomeCode, ykyjJmsxList);
        }
        return idList;
    }

    private boolean assembleReductionItems(Context ctx, String taskId, Map<String, Object> data) throws BOSException, SQLException {
        String sql = "select pre.fPayerType payerType, tpr.FCardType zzlx, tpr.FCardNumber zzhm, item.fCatalog jmfs, detail.FIncomeItemCode sdxm, detail.FDetailName jmsx, detail.FNatureName jmxz, sum(item.fAmount) jmje  from t_hr_sReductionItem item inner join t_hr_sTaxCalTaskDetail task on item.fTaxUnitId = task.fTaxUnitId and item.fPersonId = task.fPersonId and item.fPeriodDate = task.fPeriodBegin and item.FIncomeItemId = task.FIncomeItemId inner join t_hr_sReductionDetail detail on item.fDetailId = detail.fid inner join t_hr_sTaxPersonRecord tpr on item.fPersonId = tpr.fPersonId inner join t_hr_sTaxPersonRecordEntry pre on item.fPersonId = pre.fPersonId and item.fTaxUnitId = pre.fTaxUnitId where task.fCalTaskId = '" + taskId + "' group by pre.fPayerType, tpr.FCardType, tpr.FCardNumber, item.fCatalog, detail.FIncomeItemCode, detail.FDetailName, detail.FNatureName";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<HashMap<String, Object>> ykyjJmsxList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> fjmJmsxList = new ArrayList<HashMap<String, Object>>();
        String incomeCode = "jmsxfblb";
        boolean flag = false;
        while (rs.next()) {
            String payerType = rs.getString("payerType");
            if (StringUtils.isEmpty((String)payerType)) {
                logger.error((Object)("combineReductionItems error, please report person first\uff0cperson: " + rs.getString("zzhm")));
                throw new BOSException("\u8bf7\u5148\u5b8c\u6210\u4eba\u5458\u62a5\u9001");
            }
            BigDecimal jmje = rs.getBigDecimal("jmje");
            if (null == jmje) continue;
            flag = true;
            TaxCalFieldConfigCollection fields = this.getTaxCalFields(ctx, payerType, incomeCode);
            logger.debug((Object)("getTaxCalFields1: " + fields.size()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.initIncomeData(rs, fields, map);
            logger.debug((Object)("initIncomeData: " + JSON.toJSONString(map)));
            if ("0".equals(payerType)) {
                ykyjJmsxList.add(map);
                continue;
            }
            if (!"1".equals(payerType)) continue;
            fjmJmsxList.add(map);
        }
        if (!ykyjJmsxList.isEmpty()) {
            HashMap ykyjMap = (HashMap)data.get("ykyj");
            if (null == ykyjMap) {
                ykyjMap = new HashMap();
                data.put("ykyj", ykyjMap);
            }
            ykyjMap.put(incomeCode, ykyjJmsxList);
        }
        if (!fjmJmsxList.isEmpty()) {
            HashMap fjmMap = (HashMap)data.get("fjmsd");
            if (null == fjmMap) {
                fjmMap = new HashMap();
                data.put("fjmsd", fjmMap);
            }
            fjmMap.put(incomeCode, fjmJmsxList);
        }
        logger.debug((Object)("data: " + JSON.toJSONString(data)));
        return flag;
    }

    private void initIncomeData(IRowSet rs, TaxCalFieldConfigCollection fields, Map<String, Object> map) throws SQLException {
        for (int i = 0; i < fields.size(); ++i) {
            Object val;
            TaxCalFieldConfigInfo field = fields.get(i);
            if ("zzlx".equalsIgnoreCase(field.getApiField())) {
                String zzlx = rs.getString(field.getBizField());
                val = CardTypeEnum.getEnum(zzlx).getAlias();
            } else if (field.getApiField().startsWith("sbkcyf_")) {
                Date periodDate = rs.getDate(field.getBizField());
                val = CmpDateUtil.getDateStr(periodDate, "YYYY-MM");
            } else {
                val = rs.getObject(field.getBizField());
                if (val instanceof BigDecimal && ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) {
                    val = BigDecimal.ZERO;
                }
            }
            map.put(field.getApiField(), val);
        }
    }

    private TaxCalTaskInfo combineDataForBody(Context ctx, String taskId, Map<String, Object> paramMap) throws BOSException {
        TaxUnitInfo taxUnitInfo = this.getTaxUnitInfo(ctx, taskId);
        TaxCalTaskInfo taskInfo = null;
        try {
            taskInfo = TaxCalTaskFactory.getLocalInstance((Context)ctx).getTaxCalTaskInfo("where id = '" + taskId + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        if (null == taxUnitInfo || null == taskInfo) {
            return null;
        }
        paramMap.put("nsrsbh", taxUnitInfo.getTaxNumber());
        paramMap.put("areaid", taxUnitInfo.getAreaCode());
        paramMap.put("sdyf", taskInfo.getPeriod().contains("-") ? taskInfo.getPeriod().replace("-", "") : taskInfo.getPeriod());
        paramMap.put("ver", "V2.0.000");
        paramMap.put("smzh", "");
        paramMap.put("smmm", Base64Utils.decode(taxUnitInfo.getRealPassword()));
        String regNumber = taxUnitInfo.getRegNumber();
        paramMap.put("djxhid", regNumber == null ? "" : regNumber);
        paramMap.put("sbmm", Base64Utils.decode(taxUnitInfo.getDeclPassword()));
        if (taxUnitInfo.getIsAutoDeduct().equals((Object)IsAllowedQuoted.YES)) {
            paramMap.put("zxzdkc", "\u662f");
        } else {
            paramMap.put("zxzdkc", "\u5426");
        }
        if (taskInfo.getCatalog().equals((Object)TaxCalTaskCatalogEnum.TaxCalDelete)) {
            this.isDel = true;
        }
        return taskInfo;
    }

    private void addPersons4Statistics(Map<String, Object> paramMap) {
        paramMap.put("persons", this.persons);
    }

    private void combineIncomeData(Context ctx, String taskId, Map<String, Object> paramMap) throws BOSException {
        if (!this.isDel) {
            String sql = this.getCombineSql(taskId);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            this.addIncomeItems(ctx, paramMap, rowSet);
        } else {
            String sql = "select init.fid initId, init.fTaxUnitId, detail.fid detailId  from t_hr_sTaxCalTaskDetail detail  inner join t_hr_sTaxCalConfigDetail config on detail.fCmpCalTableId = config.fCmpCalTableId and detail.fIncomeItemId = config.fIncomeItemId   and detail.fCalTaskId = '" + taskId + "' and config.fIsLast = 1  inner join t_hr_sTaxCalConfigDetail relay on config.fRelayID = relay.fCmpCalTableID and config.fIncomeItemId =relay.fIncomeItemId  inner join t_hr_sTaxCalInitDetail init on relay.fCmpCalTableID = init.fCmpCalTableID and relay.fIncomeItemId =init.fIncomeItemId";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            HashSet<String> initIds = new HashSet<String>();
            HashSet<String> detailIds = new HashSet<String>();
            String taxUnitId = null;
            try {
                while (rowSet.next()) {
                    String initId = rowSet.getString("initId");
                    taxUnitId = rowSet.getString("fTaxUnitId");
                    initIds.add(initId);
                    detailIds.add(rowSet.getString("detailId"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (initIds.isEmpty()) {
                sql = this.getCombineSql(taskId);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                this.addIncomeItems(ctx, paramMap, rowSet);
                return;
            }
            String calTaskId = TaxCalForJSFacadeFactory.getLocalInstance((Context)ctx).beforeDeleteLast(CmpStrUtil.convertCollectionToSql(initIds), taxUnitId);
            this.isDel = false;
            sql = this.getCombineSql(calTaskId);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            this.addIncomeItems(ctx, paramMap, rowSet);
            this.isDel = true;
            sql = this.getCombineExclusionSql(taskId, detailIds);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            this.addIncomeItems(ctx, paramMap, rowSet);
        }
    }

    private void addIncomeItems(Context ctx, Map<String, Object> paramMap, IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                String apiObj;
                ArrayList<Map<String, Object>> incomeData;
                String declareType;
                HashMap<String, Object> calData;
                paramMap.put("accept_id", rowSet.getString("FAcceptId"));
                String payerType = rowSet.getString("PAYERTYPE");
                String incomeNumber = rowSet.getString("INCOMENUMBER");
                TaxCalFieldConfigCollection fields = this.getTaxCalFields(ctx, payerType, incomeNumber);
                if (null == fields) {
                    logger.error((Object)("cannot find TaxCalFieldConfig for payerType: " + payerType + ", incomeNumber = " + incomeNumber));
                    continue;
                }
                Map<String, Object> data = this.assembleTaxItems(rowSet, fields, incomeNumber);
                HashMap dataMap = (HashMap)paramMap.get("data");
                if (null == dataMap) {
                    dataMap = new HashMap();
                    paramMap.put("data", dataMap);
                }
                if (null == (calData = (HashMap<String, Object>)dataMap.get(declareType = fields.get(0).getDeclareType().getValue()))) {
                    calData = new HashMap<String, Object>();
                    calData.put("autofilllzbcfb", "\u662f");
                    dataMap.put(declareType, calData);
                }
                if (null == (incomeData = (ArrayList<Map<String, Object>>)calData.get(apiObj = fields.get(0).getApiObj()))) {
                    incomeData = new ArrayList<Map<String, Object>>();
                    calData.put(apiObj, incomeData);
                }
                incomeData.add(data);
                String xm = (String)data.get("xm");
                String zzlx = (String)data.get("zzlx");
                String zzhm = (String)data.get("zzhm");
                this.persons.add(xm + "_" + zzhm + "_" + zzlx + "_" + paramMap.get("sdyf"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"combineIncomeData error: ", (Throwable)e);
            e.printStackTrace();
        }
    }

    private TaxCalFieldConfigCollection getTaxCalFields(Context ctx, String residentValue, String incomeItemCode) throws BOSException {
        String declareType = "0".equals(residentValue) ? "ykyj" : "fjmsd";
        String key = declareType + "_" + incomeItemCode;
        TaxCalFieldConfigCollection fields = this.apiFieldMap.get(key);
        if (fields != null) {
            return fields;
        }
        String oql = "select declareType, taxItem.fieldSn, bizField, apiField, apiObj, incomeItemCode where declareType = '" + declareType + "' and incomeItemCode = '" + incomeItemCode + "' and isParam = 1";
        fields = TaxCalFieldConfigFactory.getLocalInstance((Context)ctx).getTaxCalFieldConfigCollection(oql);
        this.apiFieldMap.put(key, fields);
        return fields;
    }

    private Map<String, Object> assembleTaxItems(IRowSet rowSet, TaxCalFieldConfigCollection fields, String incomeCode) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < fields.size(); ++i) {
            TaxCalFieldConfigInfo field = fields.get(i);
            TaxItemInfo taxItem = field.getTaxItem();
            String columnName = null == taxItem ? field.getBizField() : "t" + taxItem.getFieldSn();
            Object val = rowSet.getObject(columnName);
            if (null == val) continue;
            if (this.clearRemoteIncome(incomeCode, columnName)) {
                val = BigDecimal.ZERO;
            }
            if ("zzlx".equalsIgnoreCase(columnName)) {
                val = CardTypeEnum.getEnum(val.toString()).getAlias();
            }
            if (val instanceof BigDecimal && ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) {
                val = BigDecimal.ZERO;
            }
            map.put(field.getApiField(), val);
        }
        map.put("sfsc", this.isDel ? "\u662f" : "\u5426");
        return map;
    }

    private boolean clearRemoteIncome(String incomeCode, String columnName) {
        return this.isDel && ACCUMULATE_INCOME_CODE.contains(incomeCode) && ("t1".equalsIgnoreCase(columnName) || "t2".equalsIgnoreCase(columnName) || "t13".equalsIgnoreCase(columnName) || "t14".equalsIgnoreCase(columnName) || "t17".equalsIgnoreCase(columnName));
    }

    private TaxUnitInfo getTaxUnitInfo(Context ctx, String taskId) throws BOSException {
        TaxUnitInfo taxUnitInfo = null;
        try {
            String oql = "select id,taxNumber,areaCode,regNumber,declPassword,realPassword,isAutoDeduct where id in (select FTaxUnitID from T_HR_STaxCalTask where fid = '" + taskId + "')";
            taxUnitInfo = TaxUnitFactory.getLocalInstance((Context)ctx).getTaxUnitInfo(oql);
        }
        catch (EASBizException e) {
            logger.error((Object)"getTaxUnitInfo error: ", (Throwable)e);
        }
        return taxUnitInfo;
    }

    private String getCombineSql(String taskId) {
        return " SELECT RECORD.FCARDTYPE ZZLX, RECORD.FCARDNUMBER ZZHM, RECORD.FReportName XM, ITEM.FINCOMECODE INCOMENUMBER, ITEM.FINCOMECODE SDXM, ENTRY.FAcceptId, FPAYERTYPE PAYERTYPE " + this.taxItems + " FROM T_HR_STAXCALTASKDETAIL DETAIL  INNER JOIN T_HR_STAXPERSONRECORD RECORD ON DETAIL.FPERSONID = RECORD.FPERSONID  INNER JOIN T_BD_PERSON PERSON ON RECORD.FPERSONID = PERSON.FID  INNER JOIN T_HR_STAXPERSONRECORDENTRY ENTRY ON DETAIL.FPERSONID = ENTRY.FPERSONID AND DETAIL.FTAXUNITID = ENTRY.FTAXUNITID  INNER JOIN T_HR_STAXINCOMEITEM ITEM ON ITEM.FID = DETAIL.FINCOMEITEMID  WHERE FCALTASKID = '" + taskId + "'";
    }

    private String getCombineExclusionSql(String taskId, Set<String> detailIds) {
        return " SELECT RECORD.FCARDTYPE ZZLX, RECORD.FCARDNUMBER ZZHM, PERSON.FNAME_L2 XM, ITEM.FINCOMECODE INCOMENUMBER, ITEM.FINCOMECODE SDXM, ENTRY.FAcceptId, FPAYERTYPE PAYERTYPE " + this.taxItems + " FROM T_HR_STAXCALTASKDETAIL DETAIL  INNER JOIN T_HR_STAXPERSONRECORD RECORD ON DETAIL.FPERSONID = RECORD.FPERSONID  INNER JOIN T_BD_PERSON PERSON ON RECORD.FPERSONID = PERSON.FID  INNER JOIN T_HR_STAXPERSONRECORDENTRY ENTRY ON DETAIL.FPERSONID = ENTRY.FPERSONID AND DETAIL.FTAXUNITID = ENTRY.FTAXUNITID  INNER JOIN T_HR_STAXINCOMEITEM ITEM ON ITEM.FID = DETAIL.FINCOMEITEMID  WHERE FCALTASKID = '" + taskId + "' and DETAIL.fid not in (" + CmpStrUtil.convertSetToSqlString(detailIds) + ")";
    }

    protected void intiTaxItem(Context ctx) throws BOSException {
        StringBuilder str = new StringBuilder();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT FIELDSN, FNUMBER  FROM T_HR_STAXITEM ");
        try {
            while (rowSet.next()) {
                str.append(",").append("T").append(rowSet.getInt(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        this.taxItems = str.toString();
    }
}

