/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;

public class EncryptProcessor {
    private static final Logger LOG = Logger.getLogger(EncryptProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptExcel(Workbook workbook, String password, OutputStream outputStream) {
        block5: {
            ByteArrayOutputStream baos = null;
            ByteArrayInputStream workbookInput = null;
            OPCPackage opc = null;
            OutputStream os = null;
            try {
                baos = new ByteArrayOutputStream();
                workbook.write((OutputStream)baos);
                workbook.close();
                workbookInput = new ByteArrayInputStream(baos.toByteArray());
                POIFSFileSystem fs = new POIFSFileSystem();
                EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
                Encryptor enc = info.getEncryptor();
                enc.confirmPassword(password);
                opc = OPCPackage.open((InputStream)workbookInput);
                os = enc.getDataStream(fs);
                opc.save(os);
                os.close();
                fs.writeFilesystem(outputStream);
                outputStream.close();
                fs.close();
                EncryptProcessor.closeIO(os);
            }
            catch (Exception e) {
                LOG.error((Object)"encryptExcel error: ", (Throwable)e);
                break block5;
            }
            finally {
                EncryptProcessor.closeIO(os);
                EncryptProcessor.closeIO(opc);
                EncryptProcessor.closeIO(workbookInput);
                EncryptProcessor.closeIO(baos);
            }
            EncryptProcessor.closeIO((Closeable)opc);
            EncryptProcessor.closeIO(workbookInput);
            EncryptProcessor.closeIO(baos);
        }
    }

    public static void closeIO(Closeable io) {
        if (null != io) {
            try {
                io.close();
            }
            catch (IOException e) {
                LOG.error((Object)"closeIO error: ", (Throwable)e);
            }
        }
    }
}

