/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.staffcontrol.IStaffManageProject;
import com.kingdee.shr.staffcontrol.StaffApplyEntryAssembleDTO;
import com.kingdee.shr.staffcontrol.StaffApplyEntryQueryDTO;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillEntryCollection;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillEntryFactory;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillEntryInfo;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillFactory;
import com.kingdee.shr.staffcontrol.StaffManageApplyBillInfo;
import com.kingdee.shr.staffcontrol.StaffManageChannelEnum;
import com.kingdee.shr.staffcontrol.StaffManageException;
import com.kingdee.shr.staffcontrol.StaffManageProjectFactory;
import com.kingdee.shr.staffcontrol.StaffManageProjectInfo;
import com.kingdee.shr.staffcontrol.StaffManageRuleFieldCollection;
import com.kingdee.shr.staffcontrol.util.IStaffManageChannel;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StaffManageGatherUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.staffcontrol.util.StaffManageGatherUtil");
    public static final String ADMIN_ORG_ID = "FAdminOrgID";
    public static final String POSITION_ID = "FpositionID";
    public static final String AUDITED = "Audited";
    public static final String UNTI_CHECK = "UntiCheck";

    public static void refreshStaffCount(Context ctx, String billId, String type) throws EASBizException, BOSException {
        StaffManageApplyBillInfo applyBillInfo = StaffManageApplyBillFactory.getLocalInstance(ctx).getStaffManageApplyBillInfo((IObjectPK)new ObjectUuidPK(billId));
        StaffManageApplyBillEntryCollection entrys = StaffManageApplyBillEntryFactory.getLocalInstance(ctx).getStaffManageApplyBillEntryCollection("where bill = '" + billId.toString() + "' order by seq");
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        StaffManageGatherUtil.validateEntryOrgAndPos(ctx, billId);
        String projectId = applyBillInfo.getProject().getId().toString();
        IStaffManageProject iStaffManageProject = StaffManageProjectFactory.getLocalInstance(ctx);
        StaffManageProjectInfo projectInfo = iStaffManageProject.getStaffManageProjectInfo((IObjectPK)new ObjectUuidPK(projectId));
        List<StaffApplyEntryQueryDTO> entryQueryDTOs = StaffManageGatherUtil.getEntryAssembleDatas(ctx, entrys, projectInfo);
        Map<String, StaffApplyEntryQueryDTO> relateIdMap = StaffManageGatherUtil.toRowIdMap(entryQueryDTOs);
        if (projectInfo.isGather()) {
            StaffManageGatherUtil.gatherStaff(ctx, entryQueryDTOs, entrys, projectInfo, relateIdMap, type);
        } else {
            StaffManageGatherUtil.updateStaffOnNotGather(ctx, entryQueryDTOs, entrys, projectInfo, relateIdMap, type);
        }
    }

    public static void validateEntryOrgAndPos(Context ctx, String billId) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("entrys.*"));
        selectors.add(new SelectorItemInfo("project.id"));
        selectors.add(new SelectorItemInfo("project.rule"));
        selectors.add(new SelectorItemInfo("project.channel"));
        selectors.add(new SelectorItemInfo("project.tableName"));
        selectors.add(new SelectorItemInfo("project.year"));
        StaffManageApplyBillInfo applyBillInfo = StaffManageApplyBillFactory.getLocalInstance(ctx).getStaffManageApplyBillInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        StaffManageProjectInfo projectInfo = applyBillInfo.getProject();
        StaffManageRuleFieldCollection dimensionColl = StaffManageProjectFactory.getLocalInstance(ctx).getDimensions(projectInfo);
        boolean containPosDimen = false;
        for (int i = 0; i < dimensionColl.size(); ++i) {
            if (!POSITION_ID.equals(dimensionColl.get(i).getColumn())) continue;
            containPosDimen = true;
            break;
        }
        String sql = " select entry.FSeq seq from t_hr_staffmanageapplybillentry entry left join " + projectInfo.getTableName() + " staff on entry.FRelateRowId = staff.fid left join t_org_admin org on staff.fadminorgid = org.fid where entry.fbillid = '" + billId + "' and (org.FISSEALUP = 1 or org.fisstartshr=0) order by entry.FSeq";
        if (containPosDimen) {
            sql = " select entry.FSeq seq from t_hr_staffmanageapplybillentry entry left join " + projectInfo.getTableName() + " staff on entry.FRelateRowId = staff.fid left join t_org_admin org on staff.fadminorgid = org.fid left join t_org_position pos on staff.fpositionid = pos.fid where entry.fbillid = '" + billId + "' and (org.FISSEALUP = 1 or org.fisstartshr=0 or (staff.fpositionid is not null and pos.FDeletedStatus = 2)) order by entry.FSeq";
        }
        ArrayList<String> errorSeq = new ArrayList<String>();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (iRowSet.next()) {
                errorSeq.add(iRowSet.getString("seq"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("StaffManageGatherUtil validateEntryOrgAndPos error:" + e));
            e.printStackTrace();
        }
        if (errorSeq.size() > 0) {
            throw new StaffManageException(StaffManageException.ORG_OR_POS_SEALUP, new Object[]{errorSeq});
        }
    }

    public static List<StaffApplyEntryQueryDTO> getEntryAssembleDatas(Context ctx, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo) throws EASBizException, BOSException {
        if (entrys == null || entrys.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<StaffApplyEntryQueryDTO> results = new ArrayList<StaffApplyEntryQueryDTO>();
        ArrayList<String> rowIds = new ArrayList<String>();
        for (int i = 0; i < entrys.size(); ++i) {
            String rowId = entrys.get(i).getRelateRowId();
            rowIds.add(rowId);
        }
        String rowIdStr = StaffManageGatherUtil.getFidStr(rowIds.toArray());
        String tableName = projectInfo.getTableName();
        StaffManageRuleFieldCollection dimensionColl = null;
        try {
            dimensionColl = StaffManageProjectFactory.getLocalInstance(ctx).getDimensions(projectInfo);
            String dimensionStr = "";
            ArrayList<String> dimensionList = new ArrayList<String>();
            for (int i = 0; i < dimensionColl.size(); ++i) {
                dimensionList.add(dimensionColl.get(i).getColumn());
                dimensionStr = dimensionStr + "staff." + dimensionColl.get(i).getColumn() + " " + dimensionColl.get(i).getColumn() + ",";
            }
            IStaffManageChannel iStaffManageChannel = StaffManageChannelUtil.getInstance(projectInfo.getChannel());
            String channelInDBStr = "";
            List<String> channelInDBs = Arrays.asList(iStaffManageChannel.getSQLChip().split(","));
            for (String channelInDB : channelInDBs) {
                channelInDBStr = channelInDBStr + "staff." + channelInDB + " " + channelInDB + ",";
            }
            String sql = " select staff.FID FID,staff.FNumber FNumber," + dimensionStr + " staff.FPersonCount FPersonCount, staff.fState FState,staff.FContainSub FContainSub,staff.FControlWay FControlWay," + channelInDBStr + " org.FPARENTID FParentId,org.fisleaf FIsLeaf,org.flongnumber FLongNumber from " + tableName + " staff left join t_org_admin org on staff.fadminorgid = org.fid where (staff.fstate = 1 or staff.fid in (" + rowIdStr + ")) and staff.fsharestate <> 1 and org.FISSEALUP = 0 and org.fisstartshr=1";
            if (dimensionList.contains(POSITION_ID)) {
                sql = " select staff.FID FID,staff.FNumber FNumber," + dimensionStr + " staff.FPersonCount FPersonCount, staff.fState FState,staff.FContainSub FContainSub,staff.FControlWay FControlWay," + channelInDBStr + " org.FPARENTID FParentId,org.fisleaf FIsLeaf,org.flongnumber FLongNumber from " + tableName + " staff left join t_org_admin org on staff.fadminorgid = org.fid left join t_org_position pos on staff.fpositionid = pos.fid where (staff.fstate = 1 or staff.fid in (" + rowIdStr + ")) and (pos.FDeletedStatus = 1 or staff.fpositionid is null)  and staff.fsharestate <> 1 and org.FISSEALUP = 0 and org.fisstartshr=1";
            }
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                StaffApplyEntryQueryDTO entryEntryQueryDTO = new StaffApplyEntryQueryDTO();
                LinkedHashMap<String, String> dbDataMap = new LinkedHashMap<String, String>();
                String dimensionValueStr = "";
                String dimenExceptOrgValueStr = "";
                String dimenExceptOrgPosStr = "";
                for (String columnStr : dimensionList) {
                    dbDataMap.put(columnStr, iRowSet.getString(columnStr));
                    dimensionValueStr = dimensionValueStr + iRowSet.getString(columnStr);
                    if (ADMIN_ORG_ID.equals(columnStr)) continue;
                    dimenExceptOrgValueStr = dimenExceptOrgValueStr + iRowSet.getString(columnStr);
                    if (POSITION_ID.equals(columnStr)) continue;
                    dimenExceptOrgPosStr = dimenExceptOrgPosStr + iRowSet.getString(columnStr);
                }
                LinkedHashMap<String, Integer> staffChannelMap = new LinkedHashMap<String, Integer>();
                for (String channelInDB : channelInDBs) {
                    staffChannelMap.put(channelInDB, iRowSet.getInt(channelInDB));
                }
                if (dimensionList.contains(POSITION_ID)) {
                    entryEntryQueryDTO.setHavePosition(Boolean.TRUE);
                    if (StringUtils.isEmpty((String)((String)dbDataMap.get(POSITION_ID)))) {
                        entryEntryQueryDTO.setHavePositionVal(Boolean.FALSE);
                    } else {
                        entryEntryQueryDTO.setHavePositionVal(Boolean.TRUE);
                    }
                } else {
                    entryEntryQueryDTO.setHavePosition(Boolean.FALSE);
                    entryEntryQueryDTO.setHavePositionVal(Boolean.FALSE);
                }
                entryEntryQueryDTO.setDimensionValStr(dimensionValueStr);
                entryEntryQueryDTO.setDimenExceptOrgStr(dimenExceptOrgValueStr);
                entryEntryQueryDTO.setDimenExceptOrgPos(dimenExceptOrgPosStr);
                entryEntryQueryDTO.setFID(iRowSet.getString("FID"));
                entryEntryQueryDTO.setState(iRowSet.getInt("FState"));
                entryEntryQueryDTO.setNumber(iRowSet.getString("FNumber"));
                entryEntryQueryDTO.setLongNumber(iRowSet.getString("FLongNumber"));
                entryEntryQueryDTO.setDimensionMap(dbDataMap);
                entryEntryQueryDTO.setAdminOrgID(iRowSet.getString(ADMIN_ORG_ID));
                entryEntryQueryDTO.setIsLeaf(iRowSet.getInt("FIsLeaf"));
                entryEntryQueryDTO.setParentId(iRowSet.getString("FParentId"));
                entryEntryQueryDTO.setContainSub(iRowSet.getInt("FContainSub"));
                entryEntryQueryDTO.setStaffChannelMap(staffChannelMap);
                entryEntryQueryDTO.setControlWay(iRowSet.getInt("FControlWay"));
                entryEntryQueryDTO.setPersonCount(iRowSet.getInt("FPersonCount"));
                results.add(entryEntryQueryDTO);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return results;
    }

    public static void gatherStaff(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, Map<String, StaffApplyEntryQueryDTO> relateIdMap, String type) throws EASBizException, BOSException {
        IStaffManageProject iStaffManageProject = StaffManageProjectFactory.getLocalInstance(ctx);
        StaffManageRuleFieldCollection dimensionColl = iStaffManageProject.getDimensions(projectInfo);
        String dimension = StaffManageGatherUtil.getDimension(dimensionColl);
        Set<String> updateRowSet = new HashSet<String>();
        updateRowSet = ADMIN_ORG_ID.equals(dimension) ? StaffManageGatherUtil.orgGatherStaff(ctx, entryQueryDTOs, entrys, projectInfo, updateRowSet, relateIdMap, type) : (POSITION_ID.equals(dimension) ? StaffManageGatherUtil.orgAndPosGatherStaff(ctx, entryQueryDTOs, entrys, projectInfo, updateRowSet, relateIdMap, type) : StaffManageGatherUtil.otherGatherStaff(ctx, entryQueryDTOs, entrys, projectInfo, updateRowSet, relateIdMap, type));
        if (AUDITED.equals(type)) {
            StaffManageGatherUtil.updateActualAndStaffChannel(ctx, projectInfo.getChannel().getValue(), entrys, relateIdMap);
        }
        ArrayList<StaffApplyEntryQueryDTO> updateDatas = new ArrayList<StaffApplyEntryQueryDTO>();
        for (StaffApplyEntryQueryDTO data : entryQueryDTOs) {
            if (!updateRowSet.contains(data.getFID())) continue;
            updateDatas.add(data);
        }
        StaffManageGatherUtil.batchUpdateStaffTable(ctx, projectInfo.getTableName(), updateDatas);
    }

    public static Set<String> orgGatherStaff(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, Set<String> updateRowSet, Map<String, StaffApplyEntryQueryDTO> relateIdMap, String type) throws EASBizException, BOSException {
        Map<String, String> channelMap = StaffManageChannelUtil.getInstance(projectInfo.getChannel()).getName2AliasMap(ctx);
        StaffManageGatherUtil.removeEntryDTO(entryQueryDTOs, relateIdMap, entrys);
        for (int i = 0; i < entrys.size(); ++i) {
            StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
            StaffApplyEntryQueryDTO entryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
            entryQueryDTOs.add(entryQueryDTO);
            Map<String, List<StaffApplyEntryQueryDTO>> dimenExceptOrgMap = StaffManageGatherUtil.toDimenExceptOrgMap(entryQueryDTOs);
            List<String> channelCols = StaffManageGatherUtil.getUpdateChannelColumns(entryInfo, projectInfo.getChannel());
            int applyCount = StaffManageGatherUtil.getApplyCount(entryInfo, type);
            List<String> allParentNodeIds = StaffManageGatherUtil.getAllUpNodeId(ctx, entryQueryDTO.getAdminOrgID());
            StaffApplyEntryAssembleDTO assembleDTO = StaffManageGatherUtil.getAssembleData(dimenExceptOrgMap, entryQueryDTO.getDimenExceptOrgStr());
            Boolean isleafNode = StaffManageGatherUtil.isEnableTreeLeaf(entryQueryDTO, entryQueryDTOs);
            if (entryQueryDTO.getContainSub() != 0 && entryQueryDTO.getIsLeaf() != 1 && !isleafNode.booleanValue()) continue;
            Map<String, Integer> entryStaffMap = entryQueryDTO.getStaffChannelMap();
            for (String channelCol : channelCols) {
                int channelStaffVal = entryStaffMap.get(channelCol) + applyCount;
                if (channelStaffVal < 0) {
                    throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_ZERO, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol)});
                }
                entryStaffMap.put(channelCol, channelStaffVal);
            }
            updateRowSet.add(entryQueryDTO.getFID());
            if (entryQueryDTO.getIsLeaf() == 1 || isleafNode.booleanValue()) {
                allParentNodeIds.remove(entryQueryDTO.getAdminOrgID());
            }
            for (String adminId : allParentNodeIds) {
                StaffApplyEntryQueryDTO parentDTO = assembleDTO.getAllStaffMap().get(adminId);
                if (StringUtils.isEmpty((String)adminId) || parentDTO == null) continue;
                Map<String, Integer> adminStaffMap = parentDTO.getStaffChannelMap();
                for (String channelCol : channelCols) {
                    int sumSubStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, assembleDTO, adminId, channelCol);
                    adminStaffMap.put(channelCol, sumSubStaff);
                }
                updateRowSet.add(parentDTO.getFID());
            }
        }
        return updateRowSet;
    }

    public static Set<String> orgAndPosGatherStaff(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, Set<String> updateRowSet, Map<String, StaffApplyEntryQueryDTO> relateIdMap, String type) throws EASBizException, BOSException {
        Map<String, String> channelMap = StaffManageChannelUtil.getInstance(projectInfo.getChannel()).getName2AliasMap(ctx);
        StaffManageGatherUtil.removeEntryDTO(entryQueryDTOs, relateIdMap, entrys);
        for (int i = 0; i < entrys.size(); ++i) {
            StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
            StaffApplyEntryQueryDTO entryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
            entryQueryDTOs.add(entryQueryDTO);
            Boolean isleafNode = StaffManageGatherUtil.isEnableTreeLeaf(entryQueryDTO, entryQueryDTOs);
            if (!entryQueryDTO.isHavePositionVal() && !isleafNode.booleanValue()) continue;
            List<String> channelCols = StaffManageGatherUtil.getUpdateChannelColumns(entryInfo, projectInfo.getChannel());
            int applyCount = StaffManageGatherUtil.getApplyCount(entryInfo, type);
            Map<String, Integer> entryStaffMap = entryQueryDTO.getStaffChannelMap();
            for (String channelCol : channelCols) {
                int channelStaffVal = entryStaffMap.get(channelCol) + applyCount;
                if (channelStaffVal < 0) {
                    throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_ZERO, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol)});
                }
                entryStaffMap.put(channelCol, channelStaffVal);
            }
            updateRowSet.add(entryQueryDTO.getFID());
            ArrayList<StaffApplyEntryQueryDTO> allOrgDatas = new ArrayList<StaffApplyEntryQueryDTO>();
            ArrayList<StaffApplyEntryQueryDTO> allPositionDatas = new ArrayList<StaffApplyEntryQueryDTO>();
            for (StaffApplyEntryQueryDTO staffApplyEntryQueryDTO : entryQueryDTOs) {
                if (StringUtils.isEmpty((String)staffApplyEntryQueryDTO.getDimensionMap().get(POSITION_ID))) {
                    allOrgDatas.add(staffApplyEntryQueryDTO);
                    continue;
                }
                allPositionDatas.add(staffApplyEntryQueryDTO);
            }
            if (allOrgDatas.size() == 0) continue;
            HashMap<String, Object> orgToPositionMap = new HashMap<String, Object>();
            for (StaffApplyEntryQueryDTO positionData : allPositionDatas) {
                Object bList;
                if (null == orgToPositionMap.get(positionData.getAdminOrgID())) {
                    bList = new ArrayList<StaffApplyEntryQueryDTO>();
                    bList.add(positionData);
                    orgToPositionMap.put(positionData.getAdminOrgID(), bList);
                    continue;
                }
                bList = (List)orgToPositionMap.get(positionData.getAdminOrgID());
                bList.add(positionData);
            }
            List<String> list = StaffManageGatherUtil.getAllUpNodeId(ctx, entryQueryDTO.getAdminOrgID());
            if (isleafNode.booleanValue() && entryQueryDTO.getContainSub() == 1) {
                list.remove(entryQueryDTO.getAdminOrgID());
            }
            ArrayList<StaffApplyEntryQueryDTO> allParentOrgDatas = new ArrayList<StaffApplyEntryQueryDTO>();
            for (StaffApplyEntryQueryDTO data : allOrgDatas) {
                if (!entryQueryDTO.getAdminOrgID().equals(data.getAdminOrgID()) || data.getContainSub() != 0) continue;
                allParentOrgDatas.add(data);
            }
            allParentOrgDatas.addAll(StaffManageGatherUtil.getParentNodeDatas(allOrgDatas, list));
            Map<String, List<StaffApplyEntryQueryDTO>> orgMap = StaffManageGatherUtil.toDimenExceptOrgPosMap(allOrgDatas);
            StaffApplyEntryAssembleDTO assembleDTO = StaffManageGatherUtil.getAssembleData(orgMap, entryQueryDTO.getDimenExceptOrgPos());
            for (StaffApplyEntryQueryDTO parentData : allParentOrgDatas) {
                String orgId = parentData.getAdminOrgID();
                Map<String, Integer> channelStaffMap = parentData.getStaffChannelMap();
                if (entryQueryDTO.getAdminOrgID().equals(orgId) && parentData.getContainSub() == 0) {
                    for (String channelCol : channelCols) {
                        int sumSubPositionStaff = 0;
                        String isDirectSql = "select " + channelCol + " from " + projectInfo.getTableName() + " where FAdminOrgID = '" + entryQueryDTO.getAdminOrgID() + "' and (FpositionID is not null or FpositionID<>'') and FState=1;";
                        IRowSet directExecuteQuery = DbUtil.executeQuery((Context)ctx, (String)isDirectSql);
                        if (!(directExecuteQuery != null && directExecuteQuery.size() != 0 || entryQueryDTO.isHavePositionVal())) {
                            sumSubPositionStaff = entryStaffMap.get(channelCol);
                        } else {
                            for (StaffApplyEntryQueryDTO positionDTO : (List)orgToPositionMap.get(orgId)) {
                                sumSubPositionStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
                            }
                        }
                        channelStaffMap.put(channelCol, sumSubPositionStaff);
                    }
                    updateRowSet.add(parentData.getFID());
                    continue;
                }
                for (String channelCol : channelCols) {
                    int orgSubSumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, assembleDTO, assembleDTO, allPositionDatas, parentData, entryQueryDTO, channelCol);
                    channelStaffMap.put(channelCol, orgSubSumStaff);
                }
                updateRowSet.add(parentData.getFID());
            }
        }
        return updateRowSet;
    }

    public static Set<String> otherGatherStaff(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, Set<String> updateRowSet, Map<String, StaffApplyEntryQueryDTO> relateIdMap, String type) throws EASBizException, BOSException {
        Map<String, String> channelMap = StaffManageChannelUtil.getInstance(projectInfo.getChannel()).getName2AliasMap(ctx);
        StaffManageGatherUtil.removeEntryDTO(entryQueryDTOs, relateIdMap, entrys);
        block0: for (int i = 0; i < entrys.size(); ++i) {
            StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
            StaffApplyEntryQueryDTO entryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
            entryQueryDTOs.add(entryQueryDTO);
            List<String> channelCols = StaffManageGatherUtil.getUpdateChannelColumns(entryInfo, projectInfo.getChannel());
            int applyCount = StaffManageGatherUtil.getApplyCount(entryInfo, type);
            String optMsg = StaffManageGatherUtil.getOptStaffMsg(ctx, entryInfo, type);
            if (entryInfo.getSeq() == 0) {
                entryInfo.setSeq(i + 1);
            }
            Map<String, Integer> entryStaffMap = entryQueryDTO.getStaffChannelMap();
            for (String channelCol : channelCols) {
                int channelStaffVal = entryStaffMap.get(channelCol) + applyCount;
                if (channelStaffVal < 0) {
                    throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_ZERO, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol)});
                }
                entryStaffMap.put(channelCol, channelStaffVal);
            }
            updateRowSet.add(entryQueryDTO.getFID());
            List<String> allParentNodeIds = StaffManageGatherUtil.getAllUpNodeId(ctx, entryQueryDTO.getAdminOrgID());
            if (entryQueryDTO.isHavePosition()) {
                StaffManageGatherUtil.otherAndHavePosGatherStaff(ctx, entryQueryDTOs, entryInfo, entryQueryDTO, updateRowSet, allParentNodeIds, channelCols, channelMap, type);
                continue;
            }
            Map<String, List<StaffApplyEntryQueryDTO>> dimenExceptOrgMap = StaffManageGatherUtil.toDimenExceptOrgMap(entryQueryDTOs);
            StaffApplyEntryAssembleDTO assembleDTO = StaffManageGatherUtil.getAssembleData(dimenExceptOrgMap, entryQueryDTO.getDimenExceptOrgStr());
            String orgId = entryQueryDTO.getAdminOrgID();
            if (entryQueryDTO.getContainSub() == 1) {
                for (String channelCol : channelCols) {
                    int sumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, assembleDTO, orgId, channelCol);
                    if (entryQueryDTO.getStaffChannelMap().get(channelCol) >= sumStaff) continue;
                    throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_SUB, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, entryQueryDTO.getStaffChannelMap().get(channelCol), sumStaff});
                }
            }
            if (entryQueryDTO.getContainSub() == 1) {
                allParentNodeIds.remove(orgId);
            }
            List<StaffApplyEntryQueryDTO> parentNodeDatas = StaffManageGatherUtil.getParentNodeDatas(dimenExceptOrgMap.get(entryQueryDTO.getDimenExceptOrgStr()), allParentNodeIds);
            boolean isAddStaff = StaffManageGatherUtil.isAddStaff(entryInfo, type);
            for (StaffApplyEntryQueryDTO parentData : parentNodeDatas) {
                String parentOrgId = parentData.getAdminOrgID();
                if (StringUtils.isEmpty((String)parentOrgId) || assembleDTO.getAllStaffMap().get(parentOrgId) == null) continue;
                ArrayList<String> needUpdateChannel = new ArrayList<String>();
                Map<String, Integer> channelStaffMap = parentData.getStaffChannelMap();
                for (String channelCol : channelCols) {
                    int subSumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, assembleDTO, parentOrgId, channelCol);
                    int parentStaff = parentData.getStaffChannelMap().get(channelCol);
                    if (isAddStaff && parentStaff < subSumStaff) {
                        if (parentStaff + applyCount < subSumStaff) {
                            throw new StaffManageException(StaffManageException.ADD_STAFF_NOT_ENOUGH, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, subSumStaff, parentStaff + applyCount});
                        }
                        channelStaffMap.put(channelCol, parentStaff + applyCount);
                        needUpdateChannel.add(channelCol);
                        continue;
                    }
                    if (isAddStaff) continue;
                    if (parentStaff < subSumStaff) {
                        throw new StaffManageException(StaffManageException.STAFF_MORE_THAN_PARENT, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, subSumStaff, parentStaff});
                    }
                    if (parentStaff + applyCount < subSumStaff) continue;
                    channelStaffMap.put(channelCol, parentStaff + applyCount);
                    needUpdateChannel.add(channelCol);
                }
                if (needUpdateChannel.size() == 0) continue block0;
                updateRowSet.add(parentData.getFID());
                channelCols = needUpdateChannel;
            }
        }
        return updateRowSet;
    }

    public static void otherAndHavePosGatherStaff(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryInfo entryInfo, StaffApplyEntryQueryDTO entryQueryDTO, Set<String> updateRowSet, List<String> allParentNodeIds, List<String> channelCols, Map<String, String> channelMap, String type) throws EASBizException, BOSException {
        int applyCount = StaffManageGatherUtil.getApplyCount(entryInfo, type);
        String optMsg = StaffManageGatherUtil.getOptStaffMsg(ctx, entryInfo, type);
        ArrayList<StaffApplyEntryQueryDTO> allOrgDatas = new ArrayList<StaffApplyEntryQueryDTO>();
        ArrayList<StaffApplyEntryQueryDTO> allPositionDatas = new ArrayList<StaffApplyEntryQueryDTO>();
        for (StaffApplyEntryQueryDTO queryDTO : entryQueryDTOs) {
            if (StringUtils.isEmpty((String)queryDTO.getDimensionMap().get(POSITION_ID))) {
                allOrgDatas.add(queryDTO);
                continue;
            }
            allPositionDatas.add(queryDTO);
        }
        if (allOrgDatas.size() == 0) {
            return;
        }
        Map<String, List<StaffApplyEntryQueryDTO>> orgMap = StaffManageGatherUtil.toDimenExceptOrgPosMap(allOrgDatas);
        Map<String, List<StaffApplyEntryQueryDTO>> posMap = StaffManageGatherUtil.toDimenExceptOrgPosMap(allPositionDatas);
        StaffApplyEntryAssembleDTO subAssembleDTO = StaffManageGatherUtil.getAssembleData(orgMap, entryQueryDTO.getDimenExceptOrgPos());
        HashMap orgToPositionMap = new HashMap();
        if (posMap.get(entryQueryDTO.getDimenExceptOrgPos()) != null) {
            for (StaffApplyEntryQueryDTO staffApplyEntryQueryDTO : posMap.get(entryQueryDTO.getDimenExceptOrgPos())) {
                List<StaffApplyEntryQueryDTO> bList;
                if (null == orgToPositionMap.get(staffApplyEntryQueryDTO.getAdminOrgID())) {
                    bList = new ArrayList<StaffApplyEntryQueryDTO>();
                    bList.add(staffApplyEntryQueryDTO);
                    orgToPositionMap.put(staffApplyEntryQueryDTO.getAdminOrgID(), bList);
                    continue;
                }
                bList = (List)orgToPositionMap.get(staffApplyEntryQueryDTO.getAdminOrgID());
                bList.add(staffApplyEntryQueryDTO);
            }
        }
        String orgId = entryQueryDTO.getAdminOrgID();
        if (!entryQueryDTO.isHavePositionVal()) {
            for (String channelCol : channelCols) {
                int sumStaff = 0;
                if (entryQueryDTO.getContainSub() == 0 && orgToPositionMap.get(orgId) != null) {
                    for (StaffApplyEntryQueryDTO positionDTO : (List)orgToPositionMap.get(orgId)) {
                        sumStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
                    }
                } else if (entryQueryDTO.getContainSub() == 1) {
                    sumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, subAssembleDTO, subAssembleDTO, allPositionDatas, entryQueryDTO, entryQueryDTO, channelCol);
                }
                if (entryQueryDTO.getStaffChannelMap().get(channelCol) >= sumStaff) continue;
                throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_SUB, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, entryQueryDTO.getStaffChannelMap().get(channelCol), sumStaff});
            }
        }
        ArrayList<StaffApplyEntryQueryDTO> arrayList = new ArrayList<StaffApplyEntryQueryDTO>();
        if (entryQueryDTO.isHavePositionVal()) {
            StaffApplyEntryQueryDTO directAndSameDimen = subAssembleDTO.getDirectStaffMap().get(entryQueryDTO.getAdminOrgID());
            if (directAndSameDimen != null) {
                arrayList.add(directAndSameDimen);
            }
        } else if (entryQueryDTO.getContainSub() == 1) {
            allParentNodeIds.remove(entryQueryDTO.getAdminOrgID());
        }
        if (orgMap.get(entryQueryDTO.getDimenExceptOrgPos()) != null && StaffManageGatherUtil.getParentNodeDatas(orgMap.get(entryQueryDTO.getDimenExceptOrgPos()), allParentNodeIds).size() > 0) {
            arrayList.addAll(StaffManageGatherUtil.getParentNodeDatas(orgMap.get(entryQueryDTO.getDimenExceptOrgPos()), allParentNodeIds));
        }
        boolean isAddStaff = StaffManageGatherUtil.isAddStaff(entryInfo, type);
        for (StaffApplyEntryQueryDTO parentData : arrayList) {
            String parentOrgId = parentData.getAdminOrgID();
            Map<String, Integer> channelStaffMap = parentData.getStaffChannelMap();
            ArrayList<String> needUpdateChannel = new ArrayList<String>();
            if (entryQueryDTO.getAdminOrgID().equals(parentOrgId) && parentData.getContainSub() == 0) {
                for (String channelCol : channelCols) {
                    int parentDirectStaff = parentData.getStaffChannelMap().get(channelCol);
                    int sumSubPositionStaff = 0;
                    if (orgToPositionMap.get(parentOrgId) != null) {
                        for (StaffApplyEntryQueryDTO positionDTO : (List)orgToPositionMap.get(parentOrgId)) {
                            sumSubPositionStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
                        }
                    }
                    if (isAddStaff && parentDirectStaff < sumSubPositionStaff) {
                        if (parentDirectStaff + applyCount < sumSubPositionStaff) {
                            throw new StaffManageException(StaffManageException.ADD_STAFF_NOT_ENOUGH, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, sumSubPositionStaff, parentDirectStaff + applyCount});
                        }
                        channelStaffMap.put(channelCol, parentDirectStaff + applyCount);
                        needUpdateChannel.add(channelCol);
                        continue;
                    }
                    if (isAddStaff) continue;
                    if (parentDirectStaff < sumSubPositionStaff) {
                        throw new StaffManageException(StaffManageException.STAFF_MORE_THAN_PARENT, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, sumSubPositionStaff, parentDirectStaff});
                    }
                    if (parentDirectStaff + applyCount < sumSubPositionStaff) continue;
                    channelStaffMap.put(channelCol, parentDirectStaff + applyCount);
                    needUpdateChannel.add(channelCol);
                }
            } else {
                if (StringUtils.isEmpty((String)parentOrgId) || parentData == null) continue;
                for (String channelCol : channelCols) {
                    int orgSubSumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, subAssembleDTO, subAssembleDTO, allPositionDatas, parentData, entryQueryDTO, channelCol);
                    int parentStaff = parentData.getStaffChannelMap().get(channelCol);
                    if (isAddStaff && parentStaff < orgSubSumStaff) {
                        if (parentStaff + applyCount < orgSubSumStaff) {
                            throw new StaffManageException(StaffManageException.ADD_STAFF_NOT_ENOUGH, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, orgSubSumStaff, parentStaff + applyCount});
                        }
                        channelStaffMap.put(channelCol, parentStaff + applyCount);
                        needUpdateChannel.add(channelCol);
                        continue;
                    }
                    if (isAddStaff) continue;
                    if (parentStaff < orgSubSumStaff) {
                        throw new StaffManageException(StaffManageException.STAFF_MORE_THAN_PARENT, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, orgSubSumStaff, parentStaff});
                    }
                    if (parentStaff + applyCount < orgSubSumStaff) continue;
                    channelStaffMap.put(channelCol, parentStaff + applyCount);
                    needUpdateChannel.add(channelCol);
                }
            }
            if (needUpdateChannel.size() == 0) break;
            updateRowSet.add(parentData.getFID());
            channelCols = needUpdateChannel;
        }
    }

    public static void validateStaffOnGather(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, StaffManageRuleFieldCollection dimensionColl, String type) throws BOSException, EASBizException {
        String dimension = StaffManageGatherUtil.getDimension(dimensionColl);
        Map<String, StaffApplyEntryQueryDTO> relateIdMap = StaffManageGatherUtil.toRowIdMap(entryQueryDTOs);
        HashSet<String> updateRowSet = new HashSet<String>();
        if (ADMIN_ORG_ID.equals(dimension) || POSITION_ID.equals(dimension)) {
            Map<String, String> channelMap = StaffManageChannelUtil.getInstance(projectInfo.getChannel()).getName2AliasMap(ctx);
            for (int i = 0; i < entrys.size(); ++i) {
                StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
                StaffApplyEntryQueryDTO entryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
                Boolean isleafNode = StaffManageGatherUtil.isEnableTreeLeaf(entryQueryDTO, entryQueryDTOs);
                if (ADMIN_ORG_ID.equals(dimension) && entryQueryDTO.getContainSub() != 0 && entryQueryDTO.getIsLeaf() != 1 && !isleafNode.booleanValue()) {
                    throw new StaffManageException(StaffManageException.IS_NOT_LAST_ON_ORG, new Object[]{i + 1, entryQueryDTO.getNumber()});
                }
                if (POSITION_ID.equals(dimension) && !entryQueryDTO.isHavePositionVal() && !isleafNode.booleanValue()) {
                    throw new StaffManageException(StaffManageException.IS_NOT_LAST_ON_ORGANDPOS, new Object[]{i + 1, entryQueryDTO.getNumber()});
                }
                List<String> channelCols = StaffManageGatherUtil.getUpdateChannelColumns(entryInfo, projectInfo.getChannel());
                int applyCount = StaffManageGatherUtil.getApplyCount(entryInfo, type);
                Map<String, Integer> entryStaffMap = entryQueryDTO.getStaffChannelMap();
                for (String channelCol : channelCols) {
                    int channelStaffVal = entryStaffMap.get(channelCol) + applyCount;
                    if (channelStaffVal < 0) {
                        throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_ZERO, new Object[]{i + 1, entryQueryDTO.getNumber(), channelMap.get(channelCol)});
                    }
                    entryStaffMap.put(channelCol, channelStaffVal);
                }
            }
        } else {
            StaffManageGatherUtil.otherGatherStaff(ctx, entryQueryDTOs, entrys, projectInfo, updateRowSet, relateIdMap, type);
        }
    }

    protected static Boolean isEnableTreeLeaf(StaffApplyEntryQueryDTO entryQueryDTO, List<StaffApplyEntryQueryDTO> entryQueryDTOs) {
        block5: {
            block3: {
                block4: {
                    if (!entryQueryDTO.isHavePosition()) break block3;
                    if (entryQueryDTO.getContainSub() != 0) break block4;
                    for (StaffApplyEntryQueryDTO node : entryQueryDTOs) {
                        if (!entryQueryDTO.getAdminOrgID().equals(node.getAdminOrgID()) || !node.isHavePositionVal()) continue;
                        return false;
                    }
                    break block5;
                }
                if (entryQueryDTO.getContainSub() != 1) break block5;
                for (StaffApplyEntryQueryDTO node : entryQueryDTOs) {
                    if ((!entryQueryDTO.getAdminOrgID().equals(node.getAdminOrgID()) || node.getContainSub() != 0) && !node.getLongNumber().contains(entryQueryDTO.getLongNumber() + "!")) continue;
                    return false;
                }
                break block5;
            }
            for (StaffApplyEntryQueryDTO node : entryQueryDTOs) {
                if ((!entryQueryDTO.getAdminOrgID().equals(node.getAdminOrgID()) || node.getContainSub() != 0) && !node.getLongNumber().contains(entryQueryDTO.getLongNumber() + "!")) continue;
                return false;
            }
        }
        return true;
    }

    public static void updateStaffOnNotGather(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, Map<String, StaffApplyEntryQueryDTO> relateIdMap, String type) throws BOSException, EASBizException {
        List<StaffApplyEntryQueryDTO> updateRows = StaffManageGatherUtil.validateStaffOnNotGather(ctx, entryQueryDTOs, entrys, projectInfo, type);
        if (AUDITED.equals(type)) {
            StaffManageGatherUtil.updateActualAndStaffChannel(ctx, projectInfo.getChannel().getValue(), entrys, relateIdMap);
        }
        StaffManageGatherUtil.batchUpdateStaffTable(ctx, projectInfo.getTableName(), updateRows);
    }

    /*
     * WARNING - void declaration
     */
    public static List<StaffApplyEntryQueryDTO> validateStaffOnNotGather(Context ctx, List<StaffApplyEntryQueryDTO> entryQueryDTOs, StaffManageApplyBillEntryCollection entrys, StaffManageProjectInfo projectInfo, String type) throws BOSException, EASBizException {
        Map<String, StaffApplyEntryQueryDTO> relateIdMap = StaffManageGatherUtil.toRowIdMap(entryQueryDTOs);
        Map<String, String> channelMap = StaffManageChannelUtil.getInstance(projectInfo.getChannel()).getName2AliasMap(ctx);
        StaffManageGatherUtil.removeEntryDTO(entryQueryDTOs, relateIdMap, entrys);
        ArrayList<StaffApplyEntryQueryDTO> updateRows = new ArrayList<StaffApplyEntryQueryDTO>();
        for (int i = 0; i < entrys.size(); ++i) {
            StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
            StaffApplyEntryQueryDTO entryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
            entryQueryDTOs.add(entryQueryDTO);
            List<String> channelCols = StaffManageGatherUtil.getUpdateChannelColumns(entryInfo, projectInfo.getChannel());
            int applyCount = StaffManageGatherUtil.getApplyCount(entryInfo, type);
            String optMsg = StaffManageGatherUtil.getOptStaffMsg(ctx, entryInfo, type);
            if (entryInfo.getSeq() == 0) {
                entryInfo.setSeq(i + 1);
            }
            Map<String, Integer> entryStaffMap = entryQueryDTO.getStaffChannelMap();
            for (String channelCol : channelCols) {
                int channelStaffVal = entryStaffMap.get(channelCol) + applyCount;
                if (channelStaffVal < 0) {
                    throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_ZERO, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol)});
                }
                entryStaffMap.put(channelCol, channelStaffVal);
            }
            updateRows.add(entryQueryDTO);
            if (entryQueryDTO.isHavePosition()) {
                StaffApplyEntryQueryDTO staffApplyEntryQueryDTO;
                ArrayList<StaffApplyEntryQueryDTO> allOrgDatas = new ArrayList<StaffApplyEntryQueryDTO>();
                ArrayList<StaffApplyEntryQueryDTO> allPositionDatas = new ArrayList<StaffApplyEntryQueryDTO>();
                for (StaffApplyEntryQueryDTO queryDTO : entryQueryDTOs) {
                    if (StringUtils.isEmpty((String)queryDTO.getDimensionMap().get(POSITION_ID))) {
                        allOrgDatas.add(queryDTO);
                        continue;
                    }
                    allPositionDatas.add(queryDTO);
                }
                if (allOrgDatas.size() == 0) continue;
                Map<String, List<StaffApplyEntryQueryDTO>> orgMap = StaffManageGatherUtil.toDimenExceptOrgPosMap(allOrgDatas);
                Map<String, List<StaffApplyEntryQueryDTO>> posMap = StaffManageGatherUtil.toDimenExceptOrgPosMap(allPositionDatas);
                StaffApplyEntryAssembleDTO subAssembleDTO = StaffManageGatherUtil.getAssembleData(orgMap, entryQueryDTO.getDimenExceptOrgPos());
                HashMap orgToPositionMap = new HashMap();
                if (posMap.get(entryQueryDTO.getDimenExceptOrgPos()) != null) {
                    for (StaffApplyEntryQueryDTO staffApplyEntryQueryDTO2 : posMap.get(entryQueryDTO.getDimenExceptOrgPos())) {
                        List<StaffApplyEntryQueryDTO> bList;
                        if (null == orgToPositionMap.get(staffApplyEntryQueryDTO2.getAdminOrgID())) {
                            bList = new ArrayList<StaffApplyEntryQueryDTO>();
                            bList.add(staffApplyEntryQueryDTO2);
                            orgToPositionMap.put(staffApplyEntryQueryDTO2.getAdminOrgID(), bList);
                            continue;
                        }
                        bList = (List)orgToPositionMap.get(staffApplyEntryQueryDTO2.getAdminOrgID());
                        bList.add(staffApplyEntryQueryDTO2);
                    }
                }
                Object orgId = entryQueryDTO.getAdminOrgID();
                if (!entryQueryDTO.isHavePositionVal()) {
                    for (Object channelCol : channelCols) {
                        int sumStaff = 0;
                        if (entryQueryDTO.getContainSub() == 0 && orgToPositionMap.get(orgId) != null) {
                            for (StaffApplyEntryQueryDTO positionDTO : (List)orgToPositionMap.get(orgId)) {
                                sumStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
                            }
                        } else if (entryQueryDTO.getContainSub() == 1) {
                            sumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, subAssembleDTO, subAssembleDTO, allPositionDatas, entryQueryDTO, entryQueryDTO, (String)channelCol);
                        }
                        if (entryQueryDTO.getStaffChannelMap().get(channelCol) >= sumStaff) continue;
                        throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_SUB, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, entryQueryDTO.getStaffChannelMap().get(channelCol), sumStaff});
                    }
                }
                if (!entryQueryDTO.isHavePositionVal() && entryQueryDTO.getContainSub() == 1) {
                    orgId = entryQueryDTO.getParentId();
                }
                StaffApplyEntryQueryDTO staffApplyEntryQueryDTO3 = new StaffApplyEntryQueryDTO();
                if (entryQueryDTO.isHavePositionVal() && (staffApplyEntryQueryDTO = subAssembleDTO.getDirectStaffMap().get(orgId)) != null && orgToPositionMap.get(orgId) != null) {
                    Object channelCol;
                    channelCol = channelCols.iterator();
                    while (channelCol.hasNext()) {
                        String channelCol2 = (String)channelCol.next();
                        int parentDirectStaff = staffApplyEntryQueryDTO.getStaffChannelMap().get(channelCol2);
                        int sumSubPositionStaff = 0;
                        for (StaffApplyEntryQueryDTO positionDTO : (List)orgToPositionMap.get(orgId)) {
                            sumSubPositionStaff += positionDTO.getStaffChannelMap().get(channelCol2).intValue();
                        }
                        if (parentDirectStaff >= sumSubPositionStaff) continue;
                        throw new StaffManageException(StaffManageException.STAFF_MORE_THAN_PARENT, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol2) + optMsg, sumSubPositionStaff, parentDirectStaff});
                    }
                    updateRows.add(entryQueryDTO);
                    continue;
                }
                if (StringUtils.isEmpty((String)orgId)) {
                    updateRows.add(entryQueryDTO);
                    continue;
                }
                List<String> allParentNodeIds = StaffManageGatherUtil.getAllUpNodeId(ctx, (String)orgId);
                boolean needVali = false;
                for (String parentId : allParentNodeIds) {
                    if (subAssembleDTO.getAllStaffMap().get(parentId) == null) continue;
                    needVali = true;
                    orgId = parentId;
                    StaffApplyEntryQueryDTO staffApplyEntryQueryDTO4 = subAssembleDTO.getAllStaffMap().get(orgId);
                    break;
                }
                if (!needVali) {
                    updateRows.add(entryQueryDTO);
                    continue;
                }
                for (String channelCol : channelCols) {
                    void var22_39;
                    int sumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, subAssembleDTO, subAssembleDTO, allPositionDatas, (StaffApplyEntryQueryDTO)var22_39, entryQueryDTO, channelCol);
                    if (var22_39.getStaffChannelMap().get(channelCol) >= sumStaff) continue;
                    throw new StaffManageException(StaffManageException.STAFF_MORE_THAN_PARENT, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, sumStaff, var22_39.getStaffChannelMap().get(channelCol)});
                }
                updateRows.add(entryQueryDTO);
                continue;
            }
            Map<String, List<StaffApplyEntryQueryDTO>> dimenExceptOrgMap = StaffManageGatherUtil.toDimenExceptOrgMap(entryQueryDTOs);
            StaffApplyEntryAssembleDTO assembleDTO = StaffManageGatherUtil.getAssembleData(dimenExceptOrgMap, entryQueryDTO.getDimenExceptOrgStr());
            if (entryQueryDTO.getContainSub() == 1) {
                if (entryQueryDTO.getIsLeaf() == 1 && assembleDTO.getDirectStaffMap().get(entryQueryDTO.getAdminOrgID()) == null) {
                    updateRows.add(entryQueryDTO);
                } else {
                    for (String channelCol : channelCols) {
                        int sumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, assembleDTO, entryQueryDTO.getAdminOrgID(), channelCol);
                        if (entryQueryDTO.getStaffChannelMap().get(channelCol) >= sumStaff) continue;
                        throw new StaffManageException(StaffManageException.STAFF_LESS_THAN_SUB, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, entryQueryDTO.getStaffChannelMap().get(channelCol), sumStaff});
                    }
                }
            }
            String orgId = entryQueryDTO.getAdminOrgID();
            if (entryQueryDTO.getContainSub() == 1) {
                orgId = entryQueryDTO.getParentId();
            }
            if (StringUtils.isEmpty((String)entryQueryDTO.getParentId())) {
                updateRows.add(entryQueryDTO);
                continue;
            }
            StaffApplyEntryQueryDTO parentDTO = assembleDTO.getAllStaffMap().get(orgId);
            if (parentDTO == null) {
                List<String> allParentNodeIds = StaffManageGatherUtil.getAllUpNodeId(ctx, entryQueryDTO.getParentId());
                boolean needVali = false;
                for (String string : allParentNodeIds) {
                    if (assembleDTO.getAllStaffMap().get(string) == null) continue;
                    needVali = true;
                    orgId = string;
                    parentDTO = assembleDTO.getAllStaffMap().get(orgId);
                    break;
                }
                if (!needVali) {
                    updateRows.add(entryQueryDTO);
                    continue;
                }
            }
            for (String channelCol : channelCols) {
                int sumStaff = StaffManageGatherUtil.getSumStaffOfLowerNode(ctx, assembleDTO, orgId, channelCol);
                if (parentDTO.getStaffChannelMap().get(channelCol) >= sumStaff) continue;
                throw new StaffManageException(StaffManageException.STAFF_MORE_THAN_PARENT, new Object[]{entryInfo.getSeq(), entryQueryDTO.getNumber(), channelMap.get(channelCol) + optMsg, sumStaff, parentDTO.getStaffChannelMap().get(channelCol)});
            }
            updateRows.add(entryQueryDTO);
        }
        return updateRows;
    }

    public static void updateActualAndStaffChannel(Context ctx, int channelVal, StaffManageApplyBillEntryCollection entrys, Map<String, StaffApplyEntryQueryDTO> relateIdMap) throws BOSException, EASBizException {
        String curChannelInDB = StaffManageChannelUtil.getStaffChannel(channelVal);
        for (int i = 0; i < entrys.size(); ++i) {
            StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
            StaffApplyEntryQueryDTO applyEntryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
            entryInfo.setActualCount(applyEntryQueryDTO.getPersonCount());
            entryInfo.setStaffChannel(applyEntryQueryDTO.getStaffChannelMap().get(curChannelInDB));
            StaffManageApplyBillEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)entryInfo);
        }
    }

    public static Map<String, List<StaffApplyEntryQueryDTO>> toDimenExceptOrgMap(List<StaffApplyEntryQueryDTO> queryDTOs) {
        if (queryDTOs == null || queryDTOs.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<StaffApplyEntryQueryDTO>> dimenExceptOrgMap = new HashMap<String, List<StaffApplyEntryQueryDTO>>();
        for (StaffApplyEntryQueryDTO dataDTO : queryDTOs) {
            List<StaffApplyEntryQueryDTO> dbDatas;
            if (null == dimenExceptOrgMap.get(dataDTO.getDimenExceptOrgStr())) {
                dbDatas = new ArrayList<StaffApplyEntryQueryDTO>();
                dbDatas.add(dataDTO);
                dimenExceptOrgMap.put(dataDTO.getDimenExceptOrgStr(), dbDatas);
                continue;
            }
            dbDatas = (List)dimenExceptOrgMap.get(dataDTO.getDimenExceptOrgStr());
            dbDatas.add(dataDTO);
        }
        return dimenExceptOrgMap;
    }

    public static Map<String, List<StaffApplyEntryQueryDTO>> toDimenExceptOrgPosMap(List<StaffApplyEntryQueryDTO> queryDTOs) {
        if (queryDTOs == null || queryDTOs.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<StaffApplyEntryQueryDTO>> dimenExceptOrgPosMap = new HashMap<String, List<StaffApplyEntryQueryDTO>>();
        for (StaffApplyEntryQueryDTO dataDTO : queryDTOs) {
            List<StaffApplyEntryQueryDTO> dbDatas;
            if (null == dimenExceptOrgPosMap.get(dataDTO.getDimenExceptOrgPos())) {
                dbDatas = new ArrayList<StaffApplyEntryQueryDTO>();
                dbDatas.add(dataDTO);
                dimenExceptOrgPosMap.put(dataDTO.getDimenExceptOrgPos(), dbDatas);
                continue;
            }
            dbDatas = (List)dimenExceptOrgPosMap.get(dataDTO.getDimenExceptOrgPos());
            dbDatas.add(dataDTO);
        }
        return dimenExceptOrgPosMap;
    }

    public static List<String> getUpdateChannelColumns(StaffManageApplyBillEntryInfo entry, StaffManageChannelEnum cNnum) {
        ArrayList<String> lists = new ArrayList<String>();
        IStaffManageChannel iStaffManageChannel = StaffManageChannelUtil.getInstance(cNnum);
        int beginChannel = entry.getBeginChannel();
        int endChannel = entry.getEndChannel();
        String endChannelInDB = iStaffManageChannel.getDBColumnByChannelVal(endChannel);
        if (beginChannel == endChannel) {
            lists.add(endChannelInDB);
            return lists;
        }
        if (endChannel > beginChannel) {
            lists.add(iStaffManageChannel.getDBColumnByChannelVal(beginChannel));
            for (int i = 1; i <= endChannel - beginChannel; ++i) {
                lists.add(iStaffManageChannel.getDBColumnByChannelVal(beginChannel + i));
            }
        }
        return lists;
    }

    public static String getFidStr(Object[] billids) {
        String fidStr = "";
        if (billids == null) {
            return "'abc'";
        }
        for (int i = 0; i < billids.length; ++i) {
            fidStr = i == billids.length - 1 ? fidStr + "'" + billids[i] + "'" : fidStr + "'" + billids[i] + "',";
        }
        return fidStr;
    }

    public static List<String> getAllUpNodeId(Context ctx, String adminId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String sql = "select FLONGNUMBER from t_org_admin where FID = '" + adminId + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                if (executeQuery.getString("FLONGNUMBER") == null || executeQuery.getString("FLONGNUMBER").equals("")) continue;
                String flongNumber = executeQuery.getString("FLONGNUMBER");
                String[] adminNumberArray = flongNumber.split("!");
                for (int i = adminNumberArray.length - 1; i >= 0; --i) {
                    String adminNumber = adminNumberArray[i];
                    String sql2 = "select FID from t_org_admin where FNUMBER = '" + adminNumber + "'";
                    IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
                    while (executeQuery2.next()) {
                        list.add(executeQuery2.getString("FID"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<String> getAllLowerNodeId(Context ctx, String adminId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String sql = "select FID from t_org_admin where fparentid = '" + adminId + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                if (executeQuery.getString("FID") == null || StringUtils.isEmpty((String)executeQuery.getString("FID"))) continue;
                list.add(executeQuery.getString("FID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<StaffApplyEntryQueryDTO> getParentNodeDatas(List<StaffApplyEntryQueryDTO> datas, List<String> nodeIds) {
        if (datas == null || datas.size() < 1) {
            return Collections.emptyList();
        }
        if (nodeIds == null || nodeIds.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<StaffApplyEntryQueryDTO> parentNodeDatas = new ArrayList<StaffApplyEntryQueryDTO>();
        for (String node : nodeIds) {
            for (StaffApplyEntryQueryDTO data : datas) {
                if (!node.equals(data.getAdminOrgID()) || data.getContainSub() != 1) continue;
                parentNodeDatas.add(data);
            }
        }
        return parentNodeDatas;
    }

    public static int getSumStaffOfLowerNode(Context ctx, StaffApplyEntryAssembleDTO parentAssembleData, StaffApplyEntryAssembleDTO subAssembleData, StaffApplyEntryQueryDTO parentData, StaffApplyEntryQueryDTO data, String channelCol) {
        String parentId = parentData.getAdminOrgID();
        Map<String, StaffApplyEntryQueryDTO> allStaffMap = subAssembleData.getAllStaffMap();
        Map<String, StaffApplyEntryQueryDTO> directStaffMap = subAssembleData.getDirectStaffMap();
        StaffApplyEntryQueryDTO parentDirectData = parentAssembleData.getDirectStaffMap().get(parentId);
        int parentDirect = parentDirectData == null ? 0 : parentDirectData.getStaffChannelMap().get(channelCol);
        int sumLowerNodeStaff = 0;
        boolean hasSameOrgIdDirectData = false;
        if (data.getAdminOrgID().equals(parentData.getAdminOrgID())) {
            if (allStaffMap.get(data.getAdminOrgID()) != null) {
                return data.getStaffChannelMap().get(channelCol);
            }
            hasSameOrgIdDirectData = true;
        }
        HashSet<String> haveDataOrgIds = new HashSet<String>();
        List<String> orgLowerNodeIds = StaffManageGatherUtil.getAllLowerNodeId(ctx, parentId);
        for (String id : orgLowerNodeIds) {
            if (allStaffMap.get(id) == null) continue;
            haveDataOrgIds.add(id);
            sumLowerNodeStaff += allStaffMap.get(id).getStaffChannelMap().get(channelCol).intValue();
        }
        if (haveDataOrgIds.containsAll(orgLowerNodeIds)) {
            if (hasSameOrgIdDirectData) {
                return data.getStaffChannelMap().get(channelCol) + sumLowerNodeStaff;
            }
            return parentDirect + sumLowerNodeStaff;
        }
        int otherNodeSumStaff = 0;
        orgLowerNodeIds.removeAll(haveDataOrgIds);
        otherNodeSumStaff = StaffManageGatherUtil.recursionLowerNodes(ctx, orgLowerNodeIds, allStaffMap, directStaffMap, otherNodeSumStaff, channelCol);
        if (hasSameOrgIdDirectData) {
            return data.getStaffChannelMap().get(channelCol) + sumLowerNodeStaff;
        }
        return parentDirect + sumLowerNodeStaff + otherNodeSumStaff;
    }

    public static int getSumStaffOfLowerNode(Context ctx, StaffApplyEntryAssembleDTO assembleDataDTO, String parentId, String channelCol) {
        Set<String> allStaffOrgIdSet = assembleDataDTO.getAllStaffOrgIdSet();
        Map<String, StaffApplyEntryQueryDTO> allStaffMap = assembleDataDTO.getAllStaffMap();
        Map<String, StaffApplyEntryQueryDTO> directStaffMap = assembleDataDTO.getDirectStaffMap();
        List<String> orgLowerNodeIds = StaffManageGatherUtil.getAllLowerNodeId(ctx, parentId);
        int sumLowerNodeStaff = 0;
        if (directStaffMap.get(parentId) != null) {
            sumLowerNodeStaff += directStaffMap.get(parentId).getStaffChannelMap().get(channelCol).intValue();
        }
        for (String id : orgLowerNodeIds) {
            if (allStaffMap.get(id) != null) {
                sumLowerNodeStaff += allStaffMap.get(id).getStaffChannelMap().get(channelCol).intValue();
                continue;
            }
            if (directStaffMap.get(id) == null) continue;
            sumLowerNodeStaff += directStaffMap.get(id).getStaffChannelMap().get(channelCol).intValue();
        }
        if (allStaffOrgIdSet.containsAll(orgLowerNodeIds)) {
            return sumLowerNodeStaff;
        }
        orgLowerNodeIds.removeAll(allStaffOrgIdSet);
        sumLowerNodeStaff = StaffManageGatherUtil.recursionLowerNodes(ctx, orgLowerNodeIds, allStaffMap, directStaffMap, sumLowerNodeStaff, channelCol);
        return sumLowerNodeStaff;
    }

    public static int getSumStaffOfLowerNode(Context ctx, StaffApplyEntryAssembleDTO parentAssembleDTO, StaffApplyEntryAssembleDTO subAssembleDTO, List<StaffApplyEntryQueryDTO> allPositionDatas, StaffApplyEntryQueryDTO parentData, StaffApplyEntryQueryDTO subData, String channelCol) {
        String parentOrgId = parentData.getAdminOrgID();
        Map<String, StaffApplyEntryQueryDTO> parentDirectStaffMap = parentAssembleDTO.getDirectStaffMap();
        Map<String, StaffApplyEntryQueryDTO> orgAllStaffMap = subAssembleDTO.getAllStaffMap();
        Map<String, StaffApplyEntryQueryDTO> orgDirectStaffMap = subAssembleDTO.getDirectStaffMap();
        Set<String> orgAllStaffIds = subAssembleDTO.getAllStaffOrgIdSet();
        int sumLowerNodeStaff = 0;
        List<String> orgLowerNodeIds = StaffManageGatherUtil.getAllLowerNodeId(ctx, parentOrgId);
        if (parentDirectStaffMap.get(parentOrgId) != null) {
            sumLowerNodeStaff = parentDirectStaffMap.get(parentOrgId).getStaffChannelMap().get(channelCol);
        } else {
            for (StaffApplyEntryQueryDTO positionDTO : allPositionDatas) {
                if (!positionDTO.getDimenExceptOrgPos().equals(parentData.getDimenExceptOrgPos()) || !parentOrgId.equals(positionDTO.getAdminOrgID())) continue;
                sumLowerNodeStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
            }
        }
        HashMap<String, List<StaffApplyEntryQueryDTO>> orgToPositionMap = new HashMap<String, List<StaffApplyEntryQueryDTO>>();
        for (StaffApplyEntryQueryDTO positionData : allPositionDatas) {
            List<StaffApplyEntryQueryDTO> bList;
            if (!subData.getDimenExceptOrgPos().equals(positionData.getDimenExceptOrgPos())) continue;
            if (null == orgToPositionMap.get(positionData.getAdminOrgID())) {
                bList = new ArrayList<StaffApplyEntryQueryDTO>();
                bList.add(positionData);
                orgToPositionMap.put(positionData.getAdminOrgID(), bList);
                continue;
            }
            bList = (List)orgToPositionMap.get(positionData.getAdminOrgID());
            bList.add(positionData);
        }
        for (String lowerOrgId : orgLowerNodeIds) {
            if (orgAllStaffMap.get(lowerOrgId) != null) {
                sumLowerNodeStaff += orgAllStaffMap.get(lowerOrgId).getStaffChannelMap().get(channelCol).intValue();
                continue;
            }
            if (orgDirectStaffMap.get(lowerOrgId) != null) {
                sumLowerNodeStaff += orgDirectStaffMap.get(lowerOrgId).getStaffChannelMap().get(channelCol).intValue();
                continue;
            }
            if (orgToPositionMap.get(lowerOrgId) == null) continue;
            for (StaffApplyEntryQueryDTO positionDTO : (List)orgToPositionMap.get(lowerOrgId)) {
                sumLowerNodeStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
            }
        }
        if (orgAllStaffIds.containsAll(orgLowerNodeIds)) {
            return sumLowerNodeStaff;
        }
        orgLowerNodeIds.removeAll(orgAllStaffIds);
        sumLowerNodeStaff = StaffManageGatherUtil.recursionLowerNodes(ctx, orgLowerNodeIds, orgAllStaffMap, orgDirectStaffMap, orgToPositionMap, sumLowerNodeStaff, channelCol);
        return sumLowerNodeStaff;
    }

    public static StaffApplyEntryAssembleDTO getAssembleData(Map<String, List<StaffApplyEntryQueryDTO>> dimenExceptOrgMap, String dimenExceptOrgStr) {
        if (dimenExceptOrgMap.get(dimenExceptOrgStr) == null) {
            return new StaffApplyEntryAssembleDTO();
        }
        StaffApplyEntryAssembleDTO assembleDataDTO = new StaffApplyEntryAssembleDTO();
        for (StaffApplyEntryQueryDTO dDTO : dimenExceptOrgMap.get(dimenExceptOrgStr)) {
            List<Object> bList;
            if (dDTO.getContainSub() == 1) {
                assembleDataDTO.getAllStaffOrgIdSet().add(dDTO.getAdminOrgID());
                assembleDataDTO.getAllStaffMap().put(dDTO.getAdminOrgID(), dDTO);
                if (null == assembleDataDTO.getParentAllStaffMap().get(dDTO.getParentId())) {
                    bList = new ArrayList();
                    bList.add(dDTO);
                    assembleDataDTO.getParentAllStaffMap().put(dDTO.getParentId(), bList);
                    continue;
                }
                bList = assembleDataDTO.getParentAllStaffMap().get(dDTO.getParentId());
                bList.add(dDTO);
                continue;
            }
            if (dDTO.getContainSub() != 0) continue;
            assembleDataDTO.getDirectStaffMap().put(dDTO.getAdminOrgID(), dDTO);
            if (null == assembleDataDTO.getParentDirectMap().get(dDTO.getParentId())) {
                bList = new ArrayList<StaffApplyEntryQueryDTO>();
                bList.add(dDTO);
                assembleDataDTO.getParentDirectMap().put(dDTO.getParentId(), bList);
                continue;
            }
            bList = assembleDataDTO.getParentDirectMap().get(dDTO.getParentId());
            bList.add(dDTO);
        }
        return assembleDataDTO;
    }

    public static int recursionLowerNodes(Context ctx, List<String> orgIds, Map<String, StaffApplyEntryQueryDTO> allStaffMap, Map<String, StaffApplyEntryQueryDTO> directStaffMap, int sumLowerNodeStaff, String channelCol) {
        if (orgIds.size() == 0) {
            return sumLowerNodeStaff;
        }
        ArrayList<String> allLowerNodeIds = new ArrayList<String>();
        for (String orgId : orgIds) {
            List<String> lowerNodeIds = StaffManageGatherUtil.getAllLowerNodeId(ctx, orgId);
            if (lowerNodeIds.size() <= 0) continue;
            for (String lowerId : lowerNodeIds) {
                if (allStaffMap.get(lowerId) != null) {
                    sumLowerNodeStaff += allStaffMap.get(lowerId).getStaffChannelMap().get(channelCol).intValue();
                    continue;
                }
                if (directStaffMap.get(lowerId) == null) continue;
                allLowerNodeIds.add(lowerId);
                sumLowerNodeStaff += directStaffMap.get(lowerId).getStaffChannelMap().get(channelCol).intValue();
            }
        }
        orgIds = allLowerNodeIds;
        return StaffManageGatherUtil.recursionLowerNodes(ctx, orgIds, allStaffMap, directStaffMap, sumLowerNodeStaff, channelCol);
    }

    public static int recursionLowerNodes(Context ctx, List<String> orgIds, Map<String, StaffApplyEntryQueryDTO> allStaffMap, Map<String, StaffApplyEntryQueryDTO> directStaffMap, Map<String, List<StaffApplyEntryQueryDTO>> orgToPositionMap, int otherNodeSumStaff, String channelCol) {
        if (orgIds.size() == 0) {
            return otherNodeSumStaff;
        }
        ArrayList<String> allLowerNodeIds = new ArrayList<String>();
        for (String orgId : orgIds) {
            List<String> lowerNodeIds = StaffManageGatherUtil.getAllLowerNodeId(ctx, orgId);
            if (lowerNodeIds.size() <= 0) continue;
            for (String lowerId : lowerNodeIds) {
                if (allStaffMap.get(lowerId) != null) {
                    otherNodeSumStaff += allStaffMap.get(lowerId).getStaffChannelMap().get(channelCol).intValue();
                    continue;
                }
                if (directStaffMap.get(lowerId) != null) {
                    otherNodeSumStaff += directStaffMap.get(lowerId).getStaffChannelMap().get(channelCol).intValue();
                } else if (orgToPositionMap.get(lowerId) != null) {
                    for (StaffApplyEntryQueryDTO positionDTO : orgToPositionMap.get(lowerId)) {
                        otherNodeSumStaff += positionDTO.getStaffChannelMap().get(channelCol).intValue();
                    }
                }
                allLowerNodeIds.add(lowerId);
            }
        }
        orgIds = allLowerNodeIds;
        return StaffManageGatherUtil.recursionLowerNodes(ctx, orgIds, allStaffMap, directStaffMap, orgToPositionMap, otherNodeSumStaff, channelCol);
    }

    public static void batchUpdateStaffTable(Context ctx, String tableName, List<StaffApplyEntryQueryDTO> queryDTOs) throws BOSException {
        if (queryDTOs == null || queryDTOs.size() == 0) {
            return;
        }
        for (StaffApplyEntryQueryDTO queryDTO : queryDTOs) {
            String channelSQL = "";
            for (Map.Entry<String, Integer> map : queryDTO.getStaffChannelMap().entrySet()) {
                channelSQL = channelSQL + map.getKey() + " = " + map.getValue() + ",";
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ");
            updateSql.append(tableName);
            updateSql.append(" set ");
            updateSql.append(channelSQL);
            updateSql.append(" FState = 1,");
            if (queryDTO.getState() != 1) {
                updateSql.append(" FEnableTime = {ts'" + StaffManageGatherUtil.getTimeStr() + "'},");
            }
            updateSql.append(" FLastUpdateUserID = ? , FLastUpdateTime = ? where fid = ? ");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{StaffManageGatherUtil.getUserInfo(ctx).getId().toString(), StaffManageGatherUtil.getTime(), queryDTO.getFID()});
        }
    }

    public static UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp timestamp = new Timestamp(d.getTime().getTime());
        return timestamp;
    }

    public static String getTimeStr() {
        Timestamp timestamp = StaffManageGatherUtil.getTime();
        return DateUtils.paseTimestamp2String((Timestamp)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Map<String, StaffApplyEntryQueryDTO> toRowIdMap(List<StaffApplyEntryQueryDTO> queryDTOs) {
        if (queryDTOs == null || queryDTOs.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, StaffApplyEntryQueryDTO> result = new HashMap<String, StaffApplyEntryQueryDTO>();
        for (StaffApplyEntryQueryDTO dataDTO : queryDTOs) {
            result.put(dataDTO.getFID(), dataDTO);
        }
        return result;
    }

    public static boolean canUntiCheck(StaffManageRuleFieldCollection dimensionColl) {
        if (dimensionColl == null || dimensionColl.size() == 0 || dimensionColl.size() > 2) {
            return false;
        }
        if (dimensionColl.size() == 1 && ADMIN_ORG_ID.equals(dimensionColl.get(0).getColumn())) {
            return true;
        }
        return dimensionColl.size() == 2 && ADMIN_ORG_ID.equals(dimensionColl.get(0).getColumn()) && POSITION_ID.equals(dimensionColl.get(1).getColumn());
    }

    public static String getDimension(StaffManageRuleFieldCollection dimensionColl) {
        if (dimensionColl.size() == 1 && ADMIN_ORG_ID.equals(dimensionColl.get(0).getColumn())) {
            return ADMIN_ORG_ID;
        }
        if (dimensionColl.size() == 2 && ADMIN_ORG_ID.equals(dimensionColl.get(0).getColumn()) && POSITION_ID.equals(dimensionColl.get(1).getColumn())) {
            return POSITION_ID;
        }
        return "";
    }

    public static boolean getColLevelTerm(Map<String, String> nowDataMap, StaffApplyEntryQueryDTO parentData) {
        Map<String, String> parentDataMap = parentData.getDimensionMap();
        ArrayList<String> dimensions = new ArrayList<String>();
        for (Map.Entry<String, String> entry : nowDataMap.entrySet()) {
            dimensions.add(entry.getKey());
        }
        dimensions.remove(ADMIN_ORG_ID);
        if (dimensions.size() == 0) {
            return false;
        }
        for (String dimension : dimensions) {
            boolean a = !StringUtils.isEmpty((String)nowDataMap.get(dimension)) && StringUtils.isEmpty((String)parentDataMap.get(dimension));
            for (String dStr : dimensions) {
                if (dStr.equals(dimension)) continue;
                a = a && (StringUtils.isEmpty((String)parentDataMap.get(dStr)) || parentDataMap.get(dStr).equals(nowDataMap.get(dStr)));
            }
            if (!a) continue;
            return true;
        }
        return false;
    }

    public static int getApplyCount(StaffManageApplyBillEntryInfo entryInfo, String type) {
        int applyCount = entryInfo.getApplyCount();
        if (AUDITED.equals(type)) {
            if (entryInfo.getApplyType().getValue() == 2) {
                applyCount = -applyCount;
            }
        } else if (UNTI_CHECK.equals(type) && entryInfo.getApplyType().getValue() == 1) {
            applyCount = -applyCount;
        }
        return applyCount;
    }

    public static String getOptStaffMsg(Context ctx, StaffManageApplyBillEntryInfo entryInfo, String type) {
        String msg = EASResource.getString((String)"com.kingdee.shr.staffcontrol.StaffManageResource", (String)"label79", (Locale)ctx.getLocale());
        if (AUDITED.equals(type)) {
            if (entryInfo.getApplyType().getValue() == 2) {
                msg = EASResource.getString((String)"com.kingdee.shr.staffcontrol.StaffManageResource", (String)"label80", (Locale)ctx.getLocale());
            }
        } else if (UNTI_CHECK.equals(type) && entryInfo.getApplyType().getValue() == 1) {
            msg = EASResource.getString((String)"com.kingdee.shr.staffcontrol.StaffManageResource", (String)"label80", (Locale)ctx.getLocale());
        }
        return msg;
    }

    public static boolean isAddStaff(StaffManageApplyBillEntryInfo entryInfo, String type) {
        if (AUDITED.equals(type) && entryInfo.getApplyType().getValue() == 1 || UNTI_CHECK.equals(type) && entryInfo.getApplyType().getValue() == 2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void removeEntryDTO(List<StaffApplyEntryQueryDTO> entryQueryDTOs, Map<String, StaffApplyEntryQueryDTO> relateIdMap, StaffManageApplyBillEntryCollection entrys) {
        ArrayList<StaffApplyEntryQueryDTO> removeEntryDTO = new ArrayList<StaffApplyEntryQueryDTO>();
        for (int i = 0; i < entrys.size(); ++i) {
            StaffManageApplyBillEntryInfo entryInfo = entrys.get(i);
            StaffApplyEntryQueryDTO entryQueryDTO = relateIdMap.get(entryInfo.getRelateRowId());
            removeEntryDTO.add(entryQueryDTO);
        }
        entryQueryDTOs.removeAll(removeEntryDTO);
    }
}

