/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    private static final String HYPHEN = "-";
    private static final String COLON = ":";
    private static final String GMT_TIME_ZONE = "GMT+8:00";
    public static final String YEAR_FORMAT = "yyyy";
    public static final String MONTH_FORMAT = "MM";
    public static final String DAY_FORMAT = "dd";
    public static final String HOUR_FORMAT = "HH";
    public static final String MINUTE_FORMAT = "mm";
    public static final String SECOND_FORMAT = "ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_FORMAT = "yyyyMMddHHmmss";

    public static Long epochSecond() {
        return DateUtils.localDateTime().toEpochSecond(ZoneOffset.of("+8"));
    }

    public static Long epochMilli() {
        return DateUtils.localDateTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static String dateTime() {
        return DateUtils.localDateTime().format(FormatEnum.FORMAT_DATA_TIME.value);
    }

    public static String dateTimeNoSymbol() {
        return DateUtils.localDateTime().format(FormatEnum.FORMAT_DATA_TIME_NO_SYMBOL.value);
    }

    public static String date() {
        return DateUtils.localDate() + "";
    }

    public static String time() {
        return DateUtils.localTime().format(FormatEnum.FORMAT_TIME.value);
    }

    public static Integer year(long offset) {
        return DateUtils.localDate().plusYears(offset).getYear();
    }

    public static int month(long offset) {
        return DateUtils.localDate().plusMonths(offset).getMonthValue();
    }

    public static Integer dayOfYear() {
        return DateUtils.localDate().getDayOfYear();
    }

    public static Integer dayOfMonth() {
        return DateUtils.localDate().getDayOfMonth();
    }

    public static Integer dayOfWeek() {
        return DateUtils.localDate().getDayOfWeek().getValue();
    }

    public static Integer hour() {
        return DateUtils.localTime().getHour();
    }

    public static Integer minute() {
        return DateUtils.localTime().getMinute();
    }

    public static Integer second() {
        return DateUtils.localTime().getSecond();
    }

    public static String getCurrentTime() {
        LocalDateTime currentTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(new Date().getTime()), ZoneId.systemDefault());
        return currentTime.format(FormatEnum.FORMAT_DATE.value);
    }

    public static Timestamp getDayStartTime(long offset) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusDays(offset);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getDayOfMonth(), 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getDayEndTime(long offset) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusDays(offset);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getDayOfMonth(), 23, 59, 59);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getWeekStartTime(long offsetW) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusWeeks(offsetW);
        int v = nowDate.getDayOfWeek().getValue();
        nowDate = nowDate.minusDays(v - 1);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getDayOfMonth(), 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getWeekOfDayTime(long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now();
        int v = nowDate.getDayOfWeek().getValue();
        nowDate = nowDate.minusDays(v - 1).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getDayOfMonth(), 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getWeekEndTime(long offsetW) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusWeeks(offsetW);
        int v = nowDate.getDayOfWeek().getValue();
        nowDate = nowDate.plusDays(7 - v);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getDayOfMonth(), 23, 59, 59);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getMonthStartTime(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, 1, 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    private static Calendar getCalendar(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal;
    }

    public static Timestamp getMonthEndTimeOfDay(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getMonth().length(nowDate.toLocalDate().isLeapYear()), 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getMonthEndTime(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), nowDate.getMonthValue() - 1, nowDate.getMonth().length(nowDate.toLocalDate().isLeapYear()), 23, 59, 59);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getQuarterStartTime(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM *= 3L).plusDays(offsetD);
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), firstMonthOfQuarter.getValue() - 1, 1, 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getQuarterEndTimeOfDay(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM *= 3L).plusDays(offsetD);
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), endMonthOfQuarter.getValue() - 1, endMonthOfQuarter.length(nowDate.toLocalDate().isLeapYear()), 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getQuarterEndTime(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM *= 3L).plusDays(offsetD);
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), endMonthOfQuarter.getValue() - 1, endMonthOfQuarter.length(nowDate.toLocalDate().isLeapYear()), 23, 59, 59);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getYearStartTime(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), 0, 1, 0, 0, 0);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getYearEndTimeOfDay(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), 11, 31, 23, 59, 59);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static Timestamp getYearEndTime(long offsetY, long offsetM, long offsetD) throws ParseException {
        LocalDateTime nowDate = LocalDateTime.now().plusYears(offsetY).plusMonths(offsetM).plusDays(offsetD);
        Calendar cal = DateUtils.getCalendar(nowDate.getYear(), 11, 31, 23, 59, 59);
        nowDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return DateUtils.toTimestamp(nowDate);
    }

    public static String getLast7DaysStartTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(5, -7);
        LocalDateTime last7DaysStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return last7DaysStart.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLast7DaysEndTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        ((Calendar)cal).add(5, -7);
        LocalDateTime last7DaysEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return last7DaysEnd.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLast30DaysStartTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(5, -30);
        LocalDateTime last30DaysStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return last30DaysStart.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLast30DaysEndTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        ((Calendar)cal).add(5, -30);
        LocalDateTime last30DaysEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return last30DaysEnd.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLast90DaysStartTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(5, -90);
        LocalDateTime last90DaysStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return last90DaysStart.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLast90DaysEndTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        ((Calendar)cal).add(5, -90);
        LocalDateTime last90DaysEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return last90DaysEnd.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLastYearStartTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = GMT_TIME_ZONE;
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, -1);
        cal.add(2, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        LocalDateTime lastYearStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return lastYearStart.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String getLastYearEndTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = GMT_TIME_ZONE;
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, -1);
        cal.add(2, 0);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        LocalDateTime lastYearEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return lastYearEnd.format(FormatEnum.FORMAT_DATE.value);
    }

    public static String minusYears(Long years, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusYears(-years.longValue(), formatEnum);
    }

    public static String plusYears(Long years, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusYears(years, formatEnum);
    }

    public static String minusMonths(Long months, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusMonths(-months.longValue(), formatEnum);
    }

    public static String plusMonths(Long months, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusMonths(months, formatEnum);
    }

    public static String minusDays(Long days, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusDays(-days.longValue(), formatEnum);
    }

    public static String plusDays(Long days, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusDays(days, formatEnum);
    }

    public static String minusWeeks(Long weeks, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusWeeks(-weeks.longValue(), formatEnum);
    }

    public static String plusWeeks(Long weeks, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusWeeks(weeks, formatEnum);
    }

    public static String minusHours(Long hours, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusHours(-hours.longValue(), formatEnum);
    }

    public static String plusHours(Long hours, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusHours(hours, formatEnum);
    }

    public static String minusMinutes(Long minutes, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusMinutes(-minutes.longValue(), formatEnum);
    }

    public static String plusMinutes(Long minutes, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusMinutes(minutes, formatEnum);
    }

    public static String minusSeconds(Long seconds, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusSeconds(-seconds.longValue(), formatEnum);
    }

    public static String plusSeconds(Long seconds, FormatEnum formatEnum) {
        return DateUtils.minusOrPlusSeconds(seconds, formatEnum);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate toLocalDate(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        return DateUtils.toLocalDateTime(date).toLocalTime();
    }

    public static Timestamp toTimestamp(LocalDateTime localDateTime) throws ParseException {
        return Timestamp.valueOf(localDateTime);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        return DateUtils.toDate(localDate.atStartOfDay());
    }

    public static Date toDate(LocalTime localTime) {
        return DateUtils.toDate(LocalDateTime.of(DateUtils.localDate(), localTime));
    }

    public static Long daysInterval(LocalDate startDate, LocalDate endDate) {
        return endDate.toEpochDay() - startDate.toEpochDay();
    }

    public static Long daysInterval(String startDate, String endDate) {
        return DateUtils.daysInterval(LocalDateTime.parse(endDate, FormatEnum.FORMAT_DATA_TIME.value).toLocalDate(), LocalDateTime.parse(startDate, FormatEnum.FORMAT_DATA_TIME.value).toLocalDate());
    }

    public static Long daysInterval(LocalDateTime startDate, LocalDateTime endDate) {
        return DateUtils.daysInterval(startDate.toLocalDate(), endDate.toLocalDate());
    }

    private static String minusOrPlusYears(Long yearsToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusYears(yearsToAddOrSubtract).format(formatEnum.value);
    }

    private static String minusOrPlusMonths(Long monthsToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusMonths(monthsToAddOrSubtract).format(formatEnum.value);
    }

    private static String minusOrPlusDays(Long daysToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusDays(daysToAddOrSubtract).format(formatEnum.value);
    }

    private static String minusOrPlusWeeks(Long weeksToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusWeeks(weeksToAddOrSubtract).format(formatEnum.value);
    }

    private static String minusOrPlusHours(Long hoursToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusHours(hoursToAddOrSubtract).format(formatEnum.value);
    }

    private static String minusOrPlusMinutes(Long minutesToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusMinutes(minutesToAddOrSubtract).format(formatEnum.value);
    }

    private static String minusOrPlusSeconds(Long secondsToAddOrSubtract, FormatEnum formatEnum) {
        return DateUtils.localDateTime().plusSeconds(secondsToAddOrSubtract).format(formatEnum.value);
    }

    private static LocalDate localDate() {
        return DateUtils.localDateTime().toLocalDate();
    }

    private static LocalTime localTime() {
        return DateUtils.localDateTime().toLocalTime();
    }

    private static LocalDateTime localDateTime() {
        return LocalDateTime.now();
    }

    static enum FormatEnum {
        FORMAT_DATA_TIME(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")),
        FORMAT_DATA_TIME_NO_SYMBOL(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")),
        FORMAT_DATE(DateTimeFormatter.ofPattern("yyyy-MM-dd")),
        FORMAT_TIME(DateTimeFormatter.ofPattern("HH:mm:ss"));

        private DateTimeFormatter value;

        private FormatEnum(DateTimeFormatter format) {
            this.value = format;
        }
    }
}

