/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.dataplatform.SQLTypeEnum;
import com.kingdee.shr.dataset.model.JavaResult;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.model.VariableItem;
import java.io.Serializable;
import java.sql.NClob;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class DataplatformCacheHelper {
    private static Logger logger = Logger.getLogger(DataplatformCacheHelper.class);
    private static final String CACHE_TYPE = "shr.dataplatform";
    private static final String TYPE_VARIABLE_SQL = "SELECT FNUMBER,FTYPE,FCLZ, FCONTENT FROM T_SHR_VARIABLECONFIG WHERE FNUMBER = ?";
    private static final String TYPE_DATASET_OR_CARD_SQL = "SELECT FCONTENT FROM T_SHR_SQLRESULT WHERE FBOID = ? AND FTYPE = ?";
    public static final int TYPE_VARIABLE = 1;
    public static final int TYPE_DATASET_SQL = 2;
    public static final int TYPE_CARD_SQL = 3;
    public static final int TYPE_ENTITY_TREE = 4;
    public static final int TYPE_TABLE_TREE = 5;

    public static Object get(Context ctx, int type, String key) throws BOSException {
        String realKey = DataplatformCacheHelper.getRealKey(ctx, type, key);
        Object value = CacheService.getInstance().hget(CACHE_TYPE, String.valueOf(type), realKey);
        if (value == null && null != (value = DataplatformCacheHelper.getObjectFromDB(ctx, type, key))) {
            DataplatformCacheHelper.set(ctx, type, key, value);
        }
        return value;
    }

    private static Object getObjectFromDB(Context ctx, int type, String key) throws BOSException {
        Serializable value = null;
        if (1 == type) {
            value = DataplatformCacheHelper.getVariableFromDB(ctx, key);
        } else if (2 == type) {
            value = DataplatformCacheHelper.getDataSetSQLFromDB(ctx, key);
        } else if (3 == type) {
            value = DataplatformCacheHelper.getCardSQLFromDB(ctx, key);
        }
        return value;
    }

    private static String getRealKey(Context ctx, int type, String key) {
        return key;
    }

    public static String getRealKey(Context ctx, String key) {
        return MessageFormat.format("{0}.{1}", key, LocaleUtils.getLocal((Context)ctx));
    }

    public static void set(Context ctx, int type, String key, Object value) {
        String realKey = DataplatformCacheHelper.getRealKey(ctx, type, key);
        CacheService.getInstance().hset(CACHE_TYPE, String.valueOf(type), realKey, value);
    }

    public static void remove(Context ctx, int type, String key) {
        String realKey = DataplatformCacheHelper.getRealKey(ctx, type, key);
        CacheService.getInstance().hdel(CACHE_TYPE, String.valueOf(type), realKey);
    }

    public static void remove(int type) {
        CacheService.getInstance().hdel(CACHE_TYPE, String.valueOf(type));
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    private static SQLResult getCardSQLFromDB(Context ctx, String key) throws BOSException {
        return DataplatformCacheHelper.getSQLResult(ctx, key, SQLTypeEnum.CardSQL);
    }

    private static SQLResult getSQLResult(Context ctx, String key, SQLTypeEnum sqlTypeEnum) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)TYPE_DATASET_OR_CARD_SQL, (Object[])new Object[]{key, sqlTypeEnum.getValue()});
        SQLResult result = null;
        try {
            while (rs.next()) {
                String content;
                NClob clob = rs.getNClob("FCONTENT");
                if (null == clob || 40 != (result = (SQLResult)JSONUtils.convertJsonToObject((Context)ctx, (String)(content = String.valueOf(clob)), SQLResult.class)).getSetType()) continue;
                result = (JavaResult)JSONUtils.convertJsonToObject((Context)ctx, (String)content, JavaResult.class);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static SQLResult getDataSetSQLFromDB(Context ctx, String key) throws BOSException {
        return DataplatformCacheHelper.getSQLResult(ctx, key, SQLTypeEnum.DataSetSQL);
    }

    private static VariableItem getVariableFromDB(Context ctx, String key) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)TYPE_VARIABLE_SQL, (Object[])new Object[]{key});
        VariableItem result = null;
        try {
            while (rs.next()) {
                result = new VariableItem();
                result.setClz(rs.getString("FCLZ"));
                result.setType(rs.getInt("FTYPE"));
                result.setvName(rs.getString("FNUMBER"));
                result.setContent("");
                NClob clob = rs.getNClob("FCONTENT");
                if (null == clob) continue;
                result.setContent(String.valueOf(clob));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

