/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.cloudhub;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.faqservice.SSCFaqException;
import com.kingdee.shr.shareservice.util.Base64Utils;
import com.kingdee.shr.shareservice.util.HashingSha256;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAccessToken {
    private static final Logger logger = LoggerFactory.getLogger(UserAccessToken.class);
    private String eid = "";
    private Context ctx = null;
    public String baseUrl = "";
    private String appId = "";
    private String appidKey = "";
    private String token;
    private long expiring;
    private int code;
    private boolean isNewest = true;
    private long ts;

    public UserAccessToken(Context ctx) {
        this.ctx = ctx;
    }

    public void init() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.appId)) {
            this.initFaqAppId();
        }
        if (StringUtils.isEmpty((String)this.appidKey)) {
            this.initFaqSecret();
        }
        if (StringUtils.isEmpty((String)this.baseUrl)) {
            this.initBaseUrl();
        }
        if (StringUtils.isEmpty((String)this.token)) {
            this.getAccessTokenFromUrl();
        }
    }

    public void check() {
        if (StringUtils.isEmpty((String)this.token)) {
            this.getAccessTokenFromUrl();
        } else if (this.isExpire()) {
            this.getAccessTokenFromUrl();
        }
    }

    private void getAccessTokenFromUrl() {
        long ts = System.currentTimeMillis();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("appid", this.appId);
        dataMap.put("ts", ts);
        String nonce = this.getNonce(this.appId, this.appidKey, ts);
        dataMap.put("nonce", nonce);
        String jsObject = this.process(this.baseUrl + "/oauth/auth", dataMap);
        this.processResultFromHttp(jsObject, ts);
    }

    private void processResultFromHttp(String jsObject, long saveTime) {
        JSONObject accessTokenResult = JSONObject.parseObject((String)jsObject);
        if (accessTokenResult.getIntValue("code") == 0 && !StringUtils.isEmpty((String)accessTokenResult.getString("token"))) {
            this.setToken(accessTokenResult.getString("token"));
            this.setCode(accessTokenResult.getIntValue("code"));
            this.setExpiring(accessTokenResult.getLong("expiring"));
            this.setTs(saveTime);
        } else {
            this.backToInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String process(String url, Map<String, Object> dataMap) {
        HttpPost method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            StringBuffer string = new StringBuffer(url);
            if (dataMap != null && !dataMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String value;
                    String string2 = value = entry.getValue() != null ? entry.getValue().toString() : "";
                    if (string.toString().contains("?")) {
                        string.append("&");
                    } else {
                        string.append("?");
                    }
                    string.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            method = new HttpPost(string.toString());
            method.setHeader("Content-type", "application/json; charset=UTF-8");
            String aiStrReq = Base64Utils.encode((String)("post form to url : " + url + ", params: " + dataMap));
            logger.error("UserAccessToken process request aiStrReq : " + aiStrReq);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = "";
            if (statusCode == 200) {
                responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                aiStrReq = Base64Utils.encode((String)("post form to url res : statusCode " + statusCode + " , responseString" + responseString));
                logger.error("UserAccessToken process response aiStrReq : " + aiStrReq);
                String string3 = responseString;
                return string3;
            }
            try {
                this.backToInit();
                throw new Exception("Http Request Error, statusCode " + statusCode + " , responseString" + responseString);
            }
            catch (Exception e) {
                logger.error("post Exception : \n", (Throwable)e);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    private boolean isExpire() {
        return System.currentTimeMillis() - this.getExpiring() - 2000L > 0L;
    }

    public final String getEid() {
        return this.eid;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public String getToken() {
        this.check();
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getExpiring() {
        return this.expiring;
    }

    public void setExpiring(long expiring) {
        this.expiring = expiring;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public long getTs() {
        return this.ts;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public boolean isNewest() {
        return this.isNewest;
    }

    public void setNewest(boolean isNewest) {
        this.isNewest = isNewest;
    }

    private void initFaqAppId() throws EASBizException {
        this.appId = CloudHubPropertiesUtilsV2.getProperty((Context)this.ctx, (String)"FAQ.AI.APPID");
        if (StringUtils.isEmpty((String)this.appId)) {
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{"Please contact the administrator. Please configure the appId of firmament AI platform first"});
        }
    }

    private void initFaqSecret() throws EASBizException {
        this.appidKey = CloudHubPropertiesUtilsV2.getProperty((Context)this.ctx, (String)"FAQ.AI.APPID.KEY");
        if (StringUtils.isEmpty((String)this.appidKey)) {
            throw new SSCFaqException(SSCFaqException.CUSTOM_EXCEPTION, new Object[]{"Please contact the administrator. Please configure the app key of firmament AI platform first"});
        }
    }

    private void initBaseUrl() {
        String url = CloudHubPropertiesUtilsV2.getProperty((Context)this.ctx, (String)"FAQ.AI.BASE.URL");
        this.baseUrl = StringUtils.isEmpty((String)url) ? "https://ai.kdcloud.com/ai20" : url;
    }

    private String getNonce(String appId, String key, long ts) {
        String nonce = HashingSha256.hashStringGuava((String)(appId + key + ts));
        return nonce;
    }

    private void backToInit() {
        this.expiring = 0L;
        this.code = 0;
        this.token = "";
    }
}

