/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.cloudhub.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.faqservice.cloudhub.AccessToken;
import com.kingdee.shr.faqservice.cloudhub.AccessTokenHelper;
import com.kingdee.shr.faqservice.cloudhub.Faq;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubHttp {
    private static final Logger logger = LoggerFactory.getLogger(CloudHubHttp.class);
    public static final String CHARSET = "UTF-8";

    public static String process(Context ctx, Faq faq, Map<String, Object> dataMap) throws BOSException, EASBizException {
        if (faq.getMethod().equals("POST")) {
            return CloudHubHttp.post(ctx, faq, dataMap);
        }
        if (faq.getMethod().equals("GET")) {
            return CloudHubHttp.get(ctx, faq, dataMap);
        }
        return CloudHubHttp.post(ctx, faq, dataMap);
    }

    public static String get(Context ctx, Faq faq, Map<String, Object> dataMap) throws BOSException, EASBizException {
        HttpGet method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String url = CloudHubHttp.processUrl(ctx, faq);
            method = new HttpGet(url);
            method.setHeader("Content-type", faq.getContentType() + "; charset=" + CHARSET);
            if (dataMap != null && !dataMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String value = entry.getValue() != null ? entry.getValue().toString() : "";
                    url = url + "&" + entry.getKey() + "=" + URLEncoder.encode(value, CHARSET);
                }
            }
            logger.error("post form to url : " + url + ", params: " + JSONObject.toJSONString(dataMap));
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            String string = CloudHubHttp.processHttpRequestResult(response);
            return string;
        }
        catch (IOException e) {
            logger.error("post IOException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            logger.error("post ParseException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error("post BOSException : \n", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error("post EASBizException : \n", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("post Exception : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static String post(Context ctx, Faq faq, Map<String, Object> dataMap) throws BOSException, EASBizException {
        HttpPost method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String url = CloudHubHttp.processUrl(ctx, faq);
            method = new HttpPost(url);
            method.setHeader("Content-type", faq.getContentType() + "; charset=" + CHARSET);
            method.setEntity(CloudHubHttp.getHttpEntity(faq, dataMap));
            logger.error("HttpClientUtil post form to url : " + url + ", params: " + JSONObject.toJSONString(dataMap));
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            String string = CloudHubHttp.processHttpRequestResult(response);
            return string;
        }
        catch (IOException e) {
            logger.error("post IOException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            logger.error("post ParseException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error("post BOSException : \n", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error("post EASBizException : \n", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("post Exception : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static String post(Context ctx, Faq faq, List<Map<String, Object>> dataList) throws BOSException, EASBizException {
        HttpPost method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String url = CloudHubHttp.processUrl(ctx, faq);
            method = new HttpPost(url);
            method.setHeader("Content-type", faq.getContentType() + "; charset=" + CHARSET);
            method.setEntity(CloudHubHttp.getHttpEntity(faq, dataList));
            logger.error("HttpClientUtil post form to url : " + url + ", params: " + JSONObject.toJSONString(dataList));
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            String string = CloudHubHttp.processHttpRequestResult(response);
            return string;
        }
        catch (IOException e) {
            logger.error("post IOException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            logger.error("post ParseException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error("post BOSException : \n", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error("post EASBizException : \n", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("post Exception : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static String post(Context ctx, String url, Faq faq, Map<String, Object> queryMap, Map<String, Object> headerMap, Map<String, Object> bodyMap) throws BOSException, EASBizException {
        HttpPost method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String requestUrl = CloudHubHttp.processUrl(url, queryMap);
            method = new HttpPost(requestUrl);
            method.setHeader("Content-type", faq.getContentType() + "; charset=" + CHARSET);
            for (String key : headerMap.keySet()) {
                method.addHeader(key, String.valueOf(headerMap.get(key)));
            }
            method.setEntity(CloudHubHttp.getHttpEntity(faq, bodyMap));
            if (logger.isDebugEnabled()) {
                logger.debug("HttpClientUtil post form to url : " + requestUrl + ", params: " + JSONObject.toJSONString(bodyMap));
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            String string = CloudHubHttp.processHttpRequestResult(response);
            return string;
        }
        catch (IOException e) {
            logger.error("post IOException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            logger.error("post ParseException : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error("post BOSException : \n", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error("post EASBizException : \n", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("post Exception : \n", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static HttpEntity getHttpEntity(Faq faq, Map<String, Object> dataMap) throws UnsupportedEncodingException {
        if (faq.getContentType().equals("application/x-www-form-urlencoded")) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            if (dataMap != null && !dataMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String value = entry.getValue() != null ? entry.getValue().toString() : "";
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), value);
                    pairs.add(pair);
                }
            }
            return new UrlEncodedFormEntity(pairs, CHARSET);
        }
        StringEntity entity = new StringEntity(JSONObject.toJSONString(dataMap), CHARSET);
        entity.setContentEncoding(CHARSET);
        entity.setContentType(faq.getContentType());
        return entity;
    }

    public static HttpEntity getHttpEntity(Faq faq, List<Map<String, Object>> dataList) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(JSONObject.toJSONString(dataList), CHARSET);
        entity.setContentEncoding(CHARSET);
        entity.setContentType(faq.getContentType());
        return entity;
    }

    public static String processHttpRequestResult(HttpResponse response) throws BOSException, EASBizException, ParseException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        String responseString = "";
        if (statusCode == 200) {
            responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug("postForm : " + statusCode + " : " + responseString);
            }
            logger.error("CloudHubHttp postForm : " + statusCode + " : " + responseString);
            return responseString;
        }
        throw new BOSException("Http Request Error, statusCode : " + statusCode + " , responseString \uff1a" + JSONObject.toJSONString((Object)responseString));
    }

    private static String processUrl(String url, Map<String, Object> queryMap) throws BOSException, EASBizException {
        StringBuffer string = new StringBuffer(url);
        if (StringUtils.isEmpty((String)url) || queryMap == null || queryMap.size() <= 0) {
            return url;
        }
        try {
            for (Map.Entry<String, Object> entry : queryMap.entrySet()) {
                String value;
                String string2 = value = entry.getValue() != null ? entry.getValue().toString() : "";
                if (string.toString().contains("?")) {
                    string.append("&");
                } else {
                    string.append("?");
                }
                string.append(entry.getKey()).append("=").append(URLEncoder.encode(value, CHARSET));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return string.toString();
    }

    private static String processUrl(Context ctx, Faq faq) throws BOSException, EASBizException {
        AccessToken token = AccessTokenHelper.getInstance().getAccessToken(ctx);
        String url = token.baseUrl + faq.getPath();
        return url;
    }
}

