/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.faqservice.cloudhub.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.faqservice.cloudhub.Faq;
import com.kingdee.shr.faqservice.cloudhub.entity.Entity;
import com.kingdee.shr.faqservice.cloudhub.result.ChatResult;
import com.kingdee.shr.faqservice.cloudhub.result.CreateResult;
import com.kingdee.shr.faqservice.cloudhub.result.DeleteResult;
import com.kingdee.shr.faqservice.cloudhub.result.DetailResult;
import com.kingdee.shr.faqservice.cloudhub.result.ExportResult;
import com.kingdee.shr.faqservice.cloudhub.result.IResult;
import com.kingdee.shr.faqservice.cloudhub.result.QueryResult;
import com.kingdee.shr.faqservice.cloudhub.result.Result;
import com.kingdee.shr.faqservice.cloudhub.result.UpdateResult;
import com.kingdee.shr.faqservice.cloudhub.util.CloudHubHttp;
import com.kingdee.shr.shareservice.util.Base64Utils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);

    public static <T> IResult operation(Context ctx, Faq faq, Map<String, Object> dataMap, Entity dataType) throws BOSException, EASBizException {
        IResult resut = null;
        switch (faq.getOperator()) {
            case Create: {
                resut = RequestUtils.createOperation(ctx, faq, dataMap, new CreateResult(), dataType);
                break;
            }
            case Update: {
                resut = RequestUtils.updateOperation(ctx, faq, dataMap, new UpdateResult(), dataType);
                break;
            }
            case Query: {
                resut = RequestUtils.queryOperation(ctx, faq, dataMap, new QueryResult(), dataType);
                break;
            }
            case Delete: {
                resut = RequestUtils.deleteOperation(ctx, faq, dataMap, new DeleteResult());
                break;
            }
            case Detail: {
                resut = RequestUtils.detailOperation(ctx, faq, dataMap, new DetailResult(), dataType);
                break;
            }
            case Startup: {
                resut = RequestUtils.startupOperation(ctx, faq, dataMap, new UpdateResult());
                break;
            }
            case Import: {
                resut = RequestUtils.importOperation(ctx, faq, dataMap, new DetailResult());
                break;
            }
            case Export: {
                resut = RequestUtils.exportOperation(ctx, faq, dataMap, new ExportResult(), dataType);
                break;
            }
            case Detect: {
                resut = RequestUtils.detectOperation(ctx, faq, dataMap, new DetailResult(), dataType);
                break;
            }
            case Chat: {
                resut = RequestUtils.chatOperation(ctx, faq, dataMap, new ChatResult(), dataType);
                break;
            }
            default: {
                resut = null;
            }
        }
        if (resut != null) {
            logger.error("RequestUtils operation Result : " + Base64Utils.encode((String)resut.toString()));
        }
        return resut;
    }

    public static <T> Result<T> createOperation(Context ctx, Faq faq, Map<String, Object> dataMap, CreateResult createResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        createResult = (CreateResult)JSONObject.parseObject((String)resultString, createResult.getClass());
        if (dataType != null) {
            createResult.setDataType(dataType.getClass());
        }
        return createResult;
    }

    public static <T> Result<T> deleteOperation(Context ctx, Faq faq, String id, DeleteResult deleteResult) throws BOSException, EASBizException {
        return RequestUtils.deleteOperation(ctx, faq, (Map<String, Object>)ImmutableMap.of((Object)"id", (Object)id), deleteResult);
    }

    public static <T> Result<T> deleteOperation(Context ctx, Faq faq, Map<String, Object> dataMap, DeleteResult deleteResult) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        return (Result)JSONObject.parseObject((String)resultString, DeleteResult.class);
    }

    public static <T> Result<T> updateOperation(Context ctx, Faq faq, Map<String, Object> dataMap, UpdateResult updateResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        updateResult = (UpdateResult)JSONObject.parseObject((String)resultString, UpdateResult.class);
        if (dataType != null) {
            updateResult.setDataType(dataType.getClass());
        }
        return updateResult;
    }

    public static <T> Result<T> queryOperation(Context ctx, Faq faq, Map<String, Object> dataMap, QueryResult queryResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        queryResult = (QueryResult)JSONObject.parseObject((String)resultString, QueryResult.class);
        if (dataType != null) {
            queryResult.setDataType(dataType.getClass());
        }
        return queryResult;
    }

    public static <T> Result<T> detailOperation(Context ctx, Faq faq, Map<String, Object> dataMap, DetailResult detailResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        detailResult = (DetailResult)JSONObject.parseObject((String)resultString, DetailResult.class);
        if (dataType != null) {
            detailResult.setDataType(dataType.getClass());
        }
        return detailResult;
    }

    public static <T> Result<T> exportOperation(Context ctx, Faq faq, Map<String, Object> dataMap, ExportResult exportResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        exportResult = (ExportResult)JSONObject.parseObject((String)resultString, exportResult.getClass());
        if (dataType != null) {
            exportResult.setDataType(dataType.getClass());
        }
        return exportResult;
    }

    public static <T> Result<T> startupOperation(Context ctx, Faq faq, Map<String, Object> dataMap, UpdateResult updateResult) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        return (Result)JSONObject.parseObject((String)resultString, updateResult.getClass());
    }

    public static <T> Result<T> importOperation(Context ctx, Faq faq, Map<String, Object> dataMap, DetailResult detailResult) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        return (Result)JSONObject.parseObject((String)resultString, detailResult.getClass());
    }

    public static <T> Result<T> detectOperation(Context ctx, Faq faq, Map<String, Object> dataMap, DetailResult detailResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        detailResult = (DetailResult)JSONObject.parseObject((String)resultString, detailResult.getClass());
        if (dataType != null) {
            detailResult.setDataType(dataType.getClass());
        }
        return detailResult;
    }

    public static IResult chatOperation(Context ctx, Faq faq, Map<String, Object> dataMap, ChatResult chatResult, Entity dataType) throws BOSException, EASBizException {
        String resultString = CloudHubHttp.process(ctx, faq, dataMap);
        chatResult = (ChatResult)JSONObject.parseObject((String)resultString, chatResult.getClass());
        if (dataType != null) {
            chatResult.setDataType(dataType.getClass());
        }
        return chatResult;
    }
}

