/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile;

import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.formulaplatform.compile.AgeClass;
import com.kingdee.shr.formulaplatform.compile.FoumulaJavaFileManager;
import com.kingdee.shr.formulaplatform.compile.JavaSourceFromString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.compiler.CompileError;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextClassLoader {
    private static JavaCompiler compiler;
    private static String classPath;
    private static boolean reloadCls;
    private static long oldFileRemain;
    private static List<String> optionList;
    private static Map<String, AgeClass<?>> clsContainer;
    private static Pattern clsNamePattern;
    private static Pattern packagePattern;
    private static Logger logger;
    private static Method defineClassMethod;

    private static void init() {
        TextClassLoader.initCompile();
        Properties config = new Properties();
        String configPath = SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"formulaplatform");
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            configFile.mkdirs();
        }
        if (!(configFile = new File(configPath = configPath + File.separator + "config.properties")).exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            config = SHRSyssettingUtil.getPropertiesFileByPath((String)configPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String param = (String)config.get("TextClassLoader_oldFileRemain");
        oldFileRemain = StringUtils.isBlank((String)param) ? oldFileRemain : Long.valueOf(param);
        param = (String)config.get("TextClassLoader_recordJavaFile");
        classPath = StringUtils.isBlank((String)param) ? classPath : param;
        boolean isLinux = System.getProperty("os.name").toLowerCase().contains("linux");
        optionList = new ArrayList<String>(Arrays.asList("-cp", classPath + (isLinux ? ":" : ";") + System.getProperty("java.class.path")));
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    defineClassMethod = cl.getDeclaredMethod("defineClass", String.class, Class.forName("[B"), Integer.TYPE, Integer.TYPE);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize ClassPool", pae.getException());
        }
    }

    private static void initCompile() {
        compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler != null) {
            return;
        }
        logger.error((Object)"initCompileError");
    }

    public static ClassLoader getClassLoaderInst() {
        return MsfClassLoaderFactory.getInstance();
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        AgeClass<?> cls = clsContainer.get(name);
        if (cls != null) {
            return (Class)cls.getModel();
        }
        return Class.forName(name, true, TextClassLoader.getClassLoaderInst());
    }

    public static AgeClass<?> loadCls(String clsContent, long updateTime) {
        Matcher clsNameMatcher = clsNamePattern.matcher(clsContent);
        Matcher packageMatcher = packagePattern.matcher(clsContent.replaceAll("\r\n", ""));
        if (!clsNameMatcher.find() || !packageMatcher.find()) {
            return null;
        }
        String clsName = clsNameMatcher.group(2);
        String fullClsName = TextClassLoader.getClsFullName(packageMatcher.group(1), clsName, "");
        int clsInd = 0;
        AgeClass<Object> ageCls = clsContainer.get(fullClsName);
        if (ageCls == null || ageCls.getLastUpdateTime() < updateTime || reloadCls) {
            if (ageCls != null) {
                String simpleName = ((Class)ageCls.getModel()).getSimpleName();
                clsInd = 1 + Integer.valueOf(simpleName.substring(clsName.length()));
            }
            clsContent = clsNameMatcher.replaceFirst(clsNameMatcher.group().replace(clsName, clsName + clsInd));
            JavaSourceFromString sourceObject = new JavaSourceFromString(clsName + clsInd, clsContent);
            List<JavaSourceFromString> fileObjects = Arrays.asList(sourceObject);
            StringWriter write = new StringWriter();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            FoumulaJavaFileManager fileManagerExt = new FoumulaJavaFileManager(fileManager);
            JavaCompiler.CompilationTask task = compiler.getTask(write, fileManagerExt, null, optionList, null, fileObjects);
            boolean result = task.call();
            if (!result) {
                logger.error((Object)("compile error:" + clsName + clsInd));
                logger.error((Object)clsContent);
                logger.error(optionList);
                throw new RuntimeException((Throwable)new CompileError(write.getBuffer().toString()));
            }
            byte[] content = sourceObject.getCompiledBytes();
            Class cls = null;
            try {
                defineClassMethod.setAccessible(true);
                cls = (Class)defineClassMethod.invoke((Object)TextClassLoader.getClassLoaderInst(), null, content, new Integer(0), new Integer(content.length));
                defineClassMethod.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("InvocationTargetException", e);
            }
            ageCls = new AgeClass();
            ageCls.setModel(cls);
            ageCls.setLastUpdateTime(updateTime);
            clsContainer.put(fullClsName, ageCls);
            TextClassLoader.recordJavaFile(clsContent, content, clsName);
        }
        return ageCls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordJavaFile(String clsContent, byte[] content, String orinalClsName) {
        String subPath = TextClassLoader.getRecordFilePath(clsContent);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(subPath + ".class"));
            fos.write(content);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void deleOldFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        long curTime = System.currentTimeMillis();
        for (File subFile : file.listFiles()) {
            if (subFile.isFile()) {
                if (curTime - subFile.lastModified() <= oldFileRemain) continue;
                subFile.delete();
                continue;
            }
            TextClassLoader.deleOldFile(subFile.getAbsolutePath());
        }
        if (file.list() == null || file.list().length == 0) {
            file.delete();
        }
    }

    private static String getRecordFilePath(String clsContent) {
        Matcher clsNameMatcher = clsNamePattern.matcher(clsContent);
        Matcher packageMatcher = packagePattern.matcher(clsContent.replaceAll("\r\n", "").trim());
        clsNameMatcher.find();
        packageMatcher.find();
        StringBuffer subPath = new StringBuffer(TextClassLoader.getClsPath()).append(File.separator);
        subPath.append(packageMatcher.group(1).replaceAll("\\.", "/"));
        File file = new File(subPath.toString());
        if (!file.exists()) {
            file.mkdirs();
        }
        return subPath.append(File.separator).append(clsNameMatcher.group(2)).toString();
    }

    public static String getClsPath() {
        StringBuffer subPath = new StringBuffer(SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"formulaplatform"));
        return subPath.append(File.separator).append("cls").toString();
    }

    private static String getClsFullName(String packageName, String clsName, Object index) {
        return MessageFormat.format("{0}.{1}{2}", packageName, clsName, index);
    }

    public static AgeClass<?> loadCls(String clsContent) {
        return TextClassLoader.loadCls(clsContent, System.currentTimeMillis());
    }

    public static Object getClsInst(String fullClsName) throws InstantiationException, IllegalAccessException {
        AgeClass<?> ageCls = clsContainer.get(fullClsName);
        return ageCls == null ? null : ((Class)ageCls.getModel()).newInstance();
    }

    public static Class<?> getCls(String fullClsName) {
        AgeClass<?> ageCls = clsContainer.get(fullClsName);
        return ageCls == null ? null : (Class)ageCls.getModel();
    }

    public static AgeClass<?> getAgeCls(String fullClsName) {
        return clsContainer.get(fullClsName);
    }

    public static AgeClass<?> remove(String fullClsName) {
        return clsContainer.remove(fullClsName);
    }

    static {
        classPath = TextClassLoader.getClsPath();
        reloadCls = false;
        oldFileRemain = 3600000L;
        clsContainer = new ConcurrentHashMap();
        clsNamePattern = Pattern.compile(" (class|interface|enum)\\s+([\\w]+)\\s+");
        packagePattern = Pattern.compile("^package\\s+([\\w\\.]+)\\s*;");
        logger = Logger.getLogger(TextClassLoader.class);
        TextClassLoader.init();
    }
}

