/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.formulaexecutor;

import com.alibaba.fastjson.util.TypeUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.UniqueID;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.formulaplatform.FormulaException;
import com.kingdee.shr.formulaplatform.FormulaFuncCollection;
import com.kingdee.shr.formulaplatform.FormulaFuncFactory;
import com.kingdee.shr.formulaplatform.FormulaFuncInfo;
import com.kingdee.shr.formulaplatform.FormulaItemCollection;
import com.kingdee.shr.formulaplatform.FormulaItemFactory;
import com.kingdee.shr.formulaplatform.FormulaItemInfo;
import com.kingdee.shr.formulaplatform.FormulaTplInfo;
import com.kingdee.shr.formulaplatform.FormulaTplItemCollection;
import com.kingdee.shr.formulaplatform.FormulaTplItemInfo;
import com.kingdee.shr.formulaplatform.IFormulaFunc;
import com.kingdee.shr.formulaplatform.UpdateTypeEnum;
import com.kingdee.shr.formulaplatform.app.CollectionUtil;
import com.kingdee.shr.formulaplatform.app.FormulaUtil;
import com.kingdee.shr.formulaplatform.baseconfig.FormulaCacheService;
import com.kingdee.shr.formulaplatform.baseconfig.FormulaSqlParam;
import com.kingdee.shr.formulaplatform.compile.FormulaDynamicClass;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.FormulaExprProcessor;
import com.kingdee.shr.formulaplatform.formulaexecutor.BatchMessageTipsHeader;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaCacheLevel;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaCtx;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaExecutorUtile;
import com.kingdee.shr.formulaplatform.formulaexecutor.IFormulaExecutor;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultFormulaExecutor {
    private static Logger logger = Logger.getLogger(DefaultFormulaExecutor.class);
    public static final Pattern P_FIELD_GET = Pattern.compile("\\(scheme:getFieldVal\\)(\\(dataSource,\"([\\w]*)\",\"([\\.\\w\\$]+)\"\\))");
    public static final Pattern P_FORMULA_ID = Pattern.compile("\\(formulaFunc:getFormulaFun\\)\\(\"([\\.\\w\\$=\\+/]+)\"\\)");
    public static final Pattern P_CUNSTON_FUN = Pattern.compile("FormulaExecutorUtile\\.getFieldVal\\(([\\w\\$]+),\"([\\w]*)\",\"([\\.\\w\\$]+)\"\\)");
    public static final String FIELD_TPL_FILTER = "filter";
    private static final UniqueID uniqueID = new UniqueID();
    private FormulaCtx formulaCtx = new FormulaCtx();

    public void analyzeFunc(Context ctx, Set<String> funIds) {
        int i;
        HashSet<String> allFun = new HashSet<String>(this.formulaCtx.getInitialFunNames());
        if (funIds != null) {
            allFun.addAll(funIds);
        }
        String filterStr = "('" + StringUtils.join((Object[])allFun.toArray(), (String)"','") + "')";
        FormulaFuncCollection funcDatas = null;
        try {
            IFormulaFunc iFormulaFunc = ctx == null ? FormulaFuncFactory.getRemoteInstance() : FormulaFuncFactory.getLocalInstance(ctx);
            funcDatas = iFormulaFunc.getFormulaFuncCollection("select id,define,content,lastUpdatetime where id in " + filterStr);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int n = i = funcDatas == null ? 0 : funcDatas.size();
        while (i-- > 0) {
            this.analyzeFunc(ctx, funcDatas.get(i));
        }
    }

    public Set<String> getFuncIds(FormulaItemCollection items) {
        int i;
        HashSet<String> selectedFuncs = new HashSet<String>();
        int n = i = items == null ? 0 : items.size();
        while (i-- > 0) {
            Matcher matcher = P_FORMULA_ID.matcher(items.get(i).getScript());
            while (matcher.find()) {
                selectedFuncs.add(matcher.group(1));
            }
        }
        return selectedFuncs;
    }

    public void analyzeFunc(Context ctx, FormulaItemCollection items) {
        this.analyzeFunc(ctx, this.getFuncIds(items));
    }

    public void analyzeFormula(Context ctx, FormulaItemCollection items) throws FormulaException {
        int i;
        if (items == null || items.size() == 0) {
            return;
        }
        this.analyzeFunc(ctx, items);
        int n = i = items == null ? 0 : items.size();
        while (i-- > 0) {
            this.analyzeFormula(ctx, items.get(i), false);
        }
    }

    public Class<IFormulaExecutor> analyzeFormula(Context ctx, FormulaItemInfo formulaInfo, boolean needAnalyzeFunc) throws FormulaException {
        if (needAnalyzeFunc) {
            FormulaItemCollection items = new FormulaItemCollection();
            items.add(formulaInfo);
            this.analyzeFunc(ctx, items);
        }
        if (formulaInfo.isCompiled()) {
            return formulaInfo.getCompileCls();
        }
        Class<IFormulaExecutor> cls = this.getFormulaDynamicClass().getFormulaCls(ctx, formulaInfo, this.formulaCtx.isSimulate());
        formulaInfo.setCompiled(true);
        formulaInfo.setCompileCls(cls);
        if (formulaInfo.isSimula()) {
            FormulaCacheService.getInstance(this);
            FormulaCacheService.putFormulaItemInfo(formulaInfo);
        }
        return cls;
    }

    protected FormulaExprProcessor getFormulaExprProcess() {
        return new FormulaExprProcessor();
    }

    public Class<IFormulaExecutor> analyzeFunc(Context ctx, FormulaFuncInfo formulaFuncInfo) {
        Class<IFormulaExecutor> cls = this.getFormulaDynamicClass().getFormulaFunCls(ctx, formulaFuncInfo, false);
        formulaFuncInfo.setCompiled(true);
        formulaFuncInfo.setCompileCls(cls);
        FormulaCacheService.getInstance(this).putFormulaFuncInfo(formulaFuncInfo);
        return cls;
    }

    protected FormulaDynamicClass getFormulaDynamicClass() {
        return new FormulaDynamicClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws EASBizException, BOSException {
        FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.GLOBAL);
        try {
            this.init(ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(this.formulaCtx.getFormulaFilterInfo());
            FormulaItemCollection items = FormulaItemFactory.getLocalInstance(ctx).getFormulaItemCollection(view);
            this.resetExecutor(ctx, items);
            boolean res = this.execute(ctx, items);
            this.resetExecutor(ctx, items);
            boolean bl = res;
            return bl;
        }
        finally {
            FormulaCacheService.getInstance(this).removeCache(ctx, FormulaCacheLevel.GLOBAL);
        }
    }

    protected void init(Context ctx) {
    }

    protected void resetExecutor(Context ctx, FormulaItemCollection items) {
    }

    protected boolean execute(Context ctx, FormulaItemCollection items) throws EASBizException, BOSException {
        Map<String, List<FormulaItemInfo>> groupedItems = FormulaExecutorUtile.groupFormula(items);
        for (List<FormulaItemInfo> groupedItem : groupedItems.values()) {
            FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.FORMULA_GROUP);
            this.addDefaultItems(ctx, groupedItem);
            this.analyzeFormula(ctx, (FormulaItemCollection)CollectionUtil.toCoreCollection(groupedItem, FormulaItemCollection.class));
            this.executeGroupItem(ctx, groupedItem, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreBaseInfo> executeGroupItem(Context ctx, List<FormulaItemInfo> groupedItems) throws EASBizException, BOSException {
        FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.GLOBAL);
        FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.FORMULA_GROUP);
        try {
            List<CoreBaseInfo> list = this.executeGroupItem(ctx, groupedItems, false);
            return list;
        }
        finally {
            FormulaCacheService.getInstance(this).removeCache(ctx, FormulaCacheLevel.GLOBAL);
        }
    }

    protected List<CoreBaseInfo> executeGroupItem(Context ctx, List<FormulaItemInfo> groupedItems, boolean saveData) throws EASBizException, BOSException {
        this.formulaCtx.setBosCtx(ctx);
        FormulaItemCollection items = (FormulaItemCollection)CollectionUtil.toCoreCollection(groupedItems, FormulaItemCollection.class);
        if (this.formulaCtx.isSimulate()) {
            this.init(ctx);
            for (FormulaItemInfo item : groupedItems) {
                if (item.isSimula()) {
                    item.put("id", MessageFormat.format("S{0}_{1}", uniqueID.next(), item.getNumber()));
                }
                this.analyzeFormula(ctx, item, true);
            }
            this.resetExecutor(ctx, items);
        }
        List<CoreBaseInfo> colls = this.doExecuteGroupItem(ctx, groupedItems, saveData);
        if (this.formulaCtx.isSimulate()) {
            for (FormulaItemInfo item : groupedItems) {
                if (!item.isSimula()) continue;
                FormulaCacheService.getInstance(this).removeFormulaItemCache(item.getString("id"));
            }
            this.resetExecutor(ctx, items);
        }
        return colls;
    }

    protected List<CoreBaseInfo> doExecuteGroupItem(Context ctx, List<FormulaItemInfo> groupedItems, boolean saveData) throws EASBizException, BOSException {
        this.formulaCtx.setCurformulaExecutor(this);
        this.formulaCtx.setBosCtx(ctx);
        this.formulaCtx.setBatchSize(this.formulaCtx.isSimulate() ? 50 : this.formulaCtx.getBatchSize());
        ArrayList<CoreBaseInfo> colls = new ArrayList<CoreBaseInfo>();
        Collections.sort(groupedItems, new FormulaItemSort());
        int batch = 1;
        while (true) {
            int i;
            FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.DATA_GROUP);
            FormulaSqlParam param = this.createSqlParam(ctx, groupedItems, batch);
            List<Map<String, Object>> schedmeData = this.getSchemeDataFromGroupedItem(ctx, groupedItems, param);
            this.formulaCtx.put(SqlParam.class, (Object)param);
            this.formulaCtx.setSchemeDataSorces(schedmeData);
            int n = i = schedmeData == null ? 0 : schedmeData.size();
            while (i-- > 0) {
                this.formulaCtx.setCurSchemeDataSorces(schedmeData.get(i));
                FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.EXECUTE_GROUP);
                CoreBaseInfo coreBaseInfo = this.executeFormula(ctx, groupedItems, schedmeData.get(i));
                if (coreBaseInfo == null) continue;
                colls.add(coreBaseInfo);
            }
            if (colls.size() > 0 && saveData) {
                try {
                    this.saveData(ctx, groupedItems, colls);
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                colls.clear();
            }
            if (schedmeData == null || schedmeData.size() < this.formulaCtx.getBatchSize() || this.formulaCtx.isSimulate()) break;
            ++batch;
        }
        return colls;
    }

    protected void saveData(Context ctx, List<FormulaItemInfo> items, List<CoreBaseInfo> waitSaveData) throws BOSException, SQLException, EASBizException {
        Map<List<Object>, Object> existDataMap = this.getExistDataMap(ctx, items, waitSaveData);
        CoreBaseCollection colls = new CoreBaseCollection();
        BatchMessageTipsHeader tips = this.formulaCtx.getBatchMessageTipsHeader();
        for (CoreBaseInfo coreBaseInfo : waitSaveData) {
            Object existData = existDataMap.get(this.getExistKey(coreBaseInfo));
            BatchMessageTipsBody validateRes = this.validateSaveData(ctx, coreBaseInfo, existDataMap);
            if (validateRes != null) {
                tips.addResult(validateRes);
                if (StringUtils.isBlank((String)validateRes.getId())) {
                    validateRes.setId(String.valueOf(tips.getResult().size()));
                }
            }
            if (validateRes != null && !validateRes.isMuitTipsState()) {
                tips.setFailureCount(tips.getFailureCount() + 1);
                continue;
            }
            tips.setSuccessCount(tips.getSuccessCount() + 1);
            if (existData instanceof Collection) {
                Iterator iterator = ((Collection)existData).iterator();
                existData = iterator.hasNext() ? iterator.next() : null;
            } else if (existData instanceof IObjectCollection) {
                existData = ((IObjectCollection)existData).getObject(0);
            }
            if (existData instanceof CoreBaseInfo) {
                existData = ((CoreBaseInfo)existData).get("id");
            }
            if (StringUtils.isNotBlank((String)coreBaseInfo.getString("id"))) {
                existData = coreBaseInfo.getString("id");
            }
            if (existData != null && BOSUuid.isValid((String)existData.toString(), (boolean)false)) {
                coreBaseInfo.put("id", existData);
                tips.setUpdateCount(tips.getUpdateCount() + 1);
            } else {
                tips.setNewCount(tips.getNewCount() + 1);
            }
            colls.add(coreBaseInfo);
        }
        this.doSaveData(ctx, items, existDataMap, colls);
    }

    private void doSaveData(Context ctx, List<FormulaItemInfo> items, Map<List<Object>, Object> existDataMap, CoreBaseCollection colls) throws BOSException, EASBizException {
        if (colls.size() == 0) {
            return;
        }
        this.beforeSaveData(ctx, items, colls, existDataMap);
        EntityObjectInfo modelEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(colls.get(0).getBOSType());
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)modelEntity.getFullName()));
        iCoreBase.save(colls);
        this.afterSaveData(ctx, items, colls, existDataMap);
    }

    protected void beforeSaveData(Context ctx, List<FormulaItemInfo> items, CoreBaseCollection colls, Map<List<Object>, Object> existDataMap) {
    }

    protected void afterSaveData(Context ctx, List<FormulaItemInfo> items, CoreBaseCollection colls, Map<List<Object>, Object> existDataMap) {
    }

    protected BatchMessageTipsBody validateSaveData(Context ctx, CoreBaseInfo coreBaseInfo, Map<List<Object>, Object> existDataMap) {
        Object existData = existDataMap.get(this.getExistKey(coreBaseInfo));
        UpdateTypeEnum updateType = this.formulaCtx.getUpdateType();
        if (existData != null && updateType == UpdateTypeEnum.NEW_ADD || existData == null && updateType == UpdateTypeEnum.UPDATE_ONLY) {
            return new BatchMessageTipsBody(null, false, SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"data_already_exists", (Context)ctx));
        }
        return null;
    }

    protected Map<List<Object>, Object> getExistDataMap(Context ctx, List<FormulaItemInfo> items, List<CoreBaseInfo> waitSaveData) throws BOSException, SQLException {
        StringBuffer batchSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        int batchSize = this.formulaCtx.getBatchSize();
        HashMap<List<Object>, Object> existDataMap = new HashMap<List<Object>, Object>(waitSaveData.size());
        int size = waitSaveData.size();
        for (int i = 0; i <= size; ++i) {
            if (i == 0) {
                logger.debug((Object)"start fetch existDataMap");
            } else if (i % batchSize == 0 || i == size) {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)batchSql.toString(), (Object[])params.toArray());
                while (rowSet.next()) {
                    this.pupolateExistData(rowSet, existDataMap);
                }
                params.clear();
                batchSql.setLength(0);
                if (i == size) {
                    break;
                }
            } else {
                batchSql.append(" union ");
            }
            this.getQueryExistDataSqlAndParams(ctx, items, waitSaveData, batchSql, params, i);
        }
        return existDataMap;
    }

    protected void pupolateExistData(IRowSet rowSet, Map<List<Object>, Object> existDataMap) throws SQLException {
        existDataMap.put(this.getExistKey(rowSet), rowSet.getString("fid"));
    }

    protected void getQueryExistDataSqlAndParams(Context ctx, List<FormulaItemInfo> items, List<CoreBaseInfo> waitSaveData, StringBuffer batchSql, List<Object> params, int curIndex) {
        batchSql.append(this.getSelectSql(ctx, items, waitSaveData));
        Map<String, ColumnInfo> primayFieldsMap = this.formulaCtx.getPrimayFieldsMap();
        for (String field : primayFieldsMap.keySet()) {
            Object objValue = FormulaExecutorUtile.getFieldValFromCoreInfo(waitSaveData.get(curIndex), "test", field);
            if (objValue instanceof CoreBaseInfo) {
                objValue = ((CoreBaseInfo)objValue).getString("id");
            } else if (SQLType.DATETIME.equals((Object)primayFieldsMap.get(field).getTypeName())) {
                objValue = TypeUtils.castToTimestamp((Object)objValue);
            }
            params.add(objValue);
        }
    }

    protected List<Object> getExistKey(CoreBaseInfo coreBaseInfo) {
        Map<String, ColumnInfo> primayFieldsMap = this.formulaCtx.getPrimayFieldsMap();
        ArrayList<Object> key = new ArrayList<Object>(primayFieldsMap.size());
        for (String field : primayFieldsMap.keySet()) {
            Object objValue = FormulaExecutorUtile.getFieldValFromCoreInfo(coreBaseInfo, "test", field);
            if (objValue instanceof CoreBaseInfo) {
                objValue = ((CoreBaseInfo)objValue).getString("id");
            } else if (SQLType.DATETIME.equals((Object)primayFieldsMap.get(field).getTypeName())) {
                objValue = TypeUtils.castToTimestamp((Object)objValue);
            }
            key.add(objValue);
        }
        return key;
    }

    protected List<Object> getExistKey(IRowSet rowSet) throws SQLException {
        Map<String, ColumnInfo> primayFieldsMap = this.formulaCtx.getPrimayFieldsMap();
        ArrayList<Object> key = new ArrayList<Object>(primayFieldsMap.size());
        int i = 0;
        for (String field : primayFieldsMap.keySet()) {
            key.add(rowSet.getObject(++i));
        }
        return key;
    }

    protected FormulaTplInfo getFormulaTplInfo(FormulaItemInfo formulaItemInfo) {
        return FormulaCacheService.getInstance(this).getFormulaTplInfo(formulaItemInfo.getFormulaTpl().getString("id"));
    }

    protected String getSelectSql(Context ctx, List<FormulaItemInfo> items, List<CoreBaseInfo> waitSaveData) {
        String existSql = this.formulaCtx.getExistSql();
        if (StringUtils.isNotBlank((String)existSql)) {
            return existSql;
        }
        FormulaTplInfo formulaTplInfo = this.getFormulaTplInfo(items.get(0));
        String model = formulaTplInfo.getModel();
        EntityObjectInfo modelEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)model));
        Map<String, PropertyInfo> properties = FormulaExecutorUtile.getproperties(modelEntity);
        Map<String, ColumnInfo> primayFieldsMap = this.formulaCtx.getPrimayFieldsMap();
        for (String key : primayFieldsMap.keySet()) {
            PropertyInfo propertyInfo = properties.get(key);
            if (primayFieldsMap.get(key) != null || propertyInfo == null || propertyInfo.getMappingField() == null) continue;
            primayFieldsMap.put(key, propertyInfo.getMappingField());
        }
        StringBuffer sql = new StringBuffer("select  ");
        for (ColumnInfo column : primayFieldsMap.values()) {
            sql.append(column.getName()).append(",");
        }
        sql.setLength(sql.length() - 1);
        if (!primayFieldsMap.containsKey("fid")) {
            sql.append(",fid");
        }
        sql.append(" from ").append(modelEntity.getTable().getName()).append(" where ");
        for (ColumnInfo column : primayFieldsMap.values()) {
            sql.append(column.getName()).append("=? and ");
        }
        sql.setLength(sql.length() - 4);
        existSql = sql.toString();
        this.formulaCtx.setExistSql(existSql);
        return existSql;
    }

    protected List<Map<String, Object>> getSchemeDataFromGroupedItem(Context ctx, List<FormulaItemInfo> groupedItem, FormulaSqlParam param) throws EASBizException, BOSException {
        String formula;
        Map<String, String> schemeSqlMap = this.formulaCtx.getSchemeSqlMap();
        String sql = schemeSqlMap.get(formula = this.getCurCalFormula(groupedItem));
        if (sql == null) {
            sql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
            schemeSqlMap.put(formula, sql);
        }
        PagingHelper pageHelper = new PagingHelper();
        int start = (param.getPage() - 1) * param.getRows();
        sql = pageHelper.getPagingSqlNoOptmize(ctx, sql, start, param.getRows());
        IRowSet rowSet = DbUtil.executeQueryNoTx((Context)ctx, (String)sql);
        List returnData = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowSet);
        if (this.formulaCtx.getInitialSchemeData() != null && returnData != null) {
            Iterator dataIt = returnData.iterator();
            while (dataIt.hasNext()) {
                ((Map)dataIt.next()).putAll(this.formulaCtx.getInitialSchemeData());
            }
        }
        return returnData;
    }

    protected FormulaSqlParam createSqlParam(Context ctx, List<FormulaItemInfo> items, int curBatch) throws FormulaException {
        FormulaSqlParam sqlParam = new FormulaSqlParam();
        Set<String> selectFields = this.getSchemeFieldsFromGroupedItem(items);
        HashMap<String, String> selectFieldMap = new HashMap<String, String>();
        for (String field : selectFields) {
            selectFieldMap.put(field, field);
        }
        sqlParam.setSelectMapping(selectFieldMap);
        FormulaTplInfo formulaTplInfo = this.getFormulaTplInfo(items.get(0));
        sqlParam.setScheme(formulaTplInfo.getScheme().getNumber());
        sqlParam.setInfoCtr(this.getInfoCtrl(ctx, sqlParam, true));
        Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
        sqlParam.setFilterDate(effectDate);
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        sqlParam.setRows(this.formulaCtx.getBatchSize());
        sqlParam.setPage(curBatch);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo customFilter = this.assembleFilterInfo(ctx, sqlParam, items, curBatch);
        try {
            filterInfo.mergeFilter(customFilter, "AND");
            filterInfo.mergeFilter(this.formulaCtx.getSchemeDataFilterInfo(), "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setSorter(null);
        sqlParam.setQueryUuid(null);
        sqlParam.setSorterMethod(null);
        sqlParam.setAll(true);
        sqlParam.setSupportQueryUuid(false);
        sqlParam.setDynExtendSQLJoinConditionPostFragment(this.assembledynExtendSQLJoinConditionPostFragment(null, sqlParam));
        if (this.formulaCtx.isSimulate() && sqlParam.getFilterInfo() == null) {
            sqlParam.setRows(this.formulaCtx.getBatchSize());
            sqlParam.setPage(1);
        }
        sqlParam.setAutoExtendField(this.formulaCtx.getAutoExtendField());
        this.prepareSqlParam(null, sqlParam);
        return sqlParam;
    }

    protected FilterInfo assembleFilterInfo(Context ctx, SqlParam sqlParam, List<FormulaItemInfo> items, int curBatch) {
        if (!this.formulaCtx.isSchemeDateFilterByFormula() || this.formulaCtx.isSimulate()) {
            return null;
        }
        String filterVal = this.getCurCalFormula(items);
        BOSObjectType bosType = BOSUuid.read((String)filterVal).getType();
        String filterName = null;
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        String selectNumberSql = " select top 1 fclientNumber,1 from T_HR_StructureConfig sconfig join T_HR_StructureConfigScheme scscheme on sconfig.FSchemeID=scscheme.fid  where scscheme.fnumber=? union all select fclientNumber,2 from T_HR_StructureConfig sconfig join T_HR_StructureConfigScheme scscheme on sconfig.FSchemeID=scscheme.fid  where sconfig.FEntityName=? and scscheme.fnumber=?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectNumberSql, (Object[])new Object[]{sqlParam.getScheme(), entityObjectInfo.getFullName(), sqlParam.getScheme()});
            while (rowSet.next()) {
                if (filterName != null && rowSet.getInt(2) != 2) continue;
                filterName = rowSet.getString(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        FilterInfo returnFilter = new FilterInfo();
        if (StringUtils.isNotEmpty(filterName)) {
            returnFilter.getFilterItems().add(new FilterItemInfo(filterName + ".id", (Object)filterVal, CompareType.EQUALS));
        }
        return returnFilter;
    }

    protected String getCurCalFormula(List<FormulaItemInfo> items) {
        BOSObjectType tplType = new FormulaTplItemInfo().getBOSType();
        for (FormulaItemInfo item : items) {
            if (tplType.equals((Object)BOSUuid.read((String)item.getFormula()).getType())) continue;
            return item.getFormula();
        }
        return items.get(0).getFormula();
    }

    protected Map<String, String> assembledynExtendSQLJoinConditionPostFragment(Map<String, String> params, SqlParam sqlParam) {
        return Collections.emptyMap();
    }

    protected Map<String, String> getInfoCtrl(Context ctx, SqlParam sqlParam, boolean singleView) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scheme", sqlParam.getScheme());
        param.put("selectFields", StringUtils.join(sqlParam.getSelectMapping().keySet().iterator(), (String)","));
        List resultList = (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getStructureConfigMultiRowService");
        HashMap<String, String> InfoCtrl = new HashMap<String, String>();
        if (null != resultList) {
            for (Map map : resultList) {
                Object obj = map.get("clientNumber");
                if (!(obj instanceof String)) continue;
                InfoCtrl.put(String.valueOf(obj).toUpperCase(), String.valueOf(singleView));
            }
        }
        return InfoCtrl;
    }

    protected void prepareSqlParam(Map<String, String> params, FormulaSqlParam sqlParam) {
        sqlParam.setNeedReplaceVars(this.formulaCtx.getSqlParamReplaceVar());
    }

    protected Set<String> getSchemeFieldsFromGroupedItem(List<FormulaItemInfo> groupedItems) throws FormulaException {
        int i;
        HashSet<IFormulaExecutor> executors = new HashSet<IFormulaExecutor>();
        int n = i = groupedItems == null ? 0 : groupedItems.size();
        while (i-- > 0) {
            executors.add(FormulaExecutorUtile.getExecutorInst(groupedItems.get(i), this));
            Matcher matcher = P_FORMULA_ID.matcher(groupedItems.get(i).getScript());
            while (matcher.find()) {
                executors.add(FormulaExecutorUtile.getFuncExecutorInst(matcher.group(1), this));
            }
        }
        HashSet<String> fields = new HashSet<String>();
        for (IFormulaExecutor formulaExecutor : executors) {
            String[] fieldArr = formulaExecutor == null ? null : formulaExecutor.getSchemeField();
            if (fieldArr == null) continue;
            fields.addAll(Arrays.asList(fieldArr));
        }
        return fields;
    }

    protected CoreBaseInfo executeFormula(Context ctx, List<FormulaItemInfo> items, Map<String, Object> dataSource) throws EASBizException {
        int size;
        if (items == null || items.size() == 0) {
            return null;
        }
        this.beforeExecuteFormula(ctx, items, dataSource);
        FormulaTplInfo formulaTplInfo = this.getFormulaTplInfo(items.get(0));
        this.initCalModel(ctx, formulaTplInfo, items);
        CoreBaseInfo modelObj = (CoreBaseInfo)this.formulaCtx.getCalModel().clone();
        this.formulaCtx.setCurCalModel(modelObj);
        int n = size = items == null ? 0 : items.size();
        for (int i = 0; i < size; ++i) {
            FormulaCacheService.getInstance(this).setCacheKey(ctx, FormulaCacheLevel.EXECUTE_GROUP);
            IFormulaExecutor formulaExecutor = FormulaExecutorUtile.getExecutorInst(items.get(i), this);
            formulaExecutor.setFormulaCtx(this.formulaCtx);
            if (formulaExecutor.execute()) continue;
            this.formulaCtx.setCurCalModel(null);
            break;
        }
        this.afterExecuteFormula(ctx, items, dataSource, modelObj);
        return modelObj;
    }

    protected void afterExecuteFormula(Context ctx, List<FormulaItemInfo> items, Map<String, Object> dataSource, CoreBaseInfo modelObj) throws EASBizException {
        if (modelObj == null) {
            return;
        }
        String[] autoExtendField = this.formulaCtx.getAutoExtendField();
        for (String key : dataSource.keySet()) {
            HashMap<String, Object> extendFields = new HashMap<String, Object>(autoExtendField.length);
            for (String extendFiled : autoExtendField) {
                Object nameValue;
                if (key == null || !key.endsWith(".id") || (nameValue = dataSource.get(key.substring(0, key.lastIndexOf(".") + 1) + extendFiled)) == null) continue;
                extendFields.put(extendFiled, nameValue);
            }
            if (extendFields.isEmpty()) continue;
            this.setExtendValue(dataSource.get(key), modelObj, extendFields);
        }
    }

    protected void setExtendValue(Object id, CoreBaseInfo modelObj, Map<String, Object> extendFields) {
        if (modelObj == null || id == null) {
            return;
        }
        if (StringUtils.equals((String)modelObj.getString("id"), (String)id.toString())) {
            for (Map.Entry<String, Object> filedEntry : extendFields.entrySet()) {
                modelObj.put(filedEntry.getKey(), filedEntry.getValue());
            }
        }
        Enumeration keys = modelObj.keys();
        while (keys.hasMoreElements()) {
            Object valueObj = modelObj.get(keys.nextElement().toString());
            if (!(valueObj instanceof CoreBaseInfo)) continue;
            this.setExtendValue(id, (CoreBaseInfo)valueObj, extendFields);
        }
    }

    protected void beforeExecuteFormula(Context ctx, List<FormulaItemInfo> items, Map<String, Object> dataSource) throws EASBizException {
    }

    protected void initCalModel(Context ctx, FormulaTplInfo formulaTplInfo, List<FormulaItemInfo> items) throws EASBizException {
        CoreBaseInfo calModel = this.formulaCtx.getCalModel();
        if (calModel == null) {
            String model = formulaTplInfo.getModel();
            EntityObjectInfo modelEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)model));
            Object coreBaseInfo = null;
            try {
                Class modelCls = modelEntity.getObjectValueClazzRuntime();
                calModel = (CoreBaseInfo)modelCls.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new EASBizException(EASBizException.CLASS_INIT_ERROR, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new EASBizException(EASBizException.CLASS_INIT_ERROR, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new EASBizException(EASBizException.CLASS_INIT_ERROR, (Throwable)e);
            }
        }
        calModel.clear();
        calModel = (CoreBaseInfo)calModel.clone();
        this.formulaCtx.setCalModel(calModel);
        if (this.formulaCtx.getInitialModelData() != null) {
            for (String field : this.formulaCtx.getInitialModelData().keySet()) {
                calModel.put(field, this.formulaCtx.getInitialModelData().get(field));
            }
        }
    }

    protected void addDefaultItems(Context ctx, List<FormulaItemInfo> groupedItem) throws BOSException, EASBizException {
        if (groupedItem == null || groupedItem.size() == 0 || groupedItem.get(0).getFormulaTpl() == null) {
            return;
        }
        HashSet<String> fields = new HashSet<String>(groupedItem.size());
        fields.add(FIELD_TPL_FILTER);
        int i = groupedItem.size();
        while (--i >= 0) {
            groupedItem.set(i, FormulaUtil.gerRefFormulaItem((FormulaItemInfo)groupedItem.get(i)));
            fields.add(groupedItem.get(i).getNumber());
        }
        FormulaTplInfo tpl = this.getFormulaTplInfo(groupedItem.get(0));
        FormulaTplItemCollection tplItems = tpl.getItems();
        if (tplItems == null || tplItems.size() == fields.size()) {
            return;
        }
        for (int i2 = 0; i2 < tplItems.size(); ++i2) {
            if (fields.contains(tplItems.get(i2).getField()) || !tplItems.get(i2).isEnable() || tplItems.get(i2).getCacheDefaultVal() == null) continue;
            groupedItem.add(tplItems.get(i2).getCacheDefaultVal());
        }
    }

    public FormulaCtx getFormulaCtx() {
        return this.formulaCtx;
    }

    public DefaultFormulaExecutor setFormulaCtx(FormulaCtx formulaCtx) {
        this.formulaCtx = formulaCtx;
        return this;
    }

    class FormulaItemSort
    implements Comparator<FormulaItemInfo> {
        FormulaItemSort() {
        }

        @Override
        public int compare(FormulaItemInfo o1, FormulaItemInfo o2) {
            if (StringUtils.equalsIgnoreCase((String)o1.getNumber(), (String)DefaultFormulaExecutor.FIELD_TPL_FILTER)) {
                return -1;
            }
            if (StringUtils.equalsIgnoreCase((String)o2.getNumber(), (String)DefaultFormulaExecutor.FIELD_TPL_FILTER)) {
                return 1;
            }
            if (o1.getSortSn() == o2.getSortSn()) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
            return o1.getSortSn() - o2.getSortSn();
        }
    }
}

