/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteforother.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.inteforother.vo.InteMainResult;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRMainSqlHelper {
    private static Logger logger = LoggerFactory.getLogger(HRMainSqlHelper.class);

    public static void queryTotal(Context ctx, String sqlInfo, InteMainResult dataResult) throws BOSException {
        if (null == sqlInfo || null == dataResult || StringUtils.isEmpty((String)sqlInfo)) {
            return;
        }
        StringBuilder totalSql = new StringBuilder();
        totalSql.append("SELECT COUNT(1) CC FROM (");
        totalSql.append(HRMainSqlHelper.removeOrderByForSQL(ctx, sqlInfo));
        totalSql.append(") TEMP");
        String sql = HRMainSqlHelper.getTranslateDialectSQL(ctx, totalSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                dataResult.setTotal(rs.getInt("CC"));
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static String removeOrderByForSQL(Context ctx, String sql) {
        StringBuilder resultSQL = new StringBuilder();
        String tempOrderBy = sql;
        tempOrderBy = tempOrderBy.replace(";", "");
        while (true) {
            int orderByIndex;
            if ((orderByIndex = tempOrderBy.toUpperCase(ctx.getLocale()).indexOf("ORDER BY")) == -1) {
                resultSQL.append(tempOrderBy);
                break;
            }
            resultSQL.append(tempOrderBy.substring(0, orderByIndex));
            tempOrderBy = tempOrderBy.substring(orderByIndex);
            int bracketIndex = tempOrderBy.indexOf(")");
            if (bracketIndex == -1) break;
            tempOrderBy = tempOrderBy.substring(bracketIndex);
        }
        return resultSQL.toString();
    }

    public static String getTranslateDialectSQL(Context ctx, String sql) {
        try {
            return HRMainSqlHelper.getTranslateDialectSQL(HRMainSqlHelper.getDbType(ctx), sql);
        }
        catch (BOSException e) {
            logger.error("paging translate sql eroor: =" + sql);
            return sql;
        }
    }

    public static String getTranslateDialectSQL(int dbType, String sql) {
        if (sql.startsWith("/*dialect*/")) {
            return sql;
        }
        try {
            sql = TransUtil.translate((String)sql, (int)dbType, (FormatOptions)new FormatOptions());
        }
        catch (SqlTranslateException e) {
            logger.error("paging error sql is =" + sql);
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/*dialect*/").append(sql);
        return sb.toString();
    }

    private static int getDbType(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            int n = KSqlUtil.getDbType((Connection)cn);
            return n;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static Set<String> getQueryEntityFullName(String queryPK) {
        HashSet<String> result = new HashSet<String>();
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)MetaDataPK.create((String)queryPK));
        SelectorInfo selector = queryInfo.getSelector();
        ArrayList fields = selector.getFields();
        String entiryFullName = "";
        for (QueryFieldInfo queryFieldInfo : fields) {
            PropertyRefInfo propertyRefInfo;
            SubEntityInfo subEntity;
            PropertyRefCollection propertyRefs = queryFieldInfo.getPropertyRefs();
            if (propertyRefs == null || propertyRefs.size() <= 0 || (subEntity = (propertyRefInfo = propertyRefs.get(0)).getSubEntity()) == null) continue;
            EntityObjectInfo entityRef = subEntity.getEntityRef();
            entiryFullName = entityRef.getFullName();
            result.add(entiryFullName);
        }
        return result;
    }
}

