/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteothersys.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfm.utils.UrlEncode;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.inteothersys.InteOtherSysFieldType;
import com.kingdee.shr.inteothersys.OtherSysInterfaceF7ParamCollection;
import com.kingdee.shr.inteothersys.OtherSysInterfaceF7ParamFactory;
import com.kingdee.shr.inteothersys.OtherSysInterfaceF7ParamInfo;
import com.kingdee.shr.inteothersys.OtherSysInterfaceInfoFactory;
import com.kingdee.shr.inteothersys.OtherSysInterfaceInfoInfo;
import com.kingdee.shr.inteothersys.OtherSysInterfaceOptType;
import com.kingdee.shr.inteothersys.OtherSysInterfaceType;
import com.kingdee.shr.inteothersys.OtherSysKeysEntryCollection;
import com.kingdee.shr.inteothersys.OtherSysKeysEntryFactory;
import com.kingdee.shr.inteothersys.OtherSysKeysEntryInfo;
import com.kingdee.shr.inteothersys.OtherSysParamsEntryCollection;
import com.kingdee.shr.inteothersys.OtherSysParamsEntryFactory;
import com.kingdee.shr.inteothersys.OtherSysParamsEntryInfo;
import com.kingdee.shr.inteothersys.util.HttpClientUtil;
import com.kingdee.shr.inteothersys.util.OtherSysParamsExplainUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class OtherSysInterfaceOptUtils {
    private static Logger logger = Logger.getLogger(OtherSysInterfaceOptUtils.class);

    public static Map<String, Object> getReturnValByInterfaceID(Context ctx, Map param, List fieldList, String interfaceID) throws EASBizException, BOSException {
        Map<String, Object> preParam = OtherSysInterfaceOptUtils.getOtherSysInterfaceInfo(ctx, interfaceID, param);
        String returnValueByOptType = OtherSysInterfaceOptUtils.getReturnValueByOptType(ctx, preParam);
        Map<String, Object> keysAndVals = OtherSysParamsExplainUtils.parseReturnKeysAndVals(returnValueByOptType);
        OtherSysKeysEntryCollection keysCol = OtherSysKeysEntryFactory.getLocalInstance(ctx).getOtherSysKeysEntryCollection("where id in " + HRUtilExtend.getStrFromList((List)fieldList));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int total = keysCol.size();
        for (int i = 0; i < total; ++i) {
            String keyID = String.valueOf(fieldList.get(i));
            for (int j = 0; j < keysCol.size(); ++j) {
                OtherSysKeysEntryInfo keysEntryInfo = keysCol.get(j);
                String id = keysEntryInfo.getId().toString();
                if (!keyID.equals(id)) continue;
                HashMap<String, Object> keyMap = new HashMap<String, Object>();
                keyMap.put("key", keysEntryInfo.getKey());
                keyMap.put("name", keysEntryInfo.getName());
                int typeVal = keysEntryInfo.getType().getValue();
                keyMap.put("type", typeVal);
                Object vals = keysAndVals.get(keysEntryInfo.getKey());
                if (InteOtherSysFieldType.ENUM.getValue() == typeVal || InteOtherSysFieldType.F7.getValue() == typeVal) {
                    vals = OtherSysInterfaceOptUtils.assemblyDataByType(ctx, typeVal, vals, keyID, interfaceID);
                }
                keyMap.put("value", vals);
                resultMap.put(keysEntryInfo.getId().toString(), keyMap);
            }
        }
        return resultMap;
    }

    public static Object assemblyDataByType(Context ctx, int typeVal, Object vals, String keyID, String interfaceID) throws BOSException {
        if (InteOtherSysFieldType.ENUM.getValue() == typeVal) {
            ArrayList list = new ArrayList();
            List enumVals = new ArrayList();
            if (vals instanceof String) {
                enumVals = (List)JSON.parseObject((String)((String)vals), List.class);
            }
            if (vals instanceof List) {
                enumVals = (List)vals;
            }
            for (Object val : enumVals) {
                HashMap map = new HashMap();
                map.put("alias", val);
                map.put("value", val);
                list.add(map);
            }
            return list;
        }
        if (InteOtherSysFieldType.F7.getValue() == typeVal) {
            Map temp;
            List f7Vals = (List)vals;
            Map f7Key = (Map)f7Vals.get(0);
            ArrayList colModelList = new ArrayList();
            String oql = "where interfaces ='" + interfaceID + "' and key ='" + keyID + "'";
            OtherSysInterfaceF7ParamCollection f7ParamCollection = OtherSysInterfaceF7ParamFactory.getLocalInstance(ctx).getOtherSysInterfaceF7ParamCollection(oql);
            boolean hasID_key = false;
            boolean hasID_col = false;
            boolean hasName_key = false;
            boolean hasName_col = false;
            block1: for (String key : f7Key.keySet()) {
                HashMap<String, Object> colModelMap = new HashMap<String, Object>();
                if (key.equalsIgnoreCase("id")) {
                    hasID_key = true;
                }
                if (key.equalsIgnoreCase("name")) {
                    hasName_key = true;
                }
                for (int i = 0; i < f7ParamCollection.size(); ++i) {
                    OtherSysInterfaceF7ParamInfo f7ParamInfo = f7ParamCollection.get(i);
                    if (f7ParamInfo.getName().equalsIgnoreCase("id")) {
                        hasID_col = true;
                    }
                    if (f7ParamInfo.getName().equalsIgnoreCase("name")) {
                        hasName_col = true;
                    }
                    if (!f7ParamInfo.getName().equalsIgnoreCase(key)) continue;
                    colModelMap.put("hidden", false);
                    colModelMap.put("label", f7ParamInfo.getFieldName());
                    colModelMap.put("columnName", key);
                    colModelList.add(colModelMap);
                    continue block1;
                }
            }
            if (!hasID_col) {
                HashMap<String, Object> colModelMap = new HashMap<String, Object>();
                colModelMap.put("hidden", true);
                colModelMap.put("label", "id");
                colModelMap.put("columnName", "id");
                colModelList.add(colModelMap);
            }
            if (!hasID_key) {
                for (int i = 0; i < f7Vals.size(); ++i) {
                    temp = (Map)f7Vals.get(i);
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    temp.put("id", id);
                }
            }
            if (!hasName_col) {
                HashMap<String, Object> colModelMap = new HashMap<String, Object>();
                colModelMap.put("hidden", false);
                colModelMap.put("label", "name");
                colModelMap.put("columnName", "name");
                colModelList.add(colModelMap);
            }
            if (!hasName_key) {
                for (int i = 0; i < f7Vals.size(); ++i) {
                    temp = (Map)f7Vals.get(i);
                    temp.put("name", "name" + System.currentTimeMillis());
                }
            }
            HashMap f7Map = new HashMap();
            HashMap<String, Serializable> structure = new HashMap<String, Serializable>();
            structure.put("fastfilterData", null);
            structure.put("sorterItems", null);
            structure.put("addNewView", null);
            structure.put("colModel", colModelList);
            structure.put("requireAddNew", Boolean.valueOf(false));
            HashMap<String, Object> data = new HashMap<String, Object>();
            int records = f7Vals.size();
            int total = (int)Math.ceil((double)records / 10.0);
            data.put("records", records);
            data.put("total", total);
            data.put("page", 1);
            data.put("rows", f7Vals);
            data.put("userdata", null);
            data.put("queryUuid", null);
            f7Map.put("structure", structure);
            f7Map.put("data", data);
            return f7Map;
        }
        return null;
    }

    private static Map<String, Object> getOtherSysInterfaceInfo(Context ctx, String interfaceID, Map<String, Object> param) throws BOSException, EASBizException {
        OtherSysInterfaceInfoInfo interfaceInfo = OtherSysInterfaceInfoFactory.getLocalInstance(ctx).getOtherSysInterfaceInfoInfo("where id ='" + interfaceID + "'");
        HashMap<String, Object> preParam = new HashMap<String, Object>();
        preParam.put("interfaceName", interfaceInfo.getInterfaceName());
        int optType = interfaceInfo.getOptType().getValue();
        preParam.put("optType", optType);
        preParam.put("interfaceType", interfaceInfo.getInterfaceType().getValue());
        String oql = "where params ='" + interfaceID + "'";
        OtherSysParamsEntryCollection otherSysParamsCol = OtherSysParamsEntryFactory.getLocalInstance(ctx).getOtherSysParamsEntryCollection(oql);
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        for (int i = 0; i < otherSysParamsCol.size(); ++i) {
            OtherSysParamsEntryInfo otherSysParamsEntryInfo = otherSysParamsCol.get(i);
            String key = otherSysParamsEntryInfo.getKey();
            String id = otherSysParamsEntryInfo.getId().toString();
            if (OtherSysInterfaceOptType.WEBAPI.getValue() == optType && "SHRmethod".equalsIgnoreCase(key)) {
                requestParam.put("SHRmethod", otherSysParamsEntryInfo.getFieldValue());
                continue;
            }
            requestParam.put(key, param.get(id));
        }
        preParam.put("param", requestParam);
        return preParam;
    }

    public static Map<String, Object> writeBackOtherSysByInterfaceID(Context ctx, Map requestParam, Map writebackParam, String interfaceID) throws EASBizException, BOSException {
        Map<String, Object> preParam = OtherSysInterfaceOptUtils.getOtherSysInterfaceInfo(ctx, interfaceID, requestParam);
        Map tempParam = (Map)preParam.get("param");
        tempParam.put("valueJson", JSON.toJSONString((Object)writebackParam));
        String returnValueByOptType = OtherSysInterfaceOptUtils.getReturnValueByOptType(ctx, preParam);
        Map resultObj = (Map)JSON.parseObject((String)returnValueByOptType, Map.class);
        return resultObj;
    }

    public static String getReturnValueByOptType(Context ctx, Map param) throws EASBizException {
        Object returnValue = "";
        int optType = Integer.parseInt(String.valueOf(param.get("optType")));
        int interfaceType = Integer.parseInt(String.valueOf(param.get("interfaceType")));
        String interfaceName = String.valueOf(param.get("interfaceName"));
        Map paramToOtherSys = (Map)param.get("param");
        if (OtherSysInterfaceOptType.CUSTOMIZE.getValue() == optType) {
            try {
                Method method;
                Class<?> cls = Class.forName(interfaceName);
                Object obj = cls.newInstance();
                String methodName = "setValue";
                if (OtherSysInterfaceType.GETDATA.getValue() == interfaceType) {
                    methodName = "getValue";
                    method = cls.getDeclaredMethod(methodName, Context.class, Map.class);
                    returnValue = method.invoke(obj, ctx, paramToOtherSys);
                } else {
                    method = cls.getDeclaredMethod(methodName, Context.class, Map.class, String.class);
                    String valueJson = (String)paramToOtherSys.get("valueJson");
                    returnValue = method.invoke(obj, ctx, paramToOtherSys, valueJson);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("001", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5"));
            }
        }
        if (OtherSysInterfaceOptType.WEBAPI.getValue() == optType) {
            JSONObject jsonObject = null;
            String method = String.valueOf(paramToOtherSys.get("SHRmethod"));
            paramToOtherSys.remove("SHRmethod");
            if ("post".equalsIgnoreCase(method)) {
                jsonObject = HttpClientUtil.postForm(interfaceName, paramToOtherSys);
            } else {
                if (OtherSysInterfaceType.WRITEBACK.getValue() == interfaceType) {
                    String valueJson = String.valueOf(paramToOtherSys.get("valueJson"));
                    String encodeValJson = UrlEncode.encodeUrl((String)valueJson);
                    paramToOtherSys.put("valueJson", encodeValJson);
                } else {
                    paramToOtherSys.remove("valueJson");
                }
                jsonObject = HttpClientUtil.get(interfaceName, paramToOtherSys);
            }
            String status = String.valueOf(jsonObject.get("status"));
            returnValue = jsonObject.get("result");
            if (!"200".equals(status)) {
                throw new EASBizException(new NumericExceptionSubItem("003", "\u65e0\u8fd4\u56de\u503c\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u6216\u63a5\u53e3"));
            }
            String retValueStr = String.valueOf(returnValue);
            if (retValueStr.contains("<!DOCTYPE html>") && retValueStr.contains("login")) {
                throw new EASBizException(new NumericExceptionSubItem("002", "\u63a5\u53e3\u672a\u9274\u6743"));
            }
        }
        if (OtherSysInterfaceOptType.OSF.getValue() == optType) {
            try {
                returnValue = OSFAppUtil.callService((Context)ctx, (String)interfaceName, (Map)paramToOtherSys);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("001", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5"));
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("001", "\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5"));
            }
        }
        return OtherSysInterfaceOptUtils.confirmReturnObjType(returnValue);
    }

    private static String confirmReturnObjType(Object returnValue) {
        if (returnValue instanceof String) {
            return (String)returnValue;
        }
        return JSON.toJSONString((Object)returnValue);
    }
}

