/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.AdminTreeNodeInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.model.ParamValueItem;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.manager.util.HRManagerExUtil;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManagerAdminOrgUnitTreeDataService
extends AbstractJavaDataQueryService {
    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    protected List<Map<String, Object>> getData(Context ctx, JavaAPIParam param) throws EASBizException, BOSException {
        List<AdminTreeNodeInfo> coll;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        ParamValueItem orgType = this.getParamValueItem("orgType", param);
        String permItemId = param.getPermItemId();
        String orgTypeValue = null;
        if (null != orgType && orgType.getValue() instanceof List) {
            List l = (List)orgType.getValue();
            StringBuilder sb = new StringBuilder();
            int total = l.size();
            for (int i = 0; i < total; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Map each = (Map)l.get(i);
                sb.append(each.get("v"));
            }
            orgTypeValue = sb.toString();
        }
        if (null == (coll = this.getAdminResponseUnionAdminLeaderList(ctx, userId, permItemId, orgTypeValue)) || coll.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int total = coll.size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(total);
        for (int i = 0; i < total; ++i) {
            list.add(this.genEachItem(coll.get(i)));
        }
        return list;
    }

    private Map<String, Object> genEachItem(AdminTreeNodeInfo adminTreeNodeInfo) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("id", adminTreeNodeInfo.getId());
        item.put("longNumber", adminTreeNodeInfo.getLongNumber());
        item.put("name", adminTreeNodeInfo.getName());
        item.put("number", adminTreeNodeInfo.getNumber());
        item.put("parentId", adminTreeNodeInfo.getParentId());
        item.put("level", adminTreeNodeInfo.getLevel());
        item.put("hasPermission", adminTreeNodeInfo.isHasPermission());
        return item;
    }

    private List<AdminTreeNodeInfo> getAdminResponseUnionAdminLeaderList(Context ctx, String userId, String permItemId, String orgTypeId) throws BOSException, EASBizException {
        HashSet<String> longNumberSet = new HashSet<String>();
        this.setResponseFlongNumber(ctx, userId, longNumberSet);
        this.setLeaderFlongNumber(ctx, userId, permItemId, longNumberSet);
        return this.getAdminNodesList(ctx, orgTypeId, longNumberSet);
    }

    private List<AdminTreeNodeInfo> getAdminNodesList(Context ctx, String orgTypeId, Set<String> longNumberSet) throws BOSException {
        ArrayList<AdminTreeNodeInfo> children = new ArrayList<AdminTreeNodeInfo>();
        StringBuffer buf = new StringBuffer();
        for (String longNumber : longNumberSet) {
            buf.append("'").append(longNumber).append("',");
        }
        if (buf.length() == 0) {
            return children;
        }
        buf = buf.deleteCharAt(buf.length() - 1);
        StringBuffer finalSql = new StringBuffer("SELECT distinct child.fid id, child.FLongNumber longNumber,  child.FSORTCODE sortCode,");
        finalSql.append(" child.fname_" + ctx.getLocale() + " name,");
        finalSql.append(" child.Fnumber fnumber, child.FparentId parentId, child.Flevel flevel , child.FIsStartSHR isStartSHR ");
        finalSql.append(" from T_ORG_Admin child");
        finalSql.append(" where child.FLongNumber in (");
        finalSql.append(buf.toString());
        finalSql.append(" ) and child.FISSEALUP = 0");
        if (!StringUtils.isEmpty((String)orgTypeId)) {
            finalSql.append(" and child.FLayerTypeID in (" + HRManagerExUtil.strToBufStr(orgTypeId) + ")");
        }
        finalSql.append(" order by child.FSortCode,child.FLongNumber ");
        IRowSet finalSqlRows = DbUtil.executeQuery((Context)ctx, (String)finalSql.toString());
        AdminTreeNodeInfo subNodeInfo = null;
        try {
            while (finalSqlRows.next()) {
                subNodeInfo = new AdminTreeNodeInfo();
                subNodeInfo.setId(finalSqlRows.getString("id"));
                subNodeInfo.setLongNumber(finalSqlRows.getString("longNumber"));
                subNodeInfo.setName(finalSqlRows.getString("name"));
                subNodeInfo.setNumber(finalSqlRows.getString("fnumber"));
                subNodeInfo.setParentId(finalSqlRows.getString("parentId"));
                subNodeInfo.setLevel(finalSqlRows.getInt("flevel"));
                subNodeInfo.setHasPermission(finalSqlRows.getBoolean("isStartSHR"));
                children.add(subNodeInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return children;
    }

    private void setLeaderFlongNumber(Context ctx, String userId, String permItemId, Set<String> longNumberSet) throws BOSException {
        StringBuffer leaderSql = new StringBuffer();
        leaderSql.append("SELECT distinct kadmin.FLongNumber ");
        leaderSql.append(" from T_ORG_Admin kadmin");
        leaderSql.append(" inner join  ( ");
        leaderSql.append(" SELECT tb1.FAdminOrgID forgId from ( ");
        leaderSql.append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId));
        leaderSql.append(" )tb1 ) range on kadmin.fid = range.forgid ");
        IRowSet leaderRows = DbUtil.executeQuery((Context)ctx, (String)leaderSql.toString());
        try {
            while (leaderRows.next()) {
                longNumberSet.add(leaderRows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void setResponseFlongNumber(Context ctx, String userId, Set<String> longNumberSet) throws BOSException {
        StringBuffer responseSql = new StringBuffer("SELECT distinct child.FLongNumber ");
        responseSql.append(" from T_ORG_Admin adcount inner join T_ORG_Admin child");
        responseSql.append(" on ( charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ");
        responseSql.append(" inner join (");
        responseSql.append(HRManagerUtil.getPersonPositionResponseAdminSql(userId));
        responseSql.append(" ) range on child.fid = range.forgid ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)responseSql.toString());
        try {
            while (rows.next()) {
                longNumberSet.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

