/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.subscription.util;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.SHRXTForewarnMessageItemInfo;
import com.kingdee.shr.base.syssetting.cloud.tool.ForewarnMessageAssembleUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonnelForewarnMessageUtil
extends ForewarnMessageAssembleUtil {
    public static final String XT_FW_MESSAGE_FROM = "ForewarnFrom";
    public static final String XT_FW_MESSAGE_TO = "ForewarnTo";
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    Logger l = LoggerFactory.getLogger(PersonnelForewarnMessageUtil.class);

    protected String getResultMapFromKey() {
        return XT_FW_MESSAGE_FROM;
    }

    protected String getResultMapToKey() {
        return XT_FW_MESSAGE_TO;
    }

    protected void assembleJSONObjectInfo(Context ctx, Map<String, Object> forewarnMessageInfo, SHRXTForewarnMessageItemInfo shrxtForewarnMessageItemInfo, JSONArray arr, String text) {
        String number = this.getFirstTitleByNow();
        JSONObject itemObj = new JSONObject();
        if (shrxtForewarnMessageItemInfo.getNumber().equals(number)) {
            itemObj.put((Object)"title", forewarnMessageInfo.get(shrxtForewarnMessageItemInfo.getNumber()));
            itemObj.put((Object)"text", (Object)shrxtForewarnMessageItemInfo.getText());
            itemObj.put((Object)"date", (Object)this.df.format(new Date()));
            itemObj.put((Object)"appid", (Object)shrxtForewarnMessageItemInfo.getAppid());
            itemObj.put((Object)"url", (Object)shrxtForewarnMessageItemInfo.getUrl());
            itemObj.put((Object)"pic", (Object)shrxtForewarnMessageItemInfo.getTitlePic());
            itemObj.put((Object)"name", (Object)shrxtForewarnMessageItemInfo.getName());
            itemObj.put((Object)"zip", (Object)shrxtForewarnMessageItemInfo.getZip());
            arr.add(0, (Object)itemObj);
        } else {
            itemObj.put((Object)"title", forewarnMessageInfo.get(shrxtForewarnMessageItemInfo.getNumber()));
            itemObj.put((Object)"text", (Object)shrxtForewarnMessageItemInfo.getText());
            itemObj.put((Object)"date", (Object)this.df.format(new Date()));
            itemObj.put((Object)"appid", (Object)shrxtForewarnMessageItemInfo.getAppid());
            itemObj.put((Object)"url", (Object)shrxtForewarnMessageItemInfo.getUrl());
            itemObj.put((Object)"pic", (Object)shrxtForewarnMessageItemInfo.getListPic());
            itemObj.put((Object)"name", (Object)shrxtForewarnMessageItemInfo.getName());
            itemObj.put((Object)"zip", (Object)shrxtForewarnMessageItemInfo.getZip());
            arr.add((Object)itemObj);
        }
    }

    private String getFirstTitleByNow() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (cal.get(5) == 1) {
            return "04";
        }
        if (cal.get(7) == 1) {
            return "03";
        }
        return "02";
    }

    public String getNowDay() {
        return this.sdf.format(new Date());
    }

    public String getAfterDay(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, days);
        return this.sdf.format(cal.getTime());
    }
}

