/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.util.DateUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.CnToSpell;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.manager.ManagerExDataFormCollection;
import com.kingdee.shr.manager.ManagerExDataFormFactory;
import com.kingdee.shr.manager.ManagerExDataFormInfo;
import com.kingdee.shr.manager.ManagerExEntryTableNameFactory;
import com.kingdee.shr.manager.ManagerExEntryTableNameInfo;
import com.kingdee.shr.manager.ManagerExException;
import com.kingdee.shr.manager.ManagerExSchemeCollection;
import com.kingdee.shr.manager.ManagerExSchemeEntryCollection;
import com.kingdee.shr.manager.ManagerExSchemeEntryFactory;
import com.kingdee.shr.manager.ManagerExSchemeEntryInfo;
import com.kingdee.shr.manager.ManagerExSchemeFactory;
import com.kingdee.shr.manager.ManagerExSchemeInfo;
import com.kingdee.shr.manager.util.HRManagerConstant;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HRManagerExUtil {
    public static void updateDyEntryBillId(Context ctx, String tableName, List<String> entryIdInsertList, String billId) throws BOSException {
        if (entryIdInsertList != null && entryIdInsertList.size() > 0) {
            StringBuffer bf = new StringBuffer();
            for (int p = 0; p < entryIdInsertList.size(); ++p) {
                bf.append("'").append(entryIdInsertList.get(p)).append("'").append(",");
            }
            bf = bf.deleteCharAt(bf.length() - 1);
            String updateEntryBillIdSql = " update " + tableName + " set billId='" + billId + "' where fid in (" + bf.toString() + ")";
            DbUtil.execute((Context)ctx, (String)updateEntryBillIdSql);
        }
    }

    public static String createDyEntryTable(Context ctx, List<Map<String, Object>> rowsList, String tableName) throws BOSException, EASBizException {
        StringBuffer columnBf = new StringBuffer();
        for (int i = 0; i < rowsList.size(); ++i) {
            Map<String, Object> rowMap = rowsList.get(i);
            String property = (String)rowMap.get("property");
            property = HRManagerExUtil.removeHashFlag(property);
            Integer dataType = (Integer)rowMap.get("dataType");
            Integer dataLength = (Integer)rowMap.get("dataLength");
            Integer dataDot = (Integer)rowMap.get("dataDot");
            String columnDef = HRManagerExUtil.getColumnDefinition(property, dataType, dataLength, dataDot);
            columnBf.append(columnDef).append(",");
        }
        String createEntryTableSql = HRManagerExUtil.createEntryTableSql(columnBf, tableName);
        DbUtil.execute((Context)ctx, (String)createEntryTableSql);
        if (!ManagerExEntryTableNameFactory.getLocalInstance(ctx).exists("select id where entryTableName='" + tableName + "'")) {
            ManagerExEntryTableNameInfo tableNameInfo = new ManagerExEntryTableNameInfo();
            tableNameInfo.setEntryTableName(tableName);
            ManagerExEntryTableNameFactory.getLocalInstance(ctx).save((CoreBaseInfo)tableNameInfo);
        }
        return tableName;
    }

    public static String removeHashFlag(String property) {
        if (property.indexOf(HRManagerConstant._dshash) > -1) {
            property = property.substring(0, property.indexOf(HRManagerConstant._dshash));
        }
        if (property.indexOf(HRManagerConstant._nxhash) > -1) {
            property = property.substring(0, property.indexOf(HRManagerConstant._nxhash));
        }
        return property;
    }

    public static String createEntryTableSql(StringBuffer columnBf, String tableName) {
        StringBuffer createTableBF = new StringBuffer();
        createTableBF.append("If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tableName + "')").append("Create Table " + tableName).append("( ").append("FID VARCHAR(44) DEFAULT '' NOT NULL,").append("billId VARCHAR(44),").append(columnBf).append("dshashgroup INT,").append("FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,").append("CONSTRAINT PK_HR_MG" + DateUtils.getCustomDateString((java.util.Date)new java.util.Date(), (String)"yyyyMMddHHmmss") + " PRIMARY KEY (FID)").append(" )");
        return createTableBF.toString();
    }

    public static List<String> returnEntryIdInsertList(List<Object[]> paramsInsertList) {
        ArrayList<String> entryIdInsertList = new ArrayList<String>();
        for (int km = 0; km < paramsInsertList.size(); ++km) {
            Object[] paramArr = paramsInsertList.get(km);
            String entryIdInsert = (String)paramArr[0];
            entryIdInsertList.add(entryIdInsert);
        }
        return entryIdInsertList;
    }

    public static void dyEntryTableInsertData(Context ctx, String tableName, List<Object[]> paramsInsertList, String[] paramMarkArr) throws BOSException {
        if (paramsInsertList.size() > 0) {
            java.util.Date date = new java.util.Date();
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            StringBuffer insertDyDataSql = new StringBuffer();
            insertDyDataSql.append("insert into ").append(tableName).append("(").append("fid,").append(paramMarkArr[1]).append("dshashgroup,").append("FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime)").append(" values (").append("?,").append(paramMarkArr[0]).append("?,").append("'").append(userId).append("',").append(HRManagerExUtil.toKSqlDate(date)).append(",").append("'").append(userId).append("',").append(HRManagerExUtil.toKSqlDate(date)).append(")");
            DbUtil.executeBatch((Context)ctx, (String)insertDyDataSql.toString(), paramsInsertList);
        }
    }

    public static void dyEntryTableUpdateData(Context ctx, String tableName, List<Object[]> paramsUpdateList, String[] paramMarkArr) throws BOSException {
        if (paramsUpdateList.size() > 0) {
            java.util.Date date = new java.util.Date();
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            StringBuffer updateDyDataSql = new StringBuffer();
            updateDyDataSql.append("update ").append(tableName).append(" set ").append(paramMarkArr[2]).append("FLastUpdateUserID=").append("'").append(userId).append("',").append("FLastUpdateTime=").append(HRManagerExUtil.toKSqlDate(date)).append(" where fid=?");
            DbUtil.executeBatch((Context)ctx, (String)updateDyDataSql.toString(), paramsUpdateList);
        }
    }

    public static String[] setMarks(List<String> dyColumnsKeyList) {
        String[] paramMarkArr = new String[3];
        String insertMarks = "";
        StringBuffer insertMarksPropertys = new StringBuffer();
        StringBuffer updateMarksPropertys = new StringBuffer();
        for (int c = 0; c < dyColumnsKeyList.size(); ++c) {
            insertMarks = insertMarks + "?,";
            insertMarksPropertys.append(dyColumnsKeyList.get(c)).append(",");
            updateMarksPropertys.append(dyColumnsKeyList.get(c)).append("=?,");
        }
        updateMarksPropertys.append("dshashgroup").append("=?,");
        paramMarkArr[0] = insertMarks;
        paramMarkArr[1] = insertMarksPropertys.toString();
        paramMarkArr[2] = updateMarksPropertys.toString();
        return paramMarkArr;
    }

    public static List<Object[]> paramsInsertList(List<String> dyColumnsKeyList, List<String> dyColumnsKeyHasHashList, List<LinkedHashMap<String, Object>> dyColumnsKeyValueMapInsertList) {
        ArrayList<Object[]> paramsInsertList = new ArrayList<Object[]>();
        Object[] paramsInsertArr = null;
        for (int c = 0; c < dyColumnsKeyValueMapInsertList.size(); ++c) {
            LinkedHashMap<String, Object> dyColumnsKeyValueMapInsert = dyColumnsKeyValueMapInsertList.get(c);
            int m = 1;
            paramsInsertArr = new Object[dyColumnsKeyList.size() + 2];
            String id = BOSUuid.create((String)"6BD30471").toString();
            paramsInsertArr[0] = id;
            for (String key : dyColumnsKeyValueMapInsert.keySet()) {
                paramsInsertArr[m] = dyColumnsKeyValueMapInsert.get(key);
                ++m;
            }
            int dsHashGroup = HRManagerExUtil.getDsHashGroup(dyColumnsKeyHasHashList, dyColumnsKeyValueMapInsert);
            paramsInsertArr[dyColumnsKeyList.size() + 1] = dsHashGroup;
            paramsInsertList.add(paramsInsertArr);
        }
        return paramsInsertList;
    }

    public static List<Object[]> paramUpdateList(List<String> dyColumnsKeyList, List<String> dyColumnsKeyHasHashList, List<LinkedHashMap<String, Object>> dyColumnsKeyValueMapUpdateList, List<String> entryIdUpdateList) {
        ArrayList<Object[]> paramsUpdateList = new ArrayList<Object[]>();
        Object[] paramsUpdateArr = null;
        for (int c = 0; c < dyColumnsKeyValueMapUpdateList.size(); ++c) {
            LinkedHashMap<String, Object> dyColumnsKeyValueMapUpdate = dyColumnsKeyValueMapUpdateList.get(c);
            int m = 0;
            paramsUpdateArr = new Object[dyColumnsKeyList.size() + 2];
            for (String key : dyColumnsKeyValueMapUpdate.keySet()) {
                paramsUpdateArr[m] = dyColumnsKeyValueMapUpdate.get(key);
                ++m;
            }
            int dsHashGroup = HRManagerExUtil.getDsHashGroup(dyColumnsKeyHasHashList, dyColumnsKeyValueMapUpdate);
            paramsUpdateArr[m] = dsHashGroup;
            paramsUpdateArr[dyColumnsKeyList.size() + 1] = entryIdUpdateList.get(c);
            paramsUpdateList.add(paramsUpdateArr);
        }
        return paramsUpdateList;
    }

    private static int getDsHashGroup(List<String> dyColumnsKeyHasHashList, LinkedHashMap<String, Object> dyColumnsKeyValueMapInsert) {
        StringBuffer dsgroupValuebf = new StringBuffer();
        for (int h = 0; h < dyColumnsKeyHasHashList.size(); ++h) {
            String removeHashFlagProperty;
            Object propertyValue;
            String hasHashFlagproperty = dyColumnsKeyHasHashList.get(h);
            if (hasHashFlagproperty.indexOf(HRManagerConstant._dshash) <= -1 || (propertyValue = dyColumnsKeyValueMapInsert.get(removeHashFlagProperty = HRManagerExUtil.removeHashFlag(hasHashFlagproperty))) == null || "".equals(propertyValue)) continue;
            dsgroupValuebf.append(propertyValue).append(",");
        }
        if (dsgroupValuebf.length() > 0) {
            dsgroupValuebf = dsgroupValuebf.deleteCharAt(dsgroupValuebf.length() - 1);
        }
        int dsHashGroup = HRManagerExUtil.BKDRHash(dsgroupValuebf.toString());
        return dsHashGroup;
    }

    public static Date toSqlDate(Object strDate) {
        java.util.Date date = HRManagerExUtil.toDate(strDate);
        Date sqlDate = null;
        if (date != null) {
            sqlDate = new Date(date.getTime());
        }
        return sqlDate;
    }

    public static java.util.Date toDate(Object obj) {
        SimpleDateFormat sdf;
        java.util.Date res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if (str.indexOf("{ts'") != -1 && str.lastIndexOf("'}") != -1) {
            str = str.substring(str.indexOf("ts{'") + 5, str.lastIndexOf("'}"));
        }
        if (!(str.matches("\\d{4}[-|/|.]{1}\\d{1,2}[-|/|.]{1}\\d{1,2}(.*)") || str.matches("(.*)\\d{1,2}:\\d{1,2}:\\d{1,2}(.*)") || obj instanceof java.util.Date)) {
            return null;
        }
        String[] formatArr = new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy/MM/dd", "yyyy/M/d", "yyyy.MM.dd", "yyyy.M.d", "EEE MMM d H:m:s z y"};
        for (int i = 0; i < formatArr.length; ++i) {
            sdf = new SimpleDateFormat(formatArr[i]);
            try {
                res = sdf.parse(str);
                break;
            }
            catch (ParseException e) {
                continue;
            }
        }
        if (null == res) {
            sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyy", Locale.US);
            try {
                res = sdf.parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return res;
    }

    public static String[] getSpecialProperty() {
        String[] specialProperty = new String[]{"adminNumber", "adminOrg", "adminType", "startDate", "endDate"};
        return specialProperty;
    }

    public static String toKSqlDate(java.util.Date date) {
        String res = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            res = "{ts '" + sdf.format(date) + "'}";
        }
        catch (Exception e5) {
            return null;
        }
        return res;
    }

    public static int getCount(IRowSet rowSet) throws BOSException {
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                totalCount = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return totalCount;
    }

    public static String getTableName() {
        java.util.Date date = new java.util.Date();
        String dateStr = DateUtils.getCustomDateString((java.util.Date)date, (String)"yyyyMMddHHmmss");
        String tableName = "T_MGR_ManagerEx" + dateStr;
        return tableName;
    }

    public static ManagerExDataFormInfo getManagerExDataFormInfo(Context ctx, String billId) throws BOSException {
        ManagerExDataFormInfo info = new ManagerExDataFormInfo();
        ManagerExDataFormCollection coll = ManagerExDataFormFactory.getLocalInstance(ctx).getManagerExDataFormCollection(" where id='" + billId + "'");
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static ManagerExSchemeInfo getManagerExSchemeInfo(Context ctx, String billId) throws BOSException {
        ManagerExSchemeInfo info = new ManagerExSchemeInfo();
        ManagerExSchemeCollection coll = ManagerExSchemeFactory.getLocalInstance(ctx).getManagerExSchemeCollection(" where id='" + billId + "'");
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static String strToBufStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] strArr = str.split(",");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strArr.length; ++i) {
            buf.append("'").append(strArr[i]).append("',");
        }
        if (buf.length() > 0) {
            buf = buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static void assembleItemID(Map<String, Object> gridItemMap, Map<String, Object> rowMap) throws SQLException {
        Integer dataType = (Integer)rowMap.get("dataType");
        if (0 == dataType) {
            HRManagerExUtil.assembleNumberItemID(gridItemMap, rowMap);
        } else if (1 == dataType) {
            HRManagerExUtil.assembleStringItemID(gridItemMap, rowMap);
        } else if (2 == dataType) {
            HRManagerExUtil.assembleDateItemID(gridItemMap, rowMap);
        } else if (3 == dataType) {
            HRManagerExUtil.assembleColModelF7(gridItemMap, rowMap);
        }
    }

    public static String getColumnDefinition(String property, int dataType, int dataLength, int dataDot) {
        if (0 == dataType) {
            return property + " NUMERIC(" + dataLength + "," + dataDot + ")";
        }
        if (1 == dataType) {
            return property + " VARCHAR(" + dataLength + ")";
        }
        if (2 == dataType) {
            return property + " DateTime";
        }
        if (3 == dataType) {
            return property + " VARCHAR(44)";
        }
        return "";
    }

    public static Map<String, IRowSet> getManagerExItemRowSet(Context ctx, String schemeId) throws BOSException, EASBizException {
        HashMap<String, IRowSet> rowSetMap = new HashMap<String, IRowSet>();
        ManagerExSchemeEntryCollection entryColl = ManagerExSchemeEntryFactory.getLocalInstance(ctx).getManagerExSchemeEntryCollection("select ds ,nx where scheme='" + schemeId + "'");
        if (entryColl != null && entryColl.size() > 0) {
            ManagerExSchemeEntryInfo entryInfo = entryColl.get(0);
            IRowSet rowSetDs = HRManagerExUtil.rowSetDs(ctx, entryInfo);
            IRowSet rowSetNx = HRManagerExUtil.rowSetNx(ctx, entryInfo);
            rowSetMap.put("rowSetDs", rowSetDs);
            rowSetMap.put("rowSetNx", rowSetNx);
        }
        return rowSetMap;
    }

    public static IRowSet rowSetNx(Context ctx, ManagerExSchemeEntryInfo entryInfo) throws EASBizException, BOSException {
        String nxStr = entryInfo.getNx();
        if (StringUtils.isEmpty((String)nxStr)) {
            throw new ManagerExException(ManagerExException.EXCEPTION1);
        }
        nxStr = HRManagerExUtil.strToBufStr(nxStr);
        String nxSql = "select item.fid as id,item.fname_" + HRManagerUtil.getLocal(ctx) + " as name ,item.FDataType as dataType,item.FDataLength as dataLength, item.FDataDot as dataDot,item.FDateType as dateType,item.FProperty as property,item.FUnit_" + HRManagerUtil.getLocal(ctx) + " as unit, b.fname_" + HRManagerUtil.getLocal(ctx) + " as F7Name,b.FUIPK FMAINTAINUIPK,b.FISBASIC as FISBASIC from T_MGR_ManagerExNXItem item  left join  T_MGR_ManagerExItemForF7 b on item.FFilterField = b.fid where item.fid in (" + nxStr + ")";
        IRowSet rowSetNx = DbUtil.executeQuery((Context)ctx, (String)nxSql);
        return rowSetNx;
    }

    public static IRowSet rowSetDs(Context ctx, ManagerExSchemeEntryInfo entryInfo) throws EASBizException, BOSException {
        String dsStr = entryInfo.getDs();
        if (StringUtils.isEmpty((String)dsStr)) {
            throw new ManagerExException(ManagerExException.EXCEPTION0);
        }
        dsStr = HRManagerExUtil.strToBufStr(dsStr);
        String dsSql = "select item.fid as id,item.fname_" + HRManagerUtil.getLocal(ctx) + " as name ,item.FDataType as dataType,item.FDataLength as dataLength, item.FDataDot as dataDot,item.FDateType as dateType,item.FProperty as property,item.FUnit_" + HRManagerUtil.getLocal(ctx) + " as unit, b.fname_" + HRManagerUtil.getLocal(ctx) + " as F7Name,b.FUIPK FMAINTAINUIPK,b.FISBASIC as FISBASIC from T_MGR_ManagerExDSItem item  left join  T_MGR_ManagerExItemForF7 b on item.FFilterField = b.fid where item.fid in (" + dsStr + ")";
        IRowSet rowSetDs = DbUtil.executeQuery((Context)ctx, (String)dsSql);
        return rowSetDs;
    }

    public static Map<String, Object> assembleColModelId(Map<String, Object> gridIdMap) {
        gridIdMap.put("name", "id");
        gridIdMap.put("label", "id");
        gridIdMap.put("frozen", false);
        gridIdMap.put("width", 90);
        gridIdMap.put("align", "left");
        gridIdMap.put("key", true);
        gridIdMap.put("hidden", true);
        gridIdMap.put("editable", false);
        gridIdMap.put("sorttype", "");
        gridIdMap.put("sortable", false);
        gridIdMap.put("classes", "disabled");
        return gridIdMap;
    }

    public static Map<String, Object> assembleNumberItemID(Map<String, Object> gridItemMap, Map<String, Object> rowMap) throws SQLException {
        String property = (String)rowMap.get("property");
        String name = (String)rowMap.get("name");
        gridItemMap.put("name", property);
        gridItemMap.put("label", name);
        gridItemMap.put("frozen", false);
        gridItemMap.put("width", 200);
        gridItemMap.put("align", "left");
        gridItemMap.put("key", false);
        gridItemMap.put("editable", true);
        gridItemMap.put("sorttype", "bigdecimal");
        gridItemMap.put("sortable", false);
        gridItemMap.put("formatter", "numberfield");
        gridItemMap.put("edittype", "numberfield");
        JSONObject editoptions = JSONObject.parseObject((String)"{ \"inputJson\": { \"id\": \"\", \"name\": \"\", \"formatType\": \"number\" }, \"validateJson\": {}}");
        JSONObject inputJson = editoptions.getJSONObject("inputJson");
        Integer dataDot = (Integer)rowMap.get("dataDot");
        Integer dataLength = (Integer)rowMap.get("dataLength");
        inputJson.put("decimalPrecision", (Object)dataDot);
        inputJson.put("maxlength", (Object)dataLength);
        JSONObject validateJson = editoptions.getJSONObject("validateJson");
        validateJson.put("errMsg", (Object)"");
        validateJson.put("validatetrigger", (Object)"focus keyup datachange");
        gridItemMap.put("editoptions", editoptions);
        return gridItemMap;
    }

    public static Map<String, Object> assembleStringItemID(Map<String, Object> gridItemMap, Map<String, Object> rowMap) throws SQLException {
        String property = (String)rowMap.get("property");
        String name = (String)rowMap.get("name");
        gridItemMap.put("name", property);
        gridItemMap.put("label", name);
        gridItemMap.put("frozen", false);
        gridItemMap.put("width", 200);
        gridItemMap.put("align", "left");
        gridItemMap.put("key", false);
        gridItemMap.put("editable", true);
        gridItemMap.put("sorttype", "string");
        gridItemMap.put("sortable", false);
        if (HRManagerExUtil.getSpecialProperty()[0].equals(property) || HRManagerExUtil.getSpecialProperty()[2].equals(property)) {
            gridItemMap.put("editable", false);
            gridItemMap.put("classes", "disabled");
        }
        JSONObject editoptions = JSONObject.parseObject((String)"{ \"inputJson\": {}}");
        JSONObject inputJson = editoptions.getJSONObject("inputJson");
        Integer dataDot = (Integer)rowMap.get("dataDot");
        Integer dataLength = (Integer)rowMap.get("dataLength");
        inputJson.put("decimalPrecision", (Object)dataDot);
        inputJson.put("maxlength", (Object)dataLength);
        gridItemMap.put("editoptions", editoptions);
        gridItemMap.put("edittype", "shrtext");
        return gridItemMap;
    }

    public static Map<String, Object> assembleDateItemID(Map<String, Object> gridItemMap, Map<String, Object> rowMap) throws SQLException {
        String property = (String)rowMap.get("property");
        String name = (String)rowMap.get("name");
        Integer dateType = (Integer)rowMap.get("dateType");
        gridItemMap.put("name", property);
        gridItemMap.put("label", name);
        gridItemMap.put("frozen", false);
        gridItemMap.put("width", 200);
        gridItemMap.put("align", "left");
        gridItemMap.put("key", true);
        gridItemMap.put("hidden", false);
        gridItemMap.put("editable", true);
        gridItemMap.put("sorttype", "date");
        gridItemMap.put("sortable", false);
        gridItemMap.put("formatter", "shrDateTimePicker");
        gridItemMap.put("edittype", "shrDateTimePicker");
        StringBuffer datapickerjsonBuffer = new StringBuffer();
        datapickerjsonBuffer.append("{");
        datapickerjsonBuffer.append("\"datepickerjson\":");
        datapickerjsonBuffer.append("{");
        datapickerjsonBuffer.append("\"id\":\"dp_autoSize\",");
        datapickerjsonBuffer.append("\"name\":\"dp_autoSize\",");
        datapickerjsonBuffer.append("\"minuteStep\":\"\",");
        datapickerjsonBuffer.append("\"showTimeZoneForCtrl\":false,");
        datapickerjsonBuffer.append("\"isAutoTimeZoneTrans\":false,");
        datapickerjsonBuffer.append("\"isShowUTC\":false,");
        datapickerjsonBuffer.append("\"isReadonlyUTC\":true,");
        datapickerjsonBuffer.append("\"isRemoveSeconds\":true,");
        if (2 == dateType) {
            datapickerjsonBuffer.append("\"isRemoveDay\":true,");
        } else if (1 == dateType) {
            datapickerjsonBuffer.append("\"isRemoveDay\":false,");
        } else {
            datapickerjsonBuffer.append("\"isRemoveDay\":false,");
        }
        datapickerjsonBuffer.append("\"ctrlType\":\"Date\"");
        datapickerjsonBuffer.append("},");
        datapickerjsonBuffer.append("\"validateJson\":");
        datapickerjsonBuffer.append("{");
        datapickerjsonBuffer.append("\"errMsg\":\"\",");
        datapickerjsonBuffer.append("\"validatetrigger\":\"focus keyup datachange\"");
        datapickerjsonBuffer.append("}");
        datapickerjsonBuffer.append("}");
        gridItemMap.put("editoptions", JSONObject.parseObject((String)datapickerjsonBuffer.toString()));
        return gridItemMap;
    }

    public static Map<String, Object> assembleColModelF7(Map<String, Object> gridItemMap, Map<String, Object> rowMap) {
        String property = (String)rowMap.get("property");
        String name = (String)rowMap.get("name");
        String F7Name = (String)rowMap.get("F7Name");
        String fmaintainuipk = (String)rowMap.get("fmaintainuipk");
        Integer fisbasic = (Integer)rowMap.get("fisbasic");
        gridItemMap.put("name", property);
        gridItemMap.put("label", name);
        gridItemMap.put("frozen", false);
        gridItemMap.put("width", 200);
        gridItemMap.put("align", "left");
        gridItemMap.put("key", false);
        gridItemMap.put("edittype", "promptBox");
        gridItemMap.put("editable", true);
        gridItemMap.put("sorttype", "objectvalue");
        gridItemMap.put("sortable", false);
        gridItemMap.put("formatter", "promptBox");
        gridItemMap.put("editoptions", HRManagerExUtil.assembleColModelF7(F7Name, fmaintainuipk, fisbasic == 1 ? "state = 1" : "", property));
        return gridItemMap;
    }

    public static Map<String, Object> assembleColModelF7(String name, String uipk, String filter, String property) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> f7JsonMap = new HashMap<String, Object>();
        HashMap<String, String> validateJsonMap = new HashMap<String, String>();
        HashMap<String, Object> uipkMap = new HashMap<String, Object>();
        uipkMap.put("title", name);
        uipkMap.put("uipk", uipk);
        uipkMap.put("query", "");
        uipkMap.put("filter", filter);
        uipkMap.put("multiselect", false);
        uipkMap.put("isTree", false);
        uipkMap.put("treeUrl", "");
        uipkMap.put("isContainLowerOrg", false);
        uipkMap.put("isAdminOrg", false);
        f7JsonMap.put("subWidgetOptions", uipkMap);
        f7JsonMap.put("subWidgetName", "shrPromptGrid");
        f7JsonMap.put("searchFields", "");
        f7JsonMap.put("isHROrg", false);
        f7JsonMap.put("isAdminOrg", false);
        f7JsonMap.put("searchLikePattern", "any");
        resultMap.put("f7Json", f7JsonMap);
        validateJsonMap.put("errMsg", "");
        if (HRManagerExUtil.getSpecialProperty()[1].equals(property)) {
            validateJsonMap.put("rules", "required:true");
        }
        validateJsonMap.put("validatetrigger", "focus keyup datachange");
        resultMap.put("validateJson", validateJsonMap);
        return resultMap;
    }

    public static List<Map<String, Object>> getItemRowsList(Context ctx, String schemeId) throws BOSException, EASBizException {
        Map<String, IRowSet> rowSetMap = HRManagerExUtil.getManagerExItemRowSet(ctx, schemeId);
        IRowSet rowSetDs = rowSetMap.get("rowSetDs");
        IRowSet rowSetNx = rowSetMap.get("rowSetNx");
        List<Map<String, Object>> rowsList = HRManagerExUtil.tranferRowsList(ctx, rowSetDs, rowSetNx, false);
        return rowsList;
    }

    public static List<Map<String, Object>> getItemRowsListHasHashFlag(Context ctx, String schemeId) throws BOSException, EASBizException {
        Map<String, IRowSet> rowSetMap = HRManagerExUtil.getManagerExItemRowSet(ctx, schemeId);
        IRowSet rowSetDs = rowSetMap.get("rowSetDs");
        IRowSet rowSetNx = rowSetMap.get("rowSetNx");
        List<Map<String, Object>> rowsList = HRManagerExUtil.tranferRowsList(ctx, rowSetDs, rowSetNx, true);
        return rowsList;
    }

    private static List<Map<String, Object>> tranferRowsList(Context ctx, IRowSet rowSetDs, IRowSet rowSetNx, boolean isHashFlag) throws BOSException {
        ArrayList<Map<String, Object>> rowsList = new ArrayList<Map<String, Object>>();
        try {
            HRManagerExUtil.tranferDsRowsList(ctx, rowSetDs, rowsList, isHashFlag);
            HRManagerExUtil.tranferNxRowsList(rowSetNx, rowsList, isHashFlag);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return rowsList;
    }

    private static void tranferNxRowsList(IRowSet rowSetNx, List<Map<String, Object>> rowsList, boolean isHashFlag) throws SQLException {
        while (rowSetNx.next()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            String id = rowSetNx.getString("id");
            String name = rowSetNx.getString("name");
            String property = "";
            property = isHashFlag ? rowSetNx.getString("property") + HRManagerConstant._nxhash : rowSetNx.getString("property");
            int dataType = rowSetNx.getInt("dataType");
            int dataLength = rowSetNx.getInt("dataLength");
            int dateType = rowSetNx.getInt("dateType");
            int dataDot = rowSetNx.getInt("dataDot");
            String unit = rowSetNx.getString("unit");
            String F7Name = rowSetNx.getString("F7Name");
            String fmaintainuipk = rowSetNx.getString("fmaintainuipk");
            int fisbasic = rowSetNx.getInt("fisbasic");
            rowMap.put("id", id);
            rowMap.put("name", name);
            rowMap.put("property", property);
            rowMap.put("dataType", dataType);
            rowMap.put("dataLength", dataLength);
            rowMap.put("dateType", dateType);
            rowMap.put("dataDot", dataDot);
            rowMap.put("unit", unit);
            rowMap.put("F7Name", F7Name);
            rowMap.put("fmaintainuipk", fmaintainuipk);
            rowMap.put("fisbasic", fisbasic);
            rowsList.add(rowMap);
        }
    }

    public static void tranferDsRowsList(Context ctx, IRowSet rowSetDs, List<Map<String, Object>> rowsList, boolean isHashFlag) throws SQLException {
        while (rowSetDs.next()) {
            String id = rowSetDs.getString("id");
            String name = rowSetDs.getString("name");
            if ("xM8LhoucT6K2y23By/YFnSvt/dU=".equals(id)) {
                HRManagerExUtil.specialAdminPropertyHandler(ctx, rowSetDs, rowsList, isHashFlag);
                continue;
            }
            if ("u6PymlmkQpeftTP1tIWn9Cvt/dU=".equals(id)) {
                HRManagerExUtil.specialPeriodPropertyHandler(ctx, rowSetDs, rowsList, isHashFlag);
                continue;
            }
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            String property = "";
            property = isHashFlag ? rowSetDs.getString("property") + HRManagerConstant._dshash : rowSetDs.getString("property");
            int dataType = rowSetDs.getInt("dataType");
            int dataLength = rowSetDs.getInt("dataLength");
            int dateType = rowSetDs.getInt("dateType");
            int dataDot = rowSetDs.getInt("dataDot");
            String unit = rowSetDs.getString("unit");
            String F7Name = rowSetDs.getString("F7Name");
            String fmaintainuipk = rowSetDs.getString("fmaintainuipk");
            int fisbasic = rowSetDs.getInt("fisbasic");
            rowMap.put("id", id);
            rowMap.put("name", name);
            rowMap.put("property", property);
            rowMap.put("dataType", dataType);
            rowMap.put("dataLength", dataLength);
            rowMap.put("dataDot", dataDot);
            rowMap.put("unit", unit);
            rowMap.put("dateType", dateType);
            rowMap.put("F7Name", F7Name);
            rowMap.put("fmaintainuipk", fmaintainuipk);
            rowMap.put("fisbasic", fisbasic);
            rowsList.add(rowMap);
        }
    }

    private static void specialPeriodPropertyHandler(Context ctx, IRowSet rowSetDs, List<Map<String, Object>> rowsList, boolean isHashFlag) throws SQLException {
        String id = rowSetDs.getString("id");
        String property = "";
        property = isHashFlag ? rowSetDs.getString("property") + HRManagerConstant._dshash : rowSetDs.getString("property");
        HashMap<String, Object> rowMap1 = new HashMap<String, Object>();
        HashMap<String, Object> rowMap2 = new HashMap<String, Object>();
        HashMap<String, Object> rowMap3 = new HashMap<String, Object>();
        rowMap1.put("id", id);
        rowMap1.put("name", rowSetDs.getString("name"));
        rowMap1.put("property", property);
        rowMap1.put("dataType", 1);
        rowMap1.put("dataLength", 100);
        rowMap1.put("dataDot", 0);
        rowMap2.put("id", "");
        rowMap2.put("name", SHRServerResource.getString((String)"com.kingdee.shr.manager.app.ManagerExResource", (String)"label3", (Context)ctx));
        String property2 = "";
        property2 = isHashFlag ? HRManagerExUtil.getSpecialProperty()[3] + HRManagerConstant._dshash : HRManagerExUtil.getSpecialProperty()[3];
        rowMap2.put("property", property2);
        rowMap2.put("dataType", 2);
        rowMap2.put("dataLength", 100);
        rowMap2.put("dataDot", 0);
        rowMap2.put("dateType", 1);
        rowMap3.put("id", "");
        rowMap3.put("name", SHRServerResource.getString((String)"com.kingdee.shr.manager.app.ManagerExResource", (String)"label4", (Context)ctx));
        String property3 = "";
        property3 = isHashFlag ? HRManagerExUtil.getSpecialProperty()[4] + HRManagerConstant._dshash : HRManagerExUtil.getSpecialProperty()[4];
        rowMap3.put("property", property3);
        rowMap3.put("dataType", 2);
        rowMap3.put("dataLength", 100);
        rowMap3.put("dataDot", 0);
        rowMap3.put("dateType", 1);
        rowsList.add(rowMap1);
        rowsList.add(rowMap2);
        rowsList.add(rowMap3);
    }

    private static void specialAdminPropertyHandler(Context ctx, IRowSet rowSetDs, List<Map<String, Object>> rowsList, boolean isHashFlag) throws SQLException {
        HashMap<String, Object> rowMap1 = new HashMap<String, Object>();
        HashMap<String, Object> rowMap2 = new HashMap<String, Object>();
        HashMap<String, Object> rowMap3 = new HashMap<String, Object>();
        rowMap1.put("id", "");
        rowMap1.put("name", SHRServerResource.getString((String)"com.kingdee.shr.manager.app.ManagerExResource", (String)"label0", (Context)ctx));
        rowMap1.put("property", HRManagerExUtil.getSpecialProperty()[0]);
        rowMap1.put("dataType", 1);
        rowMap1.put("dataLength", 100);
        rowMap1.put("dataDot", 0);
        rowMap1.put("unit", "");
        rowMap1.put("dateType", 1);
        rowMap1.put("F7Name", "");
        rowMap1.put("fmaintainuipk", "");
        rowMap1.put("fisbasic", 0);
        rowMap2.put("id", "");
        rowMap2.put("name", SHRServerResource.getString((String)"com.kingdee.shr.manager.app.ManagerExResource", (String)"label1", (Context)ctx));
        String property2 = "";
        property2 = isHashFlag ? HRManagerExUtil.getSpecialProperty()[1] + HRManagerConstant._dshash : HRManagerExUtil.getSpecialProperty()[1];
        rowMap2.put("property", property2);
        rowMap2.put("dataType", 3);
        rowMap2.put("dataLength", 44);
        rowMap2.put("dataDot", 0);
        rowMap2.put("unit", "");
        rowMap2.put("dateType", 1);
        rowMap2.put("F7Name", SHRServerResource.getString((String)"com.kingdee.shr.manager.app.ManagerExResource", (String)"label1", (Context)ctx));
        rowMap2.put("fmaintainuipk", "com.kingdee.eas.basedata.org.app.AdminOrgUnit.managerex.F7");
        rowMap2.put("fisbasic", 0);
        rowMap3.put("id", "");
        rowMap3.put("name", SHRServerResource.getString((String)"com.kingdee.shr.manager.app.ManagerExResource", (String)"label2", (Context)ctx));
        rowMap3.put("property", HRManagerExUtil.getSpecialProperty()[2]);
        rowMap3.put("dataType", 1);
        rowMap3.put("dataLength", 44);
        rowMap3.put("dataDot", 0);
        rowMap3.put("unit", "");
        rowMap3.put("dateType", 1);
        rowMap3.put("F7Name", "");
        rowMap3.put("fmaintainuipk", "");
        rowMap3.put("fisbasic", 0);
        rowsList.add(rowMap1);
        rowsList.add(rowMap2);
        rowsList.add(rowMap3);
    }

    public static List<Map<String, String>> getF7Property(Context ctx, String schemeId) throws BOSException, SQLException {
        ArrayList<Map<String, String>> F7PropertyList = new ArrayList<Map<String, String>>();
        ManagerExSchemeEntryCollection entryColl = ManagerExSchemeEntryFactory.getLocalInstance(ctx).getManagerExSchemeEntryCollection("select ds,nx where scheme='" + schemeId + "'");
        if (entryColl != null && entryColl.size() > 0) {
            ManagerExSchemeEntryInfo entryInfo = entryColl.get(0);
            String dsStr = entryInfo.getDs();
            String nxStr = entryInfo.getNx();
            dsStr = HRManagerExUtil.strToBufStr(dsStr);
            nxStr = HRManagerExUtil.strToBufStr(nxStr);
            String nxSql = "select item.FProperty as property, b.ftable as btable ,b.FEntity as bentity,b.FUipk as buipk  from T_MGR_ManagerExDSItem item  left join  T_MGR_ManagerExItemForF7 b on item.FFilterField = b.fid where item.fid in (" + dsStr + ") and  item.FDataType = 3 union  select item.FProperty as property, b.ftable as btable ,b.FEntity as bentity,b.FUipk as buipk  from T_MGR_ManagerExNXItem item  left join  T_MGR_ManagerExItemForF7 b on item.FFilterField = b.fid where item.fid in (" + nxStr + ") and  item.FDataType = 3";
            IRowSet rowSetN = DbUtil.executeQuery((Context)ctx, (String)nxSql);
            HashMap<String, String> F7 = null;
            while (rowSetN.next()) {
                F7 = new HashMap<String, String>();
                String property = rowSetN.getString("property");
                String btable = rowSetN.getString("btable");
                String bentity = rowSetN.getString("bentity");
                String buipk = rowSetN.getString("buipk");
                F7.put("property", property);
                F7.put("btable", btable);
                F7.put("bentity", bentity);
                F7.put("buipk", buipk);
                F7PropertyList.add(F7);
            }
            if (dsStr.indexOf("xM8LhoucT6K2y23By/YFnSvt/dU=") != -1) {
                F7 = new HashMap();
                F7.put("property", HRManagerExUtil.getSpecialProperty()[1]);
                F7.put("btable", "T_ORG_Admin");
                F7.put("bentity", "com.kingdee.eas.basedata.org.app.AdminOrgUnit");
                F7.put("buipk", "com.kingdee.eas.basedata.org.app.AdminOrgUnit.managerex.F7");
                F7PropertyList.add(F7);
            }
        }
        return F7PropertyList;
    }

    public static String transferSpell(String name, int index) {
        if (name == null) {
            return "";
        }
        char[] chars = name.trim().toCharArray();
        String spellName = "";
        if (index > chars.length) {
            spellName = CnToSpell.getSpell((String)name, (boolean)false);
        } else {
            char[] beforeChar = new char[index];
            for (int i = 0; i < beforeChar.length; ++i) {
                char c = chars[i];
                spellName = spellName + CnToSpell.getSpell((String)String.valueOf(c), (boolean)false);
            }
            char[] charsAfter = Arrays.copyOfRange(chars, index, chars.length);
            spellName = spellName + CnToSpell.getSpell((String)String.valueOf(charsAfter), (boolean)true);
        }
        return spellName;
    }

    public static StringBuffer getTipsName(Context ctx, String checkSql) throws BOSException {
        StringBuffer bf = new StringBuffer();
        try {
            IRowSet rowData = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            while (rowData.next()) {
                String name = rowData.getString("name");
                bf.append(name).append(",");
            }
            if (bf.length() > 0) {
                bf.deleteCharAt(bf.length() - 1);
            }
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return bf;
    }

    public static Object[] checkAndReturnExceptionName(Context ctx, String billId, String billType) throws BOSException {
        Object[] result = new Object[2];
        String checkSql = "";
        if ("DS".equalsIgnoreCase(billType)) {
            checkSql = "SELECT tt.fname_" + HRManagerUtil.getLocal(ctx) + " as name FROM T_MGR_ManagerExSchemeEntry t left join T_MGR_ManagerExScheme tt on t.FSchemeID = tt.fid where fds like '%" + billId + "%'";
        } else if ("NX".equalsIgnoreCase(billType)) {
            checkSql = "SELECT tt.fname_" + HRManagerUtil.getLocal(ctx) + " as name FROM T_MGR_ManagerExSchemeEntry t left join T_MGR_ManagerExScheme tt on t.FSchemeID = tt.fid where fnx like '%" + billId + "%'";
        } else if ("SCHEME".equalsIgnoreCase(billType)) {
            checkSql = "SELECT FNumber as name FROM T_MGR_ManagerExDataForm where FSchemeID='" + billId + "'";
        }
        StringBuffer tipsName = HRManagerExUtil.getTipsName(ctx, checkSql);
        if (tipsName.length() == 0) {
            return new Object[0];
        }
        result[0] = tipsName.toString();
        String itemSql = "";
        if (tipsName.length() > 0) {
            if ("DS".equalsIgnoreCase(billType)) {
                itemSql = "SELECT fname_" + HRManagerUtil.getLocal(ctx) + " as name FROM T_MGR_ManagerExDSItem where fid='" + billId + "'";
            } else if ("NX".equalsIgnoreCase(billType)) {
                itemSql = "SELECT fname_" + HRManagerUtil.getLocal(ctx) + " as name FROM T_MGR_ManagerExNXItem where fid='" + billId + "'";
            } else if ("SCHEME".equalsIgnoreCase(billType)) {
                itemSql = "SELECT fname_" + HRManagerUtil.getLocal(ctx) + " as name FROM T_MGR_ManagerExScheme where fid='" + billId + "'";
            }
            StringBuffer itemName = HRManagerExUtil.getTipsName(ctx, itemSql);
            result[1] = itemName.toString();
        }
        return result;
    }

    public static List<Map<String, Object>> getItemDSRowsList(Context ctx, String schemeId) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> rowsDsList = new ArrayList<Map<String, Object>>();
        try {
            ManagerExSchemeEntryCollection schemeEntryColl = ManagerExSchemeEntryFactory.getLocalInstance(ctx).getManagerExSchemeEntryCollection("select ds ,nx where scheme='" + schemeId + "'");
            if (schemeEntryColl != null && schemeEntryColl.size() > 0) {
                ManagerExSchemeEntryInfo entryInfo = schemeEntryColl.get(0);
                IRowSet rowSetDs = HRManagerExUtil.rowSetDs(ctx, entryInfo);
                HRManagerExUtil.tranferDsRowsList(ctx, rowSetDs, rowsDsList, false);
            }
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return rowsDsList;
    }

    public static boolean isExistEntryTable(Context ctx, String tableName) throws BOSException {
        String isExistTableNameSql = "select count(1) from KSQL_USERTABLES where KSQL_TABNAME ='" + tableName + "'";
        int totalCount = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)isExistTableNameSql);
            totalCount = HRManagerExUtil.getCount(rowSet);
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return totalCount > 0;
    }

    public static java.util.Date convertString2Date(String dateString) {
        String tempString = dateString;
        String[] regexs = new String[]{"^\\d{4}", "^\\D{0,1}", "^\\d{1,2}", "^\\D{0,1}", "^\\d{1,2}", "^\\s*", "^\\d{0,2}", "^\\D{0,1}", "^\\d{0,2}", "^\\D{0,1}", "^\\d{0,2}"};
        ArrayList<String> numberList = new ArrayList<String>(12);
        for (int i = 0; i < regexs.length; ++i) {
            Pattern p2 = Pattern.compile(regexs[i]);
            Matcher m2 = p2.matcher(tempString);
            if (!m2.find()) continue;
            String temp = m2.group();
            if ("".equals(temp)) {
                temp = "0";
            }
            numberList.add(temp);
            tempString = tempString.replaceFirst(regexs[i], "");
        }
        try {
            tempString = String.format("%s-%02d-%02d %02d:%02d:%02d", numberList.get(0), Integer.parseInt((String)numberList.get(2)), Integer.parseInt((String)numberList.get(4)), Integer.parseInt((String)numberList.get(6)), Integer.parseInt((String)numberList.get(8)), Integer.parseInt((String)numberList.get(10)));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            java.util.Date date = df.parse(tempString);
            String temp = dateString.replaceAll("0|\\D", "");
            if (com.kingdee.shr.base.syssetting.util.DateUtils.isDaylight((String)tempString) || temp.equals(df.format(date).replaceAll("0|\\D", ""))) {
                return date;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSchemeEntryDs(Context ctx, String schemeId) throws BOSException {
        ManagerExSchemeEntryCollection entryColl = ManagerExSchemeEntryFactory.getLocalInstance(ctx).getManagerExSchemeEntryCollection("select ds where scheme='" + schemeId + "'");
        ManagerExSchemeEntryInfo entryInfo = entryColl.get(0);
        String dsStr = entryInfo.getDs();
        return dsStr;
    }

    public static String getAdminChildRangeByAdminId(String adminOrgId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select  child.fid FAdminOrgID from T_ORG_Admin adcount  inner join  T_ORG_Admin child ").append(" on (charindex(concat(adcount.flongnumber,'!'),").append(" child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ").append(" where child.FISSTARTSHR = 1 and child.fisSealUp =0 ").append(" and adcount.fid = '").append(adminOrgId).append("'");
        return sql.toString();
    }

    public static String getExecSql(Context ctx, String billId, String tableName) throws BOSException {
        String countsql = "SELECT count(1) as num FROM t_mgr_managerexdataform where FTableName='" + tableName + "' and fid not in ('" + billId + "')";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countsql);
        int num = 0;
        try {
            while (rowSet.next()) {
                num = rowSet.getInt("num");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String execSql = "drop table " + tableName;
        if (num > 0) {
            execSql = "delete from " + tableName + " where billId='" + billId + "'";
        }
        return execSql;
    }

    public static boolean isSpecialChar(String str) {
        Pattern p = Pattern.compile(HRManagerConstant.regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static int BKDRHash(String str) {
        int seed = 131;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = hash * seed + str.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }
}

