/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRManagerHttpUtil {
    private static Logger l = LoggerFactory.getLogger(HRManagerHttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String queryString, String charset, boolean pretty) {
        StringBuffer response = new StringBuffer();
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        BufferedReader reader = null;
        try {
            if (!StringUtils.isEmpty((CharSequence)queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                String line;
                reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), charset));
                while ((line = reader.readLine()) != null) {
                    if (pretty) {
                        response.append(line).append(System.getProperty("line.separator"));
                        continue;
                    }
                    response.append(line);
                }
            }
        }
        catch (URIException e) {
            l.error("Exception occurred in encoding query string " + queryString + " when executing HTTP get request!", (Throwable)e);
            e.printStackTrace();
        }
        catch (HttpException e) {
            l.error("Exception occurred while executing HTTP get request " + url + "!", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            l.error("Exception occurred while executing HTTP get request " + url + "!", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            method.releaseConnection();
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, String charset, boolean pretty) {
        StringBuffer response = new StringBuffer();
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        if (params != null) {
            HttpMethodParams p = new HttpMethodParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                p.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            method.setParams(p);
        }
        BufferedReader reader = null;
        try {
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                String line;
                reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), charset));
                while ((line = reader.readLine()) != null) {
                    if (pretty) {
                        response.append(line).append(System.getProperty("line.separator"));
                        continue;
                    }
                    response.append(line);
                }
            }
        }
        catch (Exception e) {
            l.error("Exception occurred while executing HTTP post request " + url + "!", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            method.releaseConnection();
        }
        return response.toString();
    }
}

